/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */

/*
 *  M16Cp^C}hCo
 *
 *  M16C/M32C/R32C^C}AphCoD
 */

#ifndef TOPPERS_M16C_TA_H
#define TOPPERS_M16C_TA_H

/* ^C}[hݒ */
#define MODE_TIMER		UINT_C(0x00)
#define MODE_EVTCNT		UINT_C(0x01)
#define MODE_ONESHOT	UINT_C(0x02)
#define MODE_PWM		UINT_C(0x03)

#define GATE_NONE		UINT_C(0x00)
#define GATE_TAI_L		UINT_C(0x01)
#define GATE_TAI_H		UINT_C(0x02)

#define CNTSRC_F1		UINT_C(0x00)
#define CNTSRC_F8		UINT_C(0x01)
#define CNTSRC_F2N		UINT_C(0x02)
#define CNTSRC_FC32		UINT_C(0x03)


#ifndef TOPPERS_MACRO_ONLY

/*
 *  ^C}AhCȍ
 */
extern void m16c_ta_initialize(void);

/*
 *  ^C}AhCȍI
 */
extern void m16c_ta_terminate(void);

/*
 *  [hݒ
 */
extern void m16c_ta_setmode
	(ID ch , uint8_t mode , uint8_t clksrc , uint8_t opt);

/*
 *  ̊Jn
 */
extern void m16c_ta_start(ID ch , uint16_t period);

/*
 *  ̒~
 */
extern void m16c_ta_stop(ID ch);

/*
 *  ^C}WX^l̓ǂݏo
 */
extern uint16_t m16c_ta_getcount(ID ch);

/*
 *  ^C}WX^l̏
 */
extern void m16c_ta_setcount(ID ch , uint16_t count);

#endif	/* TOPPERS_MACRO_ONLY */
#endif	/* TOPPERS_M16C_TA_H */
