static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*****************************************************/
/* <clprdef.c>                                       */
/*      Define process   @                          */
/*****************************************************/
#include "colmn.h"
extern condList CLcList;

extern CLPRTBL *pGLprocTable;
extern CLPRTBL   *pCLprocTable;
extern GlobalCt  *pGlobTable;
extern int giOptions[];
extern CLCOMMON  CLcommon;

int cl_pr_ex_define();
int cl_pr_ex_dim();
int cl_pr_ex_typedef();
int cl_process_define_exec();
int cl_pr_ex_def_array();
static int _chk_array();
static char *gsep=" \t()[],'=";

/************************************/
/* cl_process_top_exec              */
/************************************/
int cl_process_top_exec(scrct,top_leaf,func1,ncmd,cmd_cid,func2)
ScrPrCT  *scrct;
Leaf *top_leaf;
int (*func1)();
int ncmd,cmd_cid[];
int (*func2[])();
{
	Leaf *leaf,*leafw;
	int cno,rc=0;

	if (!scrct || !top_leaf || !func1) return ECL_SYSTEM_ERROR;
/*
	leaf = scrct->TreeTop;
*/
	leaf = top_leaf;
	while (leaf) {
		if ((cno=leaf->cmd.cid)==C_NODE_SCRIPT || cno==C_NODE_IMPORT) {
			if (leafw=leaf->leftleaf) {
				rc = func1(scrct,leafw,ncmd,cmd_cid,func2);
				if (rc) break;
			}
			leaf = leaf->rightleaf;
		}
		else {
			rc = func1(scrct,leaf,ncmd,cmd_cid,func2);
			break;
		}
	}
	return rc;
}

/************************************/
/* cl_process_define_exec           */
/************************************/
/*int cl_process_define_exec(scrct, cmd_cid, func)*/
int cl_process_define_exec(scrct,leaf,ncmd,cmd_cid,func)
ScrPrCT  *scrct;
Leaf *leaf;
int ncmd,cmd_cid[];
int (*func[])();
{
	int rc,cno,i;
 
	if (!leaf) return ECL_SYSTEM_ERROR;

	rc = 0;
#if 1
	while (leaf && rc==NormalEnd) {
		cno=leaf->cmd.cid;
		if (cno==C_PROC || cno==C_FUNCTION || cno==C_CLASS) break;
#else
	while ((cno=leaf->cmd.cid) != C_PROC && cno != C_FUNCTION && cno != C_CLASS &&
	       leaf->rightleaf != NULL && rc == NormalEnd) {
#endif
		else if (cno == C_NODE_DEFINE) leaf = leaf->leftleaf;
		else {
			for (i=0;i<ncmd;i++) {
				if (cno == cmd_cid[i]) {
DEBUGOUTL1(100,"[ %s ]",cl_get_pcmd_line(leaf));
					if (CLcommon.dbgopt[0]) {
						cl_debug_mode(leaf,NULL,0);
					}
					rc = func[i](leaf,scrct,NULL,0);
					if (rc) {
						clerrdisp(rc,leaf);
						return rc;
					}
					break;
				}
			}
			leaf = leaf->rightleaf;
		}
	}
	return rc;
}

/************************************/
/* cl_process_define                */
/************************************/
int cl_process_define(scrct,top_leaf)
ScrPrCT  *scrct;
Leaf     *top_leaf;
{
	int cmd[3];
	int (*func[3])();

	cmd[0] = C_DEFINE;
	cmd[1] = C_DIM;
/*	cmd[2] = C_TYPEDEF;	*/
	func[0] = cl_pr_ex_define;
	func[1] = cl_pr_ex_dim;
/*	func[2] = cl_pr_ex_typedef;	*/
	return cl_process_top_exec(scrct,top_leaf,cl_process_define_exec,2,cmd,func);
}
#if 0
/************************************/
/* cl_process_dim                   */
/************************************/
int cl_process_dim(scrct)
ScrPrCT  *scrct;
{
	return cl_process_top_exec(scrct,C_DIM,cl_process_define_exec,cl_pr_ex_dim);
}
#endif
/************************************/
/* cl_pr_ex_define                  */
/************************************/
int cl_pr_ex_define(leaf, scrct, proc, opt)
Leaf    *leaf;
ScrPrCT *scrct;
ProcCT  *proc;
int     opt;
{
	static char *msg="[ Skipped ]";
	int  i, n, rc, scno, *obj;
	parmList **pprmp;
	char **da;
	CMDObject *cmdobj;

	if (!leaf || !scrct) return ECL_SYSTEM_ERROR;

	/* parameter check */
	if ( (n=leaf->cmd.prmnum) < 1 ) {
		/* cl_pr_ex_define:p[^܂ */
		ERROROUT1(FORMAT(42),"cl_pr_ex_define");
		return ECL_EX_DEFINE;
	}

	pprmp = leaf->cmd.prmp;
	if (scno=leaf->cmd.sub_cid) {
		switch (scno) {
			case CS_MAPPEDARRAY:
				rc = cl_pr_ex_def_map_ary(n, pprmp, scrct, proc, opt);
				break;
			case CS_TYPE:
				rc = cl_pr_ex_def_type(n, pprmp, scrct, proc, opt);
				break;
			case CS_VAR:
				rc = cl_pr_ex_def_var(n-1, pprmp+1, scrct, proc, opt);
				break;
			case CS_OPTION:
#if 1
				rc = 0;
DEBUGOUTL(100,msg);
#else
				rc = let_option(n,pprmp,NULL);
#endif
				break;
			case CS_OPTIONS:
#if 1
				rc = 0;
DEBUGOUTL(100,msg);
#else
				rc = let_options(n,pprmp,NULL);
#endif
				break;
			default:
				cmdobj = leaf->cmd.cmdobj;
#if 0
				obj = cmdobj->exobj;
				if (cmdobj->nobj && cmdobj->cid==CS_SCALAR)
					rc = cl_pr_ex_def_scalar_attr_info(obj[1],pprmp,scrct,proc,obj[2],&obj[3],NULL);
				else
#endif
				rc = cl_pr_ex_def_array(cmdobj,n,pprmp,scrct,proc,opt);
		}
	}
	else {
		sswitch ( pprmp[0]->prp )
			sicase ("MAPPEDARRAY")
				rc = cl_pr_ex_def_map_ary(n, pprmp, scrct, proc, opt);
			sicase2("TYPE","TYPEDEF")
				rc = cl_pr_ex_def_type(n, pprmp, scrct, proc, opt);
			sicase ("VAR")
				rc = cl_pr_ex_def_var(n-1, pprmp+1, scrct, proc, opt);
			sicase ("OPTION")
#if 1
				rc = 0;
DEBUGOUTL(100,msg);
#else
				rc = let_option(n,pprmp,NULL);
#endif
			sicase ("OPTIONS")
#if 1
				rc = 0;
DEBUGOUTL(100,msg);
#else
				rc = let_options(n,pprmp,NULL);
#endif
			sdefault
				rc = cl_pr_ex_def_array(n, pprmp, scrct, proc, opt);
		endssw
	}
	return rc;
}

/************************************/
/* cl_pr_ex_re_define               */
/************************************/
int cl_pr_ex_re_define(leaf, proc)
Leaf    *leaf;
ProcCT  *proc;
{
	ScrPrCT *scrct;

	if (!(scrct = cl_search_src_ct())) return ECL_SYSTEM_ERROR;
	return cl_pr_ex_define(leaf,scrct,proc,D_GX_OPT_REDEFINE);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_check_define(pScCT,proc,varnam,vnlen,opt,argv)
ScrPrCT	*pScCT;
ProcCT  *proc;
char    *varnam;
int      vnlen;
int      opt;
char    *argv[];
{
	int ret,iParmNo,iLGopt,iNONE;
	tdtInfoParm ***pTBL_vnam;
	char *p,*pp;

DEBUGOUTL4(190,"cl_gx_check_define: pScCT=%08x proc=%08x [%s] opt=%08x",
pScCT,proc,varnam,opt);
	iNONE = !(opt & D_GX_OPT_SET_SCOPE);
	iParmNo = 0;
	pTBL_vnam = NULL;
	iLGopt= 0;
	if (proc && proc->pha_vnam) {
		if ((ret=cl_gx_chk_vnam('r',proc->pha_vnam,varnam,vnlen)) > 0) {
			if (iNONE || (opt & D_GX_OPT_SET_LOCAL)) {
				pTBL_vnam = proc->pTBL_vnam;
				iParmNo = ret;
				p = "LOCAL";
			}
			iLGopt = D_AUX1_LOCAL_VAR;
DEBUGOUTL1(190,"cl_gx_check_define: LOCAL ParmNo=%d",ret);
			if (argv[0] && (opt & (D_GX_OPT_SET_PRIVATE | D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL))) {
				if (opt & D_GX_OPT_SET_PRIVATE) pp = "SCRIPT";
				else if (opt & D_GX_OPT_SET_PUBLIC) pp = "PUBLIC";
				else pp = "GLOBAL";
				/* %s:%s:(W)LOCALϐ[%s]`ς݂łB */
				ERROROUT3(FORMAT(421),argv[0],pp,varnam);
			}
		}
	}
	if (pScCT) {
		if ((ret=cl_gx_chk_vnam('r',pScCT->Vary->pha_vnam,varnam,vnlen)) > 0) {
			if (!iParmNo && (iNONE || (opt & D_GX_OPT_SET_PRIVATE))) {
				pTBL_vnam = pScCT->Vary->pTBL_vnam;
				iParmNo = ret;
				p = "SCRIPT";
			}
			iLGopt |= D_AUX1_PRIVATE_VAR;
DEBUGOUTL1(190,"cl_gx_check_define: SCRIPT ParmNo=%d",ret);
			if (argv[0] && (opt & (D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL))) {
				if (opt & D_GX_OPT_SET_PUBLIC) pp = "PUBLIC";
				else pp = "GLOBAL";
				/* %s:%s:(W)SCRIPTϐ[%s]`ς݂łB */
				ERROROUT3(FORMAT(422),argv[0],pp,varnam);
			}
		}
	}
	if ((ret=cl_gx_chk_vnam('r',pCLprocTable->pha_vnam,varnam,vnlen)) > 0) {
		if (!iParmNo && (iNONE || (opt & D_GX_OPT_SET_PUBLIC))) {
			pTBL_vnam = pCLprocTable->pTBL_vnam;
			iParmNo = ret;
			p = "PUBLIC";
		}
		iLGopt |= D_AUX1_PUBLIC_VAR;
DEBUGOUTL1(190,"cl_gx_check_define: PUBLIC ParmNo=%d",ret);
	}
	if ((ret=cl_gx_chk_vnam('r',pGLprocTable->pha_vnam,varnam,vnlen)) > 0) {
		if (!iParmNo && (iNONE || (opt & D_GX_OPT_SET_GLOBAL))) {
			pTBL_vnam = pGLprocTable->pTBL_vnam;
			iParmNo = ret;
			p = "GLOBAL";
		}
		iLGopt |= D_AUX1_GLOBAL_VAR;
DEBUGOUTL1(190,"cl_gx_check_define: GLOBAL ParmNo=%d",ret);
	}
	if (cl_chk_sysvar_name(varnam, vnlen)) {
						/* %s:(E)SYSTEMϐ[%s]`ς݂łB */
		if (argv[0]) ERROROUT2(FORMAT(423),argv[0],varnam);
		iParmNo = ECL_SCRIPT_ERROR;
	}
	argv[1] = (char *)pTBL_vnam;
	argv[2] = (char *)iLGopt;
	argv[3] = p;
	return iParmNo;
}

/************************************/
/*	_chk_define                     */
/************************************/
int _chk_define(scrct,proc,varnam,vnlen,opt,argv)
ScrPrCT *scrct;
ProcCT  *proc;
char    *varnam;
int      vnlen;
int      opt;
char    *argv[];
{
	XHASHB  *pha_vname;
	tdtInfoParm ***pTBL_vname;
	int ret,iAux,iARRAY;
	char *name;
/*
printf("_chk_define: scrct=%08x proc=%08x varnam=%s vnlen=%d opt=%08x\n",scrct,proc,varnam,vnlen,opt);
*/
	name = argv[0];
	if ((ret=cl_gx_check_define(scrct,proc,varnam,vnlen,opt,argv)) < 0) return ret;
	iAux = (int)argv[2];
	iARRAY = opt & D_GX_OPT_SET_ARRAY;
	if (opt & D_GX_OPT_SET_LOCAL) {
		if (!proc) {
			/* %s: 葱OłLOCALϐ͒`ł܂B */
			ERROROUT1(FORMAT(424),name);
			return ECL_SCRIPT_ERROR;
		}
		if (pha_vname=proc->pha_vnam) {
			if (iARRAY && (iAux & D_AUX1_LOCAL_VAR)) {
				/* %s: LOCALϐ[%s]`ς݂łB */
				ERROROUT2(FORMAT(425),name,varnam);
				return ECL_SCRIPT_ERROR;
			}
			pTBL_vname = proc->pTBL_vnam;
		}
		else return -1;
	}
	else if (opt & D_GX_OPT_SET_PUBLIC) {
		pha_vname = pCLprocTable->pha_vnam;
		pTBL_vname = pCLprocTable->pTBL_vnam;
	}
	else if (opt & D_GX_OPT_SET_GLOBAL) {
		pha_vname = pGLprocTable->pha_vnam;
		pTBL_vname = pGLprocTable->pTBL_vnam;
	}
	else {
		if (!scrct) return -1;
		pha_vname = scrct->Vary->pha_vnam;
		if ((iARRAY || !proc) && (iAux & D_AUX1_PRIVATE_VAR)) {
			/* %s: SCRIPTϐ[%s]`ς݂łB */
			ERROROUT2(FORMAT(426),name,varnam);
			return ECL_SCRIPT_ERROR;
		}
		pTBL_vname = scrct->Vary->pTBL_vnam;
	}
	argv[4] = (char *)pha_vname;
	argv[5] = (char *)pTBL_vname;
/*
printf("_chk_define: ret=%3d varnam=[%s]\n",ret,varnam);
*/
	return ret;
}

/************************************/
/*	_set_index						*/
/*			is = 0 : mapped array	*/
/*			   = 1 : array			*/
/************************************/
int _set_index(is,prmnum,pprmp,offset,index,msg)
int is,prmnum;
parmList **pprmp;
int offset,index[];
char *msg;
{
	int i,rc,ixlen,ix,len,k,f,ndim,n,m1,m2;
	char *ixnam,*p;
	tdtInfoParm tInfoParm;
	tdtObjHead *Obj;

printf("_set_index: is=%d prmnum=%d offset=%d msg=[%s]\n",is,prmnum,offset,msg);

	ndim = prmnum - (1-is);
	if (ndim > MAX_ARRAY_DIM) {
		ERROROUT2(FORMAT(427),msg,prmnum);	/* %s: (%d)܂B */
		return ECL_SCRIPT_ERROR;
	}

printf("_set_index: ndim=%d\n",ndim);

	Obj = cl_gx_get_proc_obj();
#if 1	/* 2017.07.23 koba */
	ix = is + 3;
#else
	ix = is;
#endif
/*	f = 1;	*/
	m1 = n = 1;
	for (i=0;i<prmnum;i++,ix++) {
#if 1
		if ((ixlen=pprmp[i+offset]->prmlen) > 0) {
#else
		if (!(ixlen = pprmp[i+offset]->prmlen)) index[ix] = 1;
		else {
#endif
			ixnam = pprmp[i+offset]->prp;

printf("_set_index: ixnam=%s\n",ixnam);

			if (rc = cl_gx_exp_obj(1,&pprmp[i+offset],Obj,&tInfoParm)) return ECL_SCRIPT_ERROR;
			if (tInfoParm.pi_dlen > 0) {
#if 1	/* 2017.07.23 koba */
				m2 = 0;
				if (pGlobTable->options[14] & 0x01) m2++;;
				rc = cl_get_parm_bin(&tInfoParm,&m1,msg);
#if 1	/* 2020.1.3 */
				if (!rc && (tInfoParm.pi_alen & D_AULN_RANGE_DATA)) {
					if (ix <= 3) {
						/* %s: i=%d }bvCfbNXɔ͈͎w[%s]́Awł܂B */
						ERROROUT3(FORMAT(420),msg,i,ixnam);
						return ECL_SCRIPT_ERROR;
					}
					else {
#else
				if (!rc && ix>3 && (tInfoParm.pi_alen & D_AULN_RANGE_DATA)) {
#endif
					memcpy(tInfoParm.pi_data,tInfoParm.pi_data+tInfoParm.pi_dlen,tInfoParm.pi_dlen);
					if (!(rc=cl_get_parm_bin(&tInfoParm,&m2,msg))) {
						if (m1 > m2) {
							/* %s: i=%d ͈͎w[%s]słB */
							ERROROUT3(FORMAT(428),msg,i,ixnam);
							return ECL_SCRIPT_ERROR;
						}
						k = m2;
						m2 = m1;
						m1 = k - m1 + 1;
					/*	index[2] |= f;	2020.4.30 */
					}
#if 1	/* 2020.1.3 */
					}
#endif
				}
				index[ix] = m1;
				if (ix > 3) index[ix+ndim] = m2;
#else
				rc = cl_get_parm_bin(&tInfoParm,&index[ix],msg);
				if (!rc && ix>0 && (tInfoParm.pi_alen & D_AULN_RANGE_DATA)) {
					memcpy(tInfoParm.pi_data,tInfoParm.pi_data+tInfoParm.pi_dlen,tInfoParm.pi_dlen);
					if (!(rc=cl_get_parm_bin(&tInfoParm,&index[ix+MAX_ARRAY_DIM+1],msg))) {
						if (index[ix] > index[ix+MAX_ARRAY_DIM+1]) {
							/* %s: i=%d ͈͎w[%s]słB */
							ERROROUT3(FORMAT(428),msg,i,ixnam);
							return ECL_SCRIPT_ERROR;
						}
						k = index[ix+MAX_ARRAY_DIM+1];
						index[ix+MAX_ARRAY_DIM+1] = index[ix];
						index[ix] = k - index[ix] + 1;
						index[MAX_ARRAY_DIM+1] |= f;
					}
				}
#endif
				if (rc) {
					/* %s: i=%d ͈͎w[%s]lł͂܂B */
					ERROROUT3(FORMAT(429),msg,i,ixnam);
					return ECL_SCRIPT_ERROR;
				}
			}
			if (index[ix] <= 0) {
				/* %s: i=%d ͈͎w[%s]=%dsłB */
				ERROROUT4(FORMAT(430),msg,i,ixnam,index[ix]);
				return ECL_SCRIPT_ERROR;
			}
		}

printf("_set_index: ixlen=%d\n",ixlen);

#if 1	/* 2017.07.23 koba */
#if 1	/* 2020.1.3 koba */
		if (ix > 3) {
			n *= m1;
		/*	f <<= 1;	*/
		}
#else
		n *= m1;
		if (ix > 2) f <<= 1;
#endif
#else
		if (ix > 0) f <<= 1;
#endif

printf("%s: index[%d]=%d,%d f=%x index[2]=%x n=%d\n",
msg,ix,index[ix],index[ix+ndim],f,index[2],n);

	}
	if (ndim > 0) {
		index[0] = ndim;
		index[1] = n;
	}
	return 0;
}

/************************************/
/*	_check_redefine                 */
/************************************/
static int _check_redefine(varnam,vnlen,ppInfoParm,id,msg)
char *varnam;
int vnlen;
tdtInfoParm **ppInfoParm;
char id,*msg;
{
	int rc;
	char *ary;
	tdtInfoParm tInfoParm,*pInfoParm;
	parmList prmp;

	pInfoParm = &tInfoParm;
	prmp.prp = varnam;
	prmp.prmlen = vnlen;
	if (rc=cl_conv_parm_opt(&prmp,pInfoParm,D_GX_OPT_SET_ADDR)) {
		if (rc == ECL_DEFINED_ARRAY) rc = 0;
		else {
			ERROROUT2(FORMAT(125),msg,varnam);	/* %s: [%s]Ă܂B */
			return rc;
		}
	}
	if (pInfoParm->pi_id == 'S') {
		pInfoParm = (tdtInfoParm *)pInfoParm->pi_pos;
	}
	if (id=='A' || id=='R') {
		if (id && pInfoParm->pi_id != id) {
			if (id == 'A') ary = "MAPPEDARRAY";
			else ary = "ARRAY";
			/* %s: ϐ(%s)%sł͂܂B */
			ERROROUT3(FORMAT(431),msg,varnam,ary);
			rc = ECL_SCRIPT_ERROR;
		}
	}
	*ppInfoParm = pInfoParm;
	return rc;
}

/************************************/
/*	cl_get_def_scope				*/
/************************************/
int cl_get_def_scope(p)
char *p;
{
	int opt;

	opt = 0;
	if (!stricmp(p,"GLOBAL") || !stricmp(p,D_STR_SCOPE_GLOBAL))
		opt = D_GX_OPT_SET_GLOBAL;
	else if (!stricmp(p,"PUBLIC") || !stricmp(p,D_STR_SCOPE_PUBLIC))
		opt = D_GX_OPT_SET_PUBLIC;
	else if (!stricmp(p,"PRIVATE") || !stricmp(p,D_STR_SCOPE_PRIVATE))
		opt = D_GX_OPT_SET_PRIVATE;
	else if (!stricmp(p,"LOCAL") || !stricmp(p,D_STR_SCOPE_LOCAL))
		opt = D_GX_OPT_SET_LOCAL;
	return opt;
}
#if 0
/************************************/
/*	cl_get_def_modifier				*/
/************************************/
int cl_get_def_modifier(Prmnum,Pprmp,check,iParm)
int      Prmnum;
parmList **Pprmp;
int      check[],iParm[];
{
	parmList **pprmp;
	int  prmnum,np,i,n,iCONST,iOpt,iARRAY,iCHK,iOK,rc,opt;
	char *p;

	n = iCONST = iOpt = iARRAY = iOK = opt = 0;
	np   = check[0];
	iCHK = check[1];
	prmnum = Prmnum;
	pprmp  = Pprmp;
	if (prmnum < np) np = prmnum;
	for (i=0;i<np;i++) {
		p = pprmp[0]->prp;
		if (!iOpt && (iOpt=cl_get_def_scope(p))) {
			n++;
			pprmp++;
			opt |= iOpt;
			iOK |= 0x01;
		}
		else if (!iCONST && !stricmp(p,"CONST")) {
			n++;
			pprmp++;
			iCONST = D_AUX1_PROTECTED;
			opt |= D_GX_OPT_SET_CONST;
			iOK |= 0x02;
		}
		else if (!iARRAY && !stricmp(p,"ARRAY")) {
			n++;
			pprmp++;
			iARRAY = 1;
			opt |= D_GX_OPT_SET_ARRAY;
			iOK |= 0x04;
		}
		if (iCHK & iOK) ;
		else break;
		iCHK &= ~iOK;
	}
	check[2] = iOK;
	check[3] = opt;

	if (prmnum > n) {
		if (rc=cl_get_def_attr(pprmp[0]->prp,pprmp[0]->prmlen,iParm,NULL,NULL)) return rc;
		else if (iParm[0] > 0) n++;
	}
/*
printf("cl_get_def_modifier: np=%d n=%d iOk=%02x opt=%08x\n",np,n,check[2],check[3]);
*/
	return n;
}
#endif
/************************************/
/*	cl_get_def_modifier_SSP			*/
/************************************/
int cl_get_def_modifier_SSP(s,slen,ssp,sep,check,iParm,bxobj,Obj)
char   *s;
int    slen;
SSPL_S *ssp;
char   *sep;
int    check[],iParm[];
GXObject *bxobj[];
tdtObjHead *Obj;
{
	int  np,i,n,iCONST,iOpt,iARRAY,iCHK,iOK,rc,opt,len,spw,iSTATIC,iCLEAR;
	char *p;

	n = iCONST = iOpt = iARRAY = iOK = opt = iSTATIC = iCLEAR = 0;
	iCHK = check[1];
	spw = ssp->sp;
	while ((len=akxtgwnsl(s,slen,ssp,sep,0x41)) > 0) {
		p = strtemp(ssp->wd,len);
/*
printf("cl_get_def_modifier_SSP: p=[%s]\n",p);
*/
		if (!iOpt && (iOpt=cl_get_def_scope(p))) {
			n++;
			opt |= iOpt;
			iOK |= 0x01;
		}
		else if (!iCONST && !stricmp(p,"CONST")) {
			n++;
			iCONST = D_AUX1_PROTECTED;
			opt |= D_GX_OPT_SET_CONST;
			iOK |= 0x02;
		}
		else if (!iARRAY && !stricmp(p,"ARRAY")) {
			n++;
			iARRAY = 1;
			opt |= D_GX_OPT_SET_ARRAY;
			iOK |= 0x04;
		}
		else if (!iSTATIC && !stricmp(p,"STATIC")) {
			n++;
			iSTATIC = 1;
			opt |= D_GX_OPT_SET_STATIC;
			iOK |= 0x08;
		}
		else if (!iCLEAR && !stricmp(p,"CLEAR")) {
			n++;
			iSTATIC = 1;
			opt |= D_GX_OPT_SET_CLEAR;
			iOK |= 0x10;
		}
		if (!(iCHK & iOK)) {
			ssp->sp = spw;
			break;
		}
		iCHK &= ~iOK;
		spw = ssp->sp;
/*
printf("cl_get_def_modifier_SSP: spw=%d\n",spw);
*/
	}
	check[2] = iOK;
	check[3] = opt;
/*
printf("cl_get_def_modifier_SSP: sp=%d\n",ssp->sp);
*/
	if (rc=cl_get_def_attr_SSP(s,slen,ssp,sep,iParm,bxobj,Obj)) return rc;
	else if (iParm[0] > 0) n++;
	else {
		ssp->sp = spw;
	}
/*
printf("cl_get_def_modifier_SSP: sp=%d n=%d iOk=%02x opt=%08x iParm[0]=%d\n",
ssp->sp,n,check[2],check[3],iParm[0]);
*/
	return n;
}

/************************************/
/*	cl_def_chk_name_opt				*/
/************************************/
int cl_def_chk_name_opt(varnam,vnlen,func,msg,redef_flg)
char *varnam;
int   vnlen;
char *func,*msg;
int   redef_flg;
{
	static char *p0=NULL;
	char work[256],*p;
	int  opt;

	if (redef_flg) opt = 0x01;	/* sIhnj */
	else opt = 0;
	strnzcpy(work,varnam,vnlen,sizeof(work)-1);
	if (vnlen > Var_NM_MAX) {
		ERROROUT3(FORMAT(496),func,work,vnlen);	/* %s: ϐ(%s)̒(%d)܂B */
		return ECL_SCRIPT_ERROR;
	}
	else if (cl_chk_name_opt(varnam,vnlen,opt)) {
		if (func && msg) {
			if (vnlen > 0)
				/* %s: %s(%s)Ă܂B */
				ERROROUT3(FORMAT(432),func,msg,work);
			else
				ERROROUT2(FORMAT(76),func,msg);	/* %s: %s܂B */
		}
		return ECL_SCRIPT_ERROR;
	}
#if 1
	if (cl_chk_sysvar_name(varnam,vnlen)) {
		ERROROUT2(FORMAT(453),func,work);
		return ECL_EX_DEFINE;
	}
#else
	else if (cl_is_yoyakugo(work)) {
		ERROROUT2(FORMAT(121),func,work);
		return ECL_EX_DEFINE;
	}
#endif
	return 0;
}

/************************************/
/*	cl_def_chk_name					*/
/************************************/
int cl_def_chk_name(varnam,vnlen,func,msg)
char *varnam;
int   vnlen;
char *func,*msg;
{
	return cl_def_chk_name_opt(varnam,vnlen,func,msg,0);
}

/************************************/
/*	_get_varname					*/
/************************************/
int _get_varname(s,slen,ssp,proc,bxobj,pp)
char *s;
int  slen;
SSPL_S *ssp;
ProcCT *proc;
GXObject *bxobj[];
char **pp;
{
	int rc,pos,llen,vnlen,iSKIP,len;
	tdtObjHead *pObj;
	tdtInfoParm tInfoParm;
	char c,*p,*line,*varnam;

	if (bxobj && bxobj[0]) {
		line = NULL;
		llen = 0;
		c = '(';
	}
	else {
		iSKIP = 0;
		pos = ssp->sp;
/*
printf("_get_varname: pos=%d s+pos=[%s]\n",pos,s+pos);
*/
		ssp->sp += akxnskipin(s+pos,slen-pos," \t");
		pos = ssp->sp;
/*
printf("_get_varname: pos=%d s+pos=[%s]\n",pos,s+pos);
*/
		if ((c=*(s+pos)) == '(') iSKIP = pos + 1;
		else {
			vnlen = akxtgwnsl(s,slen,ssp,gsep,0x41);
			varnam = ssp->wd;
			len = akxnskipin(varnam,vnlen,"$%#");
			if (len<=0 || (vnlen>1 && len<=1)) {
				return 0;
			}
			pos++;
			llen = vnlen - 1;
			if (len >= vnlen) {
				clpeeksl(s,slen,ssp,gsep,0x41);
				if (*ssp->wd == '(') iSKIP = ssp->sp + 1;
				else {
					/* _get_varname: [%s]͕ϐɕϊł܂B */
					ERROROUT1(FORMAT(585),strtemp(varnam,vnlen));
					return ECL_SCRIPT_ERROR;
				}
			}
		}
		line = s + pos;
		if (iSKIP) {
			ssp->sp = iSKIP - 1;
			if (rc=cl_skip_to_delm(s,slen,"()",ssp,gsep,0)) {
				ERROROUT1(FORMAT(433),"_get_varname");	/* %s: JbRĂ܂B */
				return ECL_SCRIPT_ERROR;
			}
			llen = ssp->sp - pos;
		}
	}
	if (bxobj) {
		if (proc) pObj = proc->Obj;
		else pObj = cl_gx_get_scr_obj();
	}
	else pObj = NULL;
/*
printf("_get_varname: llen=%d line=[%s]\n",llen,line);
*/
	if (rc=cl_gx_expsn_obj_opt(line,llen,bxobj,pObj,&tInfoParm,0)) return rc;
	if ((llen=parm_to_char_tmp(&tInfoParm,pp,0)) < 0) return rc;
	if (c != '(') {
		if (!(p=cl_tmp_const_malloc(llen+2))) return -1;
		*p = c;
		memzcpy(p+1,*pp,llen);
		*pp = p;
		llen++;
	}
/*
printf("_get_varname: vnlen=%d varnam=[%s]\n",llen,*pp);
*/
	return llen;
}

/************************************/
/*	_set_array_values				*/
/************************************/
int _set_array_values(pInfoParm,prmnum,pprmp,Obj)
tdtInfoParm *pInfoParm;
int      prmnum;
parmList **pprmp;
tdtObjHead *Obj;
{
	int  i,rc,len;
	int  nparm;
	char *prnam,id;
	tdtInfoParm tInfoParm,tInfoParm2[2],**ppParm,*pInfoParmW,tInfoParmW[2];

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_set_array_values: prmnum=%d pInfoParm=",pInfoParm,prmnum,0);

	if (rc=cl_gx_exp_obj_opt(prmnum,pprmp,Obj,tInfoParm2,D_GX_OPT_PARMINFO2)) return rc;
	pInfoParmW = tInfoParm2;
#if 1	/* 2019.5.18 */
#if 1	/* 2019.6.1 */
	if (pInfoParmW->pi_alen & D_AULN_PARMINFO2) {
#else
	if (pInfoParmW->pi_id=='N' || (pInfoParmW->pi_alen & D_AULN_PARMINFO2)) {
#endif
		cl_gx_copy_info(tInfoParmW, pInfoParmW);
		if (pInfoParmW->pi_alen & D_AULN_PARMINFO2)
			memcpy(tInfoParmW+1,pInfoParmW+1,sizeof(tdtInfoParm));
		if (rc = _kakko_tenkai(NULL,tInfoParm2,tInfoParmW)) return rc;
	}
#endif
	if (pInfoParmW->pi_alen & D_AULN_PARMINFO2) {
		if (nparm=tInfoParm2[1].pi_pos) {
			pInfoParmW = (tdtInfoParm *)tInfoParm2[1].pi_data;
		}
	}
	else {
		nparm = 1;
	}
	if ((id=pInfoParm->pi_id)=='A' || id=='R') {
		if (!(ppParm=(tdtInfoParm **)cl_tmp_const_malloc(sizeof(tdtInfoParm *)*(nparm+2)))) return -1;
		ppParm[0] = pInfoParm;
		ppParm[1] = &tInfoParm;
		cl_set_parm_bin(&tInfoParm,0);
		for (i=0;i<nparm;i++) ppParm[i+2] = pInfoParmW++;
		rc = cl_set_array(&len,nparm+2,ppParm);
	}
	else if (id == ' ') rc = cl_gx_rep_info_set(pInfoParm,&pInfoParmW[nparm-1],1);
	else rc = -1;
	return rc;
}

/************************************/
/*	cl_def_map_ary_max_chk				*/
/************************************/
int cl_def_map_ary_max_chk(c,index,scrct,proc,opt)
char c;
int *index;
ScrPrCT *scrct;
ProcCT  *proc;
int     opt;
{
	int *pSize,i,ndim,m,rc;
	tdtInfoParm ***pTBL_pas;

/*	if      (c == '$') pSize = (int *)scrct->Vary->pTBL_dolu[0];
	else */if (c == '#') pSize = (int *)scrct->Vary->pTBL_igeta[0];
	else if (c == '%') {
		if (opt & D_GX_OPT_SET_LOCAL) {
			if (!proc) return -1;
			if (!(pTBL_pas=proc->pTBL_pasento)) return -1;
		}
		else pTBL_pas =scrct->Vary->pTBL_pasento;
		pSize = (int *)pTBL_pas[0];
	}
	else pSize = (int *)scrct->Vary->pTBL_dolu[0];

#if 0	/* 2020.5.1 Koba ǉAsv */
	rc = 0;
	if (c == '%') m = pSize[7];
	else m = pSize[2];
	if (index[3]+index[1]-1 > m) {
		/* cl_pr_ex_def_map_ary: ͈͎w(%d[%d,%d,%d])ϐž(%d)𒴂Ă܂B */
		ERROROUT5(FORMAT(434),index[0],index[1],index[2],index[3],m);
		if (c=='%' && index[0]==1 && index[3]<=m) {
			index[1] = m - index[3] + 1;
			index[2] =index[1];
			index[4] = m;
			/* %s: ܂B */
			ERROROUT1(FORMAT(230),"cl_pr_ex_def_map_ary");
		}
		else rc =  ECL_SCRIPT_ERROR;
	}
	return rc;
#else
#if 1	/* 2017.7.18 Koba */
/*
	ndim = index[0];
	m = index[1];
	for (i=1;i<ndim;i++) m += index[i+4];
	index[1] = m;
	if (index[1]+m-1 > pSize[2]) {
*/
	if (index[3]+index[1]-1 > pSize[2]) {
#else
	if (index[0]+index[1]*index[2]*index[3]-1 > pSize[2]) {
#endif
#endif
		/* cl_pr_ex_def_map_ary: ͈͎w(%d[%d,%d,%d])ϐž(%d)𒴂Ă܂B */
		ERROROUT5(FORMAT(434),index[0],index[1],index[2],index[3],pSize[2]);
		return ECL_SCRIPT_ERROR;
	}
#if 1	/* 2020.5.1 Koba */
	if (c == '%') {
		index[2] = pSize[7] - index[3] + 1;
		if (index[2] < 0) index[2] = 0;
	}
#endif
	return 0;
}

/************************************/
/*	cl_pr_ex_def_map_ary			*/
/************************************/
int cl_pr_ex_def_map_ary(prmnum, pprmp, scrct, proc, opt)
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT   *proc;
int      opt;
{
	char *argv[6], *_name_;
	XHASHB *pha_vname;
	int  i, iParmNo, rc, vnlen, n, *pSize, ixlen, nparm,len,is,line_len;
	char c, *varnam, *p, *ixnam, wrk[128],*line,*pp;
	tdtInfoParm *pInfoParm,tInfoParm;
	tdtArrayIndex tIndex;
	int *index;
	tdtInfoParm ***pTBL_vname,***pTBL_pas;
	uchar ucLOCAL=0;
	int iARRAY,iEQU,iSET,iCONST;
	SSPL_S ssp;
	parmList *qprmp[MAX_ARRAY_DIM+1];
	tdtObjHead *pObj;
/*
printf("cl_pr_ex_def_map_ary: prmnum=%d pprmp=%08x scrct=%08x proc=%08x opt=%d\n",
prmnum, pprmp, scrct, proc, opt);
*/
	argv[0] = _name_ = "cl_pr_ex_def_map_ary";

	/* parameter check */
	if (!proc && prmnum<2) {
		ERROROUT1(FORMAT(42),_name_);	/* %s: p[^܂B */
		return ECL_EX_DEFINE;
	}
	iEQU = iSET = iCONST = 0;
	iARRAY = 1;
	line = pprmp[1]->prp;
	line_len  = pprmp[1]->prmlen;
/*
printf("%s: prmnum=%d line_len=%d line=[%s]\n",argv[0],prmnum,line_len,line);
*/
	memset(&ssp,0,sizeof(SSPL_S));
	is = ssp.sp;
	/* ϐ̎擾 */
	vnlen = akxtgwnsl(line,line_len,&ssp,gsep,0x41);
	if (vnlen <= 0) {
		ERROROUT1(FORMAT(435),argv[0]);	/* %s: ϐ܂B */
		return ECL_EX_DEFINE;
	}
	memnzcpy(wrk,ssp.wd,vnlen,sizeof(wrk)-1);
	varnam = wrk;
	c = *varnam;
	/* z񖼂ɕϐw\Ƃ */
	if (c=='(' || c=='$' || c=='#' || c=='%') {
		ssp.sp = is;
		if ((len=_get_varname(line,line_len,&ssp,proc,&pprmp[0]->bxobj,&pp)) < 0) return len;
		else if (len > 0) {
			varnam = pp;
			vnlen = len;
			c = *varnam;
		}
	}
/*
printf("%s: vnlen=%d varnam=[%s]\n",argv[0],vnlen,strtemp(varnam,vnlen));
*/
	/* z񖼂̃`FbN */
	if (c=='$') {
		vnlen--;
		varnam++;
	}
	else if (c!='#' && c!='%') c = '$';
#if 1
	p = varnam;
	len = vnlen;
	if (c=='%' || c=='#') {
		p++;
		len--;
	}
	if (rc=cl_def_chk_name(p,len,_name_,FORMAT(441))) return rc;
#else
	if (((c=='%' || c=='#') && cl_chk_name(varnam+1,vnlen-1)) ||
	    (c!='%' && c!='#' && cl_chk_name(varnam,vnlen))) {
		ERROROUT2(FORMAT(436),_name_,varnam);	/* %s: ϐ(%s)Ă܂B */
		return ECL_SCRIPT_ERROR;
	}
#endif
	/* z`̎擾 */
	nparm = cl_get_array_def_parm(line,line_len,"=",&ssp,gsep,MAX_ARRAY_DIM+1,qprmp,&iEQU);
	if (nparm < 0) return n;
	else if (!nparm) {
		if (proc) iARRAY = 2;
	}
/*
printf("%s: nparm=%d iARRAY=%d\n",_name_,nparm,iARRAY);
*/
#if 0
	if (iARRAY==1 && nparm<2) {
		/* %s: CfbNX܂͎̎w肪܂B */
		ERROROUT1(FORMAT(437),_name_);
		return ECL_SCRIPT_ERROR;
	}
#endif
	if (opt & D_GX_OPT_REDEFINE) {
		if (rc=_check_redefine(varnam,vnlen,&pInfoParm,'A',_name_)) return rc;
		iParmNo = 0;
	}
	else {
		if ((iParmNo=_chk_define(scrct,proc,varnam,vnlen,opt,argv)) < 0) return iParmNo;
		if (iARRAY==2 && !iParmNo) {
			ERROROUT2(FORMAT(438),argv[0],varnam);	/* %s: [%s]͖`łB */
			return ECL_SCRIPT_ERROR;
		}
/*
printf("%s: iParmNo=%d\n",_name_,iParmNo);
*/
	}
#if 1
	if (iARRAY == 1) {
		if (nparm>0 && iParmNo>0) {
#else
	if (nparm > 0) {
		if (iParmNo > 0) {
#endif
			/* %s: `ςMAPPEDARRAŶ߃CfbNX܂͎͎wł܂B */
			ERROROUT1(FORMAT(439),_name_);
			return ECL_SCRIPT_ERROR;
		}
		memset(&tIndex,0,sizeof(tdtArrayIndex));
		tIndex.uAttr[0] = DEF_ZOK_VARI;
		tIndex.size = sizeof(tdtInfoParm *);
		index = tIndex.index;
#if 1	/* 2017.7.18 koba */
		index[0] = 1;
#if 1	/* 2020.7.4 */
		index[3] = 1;
#else
		for (i=0;i<index[0]+1;i++) index[i+3] = 1;
#endif
		index[4] = 10;
		index[1] = index[4];
/*
printf("cl_pr_ex_def_map_ary:1 index = %d %d %d %d %d\n",
index[0],index[1],index[2],index[3],index[4]);
*/
#else
		for (i=0;i<4;i++) index[i] = 1;
		index[1] = 10;
#endif
		if (rc = _set_index(0,nparm,qprmp,0,index,_name_)) return rc;
		if ((rc=cl_def_map_ary_max_chk(c,index,scrct,proc,opt)) < 0) return rc;
	}

	if (opt & D_GX_OPT_REDEFINE) {
		memcpy(pInfoParm->pi_data,&tIndex,sizeof(tdtArrayIndex));
	}
	else if (iParmNo > 0) {
		pTBL_vname = (tdtInfoParm ***)argv[1];
		pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);
	}
	else {
		pha_vname  = (XHASHB *)argv[4];
		if ((iParmNo=cl_gx_chk_vnam('s',pha_vname,varnam,vnlen))<1){
					/* %s: %s%sGgp̋󂫂܂B */
			ERROROUT3(FORMAT(323),_name_,varnam,argv[3]);
			return ECL_SCRIPT_ERROR;
		}
/*
printf("%s: pha_vname=%08x varnam=[%s] vnlen=%d iParmNo=%d\n",
argv[0],pha_vname,varnam,vnlen,iParmNo);
*/
		pTBL_vname = (tdtInfoParm ***)argv[5];
		pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);
		if (!pInfoParm) return (ECL_SCRIPT_ERROR);
		info_parm_clear(pInfoParm);
		pInfoParm->pi_id   = 'A';
		pInfoParm->pi_scale = D_DATA_MALLOC | D_DATA_INDEX_FREE;
		pInfoParm->pi_attr = DEF_ZOK_VARI;
		pInfoParm->pi_dlen  = sizeof(tdtArrayIndex);

		if (!(pInfoParm->pi_data = Malloc(sizeof(tdtArrayIndex)))) return ECL_MALLOC_ERROR;
		memcpy(pInfoParm->pi_data,&tIndex,sizeof(tdtArrayIndex));

		if (!(p=Malloc(vnlen+1))) {
			ERROROUT("Array name area malloc");
			return ECL_MALLOC_ERROR;
		}
		strnzcpy(p,varnam,vnlen);
		pInfoParm->pi_pos = (long)p;

		if (opt & D_GX_OPT_SET_LOCAL) pInfoParm->pi_hlen = proc->ProcGid;
		else pInfoParm->pi_hlen = scrct->ScrGid;

		if (c=='%' && (opt & D_GX_OPT_SET_LOCAL)) ucLOCAL = D_AUX1_LOCAL_VAR;
		pInfoParm->pi_aux[1] = ucLOCAL;

		if ((rc=cl_gx_clear_var_define(scrct,proc,p,opt)) < 0) return rc;
	}
	if (iEQU) {
/*
printf("%s: iARRAY=%d is=%d prmnum=%d\n",argv[0],iARRAY,is,prmnum);
printf("%s: iEQU=%d ssp.sp=%d\n",argv[0],iEQU,ssp.sp);
*/
		pprmp[2]->prp = line + iEQU;
		pprmp[2]->prmlen = line_len - iEQU;
		if (proc) pObj = proc->Obj;
		else pObj = scrct->Obj;
		if (rc = _set_array_values(pInfoParm,1,&pprmp[2],pObj)) return rc;
	}
	return 0;
}
#if 0
/************************************/
/*	cl_pr_ex_def_scalar                 */
/************************************/
int cl_pr_ex_def_scalar(prmnum, pprmp, scrct, proc, opt)
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT  *proc;
int      opt;	/* =0:`ς݂̂Ƃ́A̒lݒ肵Ȃ/!=0:ɐݒ肷 */
{
	return cl_pr_ex_def_scalar_info(prmnum, pprmp, scrct, proc, opt, NULL);
}
#endif

/************************************/
/*	cl_pr_ex_def_scalar_attr_info	*/
/************************************/
int cl_pr_ex_def_scalar_attr_info(prmnum, pprmp, scrct, proc, opt, iParm, ppInfoParm)
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT  *proc;	/* defineR}ĥƂ́ANULL */
int      opt;	/* =0:`ς݂̂Ƃ́A̒lݒ肵Ȃ/!=0:ɐݒ肷 */
int      iParm[];
tdtInfoParm  **ppInfoParm;
{
	int  i,iParmNo,rc,vnlen,iOpt,iNew,len,iCONST,isp,iAux,iSet,tmpvnlen,iFound,option;
	char c, *varnam,*p,*argv[6],*pp,cLET,*vrn;
	prmList *pprmList;
	GWPRM_S gwprm;
	SSPL_S ssp;
	char wrk[4096],tmpvname[40];
	int atr,attr,atr0,size,size_old,attr_old,alsize;
	Leaf tLeaf;
	tdtInfoParm  *pInfoParm,tInfoParm1,tInfoParm2;
	parmList   qpL;
	tdtInfoParm ***pTBL_vname;
	XHASHB *pha_vname;
	MCAT mcat;

	argv[0] = "cl_pr_ex_def_scalar_attr_info";

	iCONST = 0;
	if (opt & D_GX_OPT_SET_CONST) iCONST = D_AUX1_PROTECTED;
	iOpt = opt & D_GX_OPT_SET_SCOPE;
	if (!proc && !iOpt) {
		opt |= D_GX_OPT_SET_PRIVATE;
	}
	if (opt & (D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL)) {
		iOpt |= D_GX_OPT_ALC_CONST;
	}
#if 0
	if ((attr=iParm[0]) == DEF_ZOK_VARI) {
		attr = iParm[0] = 0;
	}
#else
	attr = iParm[0];
#endif
	gwprm.line = pprmp[0]->prp;
	gwprm.line_len = pprmp[0]->prmlen;

DEBUGOUTL3(120,"%s:Enter: iOpt=%08x prmnum=%d",argv[0],iOpt,prmnum);
DEBUGOUTL5(120,"%s: iParm=%d %d %d %d",argv[0],iParm[0],iParm[1],iParm[2],iParm[3]);
DEBUGOUTL4(120,"%s: attr=%d line_len=%d line=[%s]",argv[0],attr,gwprm.line_len,gwprm.line);

	pprmp[1]->prp = gwprm.line + prmnum;
	pprmp[1]->prmlen = gwprm.line_len - prmnum;

	ssp.sp = prmnum;
	ssp.wd = wrk;
	ssp.wdmax = sizeof(wrk);
	atr0 = cmp_gtwd(&gwprm,&ssp,0);
	vnlen  = strlen(wrk);
	varnam = wrk;

DEBUGOUTL5(120,"%s: vnlen=%d varnam=[%s] atr0=%d ssp.sp=%d",argv[0],vnlen,varnam,atr0,ssp.sp);

	ssp.wd = wrk + vnlen + 1;
	ssp.wdmax -= vnlen + 1;
	atr = cmp_gtwd(&gwprm,&ssp,0);
	c = *ssp.wd;

DEBUGOUTL2(120,"%s: c=%c",argv[0],c);

	rc = iNew = isp = 0;
	if (proc) {
		if (!attr && !(opt & (D_GX_OPT_SET_SCOPE | D_GX_OPT_SET_CONST))) iNew = 1;
		else if (!attr && (atr0>=14 && atr0<=17)) iNew = 1;
		else {
			while ((atr<71 || atr>90)&&(atr<14 || atr>17)) {
				if ((atr=cmp_gtwd(&gwprm,&ssp,0)) <= 0) break;

DEBUGOUTL2(121,"%s: atr=%d",argv[0],atr);

			}
			if ((atr>=71 && atr<=90)||(atr>=14 && atr<=17)) {
				if (!attr) iNew = 1;
			/*	else if (c != '=') rc = -1;	*/
				isp = ssp.sp;
			}
			else if (atr0!=62 && atr0<=100/* || c*/) rc = -2;
		}
	}
	else {
		if (c == '=') {
			if (!attr && !(opt & (D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL))) iNew = 1;
		}
	/*	else if (atr>0 && atr<=100) rc = -3;	*/
	}
	cLET = *ssp.wd;

DEBUGOUTL4(120,"%s: attr=%d atr0=%d c=[%c]",argv[0],attr,atr0,c);
DEBUGOUTL4(120,"%s: atr=%d iNew=%d wd=[%s]",argv[0],atr,iNew,ssp.wd);

	if (rc) {
		ERROROUT2(FORMAT(440),argv[0],rc);	/* %s: SYNTAXĂ܂Brc=%d */
		return ECL_SCRIPT_ERROR;
	}
	else if (iNew) {
		tLeaf.cmd.prmnum = 1;
		tLeaf.cmd.prmp = &pprmp[1];
		iOpt |= D_GX_OPT_GET_ADDR;
		pInfoParm = NULL;
		if ((rc=let_compute_info(&tLeaf,proc,iOpt,&pInfoParm)) < 0) return rc;
		if (pInfoParm && iCONST) pInfoParm->pi_aux[1] |= D_AUX1_PROTECTED;
		if (ppInfoParm) *ppInfoParm = pInfoParm;
/*
DEBUGOUT2("%s: bxobj=%08x",argv[0],pprmp[1]->bxobj);
*/
		return 0;
	}

	/* ϐ̎擾 */
	c = *varnam;
	/* ϐɕϐw\Ƃ */
	if (c=='(' || c=='$') {
		memset(&ssp,0,sizeof(SSPL_S));
		ssp.sp = prmnum;
		if ((len=_get_varname(gwprm.line,gwprm.line_len,&ssp,proc,&pprmp[0]->bxobj,&pp)) < 0) return len;
		else if (len > 0) {
			varnam = pp;
			vnlen = len;
			c = *varnam;
		}
	}

DEBUGOUTL3(120,"%s: vnlen=%d varnam=[%s]",argv[0],vnlen,strtemp(varnam,vnlen));

	c = *varnam;
	if (c == '$') {
		varnam++;
		vnlen--;
	}
	else if (c=='%' || c=='#') {
		ERROROUT2(FORMAT(436),argv[0],varnam);	/* %s: ϐ(%s)Ă܂B */
		return ECL_SCRIPT_ERROR;
	}

	if (!proc) {
		if (rc=cl_def_chk_name(varnam,vnlen,argv[0],FORMAT(441))) return rc;	/* ϐ */
	}
	else if (cl_chk_name(varnam, vnlen)) {
		ERROROUT2(FORMAT(436),argv[0],varnam);	/* %s: ϐ(%s)Ă܂B */
		return ECL_SCRIPT_ERROR;
	}
	memset(&tInfoParm2,0,sizeof(tdtInfoParm));
	if (proc && isp>0 && cLET) {
		if (rc=cl_gx_expsn_obj_opt(gwprm.line+isp,gwprm.line_len-isp,
		                           pprmp[1]->bxobj,proc->Obj,&tInfoParm2,0)) return rc;
DEBUGOUT_InfoParm(120,"%s: rc=%d",&tInfoParm2,argv[0],rc);
	}
	iSet = opt & 0x01;
	if (opt & D_GX_OPT_REDEFINE) {
		iSet = 1;
		if (rc=_check_redefine(varnam,vnlen,&pInfoParm,' ',argv[0])) return rc;
		attr_old = pInfoParm->pi_attr;
		if (!attr) attr = attr_old;
		if ((attr>=DEF_ZOK_BINA && attr<=DEF_ZOK_DECI) && (attr_old>=DEF_ZOK_BINA && attr_old<=DEF_ZOK_DECI)) ;
		else if (attr != attr_old) {
			/* %s:̑(%d)ƍĒ`(%d)Ă܂B */
			ERROROUT3(FORMAT(442),argv[0],attr_old,attr);
			return ECL_SCRIPT_ERROR;
		}
		if (opt & D_GX_OPT_SET_CLEAR) {
			info_parm_clear(pInfoParm);
			cl_set_parm_init(pInfoParm,iParm,0x01);
		}
		else if (pInfoParm->pi_aux[0]) {
			if (attr_old==DEF_ZOK_CHAR || attr_old==DEF_ZOK_BULK) {
				alsize = size = iParm[1];
				if (size > 0) {
					size_old = pInfoParm->pi_len;
					p = pInfoParm->pi_data;
					if (size > size_old) {
						if (attr == DEF_ZOK_CHAR) alsize++;
						else if (attr == DEF_ZOK_BULK) alsize += sizeof(int);
						if (!(p=Realloc(p,alsize))) return -1;
						pInfoParm->pi_paux = pInfoParm->pi_data = p;
						if (attr == DEF_ZOK_BULK) {
							memcpy(&len,p+size_old,sizeof(int));
							memcpy(p+size,&len,sizeof(int));
						}
					}
					else if (size < size_old) {
						if (attr == DEF_ZOK_BULK) {
							memcpy(&len,p+size_old,sizeof(int));
							len = X_MIN(size,len);
							memcpy(p+size,&len,sizeof(int));
						}
						else {
							*(p+size) = '\0';
							len = strlen(p);
						}
					}
					pInfoParm->pi_dlen = len;
				}
				pInfoParm->pi_len = size;
			}
			else if (attr == attr_old) {
				if (attr==DEF_ZOK_DECI &&
				    (pInfoParm->pi_hlen!=iParm[2] || pInfoParm->pi_pos!=iParm[3])) {
					pInfoParm->pi_hlen = iParm[2];	/* precision */
					pInfoParm->pi_pos = iParm[3];	/* scale */
					if ((rc=cl_mpa_scale(pInfoParm->pi_data,iParm[2],iParm[3])) < 0) return rc;
					rc = 0;
				}
			}
			else if (attr>=DEF_ZOK_BINA && attr<=DEF_ZOK_DECI) {
				cl_gx_copy_info(&tInfoParm1,pInfoParm);
			/*	info_parm_clear(pInfoParm);	*/
				cl_set_parm_init(pInfoParm,iParm,0x01);
				rc = cl_gx_rep_val_set(pInfoParm,&tInfoParm1);
			/*	if (tInfoParm1.pi_scale & 0x80) Free(tInfoParm1.pi_data);	*/
				info_parm_clear(&tInfoParm1);
			}
		}
	}
	else {
	 	if (!(opt & D_GX_OPT_SET_SCOPE) && proc) {
			if (!(pGlobTable->options[9] & 0x01) && (scrct->pFlag & D_SCRPT_NEW_LEX))
				opt |= D_GX_OPT_SET_LOCAL;
		}
		if ((iParmNo=_chk_define(scrct,proc,varnam,vnlen,opt,argv)) < 0) return iParmNo;
		iAux = (int)argv[2];
		if (iParmNo) {
			pTBL_vname = (tdtInfoParm ***)argv[1];
			if (!(opt & (D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL))) {
				iSet = 1;
				iNew = 1;	/* PUBLIC/GLOBALłȂAredefinełȂƂ́AɎw̃f[^^ŏB */
			}
		}
		else {
			pha_vname  = (XHASHB *)argv[4];
			if ((iParmNo=cl_gx_chk_vnam('s',pha_vname,varnam,vnlen))<1){
					/* %s: %s%sGgp̋󂫂܂B */
				ERROROUT3(FORMAT(323),argv[0],varnam,argv[3]);
				return ECL_SCRIPT_ERROR;
			}
			pTBL_vname = (tdtInfoParm ***)argv[5];
			iSet = iNew = 1;
		}

		pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);

DEBUGOUTL4(111,"%s: iNew=%d iParmNo=%d pInfoParm=%08x",argv[0],iNew,iParmNo,pInfoParm);

		if (!pInfoParm) return ECL_SCRIPT_ERROR;

		if (!iSet || !cLET) {
			if ((rc=cl_gx_clear_var_define(scrct,proc,varnam,opt)) < 0) return rc;
		}
		if (iNew && ((c=pInfoParm->pi_id)==' ' || !c)) {
			if (c) info_parm_clear(pInfoParm);
			cl_set_parm_init(pInfoParm,iParm,0x01);
		}
	}

DEBUGOUT_InfoParm(160,"%s:",pInfoParm,argv[0],0);

	if (ppInfoParm) *ppInfoParm = pInfoParm;
/*
if (scrct) {
DEBUGOUTL3(111,"%s: ProCT=%08x Vary=%08x",argv[0],scrct->ProCT,scrct->Vary);
}
*/
	if (iSet) {
	/*	if ((atr=cmp_gtwd(&gwprm,&ssp)) > 0) {	*/
		if (cLET) {
#if 1	/* 2019.11.11 */
			if (tInfoParm2.pi_id == ' ') {
				if (rc=cl_gx_rep_info_set(pInfoParm,&tInfoParm2,1)) return rc;
			}
			else {
#endif
			tLeaf.cmd.prmnum = 1;
			tLeaf.cmd.prmp = &pprmp[1];
			rc = let_compute_opt(&tLeaf,proc,iOpt);
#if 1	/* 2019.11.11 */
			}
#endif
/*
if (scrct) {
DEBUGOUTL3(111,"%s:after LET: ProCT=%08x Vary=%08x",argv[0],scrct->ProCT,scrct->Vary);
}
*/
/*
DEBUGOUT2("%s: bxobj=%08x",argv[0],pprmp[isp]->bxobj);
*/		}
	}
	if (iCONST) pInfoParm->pi_aux[1] |= D_AUX1_PROTECTED;
	return rc;

 Parm_Less:
	ERROROUT1(FORMAT(42),argv[0]);	/* %s: p[^܂B */
	return ECL_SCRIPT_ERROR;
}
#if 0
/************************************/
/*	cl_pr_ex_def_scalar_info		*/
/************************************/
int cl_pr_ex_def_scalar_info(prmnum, pprmp, scrct, proc, opt, ppInfoParm)
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT  *proc;	/* defineR}ĥƂ́ANULL */
int      opt;	/* =0:`ς݂̂Ƃ́A̒lݒ肵Ȃ/!=0:ɐݒ肷 */
tdtInfoParm  **ppInfoParm;
{
	int  i, rc, iOpt, iCONST, n;
	int  iParm[4],check[4];
	char *p;

	check[0] = 2;
	check[1] = 0x03;
	if ((n=cl_get_def_modifier(prmnum,pprmp,check,iParm)) < 0) return n;
	else if (n > 0) {
		pprmp  += n;
		prmnum -= n;
		if (check[2] & 0x01) opt &= ~D_GX_OPT_SET_SCOPE;
		opt |= check[3];
	}
	return cl_pr_ex_def_scalar_attr_info(prmnum,pprmp,scrct,proc,opt,iParm,ppInfoParm);
}
#endif
/************************************/
/*	cl_pr_ex_def_array              */
/************************************/
int cl_pr_ex_def_array(cmdobj,prmnum,pprmp,scrct,proc,opt)
CMDObject *cmdobj;
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT   *proc;
int      opt;
{
	int  i,rc,vnlen,n,len,iARRAY,iEQU,is,line_len;
	char c,*varnam,*pp,*p,*argv[6],*line,wrk[128],**da;
	tdtInfoParm *pInfoParm;
	int iParm[MAX_ARRAY_DIM+1],check[4],*obj,npr,iob,exec_flg,ipr,ida,ipr_pos,ida_nam;
	tdtObjHead *pObj;
	int iCONST,iSKIP,iSTATIC,iCLEAR;
	Leaf tLeaf;
	SSPL_S ssp;
	parmList *qprmp[MAX_ARRAY_DIM+1];

	argv[0] = "cl_pr_ex_def_array";

	/* parameter check */
	if (prmnum < 1) {
		ERROROUT1(FORMAT(42),argv[0]);	/* %s: p[^܂B */
		return ECL_SCRIPT_ERROR;
	}
	iCLEAR = iSTATIC = iCONST = iARRAY = iEQU = iSKIP = 0;
	mem_set_int(iParm,0,4);
	line = pprmp[0]->prp;
	line_len = pprmp[0]->prmlen;
/*
printf("%s: prmnum=%d line_len=%d line=[%s]\n",argv[0],prmnum,line_len,line);
*/
DEBUGOUTL4(170,"%s: prmnum=%d line_len=%d line=[%s]",argv[0],prmnum,line_len,line);
	memset(&ssp,0,sizeof(SSPL_S));

	exec_flg = 0;
	if (proc) pObj = proc->Obj;
	else pObj = scrct->Obj;

	if (cmdobj->nobj) goto Exobj;

	if (!(obj=cmdobj->exobj)) cl_im_expand(CLcList.mcat_obj,50,&obj);
	if (!(da=cmdobj->da)) cl_im_expand(CLcList.mcat_da,10,&da);
	npr = ida = 0;
	obj[0] = 0;	/* sub_id */
	obj[1] = 0;	/* npr */
	obj[2] = 3;	/* ipr_pos */
	iob = obj[2];

	/* ̎擾 */
	exec_flg = 1;
	npr++;
	obj[iob++] = 1;	/* hc̎擾 */
	ipr_pos = iob++;
	obj[iob++] = ida;	/* w莮 */
	da[ida] = NULL;
	check[1] = 0x1f;
	if ((n=cl_get_def_modifier_SSP(line,line_len,&ssp,gsep,check,iParm,&da[ida],pObj)) < 0) return n;
	else if (n > 0) {
		if (check[2]) {
			if (check[2] & 0x01) opt &= ~D_GX_OPT_SET_SCOPE;
			opt |= check[3];
			if (!proc && (opt & D_GX_OPT_SET_LOCAL)) {
				ERROROUT1(FORMAT(443),argv[0]);	/* %s: LOCAL͎wł܂B */
				return ECL_SCRIPT_ERROR;
			}
			if (opt & D_GX_OPT_SET_CONST) iCONST = D_AUX1_PROTECTED;
			if (opt & D_GX_OPT_SET_ARRAY) iARRAY = 1;
			if (opt & D_GX_OPT_SET_STATIC) iSTATIC = 1;
			if (opt & D_GX_OPT_SET_CLEAR) iCLEAR = 1;
printf("%s: iCONST=%08x iARRAY=%d iSTATIC=%d iCLEAR=%d\n",argv[0],iCONST,iARRAY,iSTATIC,iCLEAR);
		}
	}
	ida++;
	memcpy(&obj[iob],iParm,sizeof(int)*4);
	iob += 4;
	obj[iob++] = opt;
	obj[iob++] = iCONST;

	is = ssp.sp;
	obj[iob++] = is;
	/* ϐ̎擾(ł͕ϐǂݔ΂) */
	vnlen = akxtgwnsl(line,line_len,&ssp,gsep,0x41);
	if (vnlen <= 0) {
		ERROROUT1(FORMAT(435),argv[0]);	/* %s: ϐ܂B */
		return ECL_EX_DEFINE;
	}
	memnzcpy(wrk,ssp.wd,vnlen,sizeof(wrk)-1);
	varnam = wrk;
	if (*varnam == '(') iSKIP = 1;
	else {
		clpeeksl(line,line_len,&ssp,gsep,0x41);
		if (*ssp.wd == '(') {
			len = akxnskipin(varnam,vnlen,"$%#");
			if (len >= vnlen) iSKIP = 1;
		}
	}
	if (iSKIP) {
		ssp.sp = is;
		if (len=cl_skip_to_delm(line,line_len,"()",&ssp,gsep,0)) {
			ERROROUT1(FORMAT(433),argv[0]);	/* %s: JbRĂ܂B */
			return ECL_SCRIPT_ERROR;
		}
	}

	exec_flg = 2;
	npr++;
	obj[ipr_pos] = iob;
	obj[iob++] = 2;	/* hcz`擾̏ */
	ipr_pos = iob++;

	if (!(opt & D_GX_OPT_REDEFINE) && proc && !iARRAY && !iParm[0]) {
		clpeeksl(line,line_len,&ssp,gsep,0x41);
		if (*ssp.wd == '[') iARRAY = -1;	/* zvfƌȂ */
	}
	obj[iob++] = iARRAY;	/* z` */
	if (iARRAY >= 0) {
		/* z`̎擾 */
		n = cl_get_array_def_parm(line,line_len,"=",&ssp,gsep,MAX_ARRAY_DIM,qprmp,&iEQU);
		if (n < 0) return n;
		else if (n) iARRAY = 1;	/* z` */
		else {
			if (iARRAY) {
				if (proc) iARRAY = 2;	/* defineł͂ȂāAarray */
			}
#if 0	/* 2020.5.3 */ /* 2020.10.14 1-->0 */
			else if (opt & D_GX_OPT_REDEFINE) {
				if (iCLEAR || iCONST || iParm[0]) iARRAY = 1;
				else return 0;
			}
#endif
			else iARRAY = -1;	/* arrayz`Ȃ==>ϐ̒`܂͎ */
		}
		if (iARRAY==2 && (iCLEAR || iCONST || iParm[0]/* || (opt & D_GX_OPT_SET_SCOPE)*/)) iARRAY = 1;
		/* defineł͂ȂāAarrayAclearconstw肳Ă */
		/* ARRAY=1: zϐ̒` */
		/* ARRAY=2: zϐւ̃f[^ݒ */
		obj[iob++] = ida;	/* z` */
		obj[iob++] = n;
		obj[iob++] = iARRAY;
		obj[iob++] = iEQU;
		for (i=0;i<n;i++) {
			cl_im_parmcpy(D_OPT_ALC_LEAF,&da[ida++],qprmp[i]);
		}
		memcpy(qprmp,&da[ida-n],sizeof(parmList *)*n);
	}
/*
printf("%s: n=%d iARRAY=%d\n",argv[0],n,iARRAY);
*/
DEBUGOUTL3(170,"%s: n=%d iARRAY=%d",argv[0],n,iARRAY);
	if (iARRAY < 0) {
		obj[1] = npr;

if (DEBUGOUTCHECK(250)) {
for (i=0;i<iob;i++)
DEBUGOUTL2(250,"SCLR: obj[%d]=%d",i,obj[i]);
for (i=0;i<ida;i++)
DEBUGOUTL3(250,"SCLR: da[%d]=0x%08x[%s]",i,da[i],da[i]);
}
		cmdobj->nobj = iob;
		cmdobj->nda = ida;
		cmdobj->exobj = (int *)clmemdup(obj,iob*sizeof(int),0);
		cmdobj->da = (char **)clmemdup(da,ida*sizeof(char *),0);
		return cl_pr_ex_def_scalar_attr_info(is,pprmp,scrct,proc,opt,iParm,&pInfoParm);
	}

	/* ϐ̎擾 */
	exec_flg = 3;
	npr++;
	obj[ipr_pos] = iob;
	obj[iob++] = 3;	/* hcϐ擾̏ */
	ipr_pos = iob++;
/*
	memnzcpy(wrk,varnam,vnlen,sizeof(wrk)-1);
	varnam = wrk;
*/
	c = *varnam;
	obj[iob++] = ida;
	ida_nam = ida;
	da[ida++] = NULL;	/*clstrdup(varnam,0);*/
	/* z񖼂ɕϐw\Ƃ */
	obj[iob] = -1;
	da[ida] = NULL;
	if (iSKIP || c=='$') {
		ssp.sp = is;
	/*	da[ida] = NULL;	*/
		if ((len=_get_varname(line,line_len,&ssp,proc,&da[ida],&pp)) < 0) return len;
	/*	if ((len=_get_varname(line,line_len,&ssp,proc,&pprmp[0]->bxobj,&pp)) < 0) return len;	*/
		else if (len > 0) {
			varnam = pp;
			vnlen = len;
			c = *varnam;
		/*	obj[iob] = ida++;	*/
			obj[iob] = ida;
		}
	}
	da[ida_nam] = clstrdup(varnam,0);
	ida++;
	iob++;

	npr++;
	obj[ipr_pos] = iob;
	obj[iob++] = 4;	/* hcϐ`/Ē` */
	ipr_pos = iob++;
	npr++;
	obj[ipr_pos] = iob;
	obj[iob++] = 5;	/* hc */
	ipr_pos = iob++;
	npr++;
	obj[ipr_pos] = iob;
	obj[iob++] = 6;	/* hcCONST */
	ipr_pos = iob++;
	obj[1] = npr;

if (DEBUGOUTCHECK(250)) {
for (i=0;i<iob;i++)
DEBUGOUTL2(250,"ARRY: obj[%d]=%d",i,obj[i]);
for (i=0;i<ida;i++)
DEBUGOUTL3(250,"ARRY: da[%d]=0x%08x[%s]",i,da[i],da[i]);
}
	cmdobj->nobj = iob;
	cmdobj->nda = ida;
	cmdobj->exobj = (int *)clmemdup(obj,iob*sizeof(int),0);
	cmdobj->da = (char **)clmemdup(da,ida*sizeof(char *),0);

Exobj:
	return cl_pr_ex_def_array_engine(cmdobj,prmnum,pprmp,scrct,proc,opt);
}

/************************************/
/*	cl_pr_ex_def_array_engine		*/
/************************************/
int cl_pr_ex_def_array_engine(cmdobj,prmnum,pprmp,scrct,proc,opt)
CMDObject *cmdobj;
int      prmnum;
parmList **pprmp;
ScrPrCT  *scrct;
ProcCT   *proc;
int      opt;
{
	XHASHB *pha_vname;
	tdtInfoParm ***pTBL_vname;
	int  i,iParmNo,rc,vnlen,n,len,iARRAY,iEQU,is,line_len,count;
	int  attr,size,nparm,attr_old;
	char c,*varnam,*pp,*p,*p_old,*argv[6],*line,**da;
	tdtInfoParm *pInfoParm,**ppParm;
	tdtArrayIndex tIndex,*pIndex;
	int *index;
	int iParm[MAX_ARRAY_DIM+1],check[4],*obj,npr,iob,exec_flg,ipr,ida,ipr_pos,ida_nam;
	tdtObjHead *pObj;
	int iCONST,iSET,iNAME_OPT,iGET_NAM,iSTATIC,iCLEAR;
	parmList *qprmp[MAX_ARRAY_DIM+1];
	tdtObjHead *phObj;

	argv[0] = "cl_pr_ex_def_array_engine";

	/* parameter check */
	if (prmnum < 1) {
		ERROROUT1(FORMAT(42),argv[0]);	/* %s: p[^܂B */
		return ECL_SCRIPT_ERROR;
	}

	iCLEAR = iSTATIC = iCONST = iARRAY = iEQU = iSET = iParmNo = iGET_NAM = 0;
	mem_set_int(iParm,0,4);
	attr_old = attr = 0;
	size = sizeof(tdtInfoParm *);
	line = pprmp[0]->prp;
	line_len = pprmp[0]->prmlen;
/*
printf("%s: prmnum=%d line_len=%d line=[%s]\n",argv[0],prmnum,line_len,line);
*/
DEBUGOUTL4(170,"%s: prmnum=%d line_len=%d line=[%s]",argv[0],prmnum,line_len,line);

	exec_flg = 0;
	if (proc) pObj = proc->Obj;
	else pObj = scrct->Obj;

	if (cmdobj->nobj <= 0) {
		ERROROUT1(FORMAT(606),argv[0]);	/* %s: zϐ`R}h܂B */
		return ECL_SCRIPT_ERROR;
	}
	obj = cmdobj->exobj;
	da = cmdobj->da;
	npr = obj[1];
	ipr_pos = obj[2];
DEBUGOUTL4(170,"%s: exec_flg=%d obj[1]=%d obj[2]=%d",argv[0],exec_flg,obj[1],obj[2]);
	while (npr-- > 0) {
		ipr = obj[ipr_pos];
		iob = ipr_pos + 2;
		ipr_pos = obj[ipr_pos+1];
/*
printf("%s: ipr=%d iob=%d ipr_pos=%d\n",argv[0],ipr,iob,ipr_pos);
*/
DEBUGOUTL4(170,"%s: ipr=%d iob=%d ipr_pos=%d",argv[0],ipr,iob,ipr_pos);
		if (ipr==1 && exec_flg<1) {	/* hc̎擾 */
/*
printf("%s: iob=%d\n",argv[0],iob);
*/
			ida = obj[iob++];
			memcpy(iParm,&obj[iob],sizeof(int)*4);
			attr = iParm[0];
			size = iParm[1];
			iob += 4;
/*
printf("%s: ida=%d da[ida]=%08x\n",argv[0],ida,da[ida]);
*/
			if (rc=cl_get_def_attr_opt(NULL,0,iParm,opt,&da[ida],pObj)) return rc;
			opt = obj[iob++];
			iCLEAR = opt & D_GX_OPT_SET_CLEAR;
			iCONST = obj[iob++];
			is = obj[iob++];
printf("%s: opt=%08x iCONST=%08x is=%d iCLEAR=%d\n",argv[0],opt,iCONST,is,iCLEAR);
		}
		else if (ipr==2 && exec_flg<2) {	/* hcz`擾̏ */
			iARRAY = obj[iob++];	/* z` */
			if (iARRAY >= 0) {
				/* z`̎擾 */
				ida = obj[iob++];	/* z` */
				n = obj[iob++];
				memcpy(qprmp,&da[ida],sizeof(parmList *)*n);
				iARRAY = obj[iob++];
				iEQU = obj[iob++];

printf("%s: ida=%d n=%d iARRAY=%d iEQU=%d\n",argv[0],ida,n,iARRAY,iEQU);

			}
/*
printf("%s: iARRAY=%d\n",argv[0],iARRAY);
*/
			if (iARRAY < 0) {
				return cl_pr_ex_def_scalar_attr_info(is,pprmp,scrct,proc,opt,iParm,&pInfoParm);
			}
		}
		else if (ipr == 3) {	/* hcϐ擾̏ */
			ida_nam = obj[iob++];
			varnam = da[ida_nam];
			vnlen = strlen(varnam);
			c = *varnam;
/*
printf("%s: vnlen=%d varnam=[%s]\n",argv[0],vnlen,varnam);
*/
			if (exec_flg < 3) {
				c = '\0';
				if ((ida=obj[iob++]) >= 0) {
					if ((len=_get_varname(NULL,0,NULL,proc,&da[ida],&pp)) < 0) return len;
					else if (len > 0) {
						varnam = pp;
						vnlen = len;
						c = *varnam;
					}
					iGET_NAM = 1;
				}
			}
			if (c) {

DEBUGOUTL3(170,"%s: vnlen=%d varnam=[%s]",argv[0],vnlen,varnam);

				/*if (opt & D_GX_OPT_REDEFINE) */iNAME_OPT = 1;
				if (c=='$') {
					vnlen--;
					varnam++;
				}
				if (c=='%' || c=='#') {
					ERROROUT2(FORMAT(436),argv[0],varnam);	/* %s: ϐ(%s)Ă܂B */
					return ECL_SCRIPT_ERROR;
				}
				else if (rc=cl_def_chk_name_opt(varnam,vnlen,argv[0],FORMAT(441),opt & D_GX_OPT_REDEFINE)) return rc;
				if (iGET_NAM) p = "";
				else p = varnam;
				da[ida_nam] = clstrdup(p,0);
DEBUGOUTL3(170,"%s: ida_nam=%d da[ida_nam]=[%s]",argv[0],ida_nam,da[ida_nam]);
			}
DEBUGOUTL3(170,"%s: vnlen=%d varnam=[%s]",argv[0],vnlen,varnam);
		}
		else if (ipr == 4) {	/* hcϐ`/Ē` */

 	if ((iARRAY==1) && !(opt & D_GX_OPT_SET_SCOPE)) {
		if (proc) {
			if (!(pGlobTable->options[9] & 0x01) && (scrct->pFlag & D_SCRPT_NEW_LEX))
				opt |= D_GX_OPT_SET_LOCAL;
			else opt |= D_GX_OPT_SET_PRIVATE;
		}
		else opt |= D_GX_OPT_SET_PRIVATE;
	}

	if (iARRAY == 1) opt |= D_GX_OPT_SET_ARRAY;
	else opt &= ~D_GX_OPT_SET_ARRAY;

	if (opt & D_GX_OPT_REDEFINE) {
		if (rc=_check_redefine(varnam,vnlen,&pInfoParm,'R',"cl_pr_ex_def_array")) return rc;
		pIndex = (tdtArrayIndex *)pInfoParm->pi_data;
	/*	attr_old = pInfoParm->pi_attr;	*/
		attr_old = pIndex->uAttr[0];
		if (!attr) {
			attr = attr_old;
			size = pIndex->size;
		}
	}
	else {
		if (!attr) attr = DEF_ZOK_VARI;
		len = akxnskipto(varnam,vnlen,".");
		if (iARRAY==1 && (len<vnlen)) {
			/* %s: STRUCT̃o[%s]͎wł܂B */
			ERROROUT2(FORMAT(444),argv[0],varnam);
			return ECL_SCRIPT_ERROR;
		}
		if ((iParmNo=_chk_define(scrct,proc,varnam,len,opt,argv)) < 0) return iParmNo;
		if (iARRAY==2 && !iParmNo) {
			ERROROUT2(FORMAT(438),argv[0],varnam);	/* %s: [%s]͖`łB */
			return ECL_SCRIPT_ERROR;
		}
/*
printf("%s: iParmNo=%d\n",argv[0],iParmNo);
*/
DEBUGOUTL2(170,"%s: iParmNo=%d",argv[0],iParmNo);
	}

#if 0
	if (size <= 0) {
		ERROROUT2(FORMAT(454),argv[0],size);
		return ECL_SCRIPT_ERROR;
	}
#endif
	iParm[0] = attr;
	iParm[1] = size;
	if (!iParmNo && iARRAY==1) {
		if (rc=_def_array(n,&qprmp[0],opt,iParm,&tIndex,attr_old,pIndex)) return rc;
/*
printf("%s: qprmp[0]=%08x qprmp[0]->bxobj=%08x\n",argv[0],qprmp[0],qprmp[0]->bxobj);
*/
if (n>0) {
DEBUGOUTL3(170,"%s: qprmp[0]=%08x qprmp[0]->bxobj=%08x",argv[0],qprmp[0],qprmp[0]->bxobj);
}
	}

	if (opt & D_GX_OPT_REDEFINE) {
		if (iARRAY == 1) {
			memcpy(pInfoParm->pi_data,&tIndex,sizeof(tdtArrayIndex));
		}
		iSET = 1;
		if (iCLEAR) {
			ppParm = &pInfoParm;
			if (rc=cl_array_ope_opt(&count,1,ppParm,D_FUC_ARRAY_CLR,0)) return rc;
		}
	}
	else {
		if (iParmNo > 0) {
			pTBL_vname = (tdtInfoParm ***)argv[1];
			pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);
			if (iARRAY == 2) {
				if (pInfoParm->pi_id=='T') {
					if (++len < vnlen) {
						if (rc=_ex_get_member(&pInfoParm,opt,varnam+len,vnlen-len)) return rc;
					}
				}
				if ((c=pInfoParm->pi_id)!='R' && c!='A') {
					/* %s: [%s]͔zł͂܂B */
					ERROROUT2(FORMAT(445),argv[0],varnam);
					return ECL_SCRIPT_ERROR;
				}
				iSET = 1;
			}
			else {
				if (rc=_chk_array(n,&qprmp[0],iParm,iCONST,pInfoParm)) return rc;
			}
		}
		else {
			iSET = 1;
			pha_vname  = (XHASHB *)argv[4];
			if ((iParmNo=cl_gx_chk_vnam('s',pha_vname,varnam,vnlen)) < 1) {
					/* %s: %s%sGgp̋󂫂܂B */
				ERROROUT3(FORMAT(323),argv[0],varnam,argv[3]);
				goto Error;
			}
			pTBL_vname = (tdtInfoParm ***)argv[5];
			pInfoParm = cl_get_var_ent(pTBL_vname,iParmNo);
/*
printf("cl_pr_ex_def_array: pha_vname=%08x pTBL_vname=%08x pInfoParm=%08x\n",pha_vname,pTBL_vname,pInfoParm);
*/
DEBUGOUTL3(170,"cl_pr_ex_def_array: pha_vname=%08x pTBL_vname=%08x pInfoParm=%08x",pha_vname,pTBL_vname,pInfoParm);
			if (!pInfoParm) return ECL_SCRIPT_ERROR;
			info_parm_clear(pInfoParm);
			pInfoParm->pi_id   = 'R';
			pInfoParm->pi_scale = D_DATA_MALLOC | D_DATA_INDEX_FREE;
			pInfoParm->pi_attr = DEF_ZOK_BULK;	/* attr;	*/
			pInfoParm->pi_dlen  = sizeof(tdtArrayIndex);
			if (!(pInfoParm->pi_data = Malloc(sizeof(tdtArrayIndex)))) return -1;
			memcpy(pInfoParm->pi_data,&tIndex,sizeof(tdtArrayIndex));
			if (!(p=Malloc(vnlen+1))) {
				ERROROUT1("%s: Array name area malloc",argv[0]);
				goto Error;
			}
			strnzcpy(p,varnam,vnlen);
			pInfoParm->pi_pos = (long)p;
			if (opt & D_GX_OPT_SET_LOCAL) pInfoParm->pi_hlen = proc->ProcGid;
			else if (!(opt & (D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL))) pInfoParm->pi_hlen = scrct->ScrGid;
			pInfoParm->pi_paux = (char *)pInfoParm;	/* Rs[ꂽƂɁA̔z񂪗L`FbN邽߂ɕۑ */

			if ((rc=cl_gx_clear_var_define(scrct,proc,p,opt)) < 0) return rc;
		}
DEBUGOUT_InfoParm(194,"cl_pr_ex_def_array: attr=%d size=%d",pInfoParm,attr,size);
	}

		}
		else if (ipr == 5) {	/* hc */

	if (iSET && iEQU) {
/*
printf("cl_pr_ex_def_array: iARRAY=%d is=%d prmnum=%d\n",iARRAY,is,prmnum);
*/
		pprmp[1]->prp = line + iEQU;
		pprmp[1]->prmlen = line_len - iEQU;
		if (proc) phObj = proc->Obj;
		else phObj = scrct->Obj;
/*
printf("cl_pr_ex_def_array: proc=%08x scrct=%08x phObj=%08x\n",proc,scrct,phObj);
*/
		if (rc = _set_array_values(pInfoParm,1,&pprmp[1],phObj)) return rc;
	}

		}
		else if (ipr == 6) {	/* hcCONST */

	if (iCONST) pInfoParm->pi_aux[1] |= D_AUX1_PROTECTED;

		}
		else if (ipr == 7) {	/* pInfoParmԂ */
			ida = obj[iob];
			da[ida] = (char *)pInfoParm;
		}
	}
DEBUGOUT_InfoParm(194,"cl_pr_ex_def_array:Exit ",pInfoParm,0,0);
	return 0;

 Error:
 	if (tIndex.xhp) akxs_xhash_free(tIndex.xhp);
 	if (tIndex.pVarIndex) Free(tIndex.pVarIndex);
	return ECL_SCRIPT_ERROR;
}

/************************************/
/* cl_pr_ex_un_define				*/
/************************************/
int cl_pr_ex_un_define(leaf, proc)
Leaf    *leaf;
ProcCT  *proc;
{
	static char *_name_="cl_pr_ex_un_define";
	XHASHB *pha_vname;
	int  i, j, rc, vnlen, n, *pSize, ixlen, iHASHED_NAME, opt, scope;
	char c, *varnam, *p, *ixnam, buf[64];
	tdtInfoParm *pInfoParm,tInfoParm;
	tdtArrayIndex tIndex,*pIndex;
	int *index;
	tdtInfoParm ***pTBL_vname,***pTBL_pas;
	uchar ucLOCAL=0;
	ScrPrCT *scrct;
	parmList **pprmp;
	Leaf *topleaf,*curleaf;

	if (!leaf || !proc) return ECL_SYSTEM_ERROR;
	if (!(scrct = cl_search_src_ct())) return ECL_SYSTEM_ERROR;

	n = leaf->cmd.prmnum;
	pprmp = leaf->cmd.prmp;
	for (i=0;i<n;i++) {
		varnam = pprmp[i]->prp;
		if (rc=cl_gx_exp_obj_opt(1,&pprmp[i],proc->Obj,&tInfoParm,D_GX_OPT_GET_ADDR)) {
			ERROROUT2(FORMAT(125),_name_,varnam);	/* %s: [%s]Ă܂B */
			return ECL_SCRIPT_ERROR;
		}
DEBUGOUT_InfoParm(110,"%s: get rc=%d",&tInfoParm,_name_,rc);
		if ((c=tInfoParm.pi_id) != D_DATA_ID_STOREVAR) {
			ERROROUT2(FORMAT(446),_name_,varnam);	/* %s: %sUNDEFINEł܂B */
			return ECL_SCRIPT_ERROR;
		}
		pInfoParm = (tdtInfoParm *)tInfoParm.pi_pos;
		if ((tInfoParm.pi_aux[1] & D_AUX1_PROTECTED) ||
		    (pInfoParm->pi_aux[1] & D_AUX1_PROTECTED)) {
			ERROROUT2(FORMAT(446),_name_,varnam);	/* %s: %sUNDEFINEł܂B */
			return ECL_SCRIPT_ERROR;
		}
		vnlen = pprmp[i]->prmlen;
		opt = pInfoParm->pi_aux[1];
		if (opt & D_AUX1_HASHED_NAME) {
/*
printf("%s: opt=%08x\n",_name_,opt);
*/
			if (opt & D_AUX1_GLOBAL_VAR) {
				pha_vname = pGLprocTable->pha_vnam;
				scope = D_AUX1_GLOBAL_VAR;
			}
			else if (opt & D_AUX1_PUBLIC_VAR) {
				pha_vname = pCLprocTable->pha_vnam;
				scope = D_AUX1_GLOBAL_VAR | D_AUX1_PUBLIC_VAR;
			}
			else if (opt & D_AUX1_LOCAL_VAR) {
				pha_vname = proc->pha_vnam;
				scope = D_AUX1_GLOBAL_VAR | D_AUX1_PUBLIC_VAR | D_AUX1_PRIVATE_VAR | D_AUX1_LOCAL_VAR;
			}
			else {
				pha_vname = scrct->Vary->pha_vnam;
				scope = D_AUX1_GLOBAL_VAR | D_AUX1_PUBLIC_VAR | D_AUX1_PRIVATE_VAR;
			}
			if (pha_vname) {
				c = pInfoParm->pi_id;
				if (c=='R' || c=='A' || c=='T' || c=='P'/* || c=='L'*/) {
					varnam = (char *)pInfoParm->pi_pos;
					vnlen = strlen(varnam);
				}
				else if (*varnam == '$') {
					varnam++;
					vnlen--;
				}
				rc = cl_gx_chk_vnam('d',pha_vname,varnam,vnlen);
/*
printf("%s: delete name=[%s] ix=%d\n",_name_,varnam,rc);
*/
				if (rc > 0) {
					if ((c=*varnam)!='$' && c!='%' && c!='#') {
						p = buf;
						*buf = '$';
						memnzcpy(buf+1,varnam,vnlen,sizeof(buf)-1);
					}
					else p = varnam;
					if ((scope & D_AUX1_LOCAL_VAR) && pInfoParm->pi_id==' ') {
						topleaf = proc->ProcTop->leftleaf;
						curleaf = NULL;
#if 1
						if ((rc=cl_gx_clear_var_obj(topleaf,curleaf,p,proc->Obj,scope)) < 0) return rc;
#endif
					}
					else {
						topleaf = scrct->TreeTop;
						curleaf = leaf;
#if 1
						if ((rc=cl_gx_clear_var_obj_all(scrct,curleaf,p,scope)) < 0) return rc;
#endif
					}
#if 0
					if ((rc=cl_gx_clear_var_obj(topleaf,curleaf,p,proc->Obj,scope)) < 0) return rc;
#endif
				}
			}
		}
		cl_free_info_parm(pInfoParm);
DEBUGOUT_InfoParm(110,"%s: FreeInfo",pInfoParm,_name_,0);
	}
	return 0;
}

/************************************/
/* _def_array_set_init_by_attr      */
/*  쐬 : 2020.10.12               */
/************************************/
int _def_array_set_init_by_attr(attr,n,alsize,ptIndex,iParm)
int attr,n,alsize,iParm[];
tdtArrayIndex *ptIndex;
{
	char *p;
	int na,rc,i;
	tdtInfoParm *pInfo,*pInfoP,**ppInfo;
	tdtDefType *pDeftypeP;

printf("_def_array_set_init_by_attr: attr=%d n=%d alsize=%d\n",attr,n,alsize);

	na = n*alsize;
	if (!(p=Malloc(na))) return -10;
	memset(p,0,na);
	ptIndex->pVarIndex = (tdtInfoParm **)p;
	if (attr==DEF_ZOK_DECI && alsize==sizeof(MPA))
		m_set_array((MPA *)p,m_get_i(0),n);
	else if (attr == D_AUX0_TYPE_STRUCT) {
		if (pInfoP = (tdtInfoParm *)iParm[2]) {
			pDeftypeP = (tdtDefType *)pInfoP->pi_data;
			ppInfo = (tdtInfoParm **)p;
			for (i=0;i<n;i++) {
				if (!(p=Malloc(sizeof(tdtInfoParm)))) return -11;
				pInfo = (tdtInfoParm *)p;
				cl_parm_set0(pInfo);
				if (rc=cl_gx_rep_info_set(pInfo,pInfoP,1)) return rc;
				if (rc=_def_var_struct(pInfo,pDeftypeP)) return rc;
				*ppInfo++ = pInfo;
			}
			iParm[0] = DEF_ZOK_VARI;
			iParm[2] = 0;
		}
	}

	if (attr && attr!=DEF_ZOK_VARI) ptIndex->index[2] = n;

	return 0;
}

/************************************/
/* _def_array                       */
/************************************/
int _def_array(prmnum, pprmp, opt, iParm, ptIndex, attr_old, pIndex)
int      prmnum;
parmList **pprmp;
int      opt,iParm[],attr_old;
tdtArrayIndex *ptIndex,*pIndex;
{
	static char *_fn_="_def_array";
	int  i,rc,n,len,id,attr,size,iHASH,prmnum0,iParmW[2],m_opt;
	int  n_old,na,na_old,alsize,size_old,alsize_old,size_min,pre,old_pre,sca,old_sca;
	char c,*pp,*p,*p_old;;
	int *index;
	MPA ma;

printf("%s:Enter: prmnum=%d pprmp=%08x opt=%08x attr_old=%d\n",_fn_,prmnum,pprmp,opt,attr_old);

	if (prmnum < 0) return 0;
	else if (!pprmp) return -1;

	prmnum0 = prmnum;
	attr = iParm[0];
	size = iParm[1];
	pre  = iParm[2];
	sca  = iParm[3];

printf("%s: attr=%d size=%d pre=%d sca=%d\n",_fn_,attr,size,pre,sca);

/* ɁAl͐ݒ肳ĂȂ
p = ptIndex->uAttr;
printf("%s: new uAttr=%d %d %d %d\n",_fn_,p[0],p[1],p[2],p[3]);
*/
	if (opt & D_GX_OPT_REDEFINE) {
		if (!attr_old || !pIndex) return -2;
		else if (attr_old != attr) {
			/* %s: ̑(%d)ƍĒ`(%d)Ă܂B */
			ERROROUT3(FORMAT(442),_fn_,attr_old,attr);
			return ECL_SCRIPT_ERROR;
		}
		size_old = pIndex->size;
		index = pIndex->index;
#if 1	/* 2017.7.18 koba */
		n_old = index[1];
#else
		n_old = index[1]*index[2]*index[3];
#endif
/*
printf("attr=%d size=%d attr_old=%d size_old=%d n_old=%d\n",attr,size,attr_old,size_old,n_old);
*/
		p_old = pIndex->uAttr;
/*
printf("%s: old uAttr=%d %d %d %d\n",_fn_,p_old[0],p_old[1],p_old[2],p_old[3]);
*/
		old_pre = p_old[2];
		old_sca = p_old[3];
	}

	memset(ptIndex,0,sizeof(tdtArrayIndex));
	index = ptIndex->index;
	if ((opt & D_GX_OPT_REDEFINE) && !prmnum) {
		memcpy(index,pIndex->index,sizeof(pIndex->index));
	}
	else {
#if 1	/* 2017.7.18 koba */
#if 1	/* 2020.10.24 koba */
		index[0] = 1;
		index[2] = 0;
		index[3] = 1;
		for (i=0;i<index[0]*2;i+=2) {
			index[i+4] = 1;
			index[i+5] = 0;
		}
#else
		index[0] = 1;
		for (i=0;i<index[0]+1;i++) index[i+3] = 1;
#endif
		index[4] = 10;
		index[1] = index[4];
#else
		for (i=0;i<=MAX_ARRAY_DIM;i++) index[i] = 1;
		index[1] = 10;
#endif
	}

	if (prmnum>0 && !stricmp(pprmp[0]->prp,"HASH")) {
		if (opt & D_GX_OPT_REDEFINE) {
			ERROROUT1(FORMAT(447),_fn_);	/* %s: HASHw͍Ē`ł܂B */
			return ECL_SCRIPT_ERROR;
		}
#if 1	/* 2017.7.18 koba */
		index[2] = -1;	/* 0x80; 2020.4.30 */
#else
		index[MAX_ARRAY_DIM+1] = 0x80;
#endif
		iHASH = 1;
		pprmp++;
		prmnum--;
		if (prmnum > 1) goto Parm_More;
	}
	else iHASH = 0;
	if (prmnum > 0) {
		if (rc = _set_index(1,prmnum,pprmp,0,index,"_def_array: ")) return rc;
	}
#if 1	/* 2017.7.18 koba */
	n = index[1];
#else
	n = index[1]*index[2]*index[3];
#endif
	if (n < 0) {
		/* %s: ͈͎w([%d,%d,%d])z̍ő(%d)𒴂Ă܂B */
		ERROROUT5(FORMAT(448),_fn_,index[1],index[2],index[3],INT_MAX);
		return ECL_SCRIPT_ERROR;
	}

printf("_def_array: iHASH=%d index=%d[%d,%d,%d]\n",iHASH,index[0],index[1],index[2],index[3]);

	if (iHASH) {
		if (!(opt & D_GX_OPT_NOALLOC_INDX)) {
			if (!(ptIndex->xhp=akxs_xhash_new2(0,index[1],0,sizeof(tdtInfoParm *)))) return -9;
		}
	}
#if 1
	else if ((opt & D_GX_OPT_REDEFINE) &&
	         ((attr!=DEF_ZOK_DECI && size_old==size && n==n_old)
	       || (attr==DEF_ZOK_DECI && pre==old_pre && sca==old_sca))) {
#else
	else if (size_old==size && n==n_old) {
#endif
		ptIndex->pVarIndex = pIndex->pVarIndex;
	}
	else {
		if ((opt & D_GX_OPT_REDEFINE) &&
		    ((!size_old && size) || (size_old && !size))) {
			_redefine_size_zero(attr,size,n,size_old,n_old,ptIndex,pIndex);
		}
		else {
#if 1
			iParmW[0] = attr;
			iParmW[1] = size;
			if ((alsize=cl_get_def_alsize(iParmW)) < 0) return alsize;
#else
		  if (!size && (attr==DEF_ZOK_CHAR || attr==DEF_ZOK_BULK)) {
			attr = DEF_ZOK_VARI;
			size = sizeof(tdtInfoParm *);
		  }
		  alsize = size;
		  if (attr == DEF_ZOK_CHAR) alsize++;
		  else if (attr == DEF_ZOK_BULK) alsize += sizeof(int);
#endif
		  na = n*alsize;
		  if (na < 0) {
			/* %s: zf[^悪ől(%d)𒴂Ă܂B */
			ERROROUT4(FORMAT(456),_fn_,n,alsize,INT_MAX);
			return ECL_SCRIPT_ERROR;
		  }
		  if (opt & D_GX_OPT_REDEFINE) {
#if 1
			iParmW[0] = attr;
			iParmW[1] = size_old;
			if ((alsize_old=cl_get_def_alsize(iParmW)) < 0) return alsize_old;
#else
			alsize_old = size_old;
			if (attr == DEF_ZOK_CHAR) alsize_old++;
			else if (attr == DEF_ZOK_BULK) alsize_old += sizeof(int);
#endif
			na_old = n_old*alsize_old;
			if (!(pp=Malloc(na))) {
				/* "%s: %spMallocG[B */
				ERROROUT2(FORMAT(321),_fn_,FORMAT(586));	/*  zf[^ */
				return -11;
			}
			p_old = (char *)pIndex->pVarIndex;
			if ((attr==DEF_ZOK_CHAR || attr==DEF_ZOK_BULK) && size_old!=size) {
				p = pp;
				size_min = X_MIN(size,size_old);
				for (i=0;i<X_MIN(n,n_old);i++) {
					if (attr == DEF_ZOK_CHAR) strnzcpy(p,p_old,size_min);
					else if (attr == DEF_ZOK_BULK) {
						memcpy(&len,p_old+size_old,sizeof(int));
						memcpy(p,p_old,size_min);
						len = X_MIN(len,size);
						memcpy(p+size,&len,sizeof(int));
					}
					p += alsize;
					p_old += alsize_old;
				}
			}
			else if (attr==DEF_ZOK_DECI && iParm[2]>0) {
				m_opt = cl_get_option(12,0);
				p = pp;
				for (i=0;i<X_MIN(n,n_old);i++) {
					memcpy(p,p_old,alsize);
					if ((rc=cl_mpa_scale_opt((MPA *)p,iParm[2],iParm[3],m_opt))<0) return rc;
					p += alsize;
					p_old += alsize;
				}
			}
			else memcpy(pp,p_old,X_MIN(na,na_old));
			if (na > na_old) memset(pp+na_old,0,na-na_old);
			ptIndex->pVarIndex=(tdtInfoParm **)pp;
			Free(pIndex->pVarIndex);
		  }
		  else if (!(opt & D_GX_OPT_NOALLOC_INDX)) {
#if 1	/* 2019.11.23 */
#if 1	/* 2020.10.12 */
			if (rc=_def_array_set_init_by_attr(attr,n,alsize,ptIndex,iParm)) return rc;
#else
/*
printf("%s: attr=%d alsize=%d n=%d\n",_fn_,attr,alsize,n);
*/
			if (!(p=Malloc(na))) return -10;
			ptIndex->pVarIndex = (tdtInfoParm **)p;
			if (attr==DEF_ZOK_DECI && alsize==sizeof(MPA))
				m_set_array(p,m_get_i(0),n);
			else if (attr == D_AUX0_TYPE_STRUCT) {
				pInfoP = (tdtInfoParm *)iParm[2];
				pDeftypeP = (tdtDefType *)pInfoP->pi_data;
				ppInfo = (tdtInfoParm **)p;
				for (i=0;i<n;i++) {
					if (!(p=Malloc(sizeof(tdtInfoParm)))) return -11;
					pInfo = (tdtInfoParm *)p;
					if (rc=cl_gx_rep_info_set(pInfo,pInfoP,1)) return rc;
					if (rc=_def_var_struct(pInfo,pDeftypeP)) return rc;
					*ppInfo++ = pInfo;
				}
				iParm[0] = DEF_ZOK_VARI;
				iParm[2] = 0;
			}
			else
				memset(p,0,na);
			if (attr && attr!=DEF_ZOK_VARI) index[2] = n;
#endif
#else
			if (!(ptIndex->pVarIndex=(tdtInfoParm **)Malloc(na))) return -10;
			memset(ptIndex->pVarIndex,0,na);
#endif
		  }
		}
	}
	ptIndex->uAttr[0] = iParm[0];
	ptIndex->uAttr[2] = iParm[2];
	ptIndex->uAttr[3] = iParm[3];
	ptIndex->size = iParm[1];

printf("%s:Exit iParm=%d %d %d %d\n",_fn_,iParm[0],iParm[1],iParm[2],iParm[3]);

	return 0;

 Parm_More:
 	/* "%s: ]ȃp[^(nparm=%d [%s])܂B */
	ERROROUT3(FORMAT(605),_fn_,prmnum0,pprmp[1]->prp);
	return ECL_SCRIPT_ERROR;
}

/************************************/
/* _chk_array                       */
/************************************/
static int _chk_array(prmnum,pprmp,iParm,iCONST,pInfoParm)
int      prmnum;
parmList **pprmp;
int      iParm[],iCONST;
tdtInfoParm *pInfoParm;
{
	static char *_fn_="_chk_array";
	tdtArrayIndex tIndex,*pIndex;
	int  i,rc,n,len,id,attr,size,iHASH,ndim,prmnum0;
	int  attr_old,size_old,iCONST_old;
	int *index;

	if (prmnum < 0) return 0;
	else if (!pprmp) return -1;

	attr = iParm[0];
	size = iParm[1];
	memset(&tIndex,0,sizeof(tdtArrayIndex));
	index = tIndex.index;
#if 1	/* 2017.7.18 koba */
	index[0] = 1;
	index[1] = 10;
	index[4] = 10;
	for (i=0;i<=MAX_ARRAY_DIM;i++) index[i+4] = 1;
#else
	for (i=0;i<=MAX_ARRAY_DIM;i++) index[i] = 1;
	index[1] = 10;
#endif

	prmnum0 = prmnum;
	if (prmnum>0 && !stricmp(pprmp[0]->prp,"HASH")) {
		iHASH = 1;
		pprmp++;
		prmnum--;
		if (prmnum > 1) {
		 	/* "%s: ]ȃp[^(nparm=%d [%s])܂B */
			ERROROUT3(FORMAT(605),_fn_,prmnum0,pprmp[1]->prp);
			return ECL_SCRIPT_ERROR;
		}
	}
	else iHASH = 0;
	if (prmnum > 0) {
		if (rc = _set_index(1,prmnum,pprmp,0,index,"_chk_array: ")) return rc;
	}
#if 1	/* 2017.7.18 koba */
	n = index[1];
#else
	n = index[1]*index[2]*index[3];
#endif
	if (n < 0) {
		/* %s: ͈͎w([%d,%d,%d])z̍ő(%d)𒴂Ă܂B */
		ERROROUT5(FORMAT(448),_fn_,index[1],index[2],index[3],INT_MAX);
		return ECL_SCRIPT_ERROR;
	}
	pIndex = (tdtArrayIndex *)pInfoParm->pi_data;
	attr_old = pIndex->uAttr[0];
	rc = 0;
	iCONST_old = pInfoParm->pi_aux[1] & D_AUX1_PROTECTED;
	if ((iCONST && !iCONST_old) || (!iCONST && iCONST_old)) {
		/* %s: 萔`قȂĂ܂Bold=%d new=%d */
		ERROROUT3(FORMAT(449),_fn_,iCONST_old,iCONST);
		rc |= 1;
	}
	if (attr_old != iParm[0]) {
		/* %s: f[^^قȂĂ܂Bold=%d new=%d */
		ERROROUT3(FORMAT(450),_fn_,attr_old,iParm[0]);
		rc |= 2;
	}
	if (pIndex->size != size) {
		/* %s: قȂĂ܂Bold=%d new=%d */
		ERROROUT3(FORMAT(451),_fn_,pIndex->size,size);
		rc |= 4;
	}
#if 1	/* 2017.7.18 koba */
	ndim = index[0];
	for (i=4;i<ndim+4;i++) {
#else
	for (i=1;i<=MAX_ARRAY_DIM;i++) {
#endif
		if (pIndex->index[i] != index[i]) {
			/* %s: %dڂقȂĂ܂Bold=%d new=%d */
			ERROROUT4(FORMAT(452),_fn_,i,pIndex->index[i],index[i]);
			rc |= 8;
		}
	}
	if (rc) rc = -1;
	return rc;
}

/************************************/
/* cl_pr_ex_dim						*/
/************************************/
int cl_pr_ex_dim(leaf, scrct, proc, opt)
Leaf    *leaf;
ScrPrCT *scrct;
ProcCT  *proc;
int     opt;
{
	return cl_pr_ex_def_var(leaf->cmd.prmnum,leaf->cmd.prmp,scrct,proc,opt);
}
#if 0
/************************************/
/* cl_pr_ex_typedef					*/
/************************************/
int cl_pr_ex_typedef(leaf, scrct, proc, opt)
Leaf    *leaf;
ScrPrCT *scrct;
ProcCT  *proc;
int     opt;
{
	return cl_pr_ex_def_type(leaf->cmd.prmnum,leaf->cmd.prmp,scrct,proc,opt);
}
#endif
/************************************/
/* _redefine_size_zero				*/
/************************************/
int _redefine_size_zero(attr,size0,n,size0_old,n_old,pIndex,pIndex_old)
int attr,size0,n,size0_old,n_old;
tdtArrayIndex *pIndex,*pIndex_old;
{
	static char *_fn_="_redefine_size_zero";
	int  i,len,na,na_old,alsize,size_old,alsize_old,size_min,m;
	char *p,*pp,*p_old,*p1;
	tdtInfoParm **ppParm,*pInfoParm;
/*
printf("%s: attr=%d size0=%d n=%d size0_old=%d n_old=%d\n",_fn_,attr,size0,n,size0_old,n_old);
*/
	alsize = size0 ? size0 : size0_old;
	if (attr == DEF_ZOK_CHAR) alsize++;
	else if (attr == DEF_ZOK_BULK) alsize += sizeof(int);
	if (size0) {
		m = alsize;
		na_old = n_old*sizeof(tdtInfoParm *);
	}
	else {
		m = sizeof(tdtInfoParm *);
		na_old = alsize*n_old;
	}
	na = n*m;
/*
printf("%s: alsize=%d m=%d na_old=%d na=%d\n",_fn_,alsize,m,na_old,na);
*/
	if (na < 0) {
		/* %s: zf[^悪ől(%d)𒴂Ă܂B */
		ERROROUT4(FORMAT(456),_fn_,na,alsize,INT_MAX);
		return ECL_SCRIPT_ERROR;
	}
	if (!(pp=Malloc(na))) {
		/* "%s: %spMallocG[B */
		ERROROUT2(FORMAT(321),_fn_,FORMAT(586));	/* zf[^ */
		return -11;
	}
	if (size0) {
		p = pp;
		ppParm = pIndex_old->pVarIndex;
		for (i=0;i<X_MIN(n,n_old);i++) {
			if (pInfoParm=ppParm[i]) {
				p_old = pInfoParm->pi_data;
				size_old = pInfoParm->pi_dlen;
				size_min = X_MIN(size0,size_old);
/*
printf("%s: size_old=%d size_min=%d na=%d\n",_fn_,size_old,size_min);
*/
				if (attr == DEF_ZOK_CHAR) memzcpy(p,p_old,size_min);
				else if (attr == DEF_ZOK_BULK) {
					memcpy(&len,p_old+size_old,sizeof(int));
					memcpy(p,p_old,size_min);
					len = X_MIN(len,size0);
/*
printf("%s: len=%d\n",_fn_,len);
*/
					memcpy(p+size0,&len,sizeof(int));
				}
				else return -1;
			}
			else {
				if (attr == DEF_ZOK_CHAR) *p = '\0';
				else if (attr == DEF_ZOK_BULK) memset(p,0,alsize);
			}
			p += alsize;
		}
	}
	else {
		p = (char *)pIndex_old->pVarIndex;
		ppParm = (tdtInfoParm **)pp;
		for (i=0;i<X_MIN(n,n_old);i++) {
			if (attr == DEF_ZOK_CHAR) len = strlen(p);
			else if (attr == DEF_ZOK_BULK) memcpy(&len,p+size0_old,sizeof(int));
/*
printf("%s: len=%d\n",_fn_,len);
*/
			if (len > 0) {
				if (!(pInfoParm=(tdtInfoParm *)Malloc(sizeof(tdtInfoParm)))) {
					/* "%s: %spMallocG[B */ /* zf[^\ */
					ERROROUT2(FORMAT(321),_fn_,FORMAT(587));
					return -11;
				}
				ppParm[i] = pInfoParm;
				if (attr == DEF_ZOK_CHAR) {
					if (!(p1=Malloc(len+1))) return -11;
					memzcpy(p1,p,len);
				}
				else if (attr == DEF_ZOK_BULK) {
					if (!(p1=Malloc(len+sizeof(int)))) return -11;
					memzcpy(p1,p,len);
					memcpy(p1+len,&len,sizeof(int));
				}
				else return -1;
				cl_set_parm_char(pInfoParm,p1,len);
				pInfoParm->pi_attr = attr;
				pInfoParm->pi_len = 0;
				pInfoParm->pi_aux[0] = attr;
				pInfoParm->pi_paux = pInfoParm->pi_data;
			}
			else ppParm[i] = NULL;
			p += alsize;
		}
	}
	if (n > n_old) {
		i = m*n_old;
		memset(pp+i,0,na-i);
	}
	pIndex->pVarIndex=(tdtInfoParm **)pp;
	Free(pIndex_old->pVarIndex);
	return 0;
}

/************************************/
/* cl_get_def_alsize				*/
/************************************/
int cl_get_def_alsize(iParmW)
int iParmW[];
{
	int size,attr,alsize;

	attr = iParmW[0];
	size = iParmW[1];
	if (size) {
		alsize = size;
		if (attr == DEF_ZOK_CHAR) alsize++;
		else if (attr == DEF_ZOK_BULK) alsize += sizeof(int);
	}
	else {
		if (attr==DEF_ZOK_CHAR || attr==DEF_ZOK_BULK) {
			attr = DEF_ZOK_VARI;
			size = sizeof(tdtInfoParm);
			alsize = size;
		}
		else return -1;
	}
	iParmW[0] = attr;
	iParmW[1] = size;
	return alsize;
}
