/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Log {
    private static Logger LOGGER;

    protected static void init(InputStream in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        String handlers = props.getProperty("handlers");
        if (handlers != null) {
            String[] hs;
            props.remove("handlers");
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            props.store(b, null);
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(b.toByteArray()));
            Logger rootLogger = LogManager.getLogManager().getLogger("");
            for (Handler h : rootLogger.getHandlers()) {
                rootLogger.removeHandler(h);
            }
            for (String hn : hs = handlers.split(",")) {
                String word = hn.trim();
                try {
                    String level;
                    Class<?> clz = Log.class.getClassLoader().loadClass(word);
                    Handler h = (Handler)clz.newInstance();
                    String fname = props.getProperty(word + ".formatter");
                    if (fname != null) {
                        Class<?> clzF = Log.class.getClassLoader().loadClass(fname.trim());
                        h.setFormatter((Formatter)clzF.newInstance());
                    }
                    if ((level = props.getProperty(word + ".level")) != null) {
                        h.setLevel(Level.parse(level));
                    }
                    rootLogger.addHandler(h);
                }
                catch (Exception ex) {
                    System.err.println("Error in logger init: " + ex);
                    ex.printStackTrace();
                }
            }
        }
    }

    public static String getLogLocation() {
        return "";
    }

    public static String getLogFileName() {
        return "";
    }

    public static String getLogFilePath() {
        return Log.getLogLocation() + "/" + Log.getLogFileName();
    }

    public static void log(String s) {
    }

    public static void logRB(String key, Object ... parameters) {
    }

    public static void log(Throwable throwable) {
    }

    public static void logWarningRB(String key, Object ... parameters) {
    }

    public static void logInfoRB(String id, Object ... parameters) {
    }

    public static void logErrorRB(String key, Object ... parameters) {
    }

    public static void logErrorRB(Throwable ex, String key, Object ... parameters) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream in;
        LOGGER = Logger.getLogger("global");
        boolean loaded = false;
        File usersLogSettings = new File("logger.properties");
        if (usersLogSettings.exists()) {
            try {
                in = new FileInputStream(usersLogSettings);
                try {
                    Log.init(in);
                    loaded = true;
                }
                finally {
                    in.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!loaded) {
            try {
                in = Log.class.getResourceAsStream("/org/omegat/logger.properties");
                try {
                    Log.init(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Can't open file for logging", ex);
            }
        }
    }
}

