/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2008-2010 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */

extern void charput(unsigned char);
/*
 *   rx610 UARTp ȈSIOhCo
 */

#include <sil.h>
#include <kernel.h>
#include "target_syssvc.h"
#include "rx600_uart.h"

/* VA[hWX^iSMR) */
#define CKS			UINT_C(0x03)
#define STOP		UINT_C(0x08)
#define PM			UINT_C(0x10)
#define PE			UINT_C(0x20)
#define CHR			UINT_C(0x40)
#define CM			UINT_C(0x80)
#define ASYNC_7BIT	UINT_C(0x00)
#define ASYNC_8BIT	UINT_C(0x40)

/* VARg[WX^iSCR) */
#define CKE			UINT_C(0x03)
#define TEIE		UINT_C(0x04)
#define RE			UINT_C(0x10)
#define TE			UINT_C(0x20)
#define RIE			UINT_C(0x40)
#define TIE			UINT_C(0x80)

/* VAXe[^XWX^iSSRj */
#define TEND		UINT_C(0x04)
#define PER			UINT_C(0x08)
#define FER			UINT_C(0x10)
#define ORER		UINT_C(0x20)

/* VAg[hWX^iSEMR) */
#define ACS0		UINT_C(0x01)
#define ABCS		UINT_C(0x10)

#define SCI_SCR_FLG_ENABLE	(RE | TE)
#define SCI_SMR_FLG_ENABLE	(STOP | PM | PE | CHR | CM)

/*
 *  VAI/O|[gubN̒`
 */
typedef struct sio_port_initialization_block {
	volatile uint8_t	*ctlreg;		/* VARg[WX^iSCR) */
	volatile uint8_t	*modereg;		/* VA[hWX^iSMR) */
	volatile uint8_t	*extmodereg;	/* VAg[hWX^iSEMR) */	
	volatile uint8_t	*statusreg;		/* VAXe[^XWX^iSSRj */
	volatile uint8_t	*tdreg;			/* gX~bgf[^WX^iTDR)*/
	volatile uint8_t	*rdreg;			/* V[uf[^WX^iRDR) */
	volatile uint8_t	*bitratereg;	/* rbg[gWX^iBRR) */
	volatile uint8_t	*porticrreg;	/* ̓obt@Rg[WX^iICR) */
	volatile uint32_t	*mstpcrreg;		/* W[XgbvRg[WX^iMSTPCRj */
	volatile uint8_t	*ssrreg;		/* Xe[^XWX^ */
	volatile uint8_t	*rxiirreg;		/* RXIpݗvWX^ */
	uint8_t				tx_intno;		/* Mif[^GveBj荞ݔԍ */
	uint8_t				rx_intno;		/* Mif[^tj荞ݔԍ */
	uint8_t				er_intno;		/* MiG[j荞ݔԍ */
	uint8_t				te_intno;		/* MiIj荞ݔԍ */
	uint8_t				sci_no;			/* SCI̔ԍ(SCI0`SCI6) */
	uint32_t			mstpcr_offset;	/* MSTPCȒΉrbgItZbg */
} SIOPINIB;

/*
 *  VAI/O|[gǗubN̒`
 */
struct sio_port_control_block {
	const SIOPINIB	*p_siopinib; 				/* VAI/O|[gubN */
	intptr_t 	exinf;			 				/* g */
	bool_t		openflag;						/* I[vς݃tO */
	bool_t		sendflag;						/* M݃Cl[utO */
	bool_t		getready;						/* M */
	bool_t		putready;						/* 𑗐Mł */
	bool_t		is_initialized; 				/* foCXς݃tO */
};

/*
 *  VAI/O|[gǗubÑGA
 */
static SIOPCB	siopcb_table[TNUM_SIOP];

/* WX^e[u */
static const SIOPINIB siopinib_table[TNUM_SIOP] =
{
	{
		(volatile uint8_t *)SCI0_SCR_ADDR,
		(volatile uint8_t *)SCI0_SMR_ADDR,
		(volatile uint8_t *)SCI0_SEMR_ADDR,
		(volatile uint8_t *)SCI0_SSR_ADDR,
		(volatile uint8_t *)SCI0_TDR_ADDR,
		(volatile uint8_t *)SCI0_RDR_ADDR,
		(volatile uint8_t *)SCI0_BRR_ADDR,
		(volatile uint8_t *)PORT2_ICR_ADDR,
		(volatile uint32_t *)SYSTEM_MSTPCRB_ADDR,
		(volatile uint8_t *)SCI0_SSR_ADDR,
		(volatile uint8_t *)ICU_IR215_ADDR,
		INT_SCI0_TXI,
		INT_SCI0_RXI,
		INT_SCI0_ERI,
		INT_SCI0_TEI,
		0,
		SYSTEM_MSTPCRB_MSTPB31_BIT,
	} ,			/* UART0 */
#if TNUM_SIOP > 1
	{
		(volatile uint8_t *)SCI1_SCR_ADDR,
		(volatile uint8_t *)SCI1_SMR_ADDR,
		(volatile uint8_t *)SCI1_SEMR_ADDR,
		(volatile uint8_t *)SCI1_SSR_ADDR,
		(volatile uint8_t *)SCI1_TDR_ADDR,
		(volatile uint8_t *)SCI1_RDR_ADDR,
		(volatile uint8_t *)SCI1_BRR_ADDR,
		(volatile uint8_t *)PORT2_ICR_ADDR,
		(volatile uint32_t *)SYSTEM_MSTPCRB_ADDR,
		(volatile uint8_t *)SCI1_SSR_ADDR,
		(volatile uint8_t *)ICU_IR219_ADDR,
		INT_SCI1_TXI,
		INT_SCI1_RXI,
		INT_SCI1_ERI,
		INT_SCI1_TEI,
		1,
		SYSTEM_MSTPCRB_MSTPB30_BIT,
	} ,			/* UART1 */
#endif
#if TNUM_SIOP > 2
	{
		(volatile uint8_t *)SCI2_SCR_ADDR,
		(volatile uint8_t *)SCI2_SMR_ADDR,
		(volatile uint8_t *)SCI2_SEMR_ADDR,
		(volatile uint8_t *)SCI2_SSR_ADDR,
		(volatile uint8_t *)SCI2_TDR_ADDR,
		(volatile uint8_t *)SCI2_RDR_ADDR,
		(volatile uint8_t *)SCI2_BRR_ADDR,
		(volatile uint8_t *)PORT1_ICR_ADDR,
		(volatile uint32_t *)SYSTEM_MSTPCRB_ADDR,
		(volatile uint8_t *)SCI2_SSR_ADDR,
		(volatile uint8_t *)ICU_IR223_ADDR,
		INT_SCI2_TXI,
		INT_SCI2_RXI,
		INT_SCI2_ERI ,
		INT_SCI2_TEI,
		2,
		SYSTEM_MSTPCRB_MSTPB29_BIT,
	} ,			/* UART2 */
#endif
#if TNUM_SIOP > 3
	{
		(volatile uint8_t *)SCI3_SCR_ADDR,
		(volatile uint8_t *)SCI3_SMR_ADDR,
		(volatile uint8_t *)SCI3_SEMR_ADDR,
		(volatile uint8_t *)SCI3_SSR_ADDR,
		(volatile uint8_t *)SCI3_TDR_ADDR,
		(volatile uint8_t *)SCI3_RDR_ADDR,
		(volatile uint8_t *)SCI3_BRR_ADDR,
		(volatile uint8_t *)PORT1_ICR_ADDR,
		(volatile uint32_t *)SYSTEM_MSTPCRB_ADDR,
		(volatile uint8_t *)SCI3_SSR_ADDR,
		(volatile uint8_t *)ICU_IR227_ADDR,
		INT_SCI3_TXI,
		INT_SCI3_RXI,
		INT_SCI3_ERI,
		INT_SCI3_TEI,
		3,
		SYSTEM_MSTPCRB_MSTPB28_BIT,
	} ,			/* UART3 */
#endif
#if TNUM_SIOP > 4
	{
		(volatile uint8_t *)SCI4_SCR_ADDR,
		(volatile uint8_t *)SCI4_SMR_ADDR,
		(volatile uint8_t *)SCI4_SEMR_ADDR,
		(volatile uint8_t *)SCI4_SSR_ADDR,
		(volatile uint8_t *)SCI4_TDR_ADDR,
		(volatile uint8_t *)SCI4_RDR_ADDR,
		(volatile uint8_t *)SCI4_BRR_ADDR,
		(volatile uint8_t *)PORT0_ICR_ADDR,
		(volatile uint32_t *)SYSTEM_MSTPCRB_ADDR,
		(volatile uint8_t *)SCI4_SSR_ADDR,
		(volatile uint8_t *)ICU_IR231_ADDR,
		INT_SCI4_TXI,
		INT_SCI4_RXI,
		INT_SCI4_ERI,
		INT_SCI4_TEI,
		4,
		SYSTEM_MSTPCRB_MSTPB27_BIT,
	} ,		/* UART4 */
#endif
#if TNUM_SIOP > 5
	{
		(volatile uint8_t *)SCI5_SCR_ADDR,
		(volatile uint8_t *)SCI5_SMR_ADDR,
		(volatile uint8_t *)SCI5_SEMR_ADDR,
		(volatile uint8_t *)SCI5_SSR_ADDR,
		(volatile uint8_t *)SCI5_TDR_ADDR,
		(volatile uint8_t *)SCI5_RDR_ADDR,
		(volatile uint8_t *)SCI5_BRR_ADDR,
		(volatile uint8_t *)PORTC_ICR_ADDR,
		(volatile uint32_t *)SYSTEM_MSTPCRB_ADDR,
		(volatile uint8_t *)SCI5_SSR_ADDR,
		(volatile uint8_t *)ICU_IR235_ADDR,
		INT_SCI5_TXI,
		INT_SCI5_RXI,
		INT_SCI5_ERI,
		INT_SCI5_TEI,
		5,
		SYSTEM_MSTPCRB_MSTPB26_BIT,
	} ,		/* UART5 */
#endif
#if TNUM_SIOP > 6
	{
		(volatile uint8_t *)SCI6_SCR_ADDR,
		(volatile uint8_t *)SCI6_SMR_ADDR,
		(volatile uint8_t *)SCI6_SEMR_ADDR,
		(volatile uint8_t *)SCI6_SSR_ADDR,
		(volatile uint8_t *)SCI6_TDR_ADDR,
		(volatile uint8_t *)SCI6_RDR_ADDR,
		(volatile uint8_t *)SCI6_BRR_ADDR,
		(volatile uint8_t *)PORT0_ICR_ADDR,
		(volatile uint32_t *)SYSTEM_MSTPCRB_ADDR,
		(volatile uint8_t *)SCI6_SSR_ADDR,
		(volatile uint8_t *)ICU_IR239_ADDR,
		INT_SCI6_TXI,
		INT_SCI6_RXI,
		INT_SCI6_ERI,
		INT_SCI6_TEI,
		6,
		SYSTEM_MSTPCRB_MSTPB25_BIT,
	} ,		/* UART6 */
#endif
};

/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)	 ((uint_t)((siopid) - 1))
#define get_siopcb(siopid)	 (&(siopcb_table[INDEX_SIOP(siopid)]))
#define get_siopinib(siopid) (&(siopinib_table[INDEX_SIOP(siopid)]))


/*
 *  SIOhCõVA[hWX^(SMR)
 */
static void
rx600_uart_setmode(const SIOPINIB *p_siopinib, uint8_t bitrate, uint8_t clksrc)
{
	uint8_t i;

	/*
	 *  SCIhCȍ[`
	 */

	/*
	 *  荞ݗv惌WX^̐ݒ(ISELRi)
	 *
	 *  ZbglƓlݒ肷邱ƂɂȂ邽,
	 *  ͏ȗ.
	 */

	/*
	 *  W[Xgbv@\̐ݒ
	 */
	sil_wrw_mem((void *)p_siopinib->mstpcrreg, 
		sil_rew_mem((void *)p_siopinib->mstpcrreg) & (~p_siopinib->mstpcr_offset));

	/* M֎~, SCKn[q͓o̓|[gƂĎgp */
	sil_wrb_mem((void *)p_siopinib->ctlreg, 0x00U);

	/* NbNIrbg(SMR.CKS[1:0]rbgݒ) */
	sil_wrb_mem((void *)p_siopinib->modereg, 
					sil_reb_mem((void *)p_siopinib->modereg) | clksrc);

	/* SMRɑM^ MtH[}bgݒ) */
	sil_wrb_mem((void *)p_siopinib->modereg, 
			sil_reb_mem((void *)p_siopinib->modereg) & (~SCI_SMR_FLG_ENABLE));

	/* rbg[gݒ */
	sil_wrb_mem((void *)p_siopinib->bitratereg, bitrate);

	/* rbg({NbN16TCN̊Ԃ1rbgԂƂȂ) */
	while(i < 16){
		i++;
	}

	/* M */
	sil_wrb_mem((void *)p_siopinib->ctlreg, 
			(sil_reb_mem((void *)p_siopinib->ctlreg) | SCI_SCR_FLG_ENABLE));
}


/*
 *  SIOhCȍ[`
 */
void
rx600_uart_initialize(void)
{
	SIOPCB	*p_siopcb;
	uint_t	i;

	/*
	 *  VAI/O|[gǗubN̏
	 */
	for (p_siopcb = siopcb_table, i = 0; i < TNUM_SIOP; p_siopcb++, i++){
		p_siopcb->p_siopinib = &(siopinib_table[i]);
		p_siopcb->openflag = false;
		p_siopcb->sendflag = false;
	}
}

/*
 *  J[lÑoi[o͗p̏
 */
void
rx600_uart_init(ID siopid, uint8_t bitrate, uint8_t clksrc)
{
	SIOPCB          *p_siopcb   = get_siopcb(siopid);
	const SIOPINIB  *p_siopinib = get_siopinib(siopid);
	/*  ̎_ł́Ap_siopcb->p_siopinib͏ĂȂ  */

	/*  d̖h~  */
	p_siopcb->is_initialized = true;

	/*  n[hEFȀƑM  */
	rx600_uart_setmode(p_siopinib , bitrate, clksrc);
	sil_wrb_mem((void *)p_siopinib->ctlreg, 
					(uint8_t)(sil_reb_mem((void *)p_siopinib->ctlreg) | TE));
}


/*
 *  VAI/O|[gւ̃|[Oł̏o
 */
void
rx600_uart_pol_putc(char_t c, ID siopid)
{
#if 0
	const SIOPINIB *p_siopinib;

	p_siopinib = get_siopinib(siopid);

	/*
	 *  MWX^ɂȂ܂ő҂
	 */
	while((sil_reb_mem(
			(void *)p_siopinib->ssrreg) & SCI_SSR_TEND_BIT) == 0U);

	sil_wrb_mem((void *)p_siopinib->tdreg, (uint8_t)c);
#endif
	charput(c);
}

/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *
rx600_uart_opn_por
	(ID siopid, intptr_t exinf, uint8_t bitrate, uint8_t clksrc)
{
	SIOPCB          *p_siopcb;
	const SIOPINIB  *p_siopinib;

	p_siopcb = get_siopcb(siopid);
	p_siopinib = p_siopcb->p_siopinib;

	/*
	 *  n[hEFȀ
	 *
	 *  ɏĂꍇ, dɏȂ.
	 */
	if(!(p_siopcb->is_initialized)){
		rx600_uart_setmode(p_siopinib, bitrate, clksrc);
		p_siopcb->is_initialized = true;
	}

	p_siopcb->exinf = exinf;
	p_siopcb->getready = p_siopcb->putready = false;
	p_siopcb->openflag = true;

    return (p_siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
rx600_uart_cls_por(SIOPCB *p_siopcb)
{
	/*
	 *  UART~
	 */
	sil_wrh_mem((void *)p_siopcb->p_siopinib->ctlreg, 0x00U);
	p_siopcb->openflag = false;
	p_siopcb->is_initialized = false;
}

/*
 *  VAI/O|[gւ̕M
 */
bool_t
rx600_uart_snd_chr(SIOPCB *p_siopcb, char_t c)
{
	bool_t ercd = false;
#if 0

	if((sil_reb_mem(
		(void *)p_siopcb->p_siopinib->ssrreg) & SCI_SSR_TEND_BIT) != 0){
		sil_wrb_mem((void *)p_siopcb->p_siopinib->tdreg, (uint8_t)c);
		ercd = true;
	}
#endif
	charput(c);
	ercd = true;
	
	return ercd;
}

/*
 *  VAI/O|[g̕M
 */
int_t
rx600_uart_rcv_chr(SIOPCB *p_siopcb)
{
	int_t c = -1;

	/*
	 *  MtOON̂Ƃ̂ݎMobt@當擾.
	 *  , |[OMɑΉ邽߂ł.
	 *  , RX600V[Ył͎MtOȂ, VXeT[rX
	 *  ł͎M݂̒炵f[^MɗȂƂ, 
	 *  Mobt@當擾.
	 */
	c = (int)(sil_reb_mem((void *)p_siopcb->p_siopinib->rdreg));

	return c;
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
rx600_uart_ena_cbr(SIOPCB *p_siopcb, uint_t cbrtn)
{
	switch (cbrtn) {
		case SIO_RDY_SND:
			sil_wrb_mem((void *)p_siopcb->p_siopinib->ctlreg, 
				(sil_reb_mem((void *)p_siopcb->p_siopinib->ctlreg) | SCI_SCR_TEIE_BIT));
			break;
		case SIO_RDY_RCV:
			sil_wrb_mem((void *)p_siopcb->p_siopinib->ctlreg, 
				(sil_reb_mem((void *)p_siopcb->p_siopinib->ctlreg) | SCI_SCR_RIE_BIT));
			break;
		default:
			assert(1);
			break;
	}
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
rx600_uart_dis_cbr(SIOPCB *p_siopcb, uint_t cbrtn)
{
	switch (cbrtn) {
		case SIO_RDY_SND:
			sil_wrb_mem((void *)p_siopcb->p_siopinib->ctlreg, 
				(sil_reb_mem((void *)p_siopcb->p_siopinib->ctlreg) & (~SCI_SCR_TEIE_BIT)));
			break;
		case SIO_RDY_RCV:
			sil_wrb_mem((void *)p_siopcb->p_siopinib->ctlreg, 
				(sil_reb_mem((void *)p_siopcb->p_siopinib->ctlreg) & (~SCI_SCR_RIE_BIT)));
			break;
		default:
			assert(1);
			break;
	}
}

/*
 *  SIO̊݃T[rX[`
 */
void
rx600_uart_tx_isr(ID siopid)
{
	SIOPCB	*p_siopcb = get_siopcb(siopid);

	if((sil_reb_mem(
		(void *)p_siopcb->p_siopinib->ssrreg) & SCI_SSR_TEND_BIT) != 0U){
		/*
		 *  M\R[obN[`ĂяoD
		 */
		rx600_uart_irdy_snd(p_siopcb->exinf);
	}
}

void
rx600_uart_rx_isr(ID siopid)
{
	SIOPCB	*p_siopcb = get_siopcb(siopid);

	/*
	 *  MtOON̂Ƃ̂ݎMʒmR[obN[`Ăяo.
	 *  , RX600V[Ył͎MtOȂ, ɎMʒm
	 *  R[obN[`Ăяo.
	 *  ł͎M݂̔M.
	 */
	/*
	 *  MʒmR[obN[`ĂяoD
	 */
	rx600_uart_irdy_rcv(p_siopcb->exinf);
}

