#include "preferenses.h"

void
display_preferenses_dialog (BonoboUIComponent * uic, PanelApplet * applet)
{
  GladeXML *glade;
  GConfClient *client;
  GtkListStore *store;
  GtkWidget *checkbutton;
  GtkWidget *combobox;
  GtkWidget *dialog;
  GtkWidget *treeview;
  GtkTreeViewColumn *column;
  GtkCellRenderer *renderer;

  client = gconf_client_get_default ();

  glade = glade_xml_new (GNOME_GLADEDIR"/preferenses.glade", NULL, NULL);
  dialog = glade_xml_get_widget (glade, "dialog");

  checkbutton = glade_xml_get_widget (glade, "checkbutton1");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton),
				gconf_client_get_bool (client,
						       "/apps/vhelpdesk/UseGConf",
						       NULL));
  g_signal_connect (checkbutton, "toggled", G_CALLBACK (on_checkbutton1_toggled), client);

  combobox = glade_xml_get_widget (glade, "combobox1");
  gtk_combo_box_set_active (GTK_COMBO_BOX (combobox),
			    gconf_client_get_int (client,
						  "/apps/vhelpdesk/ResultIndex",
						  NULL));
  g_signal_connect (combobox, "changed", G_CALLBACK (on_combobox1_changed), client);

  treeview = glade_xml_get_widget (glade, "treeview1");

  store = gtk_list_store_new (2, G_TYPE_BOOLEAN, G_TYPE_STRING);
  gtk_tree_view_set_model (GTK_TREE_VIEW (treeview), GTK_TREE_MODEL (store));

  column = gtk_tree_view_column_new ();
  gtk_tree_view_column_set_title (column, _("Directory"));
  gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

  renderer = gtk_cell_renderer_toggle_new ();
  gtk_tree_view_column_pack_start (column, renderer, FALSE);

  renderer = gtk_cell_renderer_text_new ();
  gtk_tree_view_column_pack_start (column, renderer, FALSE);

  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}

/*
 * Do you use gconf?
 */
void on_checkbutton1_toggled (GtkToggleButton *togglebutton, GConfClient *client)
{
	gconf_client_set_bool (client, "/apps/vhelpdesk/UseGConf", gtk_toggle_button_get_active(togglebutton), NULL);
}

/*
 * Do you need counts of search result.
 */
void on_combobox1_changed (GtkComboBox *combobox, GConfClient *client)
{
	gconf_client_set_int (client, "/apps/vhelpdesk/ResultIndex", gtk_combo_box_get_active (combobox), NULL);
}
