/*
 * vhelpdesk_applet - Frontend of namazu.
 * Copyright (C) 2006 Yasumichi Akahoshi <yasumichi@vinelinux.org>
 * This program has borrowed the code from gnome-applets/mini-commander. 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "vhelpdesk_applet.h"
#include "preferenses.h"

struct _VHD
{
  PanelApplet *applet;
  GConfClient *client;
  GtkWidget *entry;
};

static const BonoboUIVerb myexample_menu_verbs[] = {
  BONOBO_UI_VERB ("ExampleProperties", display_preferenses_dialog),
  BONOBO_UI_VERB ("ExampleAbout", NULL),
  BONOBO_UI_VERB_END
};

/*
 * When applet icon is left-clicked, entry is switched visible/invisible.
 */
static gboolean
send_button_to_entry_event (GtkWidget * widget, GdkEventButton * event,
			    VHD * vhd)
{
  gboolean visible;

  if (event->button == 1)
    {
      g_object_get (vhd->entry, "visible", &visible, NULL);
      g_object_set (vhd->entry, "visible", !visible, NULL);
      panel_applet_gconf_set_bool (vhd->applet, "entry_visible", !visible,
				   NULL);

      return TRUE;
    }

  return FALSE;
}

/*
 * When entry is clicked, applet grub focus.
 */
static gboolean
button_press_cb (GtkEntry * entry, GdkEventButton * event, VHD * vhd)
{
  panel_applet_request_focus (vhd->applet, event->time);

  return FALSE;
}

/*
 * When user press enter key on entry, vhelpdesk is executed.
 */
void
entry_activate (GtkEntry * entry, VHD * vhd)
{
  GtkWidget *dialog;
  gchar *search_str;
  gchar *cmd_str;

  search_str =
    g_locale_from_utf8 (gtk_entry_get_text (GTK_ENTRY (vhd->entry)), -1, NULL,
			NULL, NULL);
  cmd_str = g_strdup_printf ("vhelpdesk %s", search_str);
  gdk_spawn_command_line_on_screen (gtk_widget_get_screen
				    (GTK_WIDGET (vhd->applet)), cmd_str,
				    NULL);

  g_free (search_str);
  g_free (cmd_str);
}

/*
 * When applet is destroyed, memory is freed.
 */
static void
applet_destroyed (GtkWidget * widget, VHD * vhd)
{
  g_free (vhd);
}

/*
 * applet factory
 */
static gboolean
vhelpdesk_applet_fill (PanelApplet * applet, const gchar * iid, gpointer data)
{
  VHD *vhd;
  GtkWidget *entry;
  GtkWidget *image;
  GtkWidget *hbox;

  if (strcmp (iid, "OAFIID:VHelpDeskApplet") != 0)
    return FALSE;

#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, GNOMELOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

  glade_init ();

  vhd = g_new0 (VHD, 1);
  vhd->applet = applet;
  vhd->client = gconf_client_get_default ();
  hbox = gtk_hbox_new (FALSE, 2);
  image = gtk_image_new_from_stock (GTK_STOCK_DIALOG_QUESTION, 24);
  gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);
  vhd->entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (hbox), vhd->entry, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (applet), hbox);


  g_signal_connect (vhd->entry, "activate", G_CALLBACK (entry_activate), vhd);
  g_signal_connect (vhd->entry, "button_press_event",
		    G_CALLBACK (button_press_cb), vhd);
  g_signal_connect (vhd->applet, "button_press_event",
		    G_CALLBACK (send_button_to_entry_event), vhd);
  g_signal_connect (vhd->applet, "destroy", G_CALLBACK (applet_destroyed),
		    vhd);

  panel_applet_setup_menu_from_file (applet, PACKAGE_DATA_DIR,
				     "vhelpdesk_menu.xml", "vhelpdesk",
				     myexample_menu_verbs, NULL);

  gtk_widget_show_all (GTK_WIDGET (applet));

  panel_applet_add_preferences (vhd->applet, "/schemas/apps/vhelpdesk/prefs",
				NULL);
  g_object_set (vhd->entry, "visible",
		panel_applet_gconf_get_bool (applet, "entry_visible", NULL),
		NULL);

  return TRUE;
}

/*
 * Defines a 'main' routine for the applet factory.
 */
PANEL_APPLET_BONOBO_FACTORY ("OAFIID:VHelpDeskApplet_Factory",
			     PANEL_TYPE_APPLET,
			     "an applet that is frontend of namazu.",
			     "0", vhelpdesk_applet_fill, NULL);
