/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import weka.LocalString;
import weka.core.Utils;
import weka.estimators.Estimator;

public class DiscreteEstimator
implements Estimator {
    private double[] m_Counts;
    private double m_SumOfCounts;

    public DiscreteEstimator(int n, boolean bl) {
        this.m_Counts = new double[n];
        this.m_SumOfCounts = 0.0;
        if (bl) {
            for (int i = 0; i < n; ++i) {
                this.m_Counts[i] = 1.0;
            }
            this.m_SumOfCounts = n;
        }
    }

    public DiscreteEstimator(int n, double d) {
        this.m_Counts = new double[n];
        for (int i = 0; i < n; ++i) {
            this.m_Counts[i] = d;
        }
        this.m_SumOfCounts = d * (double)n;
    }

    public void addValue(double d, double d2) {
        int n = (int)d;
        this.m_Counts[n] = this.m_Counts[n] + d2;
        this.m_SumOfCounts += d2;
    }

    public double getProbability(double d) {
        if (this.m_SumOfCounts == 0.0) {
            return 0.0;
        }
        return this.m_Counts[(int)d] / this.m_SumOfCounts;
    }

    public int getNumSymbols() {
        return this.m_Counts == null ? 0 : this.m_Counts.length;
    }

    public double getCount(double d) {
        if (this.m_SumOfCounts == 0.0) {
            return 0.0;
        }
        return this.m_Counts[(int)d];
    }

    public double getSumOfCounts() {
        return this.m_SumOfCounts;
    }

    public String toString() {
        String string = LocalString.get("Discrete Estimator. Counts = ");
        if (this.m_SumOfCounts > 1.0) {
            for (int i = 0; i < this.m_Counts.length; ++i) {
                string = string + " " + Utils.doubleToString(this.m_Counts[i], 2);
            }
            string = string + LocalString.get("  (Total = ") + Utils.doubleToString(this.m_SumOfCounts, 2) + ")\n";
        } else {
            for (int i = 0; i < this.m_Counts.length; ++i) {
                string = string + " " + this.m_Counts[i];
            }
            string = string + LocalString.get("  (Total = ") + this.m_SumOfCounts + ")\n";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            if (stringArray.length == 0) {
                System.out.println(LocalString.get("Please specify a set of instances."));
                return;
            }
            int n2 = n = Integer.parseInt(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                n = Integer.parseInt(stringArray[i]);
                if (n <= n2) continue;
                n2 = n;
            }
            DiscreteEstimator discreteEstimator = new DiscreteEstimator(n2 + 1, true);
            for (int i = 0; i < stringArray.length; ++i) {
                n = Integer.parseInt(stringArray[i]);
                System.out.println(discreteEstimator);
                System.out.println(LocalString.get("Prediction for ") + n + " = " + discreteEstimator.getProbability(n));
                discreteEstimator.addValue(n, 1.0);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

