/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import weka.LocalString;
import weka.core.Matrix;
import weka.core.Utils;
import weka.estimators.Estimator;

public class MahalanobisEstimator
implements Estimator {
    private Matrix m_CovarianceInverse = null;
    private double m_Determinant;
    private double m_ConstDelta;
    private double m_ValueMean;
    private static double TWO_PI = Math.PI * 2;

    private double normalKernel(double d) {
        Matrix matrix = new Matrix(1, 2);
        matrix.setElement(0, 0, d);
        matrix.setElement(0, 1, this.m_ConstDelta);
        return Math.exp(-matrix.multiply(this.m_CovarianceInverse).multiply(matrix.transpose()).getElement(0, 0) / 2.0) / (Math.sqrt(TWO_PI) * this.m_Determinant);
    }

    public MahalanobisEstimator(Matrix matrix, double d, double d2) {
        if (matrix.numRows() == 2 && matrix.numColumns() == 2) {
            double d3;
            double d4 = matrix.getElement(0, 0);
            double d5 = matrix.getElement(0, 1);
            double d6 = matrix.getElement(1, 0);
            double d7 = matrix.getElement(1, 1);
            if (d4 == 0.0) {
                d4 = d6;
                d6 = 0.0;
                d3 = d5;
                d5 = d7;
                d7 = d3;
            }
            if (d4 == 0.0) {
                return;
            }
            d3 = d7 - d6 * d5 / d4;
            if (d3 == 0.0) {
                return;
            }
            this.m_Determinant = matrix.getElement(0, 0) * matrix.getElement(1, 1) - matrix.getElement(1, 0) * matrix.getElement(0, 1);
            this.m_CovarianceInverse = new Matrix(2, 2);
            this.m_CovarianceInverse.setElement(0, 0, 1.0 / d4 + d5 * d6 / d4 / d4 / d3);
            this.m_CovarianceInverse.setElement(0, 1, -d5 / d4 / d3);
            this.m_CovarianceInverse.setElement(1, 0, -d6 / d4 / d3);
            this.m_CovarianceInverse.setElement(1, 1, 1.0 / d3);
            this.m_ConstDelta = d;
            this.m_ValueMean = d2;
        }
    }

    public void addValue(double d, double d2) {
    }

    public double getProbability(double d) {
        double d2 = d - this.m_ValueMean;
        if (this.m_CovarianceInverse == null) {
            return 0.0;
        }
        return this.normalKernel(d2);
    }

    public String toString() {
        if (this.m_CovarianceInverse == null) {
            return LocalString.get("No covariance inverse\n");
        }
        return LocalString.get("Mahalanovis Distribution. Mean = ") + Utils.doubleToString(this.m_ValueMean, 4, 2) + LocalString.get("  ConditionalOffset = ") + Utils.doubleToString(this.m_ConstDelta, 4, 2) + "\n" + LocalString.get("Covariance Matrix: Determinant = ") + this.m_Determinant + LocalString.get("  Inverse:\n") + this.m_CovarianceInverse;
    }

    public static void main(String[] stringArray) {
        try {
            double d = 0.5;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 10.0;
            Matrix matrix = new Matrix(2, 2);
            matrix.setElement(0, 0, 2.0);
            matrix.setElement(0, 1, -3.0);
            matrix.setElement(1, 0, -4.0);
            matrix.setElement(1, 1, 5.0);
            if (stringArray.length > 0) {
                matrix.setElement(0, 0, Double.valueOf(stringArray[0]));
            }
            if (stringArray.length > 1) {
                matrix.setElement(0, 1, Double.valueOf(stringArray[1]));
            }
            if (stringArray.length > 2) {
                matrix.setElement(1, 0, Double.valueOf(stringArray[2]));
            }
            if (stringArray.length > 3) {
                matrix.setElement(1, 1, Double.valueOf(stringArray[3]));
            }
            if (stringArray.length > 4) {
                d = Double.valueOf(stringArray[4]);
            }
            if (stringArray.length > 5) {
                d2 = Double.valueOf(stringArray[5]);
            }
            MahalanobisEstimator mahalanobisEstimator = new MahalanobisEstimator(matrix, d, d2);
            if (stringArray.length > 6) {
                d3 = Double.valueOf(stringArray[6]);
                if (stringArray.length > 7) {
                    d4 = Double.valueOf(stringArray[7]);
                }
                double d5 = (d4 - d3) / 50.0;
                for (double d6 = d3; d6 <= d4; d6 += d5) {
                    System.out.println(d6 + "  " + mahalanobisEstimator.getProbability(d6));
                }
            } else {
                System.out.println(LocalString.get("Covariance Matrix\n") + matrix);
                System.out.println(mahalanobisEstimator);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

