/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Discretize;

public class PKIDiscretize
extends Discretize {
    public boolean setInputFormat(Instances instances) throws Exception {
        this.m_FindNumBins = true;
        return super.setInputFormat(instances);
    }

    protected void findNumBins(int n) {
        Instances instances = this.getInputFormat();
        int n2 = instances.numInstances();
        for (int i = 0; i < instances.numInstances(); ++i) {
            if (!instances.instance(i).isMissing(n)) continue;
            --n2;
        }
        this.m_NumBins = (int)Math.sqrt(n2);
        if (this.m_NumBins > 0) {
            this.calculateCutPointsByEqualFrequencyBinning(n);
        }
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(7);
        vector.addElement(new Option(LocalString.get("\tSpecifies list of columns to Discretize. First") + LocalString.get(" and last are valid indexes.\n") + LocalString.get("\t(default: first-last)"), "R", 1, LocalString.get("-R <col1,col2-col4,...>")));
        vector.addElement(new Option(LocalString.get("\tInvert matching sense of column indexes."), "V", 0, "-V"));
        vector.addElement(new Option(LocalString.get("\tOutput binary attributes for discretized attributes."), "D", 0, "-D"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setMakeBinary(Utils.getFlag('D', stringArray));
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndices(string);
        } else {
            this.setAttributeIndices(LocalString.get("first-last"));
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[12];
        int n = 0;
        if (this.getMakeBinary()) {
            stringArray[n++] = "-D";
        }
        if (this.getInvertSelection()) {
            stringArray[n++] = "-V";
        }
        if (!this.getAttributeIndices().equals("")) {
            stringArray[n++] = "-R";
            stringArray[n++] = this.getAttributeIndices();
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String globalInfo() {
        return LocalString.get("Discretizes numeric attributes using equal frequency binning,") + LocalString.get(" where the number of bins is equal to the square root of the") + LocalString.get(" number of non-missing values.");
    }

    public String findNumBinsTipText() {
        return LocalString.get("Ignored.");
    }

    public boolean getFindNumBins() {
        return false;
    }

    public void setFindNumBins(boolean bl) {
    }

    public String useEqualFrequencyTipText() {
        return LocalString.get("Always true.");
    }

    public boolean getUseEqualFrequency() {
        return true;
    }

    public void setUseEqualFrequency(boolean bl) {
    }

    public String binsTipText() {
        return LocalString.get("Ignored.");
    }

    public int getBins() {
        return 0;
    }

    public void setBins(int n) {
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new PKIDiscretize(), stringArray);
            } else {
                Filter.filterFile(new PKIDiscretize(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

