/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import weka.LocalString;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class NonSparseToSparse
extends Filter
implements UnsupervisedFilter,
StreamableFilter {
    public String globalInfo() {
        return LocalString.get("An instance filter that converts all incoming instances") + LocalString.get(" into sparse format.");
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException(LocalString.get("No input instance format defined"));
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        SparseInstance sparseInstance = new SparseInstance(instance);
        sparseInstance.setDataset(instance.dataset());
        this.push(sparseInstance);
        return true;
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new NonSparseToSparse(), stringArray);
            } else {
                Filter.filterFile(new NonSparseToSparse(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

