/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import weka.LocalString;

public class OutputFormatDialog
extends JDialog {
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    protected int m_Result = 1;
    protected static final String[] m_OutputFormats = new String[]{LocalString.get("Plain Text"), LocalString.get("LaTeX"), LocalString.get("CSV")};
    protected JComboBox m_OutputFormatComboBox = new JComboBox<String>(m_OutputFormats);
    protected JSpinner m_MeanPrecSpinner = new JSpinner();
    protected JSpinner m_StdDevPrecSpinner = new JSpinner();
    protected JButton m_OkButton = new JButton("OK");
    protected JButton m_CancelButton = new JButton(LocalString.get("Cancel"));
    protected boolean m_latexOutput = false;
    protected boolean m_csvOutput = false;
    protected int m_MeanPrec = 2;
    protected int m_StdDevPrec = 2;

    public OutputFormatDialog(Frame frame) {
        super(frame, LocalString.get("Output Format..."), true);
        this.createDialog();
    }

    protected void createDialog() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(3, 2));
        this.getContentPane().add((Component)jPanel, "Center");
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.m_MeanPrecSpinner.getModel();
        spinnerNumberModel.setMaximum(new Integer(20));
        spinnerNumberModel.setMinimum(new Integer(0));
        spinnerNumberModel = (SpinnerNumberModel)this.m_StdDevPrecSpinner.getModel();
        spinnerNumberModel.setMaximum(new Integer(20));
        spinnerNumberModel.setMinimum(new Integer(0));
        jPanel.add(new JLabel(LocalString.get("Mean Precision")));
        jPanel.add(this.m_MeanPrecSpinner);
        jPanel.add(new JLabel(LocalString.get("StdDev. Precision")));
        jPanel.add(this.m_StdDevPrecSpinner);
        jPanel.add(new JLabel(LocalString.get("Output Format")));
        jPanel.add(this.m_OutputFormatComboBox);
        jPanel = new JPanel(new FlowLayout(2));
        this.getContentPane().add((Component)jPanel, "South");
        this.m_CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutputFormatDialog.this.m_Result = 1;
                OutputFormatDialog.this.setVisible(false);
            }
        });
        this.m_OkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutputFormatDialog.this.getData();
                OutputFormatDialog.this.m_Result = 0;
                OutputFormatDialog.this.setVisible(false);
            }
        });
        jPanel.add(this.m_OkButton);
        jPanel.add(this.m_CancelButton);
        this.pack();
    }

    private void setData() {
        this.m_MeanPrecSpinner.setValue(new Integer(this.m_MeanPrec));
        this.m_StdDevPrecSpinner.setValue(new Integer(this.m_StdDevPrec));
        if (this.getProduceLatex()) {
            this.m_OutputFormatComboBox.setSelectedIndex(1);
        } else if (this.getProduceCSV()) {
            this.m_OutputFormatComboBox.setSelectedIndex(2);
        } else {
            this.m_OutputFormatComboBox.setSelectedIndex(0);
        }
    }

    private void getData() {
        this.m_MeanPrec = Integer.parseInt(this.m_MeanPrecSpinner.getValue().toString());
        this.m_StdDevPrec = Integer.parseInt(this.m_StdDevPrecSpinner.getValue().toString());
        this.setProduceLatex(this.m_OutputFormatComboBox.getSelectedIndex() == 1);
        this.setProduceCSV(this.m_OutputFormatComboBox.getSelectedIndex() == 2);
    }

    public void setMeanPrec(int n) {
        this.m_MeanPrec = n;
    }

    public int getMeanPrec() {
        return this.m_MeanPrec;
    }

    public void setStdDevPrec(int n) {
        this.m_StdDevPrec = n;
    }

    public int getStdDevPrec() {
        return this.m_StdDevPrec;
    }

    public void setProduceLatex(boolean bl) {
        this.m_latexOutput = bl;
        if (this.m_latexOutput) {
            this.setProduceCSV(false);
        }
    }

    public boolean getProduceLatex() {
        return this.m_latexOutput;
    }

    public void setProduceCSV(boolean bl) {
        this.m_csvOutput = bl;
        if (this.m_csvOutput) {
            this.setProduceLatex(false);
        }
    }

    public boolean getProduceCSV() {
        return this.m_csvOutput;
    }

    public int getResult() {
        return this.m_Result;
    }

    public int showDialog() {
        this.m_Result = 1;
        this.setData();
        this.setVisible(true);
        return this.m_Result;
    }

    public static void main(String[] stringArray) {
        OutputFormatDialog outputFormatDialog = new OutputFormatDialog(null);
        if (outputFormatDialog.showDialog() == 0) {
            System.out.println(LocalString.get("Accepted"));
        } else {
            System.out.println(LocalString.get("Aborted"));
        }
    }
}

