/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.AttributedCharacterIterator;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import weka.LocalString;

public class PostscriptGraphics
extends Graphics2D {
    protected Rectangle m_extent;
    protected PrintStream m_printstream;
    protected GraphicsState m_psGraphicsState;
    protected GraphicsState m_localGraphicsState;
    protected static final boolean DEBUG = false;
    protected static Hashtable m_PSFontReplacement = new Hashtable();

    public PostscriptGraphics(int n, int n2, OutputStream outputStream) {
        this.m_extent = new Rectangle(0, 0, n2, n);
        this.m_printstream = new PrintStream(outputStream);
        this.m_localGraphicsState = new GraphicsState();
        this.m_psGraphicsState = new GraphicsState();
        this.Header();
    }

    PostscriptGraphics(PostscriptGraphics postscriptGraphics) {
        this.m_extent = new Rectangle(postscriptGraphics.m_extent);
        this.m_printstream = postscriptGraphics.m_printstream;
        this.m_localGraphicsState = new GraphicsState(postscriptGraphics.m_localGraphicsState);
        this.m_psGraphicsState = postscriptGraphics.m_psGraphicsState;
    }

    public void finished() {
        this.m_printstream.flush();
    }

    private void Header() {
        this.m_printstream.println(LocalString.get("%!PS-Adobe-3.0 EPSF-3.0"));
        this.m_printstream.println(LocalString.get("%%BoundingBox: 0 0 ") + this.xScale(this.m_extent.width) + " " + this.yScale(this.m_extent.height));
        this.m_printstream.println(LocalString.get("%%CreationDate: ") + Calendar.getInstance().getTime());
        this.m_printstream.println(LocalString.get("/Oval { % x y w h filled"));
        this.m_printstream.println(LocalString.get("gsave"));
        this.m_printstream.println(LocalString.get("/filled exch def /h exch def /w exch def /y exch def /x exch def"));
        this.m_printstream.println(LocalString.get("x w 2 div add y h 2 div sub translate"));
        this.m_printstream.println(LocalString.get("1 h w div scale"));
        this.m_printstream.println(LocalString.get("filled {0 0 moveto} if"));
        this.m_printstream.println(LocalString.get("0 0 w 2 div 0 360 arc"));
        this.m_printstream.println(LocalString.get("filled {closepath fill} {stroke} ifelse grestore} bind def"));
        this.m_printstream.println(LocalString.get("/Rect { % x y w h filled"));
        this.m_printstream.println(LocalString.get("/filled exch def /h exch def /w exch def /y exch def /x exch def"));
        this.m_printstream.println(LocalString.get("newpath "));
        this.m_printstream.println(LocalString.get("x y moveto"));
        this.m_printstream.println(LocalString.get("w 0 rlineto"));
        this.m_printstream.println(LocalString.get("0 h neg rlineto"));
        this.m_printstream.println(LocalString.get("w neg 0 rlineto"));
        this.m_printstream.println(LocalString.get("closepath"));
        this.m_printstream.println(LocalString.get("filled {fill} {stroke} ifelse} bind def"));
        this.m_printstream.println(LocalString.get("%%BeginProlog\n%%EndProlog"));
        this.m_printstream.println(LocalString.get("%%Page 1 1"));
        this.setFont(null);
        this.setColor(null);
        this.setStroke(null);
    }

    public static void addPSFontReplacement(String string, String string2) {
        m_PSFontReplacement.put(string, string2);
    }

    private int yTransform(int n) {
        return this.m_extent.height - (this.m_localGraphicsState.getYOffset() + n);
    }

    private int xTransform(int n) {
        return this.m_localGraphicsState.getXOffset() + n;
    }

    private int doScale(int n, double d) {
        return (int)StrictMath.round((double)n * d);
    }

    private int xScale(int n) {
        return this.doScale(n, this.m_localGraphicsState.getXScale());
    }

    private int yScale(int n) {
        return this.doScale(n, this.m_localGraphicsState.getYScale());
    }

    private void setStateToLocal() {
        this.setColor(this.getColor());
        this.setFont(this.getFont());
        this.setStroke(this.getStroke());
    }

    private String toHex(int n) {
        String string = Integer.toHexString(n);
        if (string.length() < 2) {
            string = "0" + string;
        }
        return string;
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.setStateToLocal();
        Color color = this.getColor();
        this.setColor(Color.white);
        this.m_printstream.println(this.xTransform(this.xScale(n)) + " " + this.yTransform(this.yScale(n2)) + " " + this.xScale(n3) + " " + this.yScale(n4) + LocalString.get(" true Rect"));
        this.setColor(color);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public Graphics create() {
        PostscriptGraphics postscriptGraphics = new PostscriptGraphics(this);
        return postscriptGraphics;
    }

    public void dispose() {
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.drawRect(n, n2, n3, n4);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.drawString(new String(byArray, n, n2), n3, n4);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.drawString(new String(cArray, n, n2), n3, n4);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, Color.WHITE, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        try {
            int[] nArray = new int[n3 * n4];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n3, n4, nArray, 0, n3);
            pixelGrabber.grabPixels();
            ColorModel colorModel = ColorModel.getRGBdefault();
            this.m_printstream.println(LocalString.get("gsave"));
            this.m_printstream.println(this.xTransform(this.xScale(n)) + " " + (this.yTransform(this.yScale(n2)) - this.yScale(n4)) + LocalString.get(" translate"));
            this.m_printstream.println(this.xScale(n3) + " " + this.yScale(n4) + LocalString.get(" scale"));
            this.m_printstream.println(n3 + " " + n4 + " " + "8" + " [" + n3 + " 0 0 " + -n4 + " 0 " + n4 + "]");
            this.m_printstream.println("{<");
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n5 = i * n3 + j;
                    this.m_printstream.print(this.toHex(colorModel.getRed(nArray[n5])));
                    this.m_printstream.print(this.toHex(colorModel.getGreen(nArray[n5])));
                    this.m_printstream.print(this.toHex(colorModel.getBlue(nArray[n5])));
                }
                this.m_printstream.println();
            }
            this.m_printstream.println(">}");
            this.m_printstream.println(LocalString.get("false 3 colorimage"));
            this.m_printstream.println(LocalString.get("grestore"));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, Color.WHITE, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, Color.WHITE, imageObserver);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.setStateToLocal();
        this.m_printstream.println(this.xTransform(this.xScale(n)) + " " + this.yTransform(this.yScale(n2)) + LocalString.get(" moveto ") + this.xTransform(this.xScale(n3)) + " " + this.yTransform(this.yScale(n4)) + LocalString.get(" lineto stroke"));
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.setStateToLocal();
        this.m_printstream.println(this.xTransform(this.xScale(n)) + " " + this.yTransform(this.yScale(n2)) + " " + this.xScale(n3) + " " + this.yScale(n4) + LocalString.get(" false Oval"));
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.setStateToLocal();
        this.m_printstream.println(this.xTransform(this.xScale(n)) + " " + this.yTransform(this.yScale(n2)) + " " + this.xScale(n3) + " " + this.yScale(n4) + LocalString.get(" false Rect"));
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
    }

    public void drawString(String string, int n, int n2) {
        this.setStateToLocal();
        this.m_printstream.println(this.xTransform(this.xScale(n)) + " " + this.yTransform(this.yScale(n2)) + LocalString.get(" moveto") + " (" + string + LocalString.get(") show stroke"));
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.fillRect(n, n2, n3, n4);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.setStateToLocal();
        this.m_printstream.println(this.xTransform(this.xScale(n)) + " " + this.yTransform(this.yScale(n2)) + " " + this.xScale(n3) + " " + this.yScale(n4) + LocalString.get(" true Oval"));
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
    }

    public void fillPolygon(Polygon polygon) {
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        if (n3 == this.m_extent.width && n4 == this.m_extent.height) {
            this.clearRect(n, n2, n3, n4);
        } else {
            this.setStateToLocal();
            this.m_printstream.println(this.xTransform(this.xScale(n)) + " " + this.yTransform(this.yScale(n2)) + " " + this.xScale(n3) + " " + this.yScale(n4) + LocalString.get(" true Rect"));
        }
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public void finalize() {
    }

    public Shape getClip() {
        return null;
    }

    public Rectangle getClipBounds() {
        return new Rectangle(0, 0, this.m_extent.width, this.m_extent.height);
    }

    public Rectangle getClipBounds(Rectangle rectangle) {
        rectangle.setBounds(0, 0, this.m_extent.width, this.m_extent.height);
        return rectangle;
    }

    public Rectangle getClipRect() {
        return null;
    }

    public Color getColor() {
        return this.m_localGraphicsState.getColor();
    }

    public Font getFont() {
        return this.m_localGraphicsState.getFont();
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public void setClip(int n, int n2, int n3, int n4) {
    }

    public void setClip(Shape shape) {
    }

    public void setColor(Color color) {
        if (color != null) {
            this.m_localGraphicsState.setColor(color);
            if (this.m_psGraphicsState.getColor().equals(color)) {
                return;
            }
            this.m_psGraphicsState.setColor(color);
        } else {
            this.m_localGraphicsState.setColor(Color.black);
            this.m_psGraphicsState.setColor(this.getColor());
        }
        this.m_printstream.print((double)this.getColor().getRed() / 255.0);
        this.m_printstream.print(" ");
        this.m_printstream.print((double)this.getColor().getGreen() / 255.0);
        this.m_printstream.print(" ");
        this.m_printstream.print((double)this.getColor().getBlue() / 255.0);
        this.m_printstream.println(LocalString.get(" setrgbcolor"));
    }

    private static String replacePSFont(String string) {
        String string2 = string;
        if (m_PSFontReplacement.containsKey(string)) {
            string2 = m_PSFontReplacement.get(string).toString();
        }
        return string2;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.m_localGraphicsState.setFont(font);
            if (font.getName().equals(this.m_psGraphicsState.getFont().getName()) && this.m_psGraphicsState.getFont().getStyle() == font.getStyle() && this.m_psGraphicsState.getFont().getSize() == this.yScale(font.getSize())) {
                return;
            }
            this.m_psGraphicsState.setFont(new Font(font.getName(), font.getStyle(), this.yScale(this.getFont().getSize())));
        } else {
            this.m_localGraphicsState.setFont(new Font(LocalString.get("Courier"), 0, 11));
            this.m_psGraphicsState.setFont(this.getFont());
        }
        this.m_printstream.println("/(" + PostscriptGraphics.replacePSFont(this.getFont().getPSName()) + ")" + LocalString.get(" findfont"));
        this.m_printstream.println(this.yScale(this.getFont().getSize()) + LocalString.get(" scalefont setfont"));
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color color) {
    }

    public void translate(int n, int n2) {
        this.m_localGraphicsState.setXOffset(this.m_localGraphicsState.getXOffset() + this.xScale(n));
        this.m_localGraphicsState.setYOffset(this.m_localGraphicsState.getYOffset() + this.yScale(n2));
        this.m_psGraphicsState.setXOffset(this.m_psGraphicsState.getXOffset() + this.xScale(n));
        this.m_psGraphicsState.setYOffset(this.m_psGraphicsState.getYOffset() + this.yScale(n2));
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(null, true, true);
    }

    public void clip(Shape shape) {
    }

    public Stroke getStroke() {
        return this.m_localGraphicsState.getStroke();
    }

    public Color getBackground() {
        return Color.white;
    }

    public void setBackground(Color color) {
    }

    public Composite getComposite() {
        return AlphaComposite.getInstance(2);
    }

    public Paint getPaint() {
        return new Color(this.getColor().getRed(), this.getColor().getGreen(), this.getColor().getBlue());
    }

    public AffineTransform getTransform() {
        return new AffineTransform();
    }

    public void setTransform(AffineTransform affineTransform) {
    }

    public void transform(AffineTransform affineTransform) {
    }

    public void shear(double d, double d2) {
    }

    public void scale(double d, double d2) {
        this.m_localGraphicsState.setXScale(d);
        this.m_localGraphicsState.setYScale(d2);
    }

    public void rotate(double d, double d2, double d3) {
    }

    public void rotate(double d) {
    }

    public void translate(double d, double d2) {
    }

    public RenderingHints getRenderingHints() {
        return new RenderingHints(null);
    }

    public void addRenderingHints(Map map) {
    }

    public void setRenderingHints(Map map) {
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
    }

    public void setStroke(Stroke stroke) {
        if (stroke != null) {
            this.m_localGraphicsState.setStroke(stroke);
            if (stroke.equals(this.m_psGraphicsState.getStroke())) {
                return;
            }
            this.m_psGraphicsState.setStroke(stroke);
        } else {
            this.m_localGraphicsState.setStroke(new BasicStroke());
            this.m_psGraphicsState.setStroke(this.getStroke());
        }
    }

    public void setPaint(Paint paint) {
    }

    public void setComposite(Composite composite) {
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        return graphicsDevice.getDefaultConfiguration();
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return false;
    }

    public void fill(Shape shape) {
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
    }

    public void drawString(String string, float f, float f2) {
        this.drawString(string, (int)f, (int)f2);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return false;
    }

    public void draw(Shape shape) {
    }

    static {
        m_PSFontReplacement.put("SansSerif.plain", "Helvetica.plain");
        m_PSFontReplacement.put("Dialog.plain", "Helvetica.plain");
        m_PSFontReplacement.put(LocalString.get("Microsoft Sans Serif"), "Helvetica.plain");
        m_PSFontReplacement.put(LocalString.get("MicrosoftSansSerif"), "Helvetica.plain");
    }

    private class GraphicsState {
        protected Color m_currentColor;
        protected Font m_currentFont;
        protected Stroke m_currentStroke;
        protected int m_xOffset;
        protected int m_yOffset;
        protected double m_xScale;
        protected double m_yScale;

        GraphicsState() {
            this.m_currentColor = Color.white;
            this.m_currentFont = new Font(LocalString.get("Courier"), 0, 11);
            this.m_currentStroke = new BasicStroke();
            this.m_xOffset = 0;
            this.m_yOffset = 0;
            this.m_xScale = 1.0;
            this.m_yScale = 1.0;
        }

        GraphicsState(GraphicsState graphicsState) {
            this.m_currentColor = graphicsState.m_currentColor;
            this.m_currentFont = graphicsState.m_currentFont;
            this.m_currentStroke = graphicsState.m_currentStroke;
            this.m_xOffset = graphicsState.m_xOffset;
            this.m_yOffset = graphicsState.m_yOffset;
            this.m_xScale = graphicsState.m_xScale;
            this.m_yScale = graphicsState.m_yScale;
        }

        protected Stroke getStroke() {
            return this.m_currentStroke;
        }

        protected void setStroke(Stroke stroke) {
            this.m_currentStroke = stroke;
        }

        protected Font getFont() {
            return this.m_currentFont;
        }

        protected void setFont(Font font) {
            this.m_currentFont = font;
        }

        protected Color getColor() {
            return this.m_currentColor;
        }

        protected void setColor(Color color) {
            this.m_currentColor = color;
        }

        protected void setXOffset(int n) {
            this.m_xOffset = n;
        }

        protected void setYOffset(int n) {
            this.m_yOffset = n;
        }

        protected int getXOffset() {
            return this.m_xOffset;
        }

        protected int getYOffset() {
            return this.m_yOffset;
        }

        protected void setXScale(double d) {
            this.m_xScale = d;
        }

        protected void setYScale(double d) {
            this.m_yScale = d;
        }

        protected double getXScale() {
            return this.m_xScale;
        }

        protected double getYScale() {
            return this.m_yScale;
        }
    }
}

