/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.estimators.DiscreteEstimator;
import weka.estimators.Estimator;
import weka.estimators.KernelEstimator;
import weka.estimators.NormalEstimator;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class NaiveBayes
extends Classifier
implements OptionHandler,
WeightedInstancesHandler {
    protected Estimator[][] m_Distributions;
    protected Estimator m_ClassDistribution;
    protected boolean m_UseKernelEstimator = false;
    protected boolean m_UseDiscretization = false;
    protected int m_NumClasses;
    protected Instances m_Instances;
    protected static final double DEFAULT_NUM_PRECISION = 0.01;
    protected Discretize m_Disc = null;

    public String globalInfo() {
        return LocalString.get("Class for a Naive Bayes classifier using estimator classes. Numeric") + LocalString.get(" estimator precision values are chosen based on analysis of the ") + LocalString.get(" training data. For this reason, the classifier is not an") + LocalString.get(" UpdateableClassifier (which in typical usage are initialized with zero") + LocalString.get(" training instances) -- if you need the UpdateableClassifier functionality,") + LocalString.get(" use the NaiveBayesUpdateable classifier. The NaiveBayesUpdateable") + LocalString.get(" classifier will  use a default precision of 0.1 for numeric attributes") + LocalString.get(" when buildClassifier is called with zero training instances.\n\n") + LocalString.get("For more information on Naive Bayes classifiers, see\n\n") + LocalString.get("George H. John and Pat Langley (1995). Estimating") + LocalString.get(" Continuous Distributions in Bayesian Classifiers. Proceedings") + LocalString.get(" of the Eleventh Conference on Uncertainty in Artificial") + LocalString.get(" Intelligence. pp. 338-345. Morgan Kaufmann, San Mateo.");
    }

    public void buildClassifier(Instances instances) throws Exception {
        Object object;
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException(LocalString.get("Cannot handle string attributes!"));
        }
        if (instances.classAttribute().isNumeric()) {
            throw new UnsupportedClassTypeException(LocalString.get("Naive Bayes: Class is numeric!"));
        }
        this.m_NumClasses = instances.numClasses();
        if (this.m_NumClasses < 0) {
            throw new Exception(LocalString.get("Dataset has no class attribute"));
        }
        this.m_Instances = new Instances(instances);
        if (this.m_UseDiscretization) {
            this.m_Disc = new Discretize();
            this.m_Disc.setInputFormat(this.m_Instances);
            this.m_Instances = Filter.useFilter(this.m_Instances, this.m_Disc);
        } else {
            this.m_Disc = null;
        }
        this.m_Distributions = new Estimator[this.m_Instances.numAttributes() - 1][this.m_Instances.numClasses()];
        this.m_ClassDistribution = new DiscreteEstimator(this.m_Instances.numClasses(), true);
        int n = 0;
        Enumeration enumeration = this.m_Instances.enumerateAttributes();
        while (enumeration.hasMoreElements()) {
            object = (Attribute)enumeration.nextElement();
            double d = 0.01;
            if (((Attribute)object).type() == 0) {
                this.m_Instances.sort((Attribute)object);
                if (this.m_Instances.numInstances() > 0 && !this.m_Instances.instance(0).isMissing((Attribute)object)) {
                    Instance instance;
                    double d2 = this.m_Instances.instance(0).value((Attribute)object);
                    double d3 = 0.0;
                    int n2 = 0;
                    for (int i = 1; i < this.m_Instances.numInstances() && !(instance = this.m_Instances.instance(i)).isMissing((Attribute)object); ++i) {
                        double d4 = instance.value((Attribute)object);
                        if (d4 == d2) continue;
                        d3 += d4 - d2;
                        d2 = d4;
                        ++n2;
                    }
                    if (n2 > 0) {
                        d = d3 / (double)n2;
                    }
                }
            }
            block6: for (int i = 0; i < this.m_Instances.numClasses(); ++i) {
                switch (((Attribute)object).type()) {
                    case 0: {
                        if (this.m_UseKernelEstimator) {
                            this.m_Distributions[n][i] = new KernelEstimator(d);
                            continue block6;
                        }
                        this.m_Distributions[n][i] = new NormalEstimator(d);
                        continue block6;
                    }
                    case 1: {
                        this.m_Distributions[n][i] = new DiscreteEstimator(((Attribute)object).numValues(), true);
                        continue block6;
                    }
                    default: {
                        throw new Exception(LocalString.get("Attribute type unknown to NaiveBayes"));
                    }
                }
            }
            ++n;
        }
        object = this.m_Instances.enumerateInstances();
        while (object.hasMoreElements()) {
            Instance instance = (Instance)object.nextElement();
            this.updateClassifier(instance);
        }
        this.m_Instances = new Instances(this.m_Instances, 0);
    }

    public void updateClassifier(Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            Enumeration enumeration = this.m_Instances.enumerateAttributes();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                if (!instance.isMissing(attribute)) {
                    this.m_Distributions[n][(int)instance.classValue()].addValue(instance.value(attribute), instance.weight());
                }
                ++n;
            }
            this.m_ClassDistribution.addValue(instance.classValue(), instance.weight());
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_UseDiscretization) {
            this.m_Disc.input(instance);
            instance = this.m_Disc.output();
        }
        double[] dArray = new double[this.m_NumClasses];
        for (int i = 0; i < this.m_NumClasses; ++i) {
            dArray[i] = this.m_ClassDistribution.getProbability(i);
        }
        Enumeration enumeration = instance.enumerateAttributes();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (!instance.isMissing(attribute)) {
                int n2;
                double d = 0.0;
                for (n2 = 0; n2 < this.m_NumClasses; ++n2) {
                    double d2 = Math.max(1.0E-75, this.m_Distributions[n][n2].getProbability(instance.value(attribute)));
                    int n3 = n2;
                    dArray[n3] = dArray[n3] * d2;
                    if (dArray[n2] > d) {
                        d = dArray[n2];
                    }
                    if (!Double.isNaN(dArray[n2])) continue;
                    throw new Exception(LocalString.get("NaN returned from estimator for attribute ") + attribute.name() + ":\n" + this.m_Distributions[n][n2].toString());
                }
                if (d > 0.0 && d < 1.0E-75) {
                    n2 = 0;
                    while (n2 < this.m_NumClasses) {
                        int n4 = n2++;
                        dArray[n4] = dArray[n4] * 1.0E75;
                    }
                }
            }
            ++n;
        }
        Utils.normalize(dArray);
        return dArray;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option(LocalString.get("\tUse kernel density estimator rather than normal\n") + LocalString.get("\tdistribution for numeric attributes"), "K", 0, "-K"));
        vector.addElement(new Option(LocalString.get("\tUse supervised discretization to process numeric attributes\n"), "D", 0, "-D"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        boolean bl = Utils.getFlag('K', stringArray);
        boolean bl2 = Utils.getFlag('D', stringArray);
        if (bl && bl2) {
            throw new IllegalArgumentException(LocalString.get("Can't use both kernel density ") + LocalString.get("estimation and discretization!"));
        }
        this.setUseSupervisedDiscretization(bl2);
        this.setUseKernelEstimator(bl);
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[2];
        int n = 0;
        if (this.m_UseKernelEstimator) {
            stringArray[n++] = "-K";
        }
        if (this.m_UseDiscretization) {
            stringArray[n++] = "-D";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocalString.get("Naive Bayes Classifier"));
        if (this.m_Instances == null) {
            stringBuffer.append(LocalString.get(": No model built yet."));
        } else {
            try {
                for (int i = 0; i < this.m_Distributions[0].length; ++i) {
                    stringBuffer.append(LocalString.get("\n\nClass ") + this.m_Instances.classAttribute().value(i) + LocalString.get(": Prior probability = ") + Utils.doubleToString(this.m_ClassDistribution.getProbability(i), 4, 2) + "\n\n");
                    Enumeration enumeration = this.m_Instances.enumerateAttributes();
                    int n = 0;
                    while (enumeration.hasMoreElements()) {
                        Attribute attribute = (Attribute)enumeration.nextElement();
                        stringBuffer.append(attribute.name() + ":  " + this.m_Distributions[n][i]);
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                stringBuffer.append(exception.getMessage());
            }
        }
        return stringBuffer.toString();
    }

    public String useKernelEstimatorTipText() {
        return LocalString.get("Use a kernel estimator for numeric attributes rather than a ") + LocalString.get("normal distribution.");
    }

    public boolean getUseKernelEstimator() {
        return this.m_UseKernelEstimator;
    }

    public void setUseKernelEstimator(boolean bl) {
        this.m_UseKernelEstimator = bl;
        if (bl) {
            this.setUseSupervisedDiscretization(false);
        }
    }

    public String useSupervisedDiscretizationTipText() {
        return LocalString.get("Use supervised discretization to convert numeric attributes to nominal ") + LocalString.get("ones.");
    }

    public boolean getUseSupervisedDiscretization() {
        return this.m_UseDiscretization;
    }

    public void setUseSupervisedDiscretization(boolean bl) {
        this.m_UseDiscretization = bl;
        if (bl) {
            this.setUseKernelEstimator(false);
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new NaiveBayes(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

