/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.pace;

import weka.LocalString;
import weka.classifiers.functions.pace.DiscreteFunction;
import weka.classifiers.functions.pace.DoubleVector;
import weka.classifiers.functions.pace.IntVector;
import weka.classifiers.functions.pace.PaceMatrix;

public abstract class MixtureDistribution {
    protected DiscreteFunction mixingDistribution;
    public static final int NNMMethod = 1;
    public static final int PMMethod = 2;

    public DiscreteFunction getMixingDistribution() {
        return this.mixingDistribution;
    }

    public void setMixingDistribution(DiscreteFunction discreteFunction) {
        this.mixingDistribution = discreteFunction;
    }

    public void fit(DoubleVector doubleVector) {
        this.fit(doubleVector, 1);
    }

    public void fit(DoubleVector doubleVector, int n) {
        DoubleVector doubleVector2;
        DoubleVector doubleVector3 = (DoubleVector)doubleVector.clone();
        if (doubleVector3.unsorted()) {
            doubleVector3.sort();
        }
        int n2 = doubleVector3.size();
        int n3 = 0;
        DiscreteFunction discreteFunction = new DiscreteFunction();
        for (int i = 0; i < n2 - 1; ++i) {
            if (!this.separable(doubleVector3, n3, i, doubleVector3.get(i + 1)) || !this.separable(doubleVector3, i + 1, n2 - 1, doubleVector3.get(i))) continue;
            doubleVector2 = doubleVector3.subvector(n3, i);
            discreteFunction.plusEquals(this.fitForSingleCluster(doubleVector2, n).timesEquals(i - n3 + 1));
            n3 = i + 1;
        }
        doubleVector2 = doubleVector3.subvector(n3, n2 - 1);
        discreteFunction.plusEquals(this.fitForSingleCluster(doubleVector2, n).timesEquals(n2 - n3));
        discreteFunction.sort();
        discreteFunction.normalize();
        this.mixingDistribution = discreteFunction;
    }

    public DiscreteFunction fitForSingleCluster(DoubleVector doubleVector, int n) {
        DoubleVector doubleVector2;
        if (doubleVector.size() < 2) {
            return new DiscreteFunction(doubleVector);
        }
        DoubleVector doubleVector3 = this.supportPoints(doubleVector, 0);
        PaceMatrix paceMatrix = this.fittingIntervals(doubleVector);
        PaceMatrix paceMatrix2 = this.probabilityMatrix(doubleVector3, paceMatrix);
        PaceMatrix paceMatrix3 = new PaceMatrix(this.empiricalProbability(doubleVector, paceMatrix).timesEquals(1.0 / (double)doubleVector.size()));
        IntVector intVector = IntVector.seq(0, doubleVector3.size() - 1);
        switch (n) {
            case 1: {
                doubleVector2 = paceMatrix2.nnls(paceMatrix3, intVector);
                break;
            }
            case 2: {
                doubleVector2 = paceMatrix2.nnlse1(paceMatrix3, intVector);
                break;
            }
            default: {
                throw new IllegalArgumentException(LocalString.get("unknown method"));
            }
        }
        DoubleVector doubleVector4 = new DoubleVector(intVector.size());
        for (int i = 0; i < doubleVector4.size(); ++i) {
            doubleVector4.set(i, doubleVector3.get(intVector.get(i)));
        }
        DiscreteFunction discreteFunction = new DiscreteFunction(doubleVector4, doubleVector2);
        discreteFunction.sort();
        discreteFunction.normalize();
        return discreteFunction;
    }

    public abstract boolean separable(DoubleVector var1, int var2, int var3, double var4);

    public abstract DoubleVector supportPoints(DoubleVector var1, int var2);

    public abstract PaceMatrix fittingIntervals(DoubleVector var1);

    public abstract PaceMatrix probabilityMatrix(DoubleVector var1, PaceMatrix var2);

    public PaceMatrix empiricalProbability(DoubleVector doubleVector, PaceMatrix paceMatrix) {
        int n = doubleVector.size();
        int n2 = paceMatrix.getRowDimension();
        PaceMatrix paceMatrix2 = new PaceMatrix(n2, 1, 0.0);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = 0.0;
                if (paceMatrix.get(j, 0) == doubleVector.get(i) || paceMatrix.get(j, 1) == doubleVector.get(i)) {
                    d = 0.5;
                } else if (paceMatrix.get(j, 0) < doubleVector.get(i) && paceMatrix.get(j, 1) > doubleVector.get(i)) {
                    d = 1.0;
                }
                paceMatrix2.setPlus(j, 0, d);
            }
        }
        return paceMatrix2;
    }

    public String toString() {
        return LocalString.get("The mixing distribution:\n") + this.mixingDistribution.toString();
    }
}

