/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.clusterers.DensityBasedClusterer;
import weka.clusterers.NumberOfClustersRequestable;
import weka.clusterers.SimpleKMeans;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.estimators.DiscreteEstimator;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class MakeDensityBasedClusterer
extends DensityBasedClusterer
implements NumberOfClustersRequestable,
OptionHandler,
WeightedInstancesHandler {
    private Instances m_theInstances;
    private double[] m_priors;
    private double[][][] m_modelNormal;
    private DiscreteEstimator[][] m_model;
    private double m_minStdDev = 1.0E-6;
    private Clusterer m_wrappedClusterer = new SimpleKMeans();
    private ReplaceMissingValues m_replaceMissing;
    private static double m_normConst = 0.5 * Math.log(Math.PI * 2);

    public MakeDensityBasedClusterer() {
    }

    public MakeDensityBasedClusterer(Clusterer clusterer) {
        this.setClusterer(clusterer);
    }

    public void setNumClusters(int n) throws Exception {
        if (this.m_wrappedClusterer == null) {
            throw new Exception(LocalString.get("Can't set the number of clusters to generate - ") + LocalString.get("no clusterer has been set yet."));
        }
        if (!(this.m_wrappedClusterer instanceof NumberOfClustersRequestable)) {
            throw new Exception(LocalString.get("Can't set the number of clusters to generate - ") + LocalString.get("wrapped clusterer does not support this facility."));
        }
        ((NumberOfClustersRequestable)((Object)this.m_wrappedClusterer)).setNumClusters(n);
    }

    public void buildClusterer(Instances instances) throws Exception {
        int n;
        int n2;
        this.m_replaceMissing = new ReplaceMissingValues();
        this.m_replaceMissing.setInputFormat(instances);
        instances = Filter.useFilter(instances, this.m_replaceMissing);
        this.m_theInstances = new Instances(instances, 0);
        if (this.m_wrappedClusterer == null) {
            throw new Exception(LocalString.get("No clusterer has been set"));
        }
        this.m_wrappedClusterer.buildClusterer(instances);
        this.m_model = new DiscreteEstimator[this.m_wrappedClusterer.numberOfClusters()][instances.numAttributes()];
        this.m_modelNormal = new double[this.m_wrappedClusterer.numberOfClusters()][instances.numAttributes()][2];
        double[][] dArray = new double[this.m_wrappedClusterer.numberOfClusters()][instances.numAttributes()];
        this.m_priors = new double[this.m_wrappedClusterer.numberOfClusters()];
        for (int i = 0; i < this.m_wrappedClusterer.numberOfClusters(); ++i) {
            for (int j = 0; j < instances.numAttributes(); ++j) {
                if (!instances.attribute(j).isNominal()) continue;
                this.m_model[i][j] = new DiscreteEstimator(instances.attribute(j).numValues(), true);
            }
        }
        Instance instance = null;
        int[] nArray = new int[instances.numInstances()];
        for (n2 = 0; n2 < instances.numInstances(); ++n2) {
            instance = instances.instance(n2);
            int n3 = n = this.m_wrappedClusterer.clusterInstance(instance);
            this.m_priors[n3] = this.m_priors[n3] + instance.weight();
            for (int i = 0; i < instances.numAttributes(); ++i) {
                if (instance.isMissing(i)) continue;
                if (instances.attribute(i).isNominal()) {
                    this.m_model[n][i].addValue(instance.value(i), instance.weight());
                    continue;
                }
                double[] dArray2 = this.m_modelNormal[n][i];
                dArray2[0] = dArray2[0] + instance.weight() * instance.value(i);
                double[] dArray3 = dArray[n];
                int n4 = i;
                dArray3[n4] = dArray3[n4] + instance.weight();
            }
            nArray[n2] = n;
        }
        for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
            if (!instances.attribute(n2).isNumeric()) continue;
            for (n = 0; n < this.m_wrappedClusterer.numberOfClusters(); ++n) {
                if (!(dArray[n][n2] > 0.0)) continue;
                double[] dArray4 = this.m_modelNormal[n][n2];
                dArray4[0] = dArray4[0] / dArray[n][n2];
            }
        }
        for (n2 = 0; n2 < instances.numInstances(); ++n2) {
            instance = instances.instance(n2);
            for (n = 0; n < instances.numAttributes(); ++n) {
                if (instance.isMissing(n) || !instances.attribute(n).isNumeric()) continue;
                double d = this.m_modelNormal[nArray[n2]][n][0] - instance.value(n);
                double[] dArray5 = this.m_modelNormal[nArray[n2]][n];
                dArray5[1] = dArray5[1] + instance.weight() * d * d;
            }
        }
        for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
            if (!instances.attribute(n2).isNumeric()) continue;
            for (n = 0; n < this.m_wrappedClusterer.numberOfClusters(); ++n) {
                if (dArray[n][n2] > 0.0) {
                    this.m_modelNormal[n][n2][1] = Math.sqrt(this.m_modelNormal[n][n2][1] / dArray[n][n2]);
                } else if (dArray[n][n2] <= 0.0) {
                    this.m_modelNormal[n][n2][1] = Double.MAX_VALUE;
                }
                if (!(this.m_modelNormal[n][n2][1] <= this.m_minStdDev)) continue;
                this.m_modelNormal[n][n2][1] = instances.attributeStats((int)n2).numericStats.stdDev;
                if (!(this.m_modelNormal[n][n2][1] <= this.m_minStdDev)) continue;
                this.m_modelNormal[n][n2][1] = this.m_minStdDev;
            }
        }
        Utils.normalize(this.m_priors);
    }

    public double[] clusterPriors() {
        double[] dArray = new double[this.m_priors.length];
        System.arraycopy(this.m_priors, 0, dArray, 0, dArray.length);
        return dArray;
    }

    public double[] logDensityPerClusterForInstance(Instance instance) throws Exception {
        double[] dArray = new double[this.m_wrappedClusterer.numberOfClusters()];
        this.m_replaceMissing.input(instance);
        instance = this.m_replaceMissing.output();
        for (int i = 0; i < this.m_wrappedClusterer.numberOfClusters(); ++i) {
            double d = 0.0;
            for (int j = 0; j < instance.numAttributes(); ++j) {
                if (instance.isMissing(j)) continue;
                if (instance.attribute(j).isNominal()) {
                    d += Math.log(this.m_model[i][j].getProbability(instance.value(j)));
                    continue;
                }
                d += this.logNormalDens(instance.value(j), this.m_modelNormal[i][j][0], this.m_modelNormal[i][j][1]);
            }
            dArray[i] = d;
        }
        return dArray;
    }

    private double logNormalDens(double d, double d2, double d3) {
        double d4 = d - d2;
        return -(d4 * d4 / (2.0 * d3 * d3)) - m_normConst - Math.log(d3);
    }

    public int numberOfClusters() throws Exception {
        return this.m_wrappedClusterer.numberOfClusters();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocalString.get("MakeDensityBasedClusterer: \n\nWrapped clusterer: ") + this.m_wrappedClusterer.toString());
        stringBuffer.append(LocalString.get("\nFitted estimators (with ML estimates of variance):\n"));
        for (int i = 0; i < this.m_priors.length; ++i) {
            stringBuffer.append(LocalString.get("\nCluster: ") + i + LocalString.get(" Prior probability: ") + Utils.doubleToString(this.m_priors[i], 4) + "\n\n");
            for (int j = 0; j < this.m_model[0].length; ++j) {
                stringBuffer.append(LocalString.get("Attribute: ") + this.m_theInstances.attribute(j).name() + "\n");
                if (this.m_theInstances.attribute(j).isNominal()) {
                    if (this.m_model[i][j] == null) continue;
                    stringBuffer.append(this.m_model[i][j].toString());
                    continue;
                }
                stringBuffer.append(LocalString.get("Normal Distribution. Mean = ") + Utils.doubleToString(this.m_modelNormal[i][j][0], 4) + LocalString.get(" StdDev = ") + Utils.doubleToString(this.m_modelNormal[i][j][1], 4) + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public void setClusterer(Clusterer clusterer) {
        this.m_wrappedClusterer = clusterer;
    }

    public Clusterer getClusterer() {
        return this.m_wrappedClusterer;
    }

    public String minStdDevTipText() {
        return LocalString.get("set minimum allowable standard deviation");
    }

    public void setMinStdDev(double d) {
        this.m_minStdDev = d;
    }

    public double getMinStdDev() {
        return this.m_minStdDev;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option(LocalString.get("\tminimum allowable standard deviation ") + LocalString.get("for normal density computation ") + LocalString.get("\n\t(default 1e-6)"), "M", 1, LocalString.get("-M <num>")));
        vector.addElement(new Option(LocalString.get("\tClusterer to wrap. (required)\n"), "W", 1, LocalString.get("-W <clusterer name>")));
        if (this.m_wrappedClusterer != null && this.m_wrappedClusterer instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, LocalString.get("\nOptions specific to clusterer ") + this.m_wrappedClusterer.getClass().getName() + ":"));
            Enumeration enumeration = ((OptionHandler)((Object)this.m_wrappedClusterer)).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        String string2 = Utils.getOption('M', stringArray);
        if (string2.length() != 0) {
            this.setMinStdDev(new Double(string2));
        }
        if ((string = Utils.getOption('W', stringArray)).length() == 0) {
            throw new Exception(LocalString.get("A clusterer must be specified with the -W option."));
        }
        String[] stringArray2 = Utils.splitOptions(string);
        if (stringArray2.length == 0) {
            throw new IllegalArgumentException(LocalString.get("Invalid clusterer specification string"));
        }
        String string3 = stringArray2[0];
        stringArray2[0] = "";
        this.setClusterer(Clusterer.forName(string3, stringArray2));
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_wrappedClusterer != null && this.m_wrappedClusterer instanceof OptionHandler) {
            stringArray = ((OptionHandler)((Object)this.m_wrappedClusterer)).getOptions();
        }
        String[] stringArray2 = new String[stringArray.length + 5];
        int n = 0;
        stringArray2[n++] = "-M";
        stringArray2[n++] = "" + this.getMinStdDev();
        if (this.getClusterer() != null) {
            stringArray2[n++] = "-W";
            stringArray2[n++] = this.getClusterer().getClass().getName();
        }
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(ClusterEvaluation.evaluateClusterer(new MakeDensityBasedClusterer(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

