<?php
// $Id: index.php,v 1.1.1.1 2011/03/02 09:42:08 ohwada Exp $

//=========================================================
// Facebook Login
// 2011-03-01 K.OHWADA
//=========================================================

require_once 'common.inc.php';

session_start();

$op = isset($_GET['op']) ? $_GET['op'] : '' ;
if ( $op == 'login' ) {
	$service->login();

// always error, when return
	echo 'error code : '.$service->get_error_code()."<br>\n";
	echo $service->get_error_msg();
	exit();

} elseif ( $op == 'logout' ) {
	$service->clear_session_token();
	unset( $_SESSION['facebook_user'] );
	header('Location: ' . $FACEBOOK_URL_INDEX );
	exit();

} elseif ( $op == 'clear' ) {
	$service->clear_session_token();
	header('Location: ' . $FACEBOOK_URL_INDEX );
	exit();
}

if ( ! $service->isset_session_token() ) {
	$misc->print_login_form();
	exit();
}

if ( !isset( $_SESSION['facebook_user'] ) ) {
	$service->set_token( $service->get_session_token() );
	$user = $service->get_me();
	if ( !is_array($user) ) {
		$msg  = 'user error '."<br>\n";
		$msg .= 'error code : '.$service->get_error_code()."<br>\n";
		$msg .= $service->get_error_msg()."<br>\n";
		$misc->print_clear( $msg );
		exit();
	}

	$_SESSION['facebook_user'] = $user['name'] ;
	$_SESSION['facebook_link'] = $user['link'] ;
}

$user = $_SESSION['facebook_user'];
$link = $_SESSION['facebook_link'];
$service->set_token( $service->get_session_token() );

$feeds = $service->get_me_feeds( true );
if ( !is_array($feeds) ) {
	$msg  = 'feed error '."<br>\n";
	$msg .= 'error code : '.$service->get_error_code()."<br>\n";
	$msg .= $service->get_error_msg()."<br>\n";
	$misc->print_logout( $user, $link, $msg );
	exit();
}

$feeds = $service->feeds_to_array( $feeds );
$feeds = $service->convert_feeds(  $feeds );
$feeds = $service->convert_feeds_encoding( $feeds, 'UTF-8' );
$misc->print_post_form( $user, $link, $feeds );
exit();

?>