package sidepanel;

import java.awt.BorderLayout;
import java.io.IOException;
import java.util.Map;

import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import map.MapData;
import map.MapPanel;

/**
 * サイドパネルです。
 * @author Kumano Tatsuo
 * Created on 2005/05/13 8:08:20
 */
public class SidePanel extends JPanel {
    /**
     * 地図 
     */
    private final Map<String, MapData> maps;

    /**
     * 地図を表示するパネル
     */
    private final MapPanel panel;

    /**
     * コンストラクタです。
     * @param maps 地図
     * @param panel 地図を表示するパネル
     * @throws IOException 入出力例外 
     */
    public SidePanel(final Map<String, MapData> maps, final MapPanel panel) throws IOException {
        this.maps = maps;
        this.panel = panel;
        this.setLayout(new BorderLayout());
        final JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("読み込み", new LoadMapPanel(maps, panel));
        this.add(tabbedPane);
    }
}
