package client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 * @author zenjiro
 */
public class GPS implements EntryPoint {

	/**
	 * This is the entry point method.
	 */
	public void onModuleLoad() {
		final VerticalPanel panel = new VerticalPanel();
		panel.add(new HTML("<h1>GPS-CS1K→ALPSLAB route</h1>"));
		panel.add(new Label("変換前（NMEA-0183形式）"));
		final TextArea inputText = new TextArea();
		inputText.setSize("40em", "10em");
		panel.add(inputText);
		panel.add(new Label("変換後（KML形式）"));
		final TextArea outputText = new TextArea();
		outputText.setSize("40em", "20em");
		outputText.setText(convert(inputText.getText()));
		panel.add(outputText);
		final StringBuffer message = new StringBuffer();
		message.append("<ul>");
		message.append("<li><a href=\"http://www.sony.jp/products/Consumer/Peripheral/GPS/GPS-CS1K/\">GPS-CS1K</a>のログ（NMEA-0813形式）を<a href=\"http://route.alpslab.jp/\">ALPSLAB route</a>に貼り付けられるKML形式に変換します。</li>");
		message.append("<li>GGA（Global Positioning System Fix Data）の緯度、経度、高度のみを利用します。</li>");
		message.append("<li>サーバとの通信は行いません。クライアント上のJavaScriptのみで動作します。</li>");
		message.append("<li>ライセンスはGPSとします。</li>");
		message.append("<ul>");
		message.append("<li><a href=\"http://prdownloads.sourceforge.jp/zenjiro/24524/GPS-1.0.0.zip\">GPS-1.0.0.zip</a>（展開すればローカルで動きます。）</li>");
		message.append("<li><a href=\"http://zenjiro.sourceforge.jp/gps/GPS.java\">GPS.java</a>（Javaソースコード、UTF-8、コンパイルには<a href=\"http://code.google.com/webtoolkit/\">GWT</a>が必要です。）</li>");
		message.append("</ul>");
		message.append("</ul>");
		panel.add(new HTML(message.toString()));
		RootPanel.get("slot1").add(panel);
		inputText.setFocus(true);

		inputText.addKeyboardListener(new KeyboardListener() {
			public void onKeyPress(final Widget sender, final char keyCode, final int modifiers) {
			}

			public void onKeyDown(final Widget sender, final char keyCode, final int modifiers) {
			}

			public void onKeyUp(final Widget sender, final char keyCode, final int modifiers) {
				outputText.setText(convert(inputText.getText()));
			}
		});
		inputText.addChangeListener(new ChangeListener() {
			public void onChange(Widget sender) {
				outputText.setText(convert(inputText.getText()));
			}
		});
		inputText.addClickListener(new ClickListener() {
			public void onClick(final Widget sender) {
				outputText.setText(convert(inputText.getText()));
			}
		});
	}

	/**
	 * ログの形式を変換します。
	 * @param string 入力
	 * @return 出力
	 */
	public String convert(final String string) {
		final StringBuffer ret = new StringBuffer();
		ret.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
		ret.append("<kml xmlns=\"http://earth.google.com/kml/2.0\">\n");
		ret.append("<Placemark>\n");
		ret.append("<Style>\n");
		ret.append("<LineStyle>\n");
		ret.append("<color>99ff0000</color>\n");
		ret.append("<width>6</width>\n");
		ret.append("</LineStyle>\n");
		ret.append("</Style>\n");
		ret.append("<LineString>\n");
		ret.append("<coordinates>\n");
		final String[] lines = string.split("[\r\n]+");
		for (int i = 0; i < lines.length; i++) {
			final String line = lines[i];
			final String[] items = line.split(",");
			if (items[0].equals("$GPGGA")) {
				final double latitude = Double.parseDouble(items[2]);
				final double longitude = Double.parseDouble(items[4]);
				final double height = Double.parseDouble(items[8]);
				ret.append(((int) (longitude / 100) + (longitude % 100) / 60) + "," + ((int) (latitude / 100)
						+ (latitude % 100) / 60) + "," + height + "\n");
			}
		}
		ret.append("</coordinates>\n");
		ret.append("</LineString>\n");
		ret.append("</Placemark>\n");
		ret.append("</kml>\n");
		return ret.toString();
	}
}
