// safe_fdcat.c
// $Id: safe_fdcat.c,v 1.3 2007/05/08 09:17:28 cvs Exp $
// masashi shimakura


#include<stdio.h>
#include<string.h>
#include<stdlib.h>
#include <errno.h>
#include <unistd.h>

#include "almemsys.h"




char * safe_fdcat(int sk, char * getdata, int * stat, int max_len, int interval)
{
int indata = 0;
int inlen = 0;
int count = 0;
int plen = 0;
char bf[BUF_DEFLEN];
char * buf = bf;

int getcount;

if(getdata != NULL){
   free(getdata);
   getdata = NULL;
   getdata = (char *)calloc(BUF_LEN, sizeof(char));
   }

while(1){

   getcount = 0;  
   while(1){
      indata = socket_read(sk, buf, BUF_DEFLEN, interval);
      if(indata <= 0){
         if(errno != 11 && errno != 25){
            #ifdef SOCKET_BUG
            fprintf(stderr, "SOCKET: safe_fdcat(1): farst read err indata=%d\n", indata);
            fprintf(stderr, "SOCKET: safe_fdcat(1): ERRNO: %d %s\n", errno, strerror(errno));
            #endif
            * stat = -1;
            return NULL;
            }
         else{
            sleep(1);
            #ifdef SOCKET_BUG
            fprintf(stderr, "SOCKET: safe_fdcat(2): ERRNO: %d %s\n", errno, strerror(errno));
            #endif
            getcount++;
            if(getcount > 5){
               * stat = -1;
               return NULL;
               }
            }
         }
      else{
         #ifdef SOCKET_BUG
         fprintf(stderr, "SOCKET: safe_fdcat(3): ERRNO: %d %s\n", errno, strerror(errno));
         #endif
         break;
         }
      }


   buf[indata] = (char)0x00;
   
   if(indata <= BUF_DEFLEN && indata > 0){
      if(max_len >= (inlen + indata)){
         inlen = inlen + indata;
         if((getdata = (char *)realloc(getdata, sizeof(char) * (inlen + 1)))==NULL){
            fprintf(stderr,"The memory cannot be newly secured. \n");
            mlexit();
            }
         strncat(getdata, buf, (indata + 1));
         clean_mem(buf, '\0', BUF_DEFLEN);
         count = mem_count(getdata, (char)0x0a);
         if(getdata[count] == (char)0x0a && count >= 0){
            getdata[count+1] = (char)0x00;
            #ifdef AL_DEBUG
            printf("(1nomall)COUNT=<%d>COUNTALL=<%d>RIALCOUNT=<%d>GETDATA=<%s>POINT<%p><%d>\n",                  indata, inlen, (int)strlen(getdata), getdata, getdata, count);
            #endif
            #ifdef AL_DEBUG
            fprintf(stderr,"RECV >>%s", getdata);
            #endif
            * stat = 0;
            return getdata;
            }
         }

      if(max_len < (inlen + indata)){
         plen = indata - (inlen - max_len);
         inlen = max_len;
         fprintf(stderr,"memory max count err. %d\n", inlen);
         if((getdata = (char *)realloc(getdata, sizeof(char) * (inlen + 1)))==NULL){
            fprintf(stderr,"The memory cannot be newly secured. \n");
            mlexit();
            }
         strncat(getdata, buf, (plen + 1));
         clean_mem(buf, '\0', BUF_DEFLEN);
         getdata[inlen - 1] = (char)0x0a;
         getdata[inlen] = (char)0x00;
         #ifdef AL_DEBUG
         printf("(1 nomall)COUNT=<%d>COUNTALL=<%d>RIALCOUNT=<%d>GETDATA=<%s>POINT<%p>P<%d>\n",
               indata, inlen, (int)strlen(getdata), getdata, getdata, plen);
         #endif
         while(1){
            indata = socket_read(sk, buf, BUF_DEFLEN, interval);
            if(indata == 0){
               return NULL;
               }
            count = mem_count(buf, (char)0x0a);
            if(buf[count] == (char)0x0a && count >= 0){
               fprintf(stderr,"data cut of buf over err. \n");
               * stat = 0;
               return getdata;
               }
            clean_mem(buf, '\0', BUF_DEFLEN);
            }

         }
      }
   }

return NULL;
}





