// tcp.c
// $Id: tcp.c,v 1.2 2007/05/08 09:03:35 cvs Exp $
// masashi shimakura

/* Linux
#include<stdio.h>
#include<netinet/in.h>
#include<unistd.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<arpa/inet.h>
#include<stdlib.h>
#include<string.h>
#include<pthread.h>
*/


/* FreeBSD */
#include<stdio.h>
#include<unistd.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<arpa/inet.h>
#include<stdlib.h>
#include<string.h>
#include<pthread.h>
#include <fcntl.h>


#include"proxy.h"
#include"almemsys.h"

extern struct my_sock ip;
extern struct buf_data bf;

/*
int socket_bind(int, char []);
int socket_connect(int, char []);
int socket_accept(int);
*/


/*------------------ BIND ----------------------*/
int socket_bind(int port, char ip_addr[])
{
if((ip.in.ls = socket(AF_INET, SOCK_STREAM, 0))==-1){
   fprintf(stderr,"----soket-err----\n");
   exit(1);
   }

ip.in.my_addr.sin_family = AF_INET;
ip.in.my_addr.sin_port = htons(port);
ip.in.my_addr.sin_addr.s_addr = inet_addr(ip_addr);

if(bind(ip.in.ls, (struct sockaddr *) &ip.in.my_addr, sizeof(ip.in.my_addr)) == -1){
   fprintf(stderr,"----bind-err---\n");
   close(ip.in.ls);
   exit(1);
   }

if((listen(ip.in.ls,0))==-1){
   fprintf(stderr,"----Listen-err---\n");
   close(ip.in.ls);
   exit(1);
   }
return 0;
}




/*----------------------- CONNECT --------------------*/
int socket_connect(int port, char ip_addr[], int count)
{

if((ip.out.sk[count] = socket(AF_INET, SOCK_STREAM, 0))==-1){
   fprintf(stderr,"----soket-err----\n");
   exit(1);
   }

ip.out.my_addr.sin_family = AF_INET;
ip.out.my_addr.sin_port = htons(port);
ip.out.my_addr.sin_addr.s_addr = inet_addr(ip_addr);

if(connect(ip.out.sk[count], (struct sockaddr *) &ip.out.my_addr, sizeof(ip.out.my_addr)) == -1){
   fprintf(stderr,"----connect-err---\n");
   return -1;
   }
return 0;
}




/*--------------------- ACCEPT -------------------*/
int socket_accept(int count)
{
ip.in.my_addrlen = sizeof(ip.in.my_addr);
if((ip.in.sk[count]=accept(ip.in.ls, (struct sockaddr *) &ip.in.my_addr, &ip.in.my_addrlen)) == -1){
   fprintf(stderr,"--- accept-err ---\n");
   fprintf(stderr,"The maximum, connected number of servers is exceeded. %d\n", count);
   close(ip.in.ls);
   exit(1);
   }
else {
   ip.fdno = count;
   }
return 0;
}



/*--------------------- SEND -------------------------
int socket_send(int sk, char * senddata)
{
static int indata;

indata = 0;
if((indata = send(sk, senddata, (int)strlen(senddata), 0)) == -1){
   fprintf(stderr,"--- 0 send err %s ---\n", senddata);
   return -1;
   }

return indata;
} 
*/

/*--------------------- SEND ------------------------- */
int socket_send(int sk, char * senddata){
int ret;
struct timeval tv;
int retval, interval;
fd_set rfds;
interval = 5;

fcntl(sk, F_SETFL, O_NONBLOCK);
tv.tv_sec = interval;
tv.tv_usec = 0;

#ifdef SOCKET_BUG
printf("SOCKET: socket_send(1): interval time set %d\n", interval);
#endif

ret = 0;

ret = send(sk, senddata, (int)strlen(senddata), 0);

while(1){
   FD_ZERO(&rfds);
   FD_SET(sk, &rfds);
   retval = select(sk + 1, &rfds, NULL, NULL, &tv);
   if(retval < 0){
      #ifdef SOCKET_BUG
      printf("SOCKET: socket_send(2): NG select <%d> ERRNO: %d %s\n",
        retval, errno, strerror(errno));
      #endif
      ret = -1;
      break;
      }
   if(retval == 0){
      #ifdef SOCKET_BUG
      printf("SOCKET: socket_send(3): NG select <%d> ERRNO: %d %s\n",
        retval, errno, strerror(errno));
      #endif
      ret = -1;
      break;
      }
   if(retval >= 1){
      #ifdef SOCKET_BUG
      printf("SOCKET: socket_send(4): NG select <%d> ERRNO: %d %s\n",
        retval, errno, strerror(errno));
      #endif
      break;
      }
   } /* while */


fcntl(sk, F_SETFL, 0);

return(ret);
}





char * select_fdcat(int sk, char * getdata, int * ret, int max)
{
struct timeval tv;
int retval;
fd_set rfds;

fcntl(sk, F_SETFL, O_NONBLOCK);
tv.tv_sec = 5;
tv.tv_usec = 0;

* ret = 0;

while(1){
   FD_ZERO(&rfds);
   FD_SET(sk, &rfds);
   retval = select(sk + 1, &rfds, NULL, NULL, &tv);
   if(retval < 0){
      fcntl(sk, F_SETFL, 0);
      #ifdef SOCKET_BUG
      printf("SOCKET: select_fdcat(1): NG select <%d>\n", retval);
      #endif
      * ret = -1;
      break;
      }
   if(retval == 0){
      fcntl(sk, F_SETFL, 0);
      #ifdef SOCKET_BUG
      printf("SOCKET: select_fdcat(2): NG select <%d>\n", retval);
      #endif
      * ret = -1;
      break;
      }
   if(retval >= 1){
      fcntl(sk, F_SETFL, 0);
      getdata = safe_fdcat(sk, getdata, ret, max, 5);
      #ifdef SOCKET_BUG
      printf("SOCKET: select_fdcat(): OK select <%d> %s\n", retval, getdata);
      #endif
      break;
      }

   } /* while */

// fcntl(sk, F_SETFL, 0);

return getdata;
}







