// sitar.c
// $Id: sitar.c,v 1.4 2007/05/14 07:24:21 cvs Exp $
// masashi shimakura

#include<stdio.h>
#include<sys/types.h>
#include<unistd.h>
#include<sys/wait.h>
#include<sys/stat.h>
#include<fcntl.h>
#include<string.h>
#include<stdlib.h>
#include<signal.h>
#include<pthread.h>

#include"sitar.h"
#include"sitar_com.h"
#include"almemsys.h"
#include "jpreturn.h"

global_data_t gd;
swap_array_t sa;

char * sitarpid = "/usr/local/zither/lock/sitarctl.pid";
pthread_mutex_t fd_mutex;
pthread_mutex_t mail_mutex;
pthread_mutex_t file1_mutex;
pthread_mutex_t file2_mutex;
pthread_mutex_t name_mutex;
pthread_mutex_t exec_mutex;


// int set_interval(void);
int get_comconf(char *, char *);
int get_configfile(char *, char *);
int get_statfile(char *);
int setup_conf(void);
int start_neg(void);
int life_put(void);
int life_pthread(void);
int sitar_scan(void);
int swap_char(char *);
int file_copy(char *, char *);
int my_chmem(char *, char *);
int scan_comand(private_data_t *);
char * check_strtol(char *);
void * scan_block(int);


int main(int argc, char * argv[])
{
pthread_t t1, t2;

pthread_mutex_init(&fd_mutex, NULL);
pthread_mutex_init(&mail_mutex, NULL);
pthread_mutex_init(&file1_mutex, NULL);
pthread_mutex_init(&file2_mutex, NULL);
pthread_mutex_init(&name_mutex, NULL);
pthread_mutex_init(&exec_mutex, NULL);

malloc_set();
set_data();
optin(argc, argv);
conf_set(gd.fi.conf_path);
malloc_set2();
swap_malloc_set();

gd.bf.my_pid = (int)getpid();

if(setpgid(gd.bf.my_pid, gd.bf.my_pid)){
   fprintf(stderr,"main(): fork stpgid no chenge!");
   } 

if((socket_connect(gd.ip.port, gd.ip.ip_addr)) < 0){
   fprintf(stderr,"main(): Not connection <1> %s %d\n", gd.ip.ip_addr, gd.ip.port);
   sleep(10);
   if((socket_connect(gd.ip.port2, gd.ip.ip2_addr)) < 0){
      fprintf(stderr,"main(): Not connection <2> %s %d\n", gd.ip.ip2_addr, gd.ip.port2);
      safe_exit("main(): socket connect err exit \n");
      }
   }


start_neg();
setup_conf();

gd.bf.stop_count = 0;
gd.bf.break_count = 0;

   pthread_create( &t1, NULL, (void *)sitar_scan, NULL);
   pthread_create( &t2, NULL, (void *)life_pthread, NULL);

   pthread_join( t1, NULL);
   pthread_join( t2, NULL);

   /* It doesn't reach. */

swap_malloc_free();
malloc_set2_free();
malloc_set_free();

close(gd.ip.sk);
gd.ip.sk = 0;
return 0;
}



/* --- LIFE_PTHREAD --- */
int life_pthread(void)
{
int count = 1;

for(;;){
   life_put();
   for(count =0; count < gd.bf.life_int; count++){
      sleep(1);
      #ifdef LIFE_DEBUG
      printf("LIFE: INTERVAL_COUNT: life_pthread():  count=%d all=%d\n", count, gd.bf.life_int);
      #endif
      }
   }
wait(NULL);

return 0;
} 





/* --------- FILE COPY -------- */
int file_copy(char * file1, char * file2)
{
int stat;
FILE * fp;
FILE * fp2;
int inA;

stat = 0;

if((fp = fopen(file1, "r+"))!=NULL){
   if((fp2 = fopen(file2, "w+"))!=NULL){
      while(stat == 0){
         inA = getc(fp);
         switch(inA){
            case EOF: stat = 1;  break;
            default : putc(inA, fp2); break;
            }
         }
      }
   else {
      fprintf(stderr,"file_copy(): %s file not open.\n", file2);
      stat = -1;
      return(stat);
      }
   fclose(fp);
   fclose(fp2);
   }
else {
   fprintf(stderr,"file_copy(): %s file not open.\n", file1);
   stat = -1;
   return(stat);
   }

return(stat);
}




/* ---------- SITAR_SCAN ----------- */
int sitar_scan(void)
{
FILE * fp;
int stat;
int bstat;
int ren;
int count;
int delmi;
long int fdcount;
int fdclean;
int fdcountstat;
int sleepcount;
stat = 0;
bstat = 0;
ren = 0;
count = 0;
delmi = 1;

for(;;){

   pthread_mutex_lock(&file1_mutex);

   gd.fi.bat2_filestat = stat_check(gd.fi.bat2_filestat, gd.fi.bat2_filename, IP_LEN, &bstat);
   if(0 > bstat){
      file_copy(gd.fi.bat2_filename, gd.fi.bat2_filename_2);
      }


   if((fp = fopen(gd.fi.bat2_filename_2, "r+"))!=NULL){

      while(1){
         gd.sd.swap = safe_fpcat(fp, gd.sd.swap, &stat, BUF_MAX);
         delmi = memcmp(gd.sd.swap, "*****", 5);

         if(ren <= (gd.td.tbufmax - 1)){
            if(stat == 0 && delmi != 0 && 0x00 != gd.sd.swap[0]){
               gd.sd.swap = check_strtol(gd.sd.swap);
               if('#' != gd.sd.swap[0]){
                  sa.tmp_data[ren] = safe_memcpy(sa.tmp_data[ren], gd.sd.swap, BUF_MAX);
                  #ifdef FREE_BUG
                  printf("FREE: single sitar_scan(1): gd.sd.swap %s\n", gd.sd.swap);
                  #endif
                  free(gd.sd.swap);
                  gd.sd.swap = NULL;
                  gd.sd.swap = (char *)calloc(IP_LEN, sizeof(char));
                  ren++;
                  }
               else{
                  #ifdef FREE_BUG
                  printf("FREE: single sitar_scan(2): gd.sd.swap %s\n", gd.sd.swap);
                  #endif
                  free(gd.sd.swap);
                  gd.sd.swap = NULL;
                  gd.sd.swap = (char *)calloc(IP_LEN, sizeof(char));
                  }
               }
            }
         else{
            sa.main_buf_err = 1;
            fprintf(stderr ,"sitar_scan(): main buf over size <%d> : gd.td.tbufmax<%d>\n",
              ren, gd.td.tbufmax);
            }

         /*  ---- **** Block ------ */
         if(ren < gd.td.tbufmax && stat == 0 && delmi == 0){

            for(fdcountstat = 0;fdcountstat == 0;){
               for(fdcount = 0; fdcount < gd.td.tcount; fdcount++){
                  #ifdef THREAD_BUG
                  printf("THREAD_FD: sitar_scan(): fdcount<%ld>fdstat<%d>\n",
                    fdcount, gd.td.fdstat[fdcount]);
                  #endif
                  if(gd.td.fdstat[fdcount] != 1){
                     gd.td.fdstat[fdcount] = 1;
                     #ifdef FREE_BUG
                     printf("FREE: sitar_scan(1): safree(%d) fdcount\n", fdcount);
                     #endif
                     safree(fdcount);
                     sacalloc(fdcount);
                     break;
                     }
                  }

               if(fdcount < gd.td.tcount){
                  for(count = 0; count < ren; count++){
                     sa.swap_data[fdcount][count] = safe_memcpy(
                         sa.swap_data[fdcount][count], sa.tmp_data[count], BUF_MAX); 
                     #ifdef THREAD_BUG
                     printf("THREAD: sitar_scan(): Thread No = %ld\n", fdcount);
                     #endif
                     }

                  if(sa.main_buf_err == 1){
                     sa.buf_err[fdcount] = 1;
                     sa.main_buf_err = 0;
                     }
                  else{
                     sa.buf_err[fdcount] = 0;
                     }
               // pthread_create
                  fdcountstat = 1;
                  pthread_create(&sa.pt[fdcount], NULL, (void *)scan_block, (int *)fdcount);
                  }
               else{
                  fprintf(stderr,"sitar_scan(): The thread cannot be made (1). %ld\n", fdcount);
                  fdcountstat = 0;
                  for(sleepcount = 0; sleepcount < 5; sleepcount++){
                     fprintf(stderr,"sitar_scan(): wait thread open (1sec). %ld\n", fdcount);
                     sleep(1);
                     }
                  }
               } // for()

            gd.sd.scan_all = safe_memcpy(gd.sd.scan_all, "\0", BUF_MAX);
            ren = 0;
            count = 0;
            } // if()

         /* ---- END Block ---- */
         if(ren >= gd.td.tbufmax || stat != 0){

            for(fdcountstat = 0;fdcountstat == 0;){
               for(fdcount = 0; fdcount < gd.td.tcount; fdcount++){
                  #ifdef THREAD_BUG
                  printf("THREAD_ERR: sitar_scan(): END fdcount<%ld>fdstat<%d>\n",
                    fdcount, gd.td.fdstat[fdcount]);
                  #endif
                  if(gd.td.fdstat[fdcount] != 1){
                     gd.td.fdstat[fdcount] = 1;
                     #ifdef FREE_BUG
                     printf("FREE: sitar_scan(2): safree(%ld) fdcount\n", fdcount);
                     #endif
                     safree(fdcount);
                     sacalloc(fdcount);
                     break;
                     }
                  }

               if(fdcount < gd.td.tcount){
                  for(count = 0; count < ren; count++){
                     sa.swap_data[fdcount][count] = safe_memcpy(
                         sa.swap_data[fdcount][count], sa.tmp_data[count], BUF_MAX); 
                     #ifdef THREAD_BUG
                     printf("THREAD_NO: sitar_scan(): Thread No = %ld\n", fdcount);
                     #endif
                     }

                  ren = 0;
                  count = 0;

                  if(sa.main_buf_err == 1){
                     sa.buf_err[fdcount] = 1;
                     sa.main_buf_err = 0;
                     }
                  else{
                     sa.buf_err[fdcount] = 0;
                     }
               // pthread_create
                  fdcountstat = 1;
                  pthread_create(&sa.pt[fdcount], NULL, (void *)scan_block, (int *)fdcount);
                  }
               else {
                  fprintf(stderr,"The thread cannot be made (2). %ld\n",fdcount);
                  fdcountstat = 0;
                  for(sleepcount = 0; sleepcount < 5; sleepcount++){
                     fprintf(stderr,"wait thread open (1sec). %ld\n",fdcount);
                     sleep(1);
                     }
                  }
               }

            gd.sd.scan_all = safe_memcpy(gd.sd.scan_all, "\0", BUF_MAX);
            ren = 0;
            count = 0;
            #ifdef FILE_DEBUG
            printf("FILE: sitar_scan(): End of file or file read err.\n");
            #endif
            break;
            } // if()

         } // while()

      stat = 0;
      fclose( fp );
      } // fopen()

// printf(" MUTEX STOP read \n");
   pthread_mutex_unlock(&file1_mutex);


   #ifdef THREAD_BUG
   printf("THREAD_FREE: sitar_scan(): satmpfree calloc()\n");
   #endif 
   satmpfree();
   satmpcalloc();

   for(fdclean = 0; fdclean < gd.td.tcount; fdclean++){
      if(gd.td.fdstat[fdclean] != 1){
         #ifdef THREAD_BUG
         printf("THREAD_FREE: sitar_scan(): No used buffer cleanup. fdclean<%d>fdstat<%d>\n",
           fdclean, gd.td.fdstat[fdclean]);
         #endif
         #ifdef MALLOC_BUG
         printf("MALLOC: sitar_scan(): No used buffer cleanup. fdclean<%d>fdstat<%d>\n",
           fdclean, gd.td.fdstat[fdclean]);
         #endif
         #ifdef FREE_BUG
         printf("FREE: sitar_scan(): safree(%d) fdclean\n", fdclean);
         #endif
         safree(fdclean);
         sacalloc(fdclean);
         }
      }


   sleep(gd.bf.bat2_int);
   } // for(;;)

// Not reachablle

return 0;
}




//  scan_block はスレッド分岐先の関数になります
void * scan_block(int count)
{
int co;
int stat;
int errcount;
int mucount;
int mutexid, middleid;
char mid_stat;
int wtime_1;
int wtime_2;
char * tmp;

wtime_1 = 0;
wtime_2 = 0;
mucount = 0;
mutexid = -1;
middleid = -1;
mid_stat = 0;
errcount = 0;
stat = 0;
private_data_t *pd;


/* Pthread detachd scan_block() */
pthread_detach(pthread_self());

if((pd = (private_data_t *)malloc(sizeof(private_data_t)))==NULL){exit(1);}
scan_malloc_set(pd);


#ifdef MALLOC_BUG
printf("MALLOC: scan_block(): scan_malloc_set(pd):\n");
#endif


pd->sb.fdno = count;

for(co = 0; sa.swap_data[pd->sb.fdno][co][0] != 0x00; co++){
   if(mutexid <= 0){
      pd->sb.swap_2 = safe_memcpy(pd->sb.swap_2, sa.swap_data[pd->sb.fdno][co], BUF_MAX);

      if(13 == char_count(pd->sb.swap_2,',') && 13 <= strlen(pd->sb.swap_2) && '#' != pd->sb.swap_2[0]){ 
         pd->sb.ch_tool = safe_memcpy(pd->sb.ch_tool, strtok_r(pd->sb.swap_2, ",", &tmp), BUF_MAX);
         pd->sb.ch_stat = safe_memcpy(pd->sb.ch_stat, strtok_r(NULL, ",", &tmp), BUF_MAX);
         pd->sb.ch_prot = safe_memcpy(pd->sb.ch_prot, strtok_r(NULL, ",", &tmp), BUF_MAX);
         pd->sb.ch_com  = safe_memcpy(pd->sb.ch_com,  strtok_r(NULL, ",", &tmp), BUF_MAX);
         pd->sb.ch_host = safe_memcpy(pd->sb.ch_host, strtok_r(NULL, ",", &tmp), BUF_MAX);
         pd->sb.ch_port = safe_memcpy(pd->sb.ch_port, strtok_r(NULL, ",", &tmp), BUF_MAX);
         pd->sb.ch_timeout = safe_memcpy(pd->sb.ch_timeout, strtok_r(NULL, ",", &tmp), BUF_MAX);
         pd->sb.ch_data = safe_memcpy(pd->sb.ch_data, strtok_r(NULL, ",", &tmp), BUF_MAX);
         pd->sb.ch_plai = safe_memcpy(pd->sb.ch_plai, strtok_r(NULL, ",", &tmp), BUF_MAX);
         pd->sb.ch_free1 = safe_memcpy(pd->sb.ch_free1, strtok_r(NULL, ",", &tmp), BUF_MAX);
         pd->sb.ch_free2 = safe_memcpy(pd->sb.ch_free2, strtok_r(NULL, ",", &tmp), BUF_MAX);
         pd->sb.ch_free3 = safe_memcpy(pd->sb.ch_free3, strtok_r(NULL, ",", &tmp), BUF_MAX);
         pd->sb.ch_free4 = safe_memcpy(pd->sb.ch_free4, strtok_r(NULL, ",", &tmp), BUF_MAX);

         if(1 <= strlen(pd->sb.ch_stat) && 1 <= strlen(pd->sb.ch_prot) &&
            1 <= strlen(pd->sb.ch_host) && 1 <= strlen(pd->sb.ch_port) &&
            1 <= strlen(pd->sb.ch_timeout) && 1 <= strlen(pd->sb.ch_data) &&
            1 <= strlen(pd->sb.ch_tool) && 1 <= strlen(pd->sb.ch_com) &&
            1 <= strlen(pd->sb.ch_plai) && 1 <= strlen(pd->sb.ch_free1)){ 

            rm_crlf(pd->sb.ch_stat, strlen(pd->sb.ch_stat));
            rm_crlf(pd->sb.ch_prot, strlen(pd->sb.ch_prot));
            rm_crlf(pd->sb.ch_host, strlen(pd->sb.ch_host));
            rm_crlf(pd->sb.ch_port, strlen(pd->sb.ch_port));
            rm_crlf(pd->sb.ch_timeout, strlen(pd->sb.ch_timeout));
            rm_crlf(pd->sb.ch_data, strlen(pd->sb.ch_data));
            rm_crlf(pd->sb.ch_tool, strlen(pd->sb.ch_tool)); 
            rm_crlf(pd->sb.ch_com, strlen(pd->sb.ch_com)); 
            rm_crlf(pd->sb.ch_plai, strlen(pd->sb.ch_plai)); 
            rm_crlf(pd->sb.ch_free1, strlen(pd->sb.ch_free1));
            rm_crlf(pd->sb.ch_free2, strlen(pd->sb.ch_free2));
            rm_crlf(pd->sb.ch_free3, strlen(pd->sb.ch_free3));
            rm_crlf(pd->sb.ch_free4, strlen(pd->sb.ch_free4));

            pd->sb.port = strtol(pd->sb.ch_port, (char **)NULL, 10);
            pd->sb.timeout = strtol(pd->sb.ch_timeout, (char **)NULL, 10);

            if(pd->sb.timeout > TIME_OUT || pd->sb.timeout < 0){
               if(pd->sb.timeout > TIME_OUT){
                  pd->sb.timeout = 4;
                  }
               else{
                  pd->sb.timeout = 0;
                  }
               fprintf(stderr,"scan_block(): default setup command time out %d\n", pd->sb.timeout);
               }

            // SET は最初の行に限定される条件なので、最初に以下の監視条件を満たすことは無いです。
            pd->sb.ch_info = safe_memcpy(pd->sb.ch_info, "\n", BUF_MAX);

            if(0 == memcmp(pd->sb.ch_tool, "PORT", 4)){
               #ifdef MONITOR_BUG
               printf("MONITOR: %s: %s: %s: %s:\n",
                 pd->sb.ch_tool, pd->sb.ch_prot, pd->sb.ch_free1, pd->sb.ch_free4);
               #endif 
               scan_port(&pd->sb);
               }
            else if(0 == memcmp(pd->sb.ch_tool, "COMAND", 6)){
               #ifdef MONITOR_BUG
               printf("MONITOR: %s: %s: %s: %s:\n",
                 pd->sb.ch_tool, pd->sb.ch_prot, pd->sb.ch_free1, pd->sb.ch_free4);
               #endif 
               scan_comand(pd);
               }
            else if(0 == memcmp(pd->sb.ch_tool, "SNMP", 4)){
               #ifdef MONITOR_BUG
               printf("MONITOR: %s: %s: %s: %s:\n",
                 pd->sb.ch_tool, pd->sb.ch_prot, pd->sb.ch_free1, pd->sb.ch_free4);
               #endif 
               scan_snmp(&pd->sb);
               }
            else if(0 == memcmp(pd->sb.ch_tool, "SET", 3)){
               #ifdef MONITOR_BUG
               printf("MONITOR: %s: %s: %s: %s:\n",
                 pd->sb.ch_tool, pd->sb.ch_prot, pd->sb.ch_free1, pd->sb.ch_free4);
               #endif 
               pd->sb.check_stat = 2;
               }
            else{
               #ifdef MONITOR_BUG
               printf("MONITOR: 存在しない属性が設定されています %s: %s: %s: %s:\n",
                 pd->sb.ch_tool, pd->sb.ch_prot, pd->sb.ch_free1, pd->sb.ch_free4);
               #endif
               goto protoloopout;
               }


            // SET 行の場合の処理になります
            if(pd->sb.check_stat == 2 ){

               swap_mem(pd->sb.ch_prot, ';', ' ', strlen(pd->sb.ch_prot));
               swap_mem(pd->sb.ch_free1, ';', ' ', strlen(pd->sb.ch_free1));
               swap_mem(pd->sb.ch_free2, ';', ' ', strlen(pd->sb.ch_free2));
               swap_mem(pd->sb.ch_free3, ';', ' ', strlen(pd->sb.ch_free3));
               swap_mem(pd->sb.ch_free4, ';', ' ', strlen(pd->sb.ch_free4));


               if(0 < (int)strlen(pd->sb.ch_free4)){ 

                  if(0 == self_memcmp(pd->sb.ch_free1, "MID")){ mid_stat = 1; }
                  else if(0 == self_memcmp(pd->sb.ch_free1, "MIX")){ mid_stat = 2; }
                  else{ mid_stat = 0; }

                  pthread_mutex_lock(&mail_mutex);

                  // mail 属性がmiddleな場合に、ブロック名をDBに登録します
                  // middleでない場合はブロック名の登録がある場合は消します。
                  if(mid_stat > 0){
                     for(mucount = 0; mucount < B_MAX; mucount++){
                        if(0 == self_memcmp(gd.td.middle_name[mucount], pd->sb.ch_free4)){
                           middleid = mucount;

                           #ifdef MAIL_MUTEX
                           printf("MAIL_MUTEX: scan_block(): 同じ名前のブロックが既に登録済みです <%s> mucount<%d><%s>count<%d><%d>\n",
                             gd.td.middle_name[mucount], mucount, pd->sb.ch_free4, gd.td.middle_id[mucount], pd->sb.fdno);
                           #endif

                           break;
                           }
                        } // for()
                     if(middleid == -1){
                        for(mucount = 0; mucount < B_MAX; mucount++){
                           if(0 == memcmp(gd.td.middle_name[mucount], " \n", 2)){
                              gd.td.middle_name[mucount] = safe_memcpy(gd.td.middle_name[mucount],
                                                                      pd->sb.ch_free4, BUF_MAX);
                              gd.td.middle_id[mucount] = 0;

                              #ifdef MAIL_MUTEX
                              printf("MAIL_MUTEX: scan_block(): ブロック新規に登録しました <%s> mucount<%d><%s>count<%d><%d>\n",
                                 gd.td.middle_name[mucount], mucount, pd->sb.ch_free4, gd.td.middle_id[mucount], pd->sb.fdno);
                              #endif

                              middleid = mucount;
                              break;
                              }
                           } // for()
                        if(mucount >= B_MAX){
                           fprintf(stderr,"scan_block(): 上限%dを越えたためブロックが登録出来ません mucount<%d> <%s>\n",
                              B_MAX, mucount, pd->sb.ch_free4);
                           }
                        }
                     }
                  else{
                     for(mucount = 0; mucount < B_MAX; mucount++){
                        if(0 == self_memcmp(gd.td.middle_name[mucount], pd->sb.ch_free4)){

                           #ifdef MAIL_MUTEX
                           printf("MAIL_MUTEX: scan_block(): MIDDLE でないのに同じ名前のブロックが既に登録済なので消します <%s> mucount<%d> <%s> count<%d>\n",
                             gd.td.middle_name[mucount], mucount, pd->sb.ch_free4, gd.td.middle_id[mucount]);
                           #endif

                           gd.td.middle_name[mucount] = safe_memcpy(gd.td.middle_name[mucount], " \n", BUF_MAX);
                           gd.td.middle_id[mucount] = 0;
                           break;
                           }
                        } // for()
                     }
                  pthread_mutex_unlock(&mail_mutex);


                  // 同じ監視ブロックが動いている場合はfor()から抜けます、スレッド排他処理しています 
                  pthread_mutex_lock(&name_mutex);

                  for(mucount = 0; mucount < gd.td.tbufmax; mucount++){
                     if(0 == self_memcmp(gd.td.mutex_name[mucount], pd->sb.ch_free4)){
                        #ifdef MUTEX_BUG
                        printf("MUTEX: scan_block(): 同じ名前の監視グループが起動中ですこの監視グループは無視します <%s> mucount<%d> <%s>\n",
                          gd.td.mutex_name[mucount], mucount, pd->sb.ch_free4);
                        #endif 
                        mutexid = 1;
                        break;
                        }
                     mutexid = 0;
                     } // for()
                  if(mutexid == 0){
                     for(mucount = 0; mucount < gd.td.tbufmax; mucount++){
                        if(0 == memcmp(gd.td.mutex_name[mucount], " \n", 2)){
                           gd.td.mutex_name[mucount] = safe_memcpy(gd.td.mutex_name[mucount],
                                                                   pd->sb.ch_free4, BUF_MAX);
                           #ifdef MUTEX_BUG
                           printf("MUTEX: scan_block(): 現在同じ監視グループは動いていないので排他処理に登録します <%s> mucount<%d>\n",
                             gd.td.mutex_name[mucount], mucount);
                           #endif
                           mutexid = 0;
                           break;
                           }
                        } // for()
                     if(mucount >= gd.td.tbufmax){
                        fprintf(stderr,"scan_block(): %s\n", MUTEX_1);
                        mutexid = 1;
                        }
                     }
                  pthread_mutex_unlock(&name_mutex);


                  // 排他処理に登録された場合の時間指定の確認
                  if(mutexid == 0){
                     if(0 == memcmp(pd->sb.ch_prot, "JUST", 4)){
                        if((wtime_1 = strtol(pd->sb.ch_timeout, (char **)NULL, 10)) >= 0){
                           #ifdef MUTEX_BUG
                           printf("MUTEX: scan_block(): JUST時間単位で一回実行の設定がされました <%s>\n",
                             pd->sb.ch_prot);
                           #endif 
                           if(0 > hloop(wtime_1)){
                              #ifdef MUTEX_BUG
                              printf("MUTEX: scan_block(): JUSTで条件を満たしていないのでループを抜けます\n");
                              #endif 
                              goto forloopout;
                              }
                           else{
                              #ifdef MUTEX_BUG
                              printf("MUTEX: scan_block(): JUSTで条件を満たしたので監視を開始します。砿n");
                              #endif 
                              }
                           wtime_1 = 0;
                           }
                        }

                     else if(0 == memcmp(pd->sb.ch_prot, "FOR", 3)){
                        if((wtime_1 = strtol(pd->sb.ch_port, (char **)NULL, 10)) >= 0){
                           if((wtime_2 = strtol(pd->sb.ch_timeout, (char **)NULL, 10)) >= 0){
                              #ifdef MUTEX_BUG
                              printf("MUTEX: scan_block(): FOR時間単位で指定時間内実行の設定がされました<%s>\n",
                                pd->sb.ch_prot);
                              #endif 
                              if(0 > floop(wtime_1, wtime_2)){
                                 #ifdef MUTEX_BUG
                                 printf("MUTEX: scan_block(): FORで条件を満たしていないのでループを抜けます <%d>から<%d>\n",
                                   wtime_1, wtime_2);
                                 #endif
                                 goto forloopout;
                                 }
                              else{
                                 #ifdef MUTEX_BUG
                                 printf("MUTEX: scan_block(): FORで条件を満たしたので監視を開始します。砿n");
                                 #endif 
                                 }
                              wtime_1 = 0;
                              wtime_2 = 0;
                              }
                           }
                        }

                     // FOR JUST 以外の場合 
                     else{
                        #ifdef MUTEX_BUG
                        printf("MUTEX: scan_block(): 時間単位の設定は入っていません\n");
                        #endif 
                        }
                     //  wait 秒待ちます
                     if(0 < (int)strlen(pd->sb.ch_plai)){ 
                        #ifdef MUTEX_BUG
                        printf("MUTEX: scan_block(): 以下の秒だけ待ちます <%s> mucount<%d>\n",
                          pd->sb.ch_plai, mucount);
                        #endif 
                        sleep(strtol(pd->sb.ch_plai, (char **)NULL, 10)); 
                        }
                     }   // mutexid = 0
                  }  // if(free4 " /n")


               // Zither に送るERRログの先頭に入るSETの内容を作成
               // mail送信属性を判断し、MIDの場合は ONかOFFに判断する。
               if(mutexid == 0){
                  pthread_mutex_lock(&mail_mutex);
                  if(mid_stat > 0){

                     if(mid_stat == 1){
                        pd->sb.ch_info = safe_sprintf(pd->sb.ch_info, BUF_MAX,"MID%d", gd.td.middle_id[middleid]);
                        }
                     else if(mid_stat == 2){
                        pd->sb.ch_info = safe_sprintf(pd->sb.ch_info, BUF_MAX,"MIX%d", gd.td.middle_id[middleid]);
                        }
                     else{
                        pd->sb.ch_info = safe_sprintf(pd->sb.ch_info, BUF_MAX,"MID%d", gd.td.middle_id[middleid]);
                        }

                     if(gd.td.middle_id[middleid] >= 3){
                        #ifdef MAIL_MUTEX
                        printf("MAIL_MUTEX: scan_block(): メール属性をOFFに設定しました <%s> mucount<%d> count<%d>\n",
                                    gd.td.middle_name[mucount], mucount, gd.td.middle_id[mucount]);
                        #endif
                        pd->sb.ch_free1 = safe_memcpy(pd->sb.ch_free1, "OFF", BUF_MAX);
                        }
                     else{
                        #ifdef MAIL_MUTEX
                        printf("MAIL_MUTEX: scan_block(): メール属性をONに設定しました <%s> mucount<%d> count<%d>\n",
                                    gd.td.middle_name[mucount], mucount, gd.td.middle_id[mucount]);
                        #endif
                        pd->sb.ch_free1 = safe_memcpy(pd->sb.ch_free1, "ON", BUF_MAX);
                        }
                     }
                  pthread_mutex_unlock(&mail_mutex);

                  // SET 行の作成
                  pd->sb.swap_2 = safe_sprintf(pd->sb.swap_2, BUF_MAX,
                     "%s,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%s,%s,%s,%s,%d,%d,%s,%s,%s,%s,%s,%s,%s;",
                     pd->sb.ch_tool,
                     u_time(),
                     ctime_getr('y'),
                     ctime_getr('m'),
                     ctime_getr('d'),
                     ctime_getr('h'),
                     ctime_getr('i'),
                     ctime_getr('s'),
                     "NOT",
                     "NOT",
                     pd->sb.ch_plai,
                     pd->sb.ch_prot,
                     wtime_1,
                     wtime_2,
                     "NOT",
                 //    "NOT",
                     pd->sb.ch_info,
                     "NOT",
                     pd->sb.ch_free1,
                     pd->sb.ch_free2,
                     pd->sb.ch_free3,
                     pd->sb.ch_free4);

                  pd->sb.scan_all = safe_strncat(pd->sb.scan_all, pd->sb.swap_2, BUF_MAX);

                  }
               } 

            // ERR が観測された場合の処理。
            if(pd->sb.check_stat == 1){

               errcount++;
               swap_mem(pd->sb.ch_stat, ';', ' ', strlen(pd->sb.ch_stat));
               swap_mem(pd->sb.ch_prot, ';', ' ', strlen(pd->sb.ch_prot));
               swap_mem(pd->sb.ch_prot, ';', ' ', strlen(pd->sb.ch_prot));
               swap_mem(pd->sb.ch_com, ';', ' ', strlen(pd->sb.ch_com));
               swap_mem(pd->sb.ch_host, ';', ' ', strlen(pd->sb.ch_host));
               swap_mem(pd->sb.ch_timeout, ';', ' ', strlen(pd->sb.ch_timeout));
               swap_mem(pd->sb.ch_data, ';', ' ', strlen(pd->sb.ch_data));
               swap_mem(pd->sb.ch_info, ';', ' ', strlen(pd->sb.ch_info));
               swap_mem(pd->sb.ch_plai, ';', ' ', strlen(pd->sb.ch_plai));
               swap_mem(pd->sb.ch_free1, ';', ' ', strlen(pd->sb.ch_free1));
               swap_mem(pd->sb.ch_free2, ';', ' ', strlen(pd->sb.ch_free2));
               swap_mem(pd->sb.ch_free3, ';', ' ', strlen(pd->sb.ch_free3));
               swap_mem(pd->sb.ch_free4, ';', ' ', strlen(pd->sb.ch_free4));

               pd->sb.swap_2 = safe_sprintf(pd->sb.swap_2, BUF_MAX,
                  "%s,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%s,%s,%s,%s,%d,%d,%s,%s,%s,%s,%s,%s,%s;",
                  pd->sb.ch_tool,
                  u_time(),
                  ctime_getr('y'),
                  ctime_getr('m'),
                  ctime_getr('d'),
                  ctime_getr('h'),
                  ctime_getr('i'),
                  ctime_getr('s'),
                  pd->sb.ch_stat,
                  pd->sb.ch_prot,
                  pd->sb.ch_com,
                  pd->sb.ch_host,
                  pd->sb.port,
                  pd->sb.timeout,
                  pd->sb.ch_data,
                  pd->sb.ch_info,
                  pd->sb.ch_plai,
                  pd->sb.ch_free1,
                  CL_VAR,
                  pd->sb.ch_free3,
                  pd->sb.ch_free4);

               pd->sb.scan_all = safe_strncat(pd->sb.scan_all, pd->sb.swap_2, BUF_MAX);
               }
            } 
         }
      protoloopout :;

      } // if(mutexid == 0)
   } // for()

// FOR JUST の条件外になるとここに飛ぶ
forloopout :;




if(mutexid == 0){
   pthread_mutex_lock(&name_mutex);
   #ifdef MUTEX_BUG
   printf("MUTEX: scan_block(1): 登録ブロック名を消します <%s> mucount<%d>\n",
     gd.td.mutex_name[mucount], mucount);
   #endif

   #ifdef FREE_BUG
   printf("FREE: single scan_block(1): gd.td.mutex_name[%d] <%s>\n",
     mucount, gd.td.mutex_name[mucount]);
   #endif

   #ifdef MUTEX_BUG
   printf("MUTEX: scan_block(2): 登録ブロック名を消しました <%s> mucount<%d>\n",
     gd.td.mutex_name[mucount], mucount);
   #endif

   gd.td.mutex_name[mucount] = safe_memcpy(gd.td.mutex_name[mucount], " \n", BUF_MAX); 
   pthread_mutex_unlock(&name_mutex);
   }


// クライアントのバッファーを上囘った監視が設定された場合の処理
if(sa.buf_err[pd->sb.fdno] == 1){
   errcount++;
   sa.buf_err[pd->sb.fdno] = 0;
   pd->sb.swap_2 = safe_sprintf(pd->sb.swap_2, BUF_MAX,
        "%s,%ld,%ld,%ld,%ld,%ld,%ld,%ld,%s,%s,%s,%s,%d,%d,%s,%s,%s,%s,%s,%s,%s;",
        "INFO",
        u_time(),
        ctime_getr('y'),
        ctime_getr('m'),
        ctime_getr('d'),
        ctime_getr('h'),
        ctime_getr('i'),
        ctime_getr('s'),
        pd->sb.ch_stat,
        "NOT",
        "監視クライアントの設定エラーです",
        gd.bf.c_name,
        0,
        0,
        gd.bf.c_info,
        "このクライアントに対して割り当てられた監視項目がバッファーの行数を上回っています",
        "2",
        "監視項目の数が設定より多いため、後ろのほうが監視してません！ ",
        CL_VAR,
        pd->sb.ch_free3,
        pd->sb.ch_free4);

   #ifdef DATA_BUG
   printf("DATA: scan_block(): バッファーの上限を越えています  %s\n", pd->sb.swap_2);
   #endif

   pd->sb.scan_all = safe_strncat(pd->sb.scan_all, pd->sb.swap_2, BUF_MAX);
   }



// ERR が観測された場合のプロトコルセット
if(mutexid == 0){
   if(gd.bf.break_count == 0 && errcount >= 1){

      if(1 < strlen(pd->sb.scan_all) && (char)0x0a != pd->sb.scan_all[0]){

         pthread_mutex_lock(&mail_mutex);
         if(gd.td.middle_id[mucount] <= 3){
            gd.td.middle_id[mucount]++;
            }
         if(gd.td.middle_id[mucount] == 3){
            gd.td.middle_id[mucount] = 6;
            }

         #ifdef MAIL_MUTEX
         printf("MAIL_MUTEX: scan_block(): エラーを観測しています <%s> mucount<%d> count<%d> co<%d>fd<%d>\n",
             gd.td.middle_name[mucount], mucount, gd.td.middle_id[mucount], co, pd->sb.fdno);
         #endif

         pthread_mutex_unlock(&mail_mutex);

         swap_mem(pd->sb.scan_all, '\n', (char)0x01, strlen(pd->sb.scan_all));

         pd->sb.ch_info = safe_sprintf(pd->sb.ch_info ,BUF_MAX,
           "%s :: COM: ERR DATA: %s\n", gd.bf.c_name, pd->sb.scan_all);

         pthread_mutex_lock(&fd_mutex);
         if((stat = socket_send(pd->sb.ch_info)) > 0){
            pd->sb.swap = select_fdcat(gd.ip.sk, pd->sb.swap, &stat, BUF_MAX);
            }
         if(stat < 0){
            safe_exit("sitar_scan(): socket err exit \n");
            }
         pthread_mutex_unlock(&fd_mutex);

         pd->sb.ch_info = safe_memcpy(pd->sb.ch_info, "\0", BUF_MAX);
         }
      }
   else{
      if(1 < strlen(pd->sb.scan_all) && (char)0x0a != pd->sb.scan_all[0]){

         pthread_mutex_lock(&mail_mutex);
         if(mid_stat == 1){
            if(gd.td.middle_id[mucount] > 1){
               gd.td.middle_id[mucount]--;
               }
            if(gd.td.middle_id[mucount] == 3){
               gd.td.middle_id[mucount] = 0;
               }
            }
         else if(mid_stat == 2){
            gd.td.middle_id[mucount] = 0;
            }
         else{
            if(gd.td.middle_id[mucount] > 1){
               gd.td.middle_id[mucount]--;
               }
            }

         #ifdef MAIL_MUTEX
         printf("MAIL_MUTEX: scan_block(): エラーを観測しませんでした <%s> mucount<%d> count<%d> co<%d>fd<%d>\n",
               gd.td.middle_name[mucount], mucount, gd.td.middle_id[mucount], co, pd->sb.fdno);
         #endif

         pthread_mutex_unlock(&mail_mutex);
         }
      }
   }



#ifdef THREAD_BUG
printf("THREAD: scan_block(): PThread free no<%d> data<%d>\n",
  pd->sb.fdno, gd.td.fdstat[pd->sb.fdno]);   
#endif

#ifdef MUTEX_BUG
printf("MUTEX: scan_block(): 監視ブロックから抜けます  <%s> mucount<%d>\n",
  gd.td.mutex_name[mucount], mucount);
#endif 

#ifdef MALLOC_BUG
printf("MALLOC: scan_block(1): scan_malloc_free(pd): free(pd)\n");
#endif

#ifdef FREE_BUG
printf("FREE: single scan_block(): scan_malloc_free(): pd\n");
#endif

#ifdef MALLOC_BUG
printf("MALLOC: scan_block(2): scan_malloc_free(pd): free(pd)\n");
#endif




gd.td.fdstat[pd->sb.fdno] = 0;
scan_malloc_free(pd);
free(pd);

return 0;
}






char * check_strtol(char * data)
{
char * swap;
int count, count0; 
int cmax = (int)strlen(data);

swap = (char *)calloc((cmax + 35), sizeof(char));

count0 = 0;
for(count = 0; count < cmax; count++){
   switch(data[count]){
      case ',' : 
                 if(count > 0){
                    if(data[count - 1] == ','){
                       swap[count0] = 'N';
                       count0++;
                       swap[count0] = 'O';
                       count0++;
                       swap[count0] = 'T';
                       count0++;
                       swap[count0] = ',';
                       }
                    else{
                       swap[count0] = data[count];
                       }
                    }
                 else{
                    swap[count0] = data[count];
                    }
                 break;
      default  : 
                 swap[count0] = data[count];
                 break;
      }
   count0++;
   }

if(count0 > 0){
   swap[count0] = (char)0x00;
   data = safe_memcpy(data, swap, BUF_MAX);
   }

#ifdef FREE_BUG
printf("FREE: single check_strtol(1): swap %s\n", swap);
#endif
free(swap);

return data;
}




/* ------ SCAN COMAND --------- */
int scan_comand(private_data_t *pd)
{
int ret = -1;

pd->sb.swap = safe_memcpy(pd->sb.swap, pd->sb.ch_com, BUF_MAX);
swap_char(pd->sb.swap);
pd->sb.ch_com = safe_sprintf(pd->sb.ch_com, BUF_MAX,"%s/%s 2>&1", gd.fi.command_path, pd->sb.swap);

#ifdef MYPEXEC_DEBUG
printf("MYPEXEC: scan_comand() %s\n", pd->sb.ch_com);
printf("MYPEXEC: scan_comand() sb.ch_plai = %s\n", pd->sb.ch_plai);
#endif

/* テストモード */
if(0 == memcmp(pd->sb.ch_plai, "4", 1)){
   #ifdef MYPEXEC_DEBUG
   printf("MYPEXEC: scna_comand() コマンド  テストモード\n");
   #endif
   pd->sb.ch_info = execom(pd->sb.ch_com, pd->sb.ch_info, pd->sb.timeout, 1);
   if(1 < strlen(pd->sb.ch_info)){
      #ifdef MYPEXEC_DEBUG
      printf("MYPEXEC: scan_comand() %s 標準出力＆エラー出力 (テストモード) \n", pd->sb.ch_info);
      #endif
      }
   if(1 >= strlen(pd->sb.ch_info)){
      #ifdef MYPEXEC_DEBUG
      printf("MYPEXEC: scan_comand() %s は  正常に終了しました(テストモード) \n", pd->sb.ch_com);
      #endif
      pd->sb.ch_info = safe_memcpy(pd->sb.ch_info, "正常です、実際に閾値を下げてエラーが出るかも確認してください", BUF_MAX );
      } 
   }
/* 通常モード */
else{
   #ifdef MYPEXEC_DEBUG
   printf("MYPEXEC: scan_comand() コマンド  通常モード\n");
   #endif
   pd->sb.ch_info = execom(pd->sb.ch_com, pd->sb.ch_info, pd->sb.timeout, 1);
   if(1 < strlen(pd->sb.ch_info)){
      #ifdef MYPEXEC_DEBUG
      printf("MYPEXEC: scan_comand() %s 標準＆エラー出力 (通常モード) \n", pd->sb.ch_info);
      #endif
      }
   if(1 >= strlen(pd->sb.ch_info)){
      #ifdef MYPEXEC_DEBUG
      printf("MYPEXEC: scan_comand() %s は  正常に終了しました(通常モード) \n", pd->sb.ch_com);
      #endif
      } 
   }

#ifdef MYPEXEC_DEBUG
printf("MYPEXEC: scan_comand() 出力がありました ---> %s --> %d\n", pd->sb.ch_info, (int)strlen(pd->sb.ch_info));
#endif

swap_mem(pd->sb.ch_info, '\n', ' ', strlen(pd->sb.ch_info));
swap_mem(pd->sb.ch_info, '\r', ' ', strlen(pd->sb.ch_info));
swap_mem(pd->sb.ch_info, ',', ' ', strlen(pd->sb.ch_info));

if(1 > (int)strlen(pd->sb.ch_info)){
   pd->sb.check_stat = 0;
   ret = 0;
   #ifdef MYPEXEC_DEBUG
   printf("MYPEXEC: scan_comand() 正常終了\n");
   #endif
   }
else{
   pd->sb.check_stat = 1;
   ret = -1;
   #ifdef MYPEXEC_DEBUG
   printf("MYPEXEC: scan_comand() 異常終了\n");
   #endif
   }

return ret;
}





int swap_char(char * chdata)
{
swap_mem(chdata, ';', ' ', strlen(chdata));
swap_mem(chdata, '|', ' ', strlen(chdata));
swap_mem(chdata, '>', ' ', strlen(chdata));
swap_mem(chdata, '<', ' ', strlen(chdata));

return 0;
}




int my_chmem(char * data1, char * data2)
{
int ret;
int count;
int count1;
int count2;
int count3;
char * cp_data1;
char * cp_data2;
int data1_size = (int)strlen(data1);
int data2_size = (int)strlen(data2);

if((cp_data1 = (char *)calloc((data1_size + 3), sizeof(char)))==NULL){ exit(1);}
if((cp_data2 = (char *)calloc((data2_size + 3), sizeof(char)))==NULL){ exit(1);}

ret = 0;

count1 = 0;
for(count = 0; data1_size > count; count++){
 if(data1[count] != '\n' && data1[count] != ' ' && data1[count] != ';' &&
      data1[count] != (char)0x01 && data1[count] != (char)0x0a){
      cp_data1[count1] = data1[count];
      #ifdef MYCHMEM_DEBUG
      printf("MYCHMEM: my_chmem(): data1 %c", data1[count]);
      #endif
      }
   else{
      count1--;
      }
   count1++;
   }

count1 = 0;
for(count = 0; data2_size > count; count++){
   if(data2[count] != '\n' && data2[count] != ' ' && data1[count] != ';' &&
      data2[count] != (char)0x01 && data2[count] != (char)0x0a){
      cp_data2[count1] = data2[count];
      #ifdef MYCHMEM_DEBUG
      printf("MYCHMEM: my_chmem(): data2 <%c>", data2[count]);
      #endif
      }
   else{
      count1--;
      }
   count1++;
   }

count2 = (int)strlen(cp_data1);
count3 = (int)strlen(cp_data2);

if(count2 == count3 && count2 > 1){
   for(count = 0; count < count2; count++){
      if(cp_data1[count] != cp_data2[count]){
         ret = -1;
         }
      #ifdef MYCHMEM_DEBUG
      printf("MYCHMEM: my_chmem(): A=%c, B=%c, STAT=%d\n", cp_data1[count], cp_data2[count], ret);
      #endif
      } 
   }
else{
   ret = -1;
   #ifdef MYCHMEM_DEBUG
   printf("MYCHMEM: my_chmem(): count2 != count3 RET=%d\n", ret);
   #endif
   }

#ifdef MYCHMEM_DEBUG
printf("MYCHMEM: my_chmem(): <%s>\n\n <%s> <%d>\n", cp_data1, cp_data2, ret);
#endif

#ifdef FREE_BUG
printf("FREE: single my_chmem(1): cp_data %s\n", cp_data1);
printf("FREE: single my_chmem(1): cp_data2 %s\n", cp_data2);
#endif
free(cp_data1);
free(cp_data2);

return(ret);
}




int get_comconf(char * bat_filename, char * senddata)
{
int stat;
FILE * fp;
int fd;

gd.bf.rec = (char *)calloc(IP_LEN, sizeof(char));
gd.bf.recdata = (char *)calloc(IP_LEN, sizeof(char));
gd.bf.intr = (char *)calloc(IP_LEN, sizeof(char));

gd.bf.intr = safe_sprintf(gd.bf.intr, BUF_MAX, "%s :: COM: BAT DATA: %s\n", gd.bf.c_name, senddata);

pthread_mutex_lock(&fd_mutex);
if((stat = socket_send(gd.bf.intr)) > 0){
   gd.bf.rec = select_fdcat(gd.ip.sk, gd.bf.rec, &stat, BUF_MAX);
   }
if(stat < 0){
   safe_exit("get_comconf(): socket err exit \n");
   }
pthread_mutex_unlock(&fd_mutex);

#ifdef GETCOM_DEBUG
printf("GETCOM: get_comconf(1): %s\n", gd.bf.rec);
#endif

swap_mem(gd.bf.rec, ';', '\n', (int)strlen(gd.bf.rec));

if(0 != (memcmp(gd.bf.rec, "500 NG", 6))){
   if((fp = fopen(bat_filename, "w+"))!=NULL){
      fprintf(fp,"%s",gd.bf.rec);
      fclose(fp);
      }
   else {
      fprintf(stderr, "get_comconf(): comand or list file not write. %s\n", bat_filename);
      }
   }
else {
   fprintf(stderr,"get_comconf(): server side comand or list file not open.\n");
   if((fp = fopen(bat_filename, "r"))!=NULL){
      fd = fileno(fp);

      gd.bf.rec = safe_filefdcat(fd, gd.bf.rec, &stat, BUF_MAX, (gd.bf.life_int + gd.bf.life_los));

      swap_mem(gd.bf.rec, '\n', ';', (int)strlen(gd.bf.rec));

      if(0 == (memcmp(senddata, "COMAND", 6))){
         gd.bf.intr = safe_sprintf(gd.bf.intr, BUF_MAX,
           "%s :: COM: PUT DATA: COMAND:%s\n", gd.bf.c_name, gd.bf.rec);
         }
      if(0 == (memcmp(senddata, "PORT", 4))){
         gd.bf.intr = safe_sprintf(gd.bf.intr, BUF_MAX,
           "%s :: COM: PUT DATA: PORT:%s\n", gd.bf.c_name, gd.bf.rec);
         }

      if(1 < (int)strlen(gd.bf.rec)){
         pthread_mutex_lock(&fd_mutex);
         if((stat = socket_send(gd.bf.intr)) > 0){
            gd.bf.recdata = select_fdcat(gd.ip.sk, gd.bf.recdata, &stat, BUF_MAX);
            }
         if(stat < 0){
            safe_exit("get_comconf(): socket err exit \n");
            }
         pthread_mutex_unlock(&fd_mutex);
         }

      #ifdef GETCOM_DEBUG
      printf("GETCOM: get_comconf(2): %s\n", gd.bf.recdata);
      #endif

      fclose(fp);
      }
   else{
      fprintf(stderr,"get_comconf(): client side comand file not open.\n");
      }
   }

#ifdef FREE_BUG
printf("FREE: single get_comconf(): gd.bf.rec %s\n", gd.bf.rec);
printf("FREE: single get_comconf(): gd.bf.recdata %s\n", gd.bf.recdata);
printf("FREE: single get_comconf(): gd.bf.intr %s\n", gd.bf.intr);
#endif
free(gd.bf.rec);
free(gd.bf.recdata);
free(gd.bf.intr);

return 0;
}




int get_configfile(char * bat_filename, char * senddata)
{
int stat = 0;
int fd;
int check;
FILE * fp;
// char * myfile;

check = 0;

gd.bf.rec = (char *)calloc(IP_LEN, sizeof(char));
gd.bf.recdata = (char *)calloc(IP_LEN, sizeof(char));
gd.bf.intr = (char *)calloc(IP_LEN, sizeof(char));

gd.bf.intr = safe_sprintf(gd.bf.intr, BUF_MAX, "%s :: COM: BAT DATA: %s\n", gd.bf.c_name, senddata);

pthread_mutex_lock(&fd_mutex);
if((stat = socket_send(gd.bf.intr)) > 0){
   gd.bf.rec = select_fdcat(gd.ip.sk, gd.bf.rec, &stat, BUF_MAX); 
   }
if(stat < 0){
   safe_exit("get_configfile(): socket err exit \n");
   }
pthread_mutex_unlock(&fd_mutex);

#ifdef CONFIGFILE_DEBUG
printf("CONFIGFILE: get_configfile():  %s %s\n", gd.bf.rec, bat_filename);
#endif

if(0 != (memcmp(gd.bf.rec, "500 NG", 6))){
   if((fp = fopen(bat_filename, "r"))!=NULL){
      fd = fileno(fp);
      gd.bf.myfile = safe_filefdcat(fd, gd.bf.myfile, &stat, BUF_MAX, (gd.bf.life_int + gd.bf.life_los));
      swap_mem(gd.bf.myfile, '\n', ';', (int)strlen(gd.bf.myfile));
      fclose(fp);
      #ifdef CONFIGFILE_DEBUG
      printf("CONFIGFILE: get_configfile():  %s\n", gd.bf.myfile);
      #endif
      }
   if((check = (my_chmem(gd.bf.myfile, gd.bf.rec))) != 0){
      if((fp = fopen(bat_filename, "w+"))!=NULL){
         swap_mem(gd.bf.rec, ';', '\n', (int)strlen(gd.bf.rec));
         fprintf(fp,"%s",gd.bf.rec);
         fclose(fp);
         #ifdef OCNFIGFILE_DEBUG
         printf("CONFIGFILE: get_configfile():  %s\n", gd.bf.rec);
         #endif
         safe_exit("get_configfile(): config file was edited. \n"); /* It ends. */
         }
      else {
         fprintf(stderr,"get_configfile(): config file not write. %s\n", bat_filename);
         }
      }
   else{
      #ifdef CONFIGFILE_DEBUG
      printf("CONFIGFILE: get_configfile(): %d\n", check);
      #endif
      }
   }

else {
   fprintf(stderr,"server side config file not open.\n");
   if((fp = fopen(gd.fi.conf_path, "r"))!=NULL){
      fd = fileno(fp);
      gd.bf.rec = safe_filefdcat(fd, gd.bf.rec, &stat, BUF_MAX, (gd.bf.life_int + gd.bf.life_los));

      swap_mem(gd.bf.rec, '\n', ';', (int)strlen(gd.bf.rec));

      gd.bf.intr = safe_sprintf(gd.bf.intr, BUF_MAX,
        "%s :: COM: PUT DATA: CONF:%s\n", gd.bf.c_name, gd.bf.rec);

      if(1 < (int)strlen(gd.bf.rec)){
         pthread_mutex_lock(&fd_mutex);
         if((stat = socket_send(gd.bf.intr)) > 0){
            gd.bf.recdata = select_fdcat(gd.ip.sk, gd.bf.recdata, &stat, BUF_MAX); 
            }
         if(stat < 0){
            safe_exit("get_configfile(2): socket err exit \n");
            }
         pthread_mutex_unlock(&fd_mutex);

         }

      #ifdef CONFIGFILE_DEBUG
      printf("CONFIGFILE: get_configfile(): %s\n", gd.bf.recdata);
      #endif

      fclose(fp);
      }
   else{
      fprintf(stderr,"get_configfile(): client side config file not open.\n");
      }
   }

#ifdef FREE_BUG
printf("FREE: single get_configfile(): gd.bf.rec %s\n", gd.bf.rec);
printf("FREE: single get_configfile(): gd.bf.recdata %s\n", gd.bf.recdata);
printf("FREE: single get_configfile(): gd.bf.intr %s\n", gd.bf.intr);
#endif
free(gd.bf.rec);
free(gd.bf.recdata);
free(gd.bf.intr);

return 0;
}




int get_statfile(char * senddata)
{
FILE * fp;
int pid, stat;

statfile_malloc();

gd.bf.intr = safe_sprintf(gd.bf.intr, BUF_MAX,"%s :: COM: BAT DATA: %s\n", gd.bf.c_name, senddata);

pthread_mutex_lock(&fd_mutex);
if((stat = socket_send(gd.bf.intr)) > 0){
   gd.bf.rec = select_fdcat(gd.ip.sk, gd.bf.rec, &stat, BUF_MAX);
   }
if(stat < 0){
   safe_exit("get_statfile(): socket err exit \n");
   }
pthread_mutex_unlock(&fd_mutex);

swap_mem(gd.bf.rec, ';', (char)0x00, strlen(gd.bf.rec));

#ifdef STATFILE_DEBUG
printf("STATFILE: get_statfile(): %s\n", gd.bf.rec);
#endif

if(0 != (memcmp(gd.bf.rec, "500 NG", 6))){

   if(gd.bf.stop_count > 0){
      if(0 == (memcmp("KILL", gd.bf.rec, 4))){
         if((fp = fopen(sitarpid, "r"))!=NULL){
             gd.bf.recs = safe_fpcat(fp, gd.bf.recs, &stat, BUF_LEN);
             if(stat != -1){
                #ifdef STATFILE_DEBUG
                printf("STATFILE: get_statfile(): startctlpid->%s\n",gd.bf.recs);
                #endif
                pid = strtol(gd.bf.recs, (char **)NULL, 10);
                if(! kill(pid, SIGKILL)){
                   fprintf(stderr,"get_statfile(): killd 'sitarctl'.. PID = %d\n", pid);
                   } 
                else{
                   fprintf(stderr,"get_statfile(): not killd 'sitarctl'.. PID = %d\n", pid);
                   } 
                fclose(fp);
                }
             else{
                fprintf(stderr,"get_statfile(): It is not possible to read normally. <%s>\n", sitarpid);
                safe_exit("2 get_statfile(): exit\n"); /* It ends. */
                }
            }
         else{
            fprintf(stderr,"get_statfile(): pid file not open. %s\n", sitarpid);
            safe_exit("3 get_statfile(): exit\n"); /* It ends. */
            }
         safe_exit("get_statfile(): Cease and desist order \n"); /* It ends. */
         #ifdef FREE_BUG
         printf("FREE: get_statfile(): statfile_free(1): \n");
         #endif
         statfile_free();
         return 0;
         }

      if(0 == (memcmp("RESTART", gd.bf.rec, 7))){
         fprintf(stderr,"get_statfile(): Get RESTART stat. \n");
         safe_exit("get_statfile(): Reactivation instruction. \n"); /* It ends. */
         #ifdef FREE_BUG
         printf("FREE: get_statfile(): statfile_free(2): \n");
         #endif
         statfile_free();
         return 0;
         }
      if(0 == (memcmp("UPDATE", gd.bf.rec, 6))){
         fprintf(stderr,"get_statfile(): Get UPDATE stat. \n");
         gd.bf.rec = execom(gd.fi.update_com, gd.bf.rec, 30, 1);
         fprintf(stderr, "%s\n", gd.bf.rec);
         safe_exit("get_statfile(): reactivates for update. \n"); /* It ends. */
         #ifdef FREE_BUG
         printf("FREE: get_statfile(): statfile_free(3): \n");
         #endif
         statfile_free();
         return 0;
         }
      }

   if(0 == (memcmp("STOP", gd.bf.rec, 4))){
      #ifdef STATFILE_DEBUG
      printf("STATFILE: get_statfile(): STAT %s\n", gd.bf.rec);
      #endif
      fprintf(stderr,"get_statfile(): Get STOP stat. \n");
      #ifdef FREE_BUG
      printf("FREE: get_statfile(): statfile_free(4): \n");
      #endif
      statfile_free();
      gd.bf.break_count = 1;
      gd.bf.stop_count = 1;
      return 0;
      }
   if(0 == (memcmp("START", gd.bf.rec, 5))){
      #ifdef STATFILE_DEBUG
      printf("STATFILE: get_statfile():  ********** STAT %s ************ \n", gd.bf.rec);
      #endif
      fprintf(stderr,"get_statfile(): Get START stat. \n");
      #ifdef FREE_BUG
      printf("FREE: get_statfile(): statfile_free(5): \n");
      #endif
      statfile_free();

      gd.bf.break_count = 0;
      gd.bf.stop_count = 1;
      return 0;
      }
   }

else {
   fprintf(stderr,"get_statfile(): server side stat file not open.\n");

   gd.bf.intr = safe_sprintf(gd.bf.intr, BUF_MAX,
     "%s :: COM: PUT DATA: STAT:%s\n", gd.bf.c_name, "START");

   if(1 < (int)strlen(gd.bf.rec)){
      pthread_mutex_lock(&fd_mutex);
      if((stat = socket_send(gd.bf.intr)) > 0){
         gd.bf.recdata = select_fdcat(gd.ip.sk, gd.bf.recdata, &stat, BUF_MAX); 
         }
      if(stat < 0){
         safe_exit("get_statfile(2): socket err exit \n");
         }
      pthread_mutex_unlock(&fd_mutex);
      }

   #ifdef STATFILE_DEBUG
   printf("get_statfile(): %s\n", gd.bf.recdata);
   #endif
   }

#ifdef FREE_BUG
printf("FREE: get_statfile(): statfile_free(6): \n");
#endif
statfile_free();

gd.bf.stop_count = 1;
return 0;
} 





int setup_conf(void)
{
int stat;

stat = 0;

gd.bf.rec = (char *)calloc(IP_LEN, sizeof(char));
gd.bf.recs = (char *)calloc(IP_LEN, sizeof(char));
gd.bf.recdata = (char *)calloc(IP_LEN, sizeof(char));
gd.bf.intr = (char *)calloc(IP_LEN, sizeof(char));

// LIFE INT 
if(gd.bf.life_int != 0){
   gd.bf.intr = safe_sprintf(gd.bf.intr, BUF_MAX,"%s :: COM: SET DATA: LIFE_INT:%d\n", gd.bf.c_name, gd.bf.life_int);
   #ifdef SET_DEBUG 
   printf("SET: setup_conf(): %s :: COM: SET DATA: LIFE_INT:%d\n", gd.bf.c_name, gd.bf.life_int);
   #endif
   pthread_mutex_lock(&fd_mutex);
   if((stat = socket_send(gd.bf.intr)) > 0){
      gd.bf.recdata = select_fdcat(gd.ip.sk, gd.bf.recdata, &stat, BUF_MAX);
      }
   if(stat < 0){
      safe_exit("setup_conf(): socket err exit \n");
      }
   pthread_mutex_unlock(&fd_mutex);

   }
else{
   fprintf(stderr,"setup_conf(): set data err LIFE_INT\n");
   }

// LIFE LOSS
if(gd.bf.life_los != 0){
   gd.bf.rec = safe_sprintf(gd.bf.rec,BUF_MAX,"%s :: COM: SET DATA: LIFE_LOS:%d\n",gd.bf.c_name,gd.bf.life_los);
   #ifdef SET_DEBUG 
   printf("SET: setup_conf() %s :: COM: SET DATA: LIFE_LOS:%d\n", gd.bf.c_name, gd.bf.life_los);
   #endif
   pthread_mutex_lock(&fd_mutex);
   if((stat = socket_send(gd.bf.rec)) > 0){
      gd.bf.recdata = select_fdcat(gd.ip.sk, gd.bf.recdata, &stat, BUF_MAX);
      }
   if(stat < 0){
      safe_exit("setup_conf(2): socket err exit \n");
      }
   pthread_mutex_unlock(&fd_mutex);

   }
else{
   fprintf(stderr,"setup_conf(): set data err LIFE_LOS\n");
   }

// LIFE ONOFF
if(gd.ld.onoff == 0){
   gd.bf.rec = safe_sprintf(gd.bf.rec,BUF_MAX,"%s :: COM: SET DATA: LIFE_ONOFF:%d\n",
     gd.bf.c_name, gd.ld.onoff);
   #ifdef SET_DEBUG 
   printf("SET: setup_conf() %s :: COM: SET DATA: LIFE_ONOFF:%d\n",
      gd.bf.c_name, gd.ld.onoff);
   #endif
   pthread_mutex_lock(&fd_mutex);
   if((stat = socket_send(gd.bf.rec)) > 0){
      gd.bf.recdata = select_fdcat(gd.ip.sk, gd.bf.recdata, &stat, BUF_MAX);
      }
   if(stat < 0){
      safe_exit("setup_conf(2): socket err exit \n");
      }
   pthread_mutex_unlock(&fd_mutex);

   }
else{
   fprintf(stderr,"setup_conf(): set data err LIFE_ONOFF\n");
   }

// MAIL CC
if(0 != strlen(gd.smtp.ch_MailCc)){
   if(0 != memcmp(gd.smtp.ch_MailCc, "NOT", 3)){
      gd.bf.recs = safe_sprintf(gd.bf.recs,BUF_MAX,"%s :: COM: SET DATA: MAIL_CC:%s\n",
        gd.bf.c_name, gd.smtp.ch_MailCc);
      #ifdef SET_DEBUG 
      printf("SET: setup_conf(): %s :: COM: SET DATA: MAIL_CC:%s\n", gd.bf.c_name, gd.smtp.ch_MailCc);
      #endif
      pthread_mutex_lock(&fd_mutex);
      if((stat = socket_send(gd.bf.recs)) > 0){
         gd.bf.recdata = select_fdcat(gd.ip.sk, gd.bf.recdata, &stat, BUF_MAX);
         }
      if(stat < 0){
         safe_exit("setup_conf(3): socket err exit \n");
         }
      pthread_mutex_unlock(&fd_mutex);
      }
   }

else{
   fprintf(stderr,"setup_conf(): set data err MAIL_CC\n");
   }

#ifdef FREE_BUG
printf("FREE: setup_conf(): statfile_free(1): \n");
#endif
statfile_free();

return 0;
}




int start_neg(void)
{
int stat;

stat = 0;

gd.bf.recdata = (char *)calloc(IP_LEN, sizeof(char));
gd.bf.intr = (char *)calloc(IP_LEN, sizeof(char));

gd.bf.intr = safe_sprintf(gd.bf.intr, BUF_MAX, "%s :: COM: NEG DATA: %s,%s\n", gd.bf.c_name, CL_VAR, gd.bf.c_info);

pthread_mutex_lock(&fd_mutex);
if((stat = socket_send(gd.bf.intr)) > 0){
   gd.bf.recdata = select_fdcat(gd.ip.sk, gd.bf.recdata, &stat, BUF_MAX);
   }
if(stat < 0){
   safe_exit("start_neg(): socket err exit \n");
   }
pthread_mutex_unlock(&fd_mutex);

if(0 == memcmp(gd.bf.recdata, "500 NG", 6)){
   fprintf(stderr,"start_neg(): youer name is %s not login, check neg.conf\n", gd.bf.c_name);
   safe_exit("2 start_neg() exit \n"); /* It ends. */
   }
else{
   fprintf(stderr,"start_neg(): youer name is %s login OK!\n", gd.bf.c_name);
   }

#ifdef FREE_BUG
printf("FREE: single stat_neg(): gd.bf.recdata %s\n", gd.bf.recdata);
printf("FREE: single stat_neg(): gd.bf.intr %s\n", gd.bf.intr);
#endif
free(gd.bf.recdata);
free(gd.bf.intr);

return 0;
}




int life_put(void)
{
int stat;

stat = 0;

gd.ld.life_data = (char *)calloc(IP_LEN, sizeof(char));
gd.ld.rec = (char *)calloc(IP_LEN, sizeof(char));

gd.ld.life_data = safe_sprintf(gd.ld.life_data, BUF_MAX, "%s :: COM: LIFE DATA: --\n", gd.bf.c_name);

pthread_mutex_lock(&fd_mutex);
if((stat = socket_send(gd.ld.life_data)) > 0){
   gd.ld.rec = select_fdcat(gd.ip.sk, gd.ld.rec, &stat, BUF_MAX);
   #ifdef LIFE_DEBUG
   printf("LIFE: life_put(): LIFE SEND> %s\n", gd.ld.life_data);
   printf("LIFE: life_put(): LIFE GET> %s\n", gd.ld.rec);
   #endif
   }
if(stat < 0){
   safe_exit("life_put(): socket err exit \n");
   }
pthread_mutex_unlock(&fd_mutex);

if(0 == memcmp(gd.ld.rec, "CHECK_BAT_SCA_CONF_STAT ", 24)){

      pthread_mutex_lock(&file2_mutex);
      get_comconf(gd.fi.bat_filename, "COMAND");
      pthread_mutex_unlock(&file2_mutex);

      pthread_mutex_lock(&file1_mutex);
      get_comconf(gd.fi.bat2_filename, "PORT");
      pthread_mutex_unlock(&file1_mutex);

      get_configfile(gd.fi.conf_path, "CONFIG");
      get_statfile("STAT");
      #ifdef FREE_BUG
      printf("FREE: single life_put(1): gd.ld.life_data %s\n", gd.ld.life_data);
      printf("FREE: single life_put(1): gd.ld.rec %s\n", gd.ld.rec);
      #endif
      free(gd.ld.life_data);
      free(gd.ld.rec);
      return 0;
      }

else if(0 == memcmp(gd.ld.rec, "CHECK_BAT_CONF_STAT ", 20)){

      pthread_mutex_lock(&file2_mutex);
      get_comconf(gd.fi.bat_filename, "COMAND");
      pthread_mutex_unlock(&file2_mutex);

      get_configfile(gd.fi.conf_path, "CONFIG");
      get_statfile("STAT");
      #ifdef FREE_BUG
      printf("FREE: single life_put(2): gd.ld.life_data %s\n", gd.ld.life_data);
      printf("FREE: single life_put(2): gd.ld.rec %s\n", gd.ld.rec);
      #endif
      free(gd.ld.life_data);
      free(gd.ld.rec);
      return 0;
      }

else if(0 == memcmp(gd.ld.rec, "CHECK_SCA_CONF_STAT ", 20)){

      pthread_mutex_lock(&file1_mutex);
      get_comconf(gd.fi.bat2_filename, "PORT");
      pthread_mutex_unlock(&file1_mutex);

      get_configfile(gd.fi.conf_path, "CONFIG");
      get_statfile("STAT");
      #ifdef FREE_BUG
      printf("FREE: single life_put(3): gd.ld.life_data %s\n", gd.ld.life_data);
      printf("FREE: single life_put(3): gd.ld.rec %s\n", gd.ld.rec);
      #endif
      free(gd.ld.life_data);
      free(gd.ld.rec);
      return 0;
      }

else if(0 == memcmp(gd.ld.rec, "CHECK_BAT_SCA_CONF ", 19)){

      pthread_mutex_lock(&file2_mutex);
      get_comconf(gd.fi.bat_filename, "COMAND");
      pthread_mutex_unlock(&file2_mutex);

      pthread_mutex_lock(&file1_mutex);
      get_comconf(gd.fi.bat2_filename, "PORT");
      pthread_mutex_unlock(&file1_mutex);

      get_configfile(gd.fi.conf_path, "CONFIG");
      #ifdef FREE_BUG
      printf("FREE: single life_put(4): gd.ld.life_data %s\n", gd.ld.life_data);
      printf("FREE: single life_put(4): gd.ld.rec %s\n", gd.ld.rec);
      #endif
      free(gd.ld.life_data);
      free(gd.ld.rec);
      return 0;
      }

else if(0 == memcmp(gd.ld.rec, "CHECK_BAT_SCA_STAT ", 19)){

      pthread_mutex_lock(&file2_mutex);
      get_comconf(gd.fi.bat_filename, "COMAND");
      pthread_mutex_unlock(&file2_mutex);

      pthread_mutex_lock(&file1_mutex);
      get_comconf(gd.fi.bat2_filename, "PORT");
      pthread_mutex_unlock(&file1_mutex);

      get_statfile("STAT");
      #ifdef FREE_BUG
      printf("FREE: single life_put(5): gd.ld.life_data %s\n", gd.ld.life_data);
      printf("FREE: single life_put(5): gd.ld.rec %s\n", gd.ld.rec);
      #endif
      free(gd.ld.life_data);
      free(gd.ld.rec);
      return 0;
      }

else if(0 == memcmp(gd.ld.rec, "CHECK_CONF_STAT ", 16)){

      get_configfile(gd.fi.conf_path, "CONFIG");
      get_statfile("STAT");
      #ifdef FREE_BUG
      printf("FREE: single life_put(6): gd.ld.life_data %s\n", gd.ld.life_data);
      printf("FREE: single life_put(6): gd.ld.rec %s\n", gd.ld.rec);
      #endif
      free(gd.ld.life_data);
      free(gd.ld.rec);
      return 0;
      }

else if(0 == memcmp(gd.ld.rec, "CHECK_SCA_CONF ", 15)){

      pthread_mutex_lock(&file1_mutex);
      get_comconf(gd.fi.bat2_filename, "PORT");
      pthread_mutex_unlock(&file1_mutex);

      get_configfile(gd.fi.conf_path, "CONFIG");
      #ifdef FREE_BUG
      printf("FREE: single life_put(7): gd.ld.life_data %s\n", gd.ld.life_data);
      printf("FREE: single life_put(7): gd.ld.rec %s\n", gd.ld.rec);
      #endif
      free(gd.ld.life_data);
      free(gd.ld.rec);
      return 0;
      }

else if(0 == memcmp(gd.ld.rec, "CHECK_BAT_CONF ", 15)){

      pthread_mutex_lock(&file2_mutex);
      get_comconf(gd.fi.bat_filename, "COMAND");
      pthread_mutex_unlock(&file2_mutex);

      get_configfile(gd.fi.conf_path, "CONFIG");
      #ifdef FREE_BUG
      printf("FREE: single life_put(8): gd.ld.life_data %s\n", gd.ld.life_data);
      printf("FREE: single life_put(8): gd.ld.rec %s\n", gd.ld.rec);
      #endif
      free(gd.ld.life_data);
      free(gd.ld.rec);
      return 0;
      }

else if(0 == memcmp(gd.ld.rec, "CHECK_BAT_STAT ", 15)){

      pthread_mutex_lock(&file2_mutex);
      get_comconf(gd.fi.bat_filename, "COMAND");
      pthread_mutex_unlock(&file2_mutex);

      get_statfile("STAT");
      #ifdef FREE_BUG
      printf("FREE: single life_put(9): gd.ld.life_data %s\n", gd.ld.life_data);
      printf("FREE: single life_put(9): gd.ld.rec %s\n", gd.ld.rec);
      #endif
      free(gd.ld.life_data);
      free(gd.ld.rec);
      return 0;
      }

else if(0 == memcmp(gd.ld.rec, "CHECK_SCA_STAT ", 15)){

      pthread_mutex_lock(&file1_mutex);
      get_comconf(gd.fi.bat2_filename, "PORT");
      pthread_mutex_unlock(&file1_mutex);

      get_statfile("STAT");
      #ifdef FREE_BUG
      printf("FREE: single life_put(10): gd.ld.life_data %s\n", gd.ld.life_data);
      printf("FREE: single life_put(10): gd.ld.rec %s\n", gd.ld.rec);
      #endif
      free(gd.ld.life_data);
      free(gd.ld.rec);
      return 0;
      }

else if(0 == memcmp(gd.ld.rec, "CHECK_BAT_SCA ", 14)){

      pthread_mutex_lock(&file2_mutex);
      get_comconf(gd.fi.bat_filename, "COMAND");
      pthread_mutex_unlock(&file2_mutex);

      pthread_mutex_lock(&file1_mutex);
      get_comconf(gd.fi.bat2_filename, "PORT");
      pthread_mutex_unlock(&file1_mutex);

      #ifdef FREE_BUG
      printf("FREE: single life_put(11): gd.ld.life_data %s\n", gd.ld.life_data);
      printf("FREE: single life_put(11): gd.ld.rec %s\n", gd.ld.rec);
      #endif
      free(gd.ld.life_data);
      free(gd.ld.rec);
      return 0;
      }

else if(0 == memcmp(gd.ld.rec, "CHECK_SCA ", 10)){

      pthread_mutex_lock(&file1_mutex);
      get_comconf(gd.fi.bat2_filename, "PORT");
      pthread_mutex_unlock(&file1_mutex);

      #ifdef FREE_BUG
      printf("FREE: single life_put(12): gd.ld.life_data %s\n", gd.ld.life_data);
      printf("FREE: single life_put(12): gd.ld.rec %s\n", gd.ld.rec);
      #endif
      free(gd.ld.life_data);
      free(gd.ld.rec);
      return 0;
      }

else if(0 == memcmp(gd.ld.rec, "CHECK_CONF ", 11)){
      get_configfile(gd.fi.conf_path, "CONFIG");
      #ifdef FREE_BUG
      printf("FREE: single life_put(13): gd.ld.life_data %s\n", gd.ld.life_data);
      printf("FREE: single life_put(13): gd.ld.rec %s\n", gd.ld.rec);
      #endif
      free(gd.ld.life_data);
      free(gd.ld.rec);
      return 0;
      }

else if(0 == memcmp(gd.ld.rec, "CHECK_STAT ", 11)){
      get_statfile("STAT");
      #ifdef FREE_BUG
      printf("FREE: single life_put(14): gd.ld.life_data %s\n", gd.ld.life_data);
      printf("FREE: single life_put(14): gd.ld.rec %s\n", gd.ld.rec);
      #endif
      free(gd.ld.life_data);
      free(gd.ld.rec);
      return 0;
      }

else if(0 == memcmp(gd.ld.rec, "CHECK_BAT ", 10)){

      pthread_mutex_lock(&file2_mutex);
      get_comconf(gd.fi.bat_filename, "COMAND");
      pthread_mutex_unlock(&file2_mutex);

      #ifdef FREE_BUG
      printf("FREE: single life_put(15): gd.ld.life_data %s\n", gd.ld.life_data);
      printf("FREE: single life_put(15): gd.ld.rec %s\n", gd.ld.rec);
      #endif
      free(gd.ld.life_data);
      free(gd.ld.rec);
      return 0;
      }

else {
      #ifdef FREE_BUG
      printf("FREE: single life_put(16): gd.ld.life_data %s\n", gd.ld.life_data);
      printf("FREE: single life_put(16): gd.ld.rec %s\n", gd.ld.rec);
      #endif
      free(gd.ld.life_data);
      free(gd.ld.rec);
      return 0;
      }

// Not reachable

#ifdef FREE_BUG
printf("FREE: single life_put(17): gd.ld.life_data %s\n", gd.ld.life_data);
printf("FREE: single life_put(17): gd.ld.rec %s\n", gd.ld.rec);
#endif
free(gd.ld.life_data);
free(gd.ld.rec);

return 0;
}




int safe_exit(char * data) 
{
fprintf(stderr,"safe_exit(): *** Procces killd pgid=%d\n",gd.bf.my_pid);
fprintf(stderr,"safe_exit(): %s\n", data);

if(kill((gd.bf.my_pid * -1), SIGKILL)){
   fprintf(stderr,"safe_exit(): child process not killd GPID = %d\n", (gd.bf.my_pid * -1));
   fprintf(stderr,"safe_exit(): Please execute the following commands. \n");
   fprintf(stderr,"safe_exit(): # kill SIGKILL %d <enter>\n", (gd.bf.my_pid * -1));
   fprintf(stderr,"safe_exit(): or,\n");
   fprintf(stderr,"safe_exit(): # killall sitarctl; killall sitar_com; killall sitar_scan <enter>\n");
   } 

return(0);
}





