// tcp.c
// $Id: tcp.c,v 1.2 2007/05/08 09:06:50 cvs Exp $
// masashi shimakura

#include<stdio.h>
#include<unistd.h>
#include<fcntl.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<arpa/inet.h>
#include<stdlib.h>
#include<string.h>
#include<errno.h>
#include<pthread.h>

#include "sitar.h"
#include"almemsys.h"

struct sockaddr_in my_addr;

extern global_data_t gd;

/*
int socket_bind(int, char []);
int socket_connect(int, char []);
int socket_accept(void);
int socket_send(char []);
char * select_fdcat(int sk, char * getdata, int * ret, int max);
*/




/*------------------ BIND ----------------------*/
int socket_bind(int port, char ip_addr[])
{
if((gd.ip.ls = socket(AF_INET, SOCK_STREAM, 0))==-1){
   fprintf(stderr,"socket_bind(1): Not cleate socket \n");
   safe_exit("socket_bind(): socket exit \n");
   }

my_addr.sin_family = AF_INET;
my_addr.sin_port = htons(port);
my_addr.sin_addr.s_addr = inet_addr(ip_addr);

if(bind(gd.ip.ls, (struct sockaddr *)(int)&my_addr, sizeof(my_addr)) == -1){
   fprintf(stderr,"socket_bind(2): Not bind addrses\n");
   close(gd.ip.ls);
   safe_exit("socket_bind(): bind exit \n");
   }

if((listen(gd.ip.ls,1))==-1){
   fprintf(stderr,"socket_bind(3): Not listen port\n");
   close(gd.ip.ls);
   safe_exit("socket_bind(): listn exit \n");
   }
return 0;
}



/*----------------------- CONNECT --------------------*/
int socket_connect(int port, char ip_addr[])
{
int ret;

ret = 0;
if((gd.ip.sk = socket(AF_INET, SOCK_STREAM, 0))==-1){
   fprintf(stderr,"socket_connect(): Not cleate socket\n");
   ret = -1;
   return(ret); 
   }

my_addr.sin_family = AF_INET;
my_addr.sin_port = htons(port);
my_addr.sin_addr.s_addr = inet_addr(ip_addr);

if(connect(gd.ip.sk, (struct sockaddr *)(int)&my_addr, sizeof(my_addr)) == -1){
   fprintf(stderr,"socket_connect(): Not connection\n");
   close(gd.ip.sk);
   ret = -1;
   return(ret); 
   }

return(ret);
}




/*--------------------- ACCEPT -------------------*/
int socket_accept(void)
{
gd.ip.my_addrlen = sizeof(my_addr);
if((gd.ip.sk=accept(gd.ip.ls, (struct sockaddr *)(int)&my_addr, &gd.ip.my_addrlen)) == -1){
   fprintf(stderr,"socket_sccept(): Not scception\n");
   safe_exit("socket_accept() exit \n");
   close(gd.ip.ls);
   }
return 0;
}






/*--------------------- SEND ------------------------- */
int socket_send(char * senddata){
int ret;
struct timeval tv;
int retval, interval;
fd_set rfds;
interval = (gd.bf.life_int + gd.bf.life_los + INT_PLUS);

fcntl(gd.ip.sk, F_SETFL, O_NONBLOCK);
tv.tv_sec = interval;
tv.tv_usec = 0;

#ifdef SOCKET_BUG
printf("SOCKET: socket_send(1): interval time set %d\n", interval);
#endif

ret = 0;

ret = send(gd.ip.sk, senddata, (int)strlen(senddata), 0);

while(1){
   FD_ZERO(&rfds);
   FD_SET(gd.ip.sk, &rfds);
   retval = select(gd.ip.sk + 1, &rfds, NULL, NULL, &tv);
   if(retval < 0){
      #ifdef SOCKET_BUG
      printf("SOCKET: socket_send(2): NG select <%d> ERRNO: %d %s\n",
        retval, errno, strerror(errno));
      #endif
      ret = -1;
      break;
      }
   if(retval == 0){
      #ifdef SOCKET_BUG
      printf("SOCKET: socket_send(3): NG select <%d> ERRNO: %d %s\n",
        retval, errno, strerror(errno));
      #endif
      ret = -1;
      break;
      }
   if(retval >= 1){
      #ifdef SOCKET_BUG
      printf("SOCKET: socket_send(4): NG select <%d> ERRNO: %d %s\n",
        retval, errno, strerror(errno));
      #endif
      break;
      }
   } /* while */


fcntl(gd.ip.sk, F_SETFL, 0);

return(ret);
}




char * select_fdcat(int sk, char * getdata, int * ret, int max)
{
struct timeval tv;
int retval;
fd_set rfds;

fcntl(sk, F_SETFL, O_NONBLOCK);
tv.tv_sec = (gd.bf.life_int + gd.bf.life_los + INT_PLUS);
tv.tv_usec = 0;

* ret = 0;

while(1){
   FD_ZERO(&rfds);
   FD_SET(sk, &rfds);
   retval = select(sk + 1, &rfds, NULL, NULL, &tv);
   if(retval < 0){
      fcntl(sk, F_SETFL, 0);
      #ifdef SOCKET_BUG
      printf("SOCKET: select_fdcat(1): NG select <%d>\n", retval);
      #endif
      * ret = -1;
      break;
      }
   if(retval == 0){
      fcntl(sk, F_SETFL, 0);
      #ifdef SOCKET_BUG
      printf("SOCKET: select_fdcat(2): NG select <%d>\n", retval);
      #endif
      * ret = -1;
      break;
      }
   if(retval >= 1){
      fcntl(sk, F_SETFL, 0);
      getdata = safe_fdcat(sk, getdata, ret, max, (gd.bf.life_int + gd.bf.life_los));
      #ifdef SOCKET_BUG
      printf("SOCKET: select_fdcat(): OK select <%d> %s\n", retval, getdata);
      #endif
      break;
      }

   } /* while */

// fcntl(sk, F_SETFL, 0);

return getdata;
}










