// confset.c
// $Id: confset.c,v 1.3 2007/05/14 07:24:44 cvs Exp $
// masashi shimakura

#include<stdio.h>
#include<unistd.h>
#include<netinet/in.h>
#include<string.h>
#include<stdlib.h>
#include<pthread.h>


#include"zither.h"
#include"almemsys.h"


extern global_data_t gd;

/* 
int conf_set(char *);
int client_set(char *);
int print_conf(void);
*/

int setup_check(void);
int path_check(char *);
int print_conf(void);



/* ----------------- SET DATA ---------------- */
int set_data(void)
{

     gd.exid.uid = 0;
     gd.fp.errlog = safe_memcpy(gd.fp.errlog, "/tmp/zither_err.log", LOGPATH_LEN);
     gd.pg.postgres_data = safe_memcpy(gd.pg.postgres_data, "NULL", LOGPATH_LEN);
     gd.pg.pg_webserver = safe_memcpy(gd.pg.pg_webserver, "NULL", LOGPATH_LEN);
     gd.fp.connectlog = safe_memcpy(gd.fp.connectlog, "/tmp/zither_connect.log", LOGPATH_LEN);
     gd.fp.file_conf = safe_memcpy(gd.fp.file_conf, "/tmp/", LOGPATH_LEN);
     gd.fp.lock_path = safe_memcpy(gd.fp.lock_path, "/tmp/", LOGPATH_LEN);
     gd.fp.clock_path = safe_memcpy(gd.fp.clock_path, "/var/tmp/", LOGPATH_LEN);
     gd.fp.neg_conf = "/etc/neg.conf";              /* read onlly */
     gd.ms.ip_addr = safe_memcpy(gd.ms.ip_addr, "127.0.0.1", IP_LEN);
     gd.ms.port = 9999;
     gd.ms.max_count = 2;
     gd.md.ch_MailFrom = safe_memcpy(gd.md.ch_MailFrom, "zither@localhost", IP_LEN);
     gd.md.ch_MailRcptTo = safe_memcpy(gd.md.ch_MailRcptTo,"root@localshot",IP_LEN);
     gd.md.ch_MailServ = safe_memcpy(gd.md.ch_MailServ, "localhost", IP_LEN);
     gd.md.in_mailonoff = 1;
     gd.md.ch_MailCc = safe_memcpy(gd.md.ch_MailCc,"NOT",IP_LEN);
     gd.bs.life_int = 10;
     gd.bs.life_los = 5;

return 0;
}








/* ----------------- SETUP CHECK ---------------- */
int setup_check(void)
{
/*
  if(0 > gd.exid.uid){
     gd.exid.uid = 0;
     }
  if(0 == strlen(gd.fp.errlog)){
     gd.fp.errlog = safe_memcpy(gd.fp.errlog, "/tmp/zither_err.log", LOGPATH_LEN);
     }
  if(0 == strlen(gd.pg.postgres_data)){
     gd.pg.postgres_data = safe_memcpy(gd.pg.postgres_data, "NULL", LOGPATH_LEN);
     }
  if(0 == strlen(gd.pg.pg_webserver)){
     gd.pg.pg_webserver = safe_memcpy(gd.pg.pg_webserver, "NULL", LOGPATH_LEN);
     }
  if(0 == strlen(gd.fp.connectlog)){
     gd.fp.connectlog = safe_memcpy(gd.fp.connectlog, "/tmp/zither_connect.log", LOGPATH_LEN);
     }
  if(0 == strlen(gd.fp.file_conf)){
     gd.fp.file_conf = safe_memcpy(gd.fp.file_conf, "/tmp/", LOGPATH_LEN);
     }
  if(0 == strlen(gd.fp.lock_path)){
     gd.fp.lock_path = safe_memcpy(gd.fp.lock_path, "/tmp/", LOGPATH_LEN);
     }
  if(0 == strlen(gd.fp.clock_path)){
     gd.fp.clock_path = safe_memcpy(gd.fp.clock_path, "/var/tmp/", LOGPATH_LEN);
     }
// if(0 == strlen(gd.fp.neg_conf)){
//     gd.fp.neg_conf = "/etc/neg.conf";              / read onlly /
//     } 
  if(0 == strlen(gd.ms.ip_addr)){
     gd.ms.ip_addr = safe_memcpy(gd.ms.ip_addr, "127.0.0.1", IP_LEN);
     }
  if(0 >= gd.ms.port){
     gd.ms.port = 9999;
     }
  if(0 >= gd.ms.max_count){
     gd.ms.max_count = 2;
     } 
  if(0 == strlen(gd.md.ch_MailFrom)){
     gd.md.ch_MailFrom = safe_memcpy(gd.md.ch_MailFrom, "zither@localhost", IP_LEN);
     } 
  if(0 == strlen(gd.md.ch_MailRcptTo)){
     gd.md.ch_MailRcptTo = safe_memcpy(gd.md.ch_MailRcptTo,"root@localshot",IP_LEN);
     } 
  if(0 == strlen(gd.md.ch_MailServ)){
     gd.md.ch_MailServ = safe_memcpy(gd.md.ch_MailServ, "localhost", IP_LEN);
     }
  if(gd.md.in_mailonoff < 0 || gd.md.in_mailonoff > 1){
     gd.md.in_mailonoff = 1;
     }
  if(0 == strlen(gd.md.ch_MailCc)){
//   gd.md.ch_MailCc[0] = (char)0x00;
     gd.md.ch_MailCc = safe_memcpy(gd.md.ch_MailCc,"NOT",IP_LEN);
     }
  if(0 >= gd.bs.life_int){
     gd.bs.life_int = 10;
     }   
  if(0 >= gd.bs.life_los){
     gd.bs.life_los = 5;
     }
*/

  if(gd.bs.life_int < 10){
     gd.bs.life_int = 10;
     }
  if(gd.bs.life_int > 60){
     gd.bs.life_int = 60;
     }
  if(gd.bs.life_los < 1){
     gd.bs.life_los = 1;
     }
  if(gd.bs.life_los > 9){
     gd.bs.life_los = 9;
     }

#ifdef PRINT_CONF
print_conf();
#endif
return 0;
}



/* ----------- PRINT CONF ------------- */

int print_conf(void)
{
   fprintf(stdout,"-- ZITHER Configration setup list --\n");
   fprintf(stdout,"-- *Config File                              = %s\n", gd.fp.conf_path);
   fprintf(stdout,"-- *Neg File                                 = %s\n", gd.fp.neg_conf);
   fprintf(stdout,"-- SOCK_IPADDR  (bind ip)                    = %s\n", gd.ms.ip_addr);
   fprintf(stdout,"-- SOCK_PORT    (listen port)                = %d\n",gd.ms.port);
   fprintf(stdout,"-- PRO_COUNT    (thread connection max)      = %d\n",gd.ms.max_count);
   fprintf(stdout,"-- ERR_LOG      (err log path)               = %s\n",gd.fp.errlog);
   fprintf(stdout,"-- CON_LOG      (connection log path)        = %s\n",gd.fp.connectlog);
   fprintf(stdout,"-- FILE_LOCK    (connection lock path)       = %s\n",gd.fp.lock_path);
   fprintf(stdout,"-- CFILE_LOCK   (connection lost lock path)  = %s\n",gd.fp.clock_path);
   fprintf(stdout,"-- FILE_CONF    (configtation path)          = %s\n",gd.fp.file_conf);
   fprintf(stdout,"-- MAIL_FROM    (base mail from)             = %s\n",gd.md.ch_MailFrom);
   fprintf(stdout,"-- MAIL_RCPTTO  (base mail To:)              = %s\n",gd.md.ch_MailRcptTo);
   fprintf(stdout,"-- MAIL_SERV    (mail server)                = %s\n",gd.md.ch_MailServ);
   fprintf(stdout,"-- MAIL_CC      (base mail Cc:)              = %s\n",gd.md.ch_MailCc);
   fprintf(stdout,"-- LIFE_INT     (base life interval sec)     = %d\n",gd.bs.life_int);
   fprintf(stdout,"-- LIFE_LOS     (base life interval los sec) = %d\n",gd.bs.life_los);
   fprintf(stdout,"-- UID          (exec user id)               = %d\n",gd.exid.uid);
   fprintf(stdout,"-- MAIL_ONOFF   (mail on or off switch)      = %d\n",gd.md.in_mailonoff);
   fprintf(stdout,"-- PG_DATA      (Postgresql connection data) = %s\n",gd.pg.postgres_data);
   fprintf(stdout,"-- PG_WEB       (applon web addrses)         = %s\n",gd.pg.pg_webserver);
   fprintf(stdout,"Version %s\n", CL_VAR);

return 0;
}




/* ------------------ CONF SET ----------------- */
int conf_set( char *conf_filename )
{
FILE * FP;
int inA=1;
int stat = 0;
char * tmp;

gd.sc.chA = (char *)calloc(IP_LEN, sizeof(char));
gd.sc.chB = (char *)calloc(IP_LEN, sizeof(char));
gd.sc.chC = (char *)calloc(IP_LEN, sizeof(char));

if((FP = fopen(conf_filename, "r"))!=NULL){
    while(1){
      gd.sc.chA = safe_fpcat(FP, gd.sc.chA, &stat, BUF_MAX);
      if(stat == -1){
         fprintf(stderr,"conf_set(): Terminal of file.\n"); 
         break;
         }
      else {
         if( NULL != strchr(gd.sc.chA,':') && 3 <= mem_count(gd.sc.chA,':') 
             && 5 <= strlen(gd.sc.chA) && 1 != mem_count(gd.sc.chA, '#')){ 
            gd.sc.chB = safe_memcpy(gd.sc.chB, strtok_r(gd.sc.chA, ":", &tmp), BUF_MAX);
            gd.sc.chC = safe_memcpy(gd.sc.chC, strtok_r(NULL, ":", &tmp), BUF_MAX);
	    if(BUF_LEN > strlen(gd.sc.chC) && IP_LEN > strlen(gd.sc.chB)){
               rm_crlf(gd.sc.chC, strlen(gd.sc.chC));
               inA = path_check(gd.sc.chB);
               switch(inA){
                  case 1 : gd.fp.errlog=safe_memcpy(gd.fp.errlog, gd.sc.chC, LOGPATH_LEN);          break;
                  case 2 : gd.fp.file_conf=safe_memcpy(gd.fp.file_conf, gd.sc.chC, LOGPATH_LEN);        break;
                  case 3 : gd.ms.ip_addr = safe_memcpy(gd.ms.ip_addr, gd.sc.chC, IP_LEN);                 break;
                  case 4 : gd.ms.port = strtol(gd.sc.chC, (char **)NULL, 10);                        break;
                  case 5 : gd.ms.max_count = strtol(gd.sc.chC, (char **)NULL, 10);              break;
                  case 6 : gd.md.ch_MailFrom = safe_memcpy(gd.md.ch_MailFrom, gd.sc.chC, IP_LEN);     break;
                  case 7 : gd.md.ch_MailRcptTo = safe_memcpy(gd.md.ch_MailRcptTo, gd.sc.chC, IP_LEN); break;
                  case 8 : gd.md.ch_MailServ = safe_memcpy(gd.md.ch_MailServ, gd.sc.chC, IP_LEN);     break;
                  case 9 : gd.bs.life_int= strtol(gd.sc.chC, (char **)NULL, 10);                 break;
                  case 10 : gd.bs.life_los= strtol(gd.sc.chC, (char **)NULL, 10);                 break;
                  case 11 : gd.md.ch_MailCc = safe_memcpy(gd.md.ch_MailCc, gd.sc.chC, IP_LEN);        break;
                  case 12 : gd.fp.lock_path=safe_memcpy(gd.fp.lock_path, gd.sc.chC, LOGPATH_LEN);       break;
                  case 13 : gd.exid.uid = strtol(gd.sc.chC, (char **)NULL, 10);     break;
                  case 14 : gd.md.in_mailonoff = strtol(gd.sc.chC, (char **)NULL, 10);     break;
                  case 15 : gd.fp.clock_path=safe_memcpy(gd.fp.clock_path, gd.sc.chC, LOGPATH_LEN);       break;
                  case 16 : gd.fp.connectlog=safe_memcpy(gd.fp.connectlog, gd.sc.chC, LOGPATH_LEN);          break;
                  case 17 : gd.pg.postgres_data=safe_memcpy(gd.pg.postgres_data, gd.sc.chC, LOGPATH_LEN);          break;
                  case 18 : gd.pg.pg_webserver=safe_memcpy(gd.pg.pg_webserver, gd.sc.chC, LOGPATH_LEN);          break;
                  default : break;
                  }
	       }
            }
         }
      } 
   fclose( FP );
   }
else {
   fprintf(stderr,"-- CONF FILE NOT OPEN %s\n",conf_filename);
   fprintf(stderr,"-- zither shutdown.\n");
   exit(1);
   }
setup_check();

free(gd.sc.chA);
free(gd.sc.chB);
free(gd.sc.chC);

return 0;
}




/* ------------------ CLIENT SET ----------------- */
int client_set( private_data_t * pd )
{
static int stat;
int inA = 1;
int count, cho;
char * tmp;

pd->chA = (char *)calloc(IP_LEN, sizeof(char));
pd->chB = (char *)calloc(IP_LEN, sizeof(char));
pd->chC = (char *)calloc(IP_LEN, sizeof(char));

// 最後のカラムに：が無いことを確認 臨時w

count = strlen(pd->rec.data);
if(count > 0){
   if(pd->rec.data[count -1] == ':'){
      free(pd->chA);
      free(pd->chB);
      free(pd->chC);
      return -1;
      }
   }
cho = mem_count(pd->rec.data,':');
pd->chA = safe_memcpy(pd->chA, pd->rec.data, BUF_MAX);

stat = -1;
if( NULL != strchr(pd->rec.data,':') && 3 <= cho && (count - cho) > 0 && count > 7 
    && 1 != mem_count(pd->rec.data, '#')){ 
   pd->chB = safe_memcpy(pd->chB, strtok_r(pd->chA, ":", &tmp), BUF_MAX);
   pd->chC = safe_memcpy(pd->chC, strtok_r(NULL, ":", &tmp), BUF_MAX);
   if(BUF_LEN > strlen(pd->chC) && IP_LEN > strlen(pd->chB)){
      rm_crlf(pd->chC, (int)strlen(pd->chC));
      inA = path_check(pd->chB);
      stat = 1;
      switch(inA){
         case 6 : pd->mail.from = safe_memcpy(pd->mail.from, pd->chC, IP_LEN);   break;
         case 7 : pd->mail.rcptto = safe_memcpy(pd->mail.rcptto, pd->chC, IP_LEN); break;
         case 8 : pd->mail.server = safe_memcpy(pd->mail.server, pd->chC, IP_LEN);   break;
         case 9 : pd->life.life_int= strtol(pd->chC, (char **)NULL, 10);
                  if(pd->life.life_int < 5){
                     pd->life.life_int = 5;
                     }
                  if(pd->life.life_int > 120){
                     pd->life.life_int = 120;
                     }
                     break;

         case 10 : pd->life.life_los= strtol(pd->chC, (char **)NULL, 10);
                  if(pd->life.life_los < 1){
                     pd->life.life_los = 1;
                     }
                  if(pd->life.life_los > 5){
                     pd->life.life_los = 5;
                     }
                     break;

         case 11 : pd->mail.cc = safe_memcpy(pd->mail.cc, pd->chC, IP_LEN);    break;
         case 19 : pd->life.onoff= strtol(pd->chC, (char **)NULL, 10);
                  if(pd->life.onoff < 0){
                     pd->life.onoff = 0;
                     }
                  if(pd->life.onoff > 1){
                     pd->life.onoff = 1;
                     }
                     break;
         default : stat = -1;  break;
         }
      }
   }

free(pd->chA);
free(pd->chB);
free(pd->chC);

return(stat);
}








/* ------------------ CLIENT SETG ----------------- */
int client_setg( private_data_t * pd )
{
static int stat;
int inA = 1;
int count, cho;
char * tmp;

pd->chA = (char *)calloc(IP_LEN, sizeof(char));
pd->chB = (char *)calloc(IP_LEN, sizeof(char));
pd->chC = (char *)calloc(IP_LEN, sizeof(char));

// 最後のカラムに：が無いことを確認 臨時w

count = strlen(pd->rec.data);
if(count > 0){
   if(pd->rec.data[count -1] == ':'){
      free(pd->chA);
      free(pd->chB);
      free(pd->chC);
      return -1;
      }
   }
cho = mem_count(pd->rec.data,':');
pd->chA = safe_memcpy(pd->chA, pd->rec.data, BUF_MAX);

stat = -1;
if( NULL != strchr(pd->rec.data,':') && 3 <= cho && (count - cho) > 0 && count > 7 
    && 1 != mem_count(pd->rec.data, '#')){ 
   pd->chB = safe_memcpy(pd->chB, strtok_r(pd->chA, ":", &tmp), BUF_MAX);
   pd->chC = safe_memcpy(pd->chC, strtok_r(NULL, ":", &tmp), BUF_MAX);
   if(BUF_LEN > strlen(pd->chC) && IP_LEN > strlen(pd->chB)){
      rm_crlf(pd->chC, (int)strlen(pd->chC));
      inA = path_check(pd->chB);
      stat = 1;
      switch(inA){
         case 6 : if(6 < (int)strlen(pd->chC)){
                     gd.md.ch_MailFrom = safe_memcpy(gd.md.ch_MailFrom, pd->chC, IP_LEN);
                     printf("SETG: MailFrom =%s\n", gd.md.ch_MailFrom);
                     }
                  else{
                     printf("SETG: MailFrom is not set\n");
                     stat = -1;
                     } 
                  break;
         case 7 : if(6 < (int)strlen(pd->chC)){
                     gd.md.ch_MailRcptTo = safe_memcpy(gd.md.ch_MailRcptTo, pd->chC, IP_LEN);
                     printf("SETG: MailRcptTo =%s\n", gd.md.ch_MailRcptTo);
                     }
                  else{
                     printf("SETG: MailRcptTo is not set\n");
                     stat = -1;
                     } 
                  break;
         case 8 : if(6 < (int)strlen(pd->chC)){
                     gd.md.ch_MailServ = safe_memcpy(gd.md.ch_MailServ, pd->chC, IP_LEN);
                     printf("SETG: MailServ =%s\n", gd.md.ch_MailServ);
                     }
                  else{
                     printf("SETG: MailServ is not set\n");
                     stat = -1;
                     } 
                  break;
         case 14 : if(0 < (int)strlen(pd->chC)){
                      gd.md.in_mailonoff = strtol(pd->chC, (char **)NULL, 10);
                      printf("SETG: MailOnOff =%d\n", gd.md.in_mailonoff);   break;
                      }
                   else{
                      printf("SETG: MailOnOff is not set\n");
                      stat = -1;
                      } 
                  break;

         default : stat = -1; break;
         }
      }
   }

free(pd->chA);
free(pd->chB);
free(pd->chC);

return(stat);
}







/* ------------------ PATH CHECK ----------------- */
int path_check(char *chA)
{
static int bu;
char ch[21][IP_LEN];
int count = 0;
char * non="NON";
char * err_log="ERR_LOG";
char * con_log="CON_LOG";
char * file_lock="FILE_LOCK";
char * file_conf="FILE_CONF";
char * sock_ipaddr="SOCK_IPADDR";
char * sock_port="SOCK_PORT";
char * pro_count="PRO_COUNT";
char * mail_from="MAIL_FROM";
char * mail_rcptto="MAIL_RCPTTO";
char * mail_serv="MAIL_SERV";
char * life_int="LIFE_INT";
char * life_los="LIFE_LOS";
char * mail_cc="MAIL_CC";
char * uid="UID"; 
char * mail_onoff="MAIL_ONOFF"; 
char * cfile_lock="CFILE_LOCK";
char * pg_data="PG_DATA";
char * pg_web="PG_WEB";
char * life_onoff="LIFE_ONOFF"; 

self_memcpy(ch[0], non, IP_LEN);
self_memcpy(ch[1], err_log, IP_LEN);
self_memcpy(ch[2], file_conf, IP_LEN);
self_memcpy(ch[3], sock_ipaddr, IP_LEN);
self_memcpy(ch[4], sock_port, IP_LEN);
self_memcpy(ch[5], pro_count, IP_LEN);
self_memcpy(ch[6], mail_from, IP_LEN);
self_memcpy(ch[7], mail_rcptto, IP_LEN);
self_memcpy(ch[8], mail_serv, IP_LEN);
self_memcpy(ch[9], life_int, IP_LEN);
self_memcpy(ch[10], life_los, IP_LEN);
self_memcpy(ch[11], mail_cc, IP_LEN);
self_memcpy(ch[12], file_lock, IP_LEN);
self_memcpy(ch[13], uid, IP_LEN);
self_memcpy(ch[14], mail_onoff, IP_LEN);
self_memcpy(ch[15], cfile_lock, IP_LEN);
self_memcpy(ch[16], con_log, IP_LEN);
self_memcpy(ch[17], pg_data, IP_LEN);
self_memcpy(ch[18], pg_web, IP_LEN);
self_memcpy(ch[19], life_onoff, IP_LEN);

bu = 0;
if(IP_LEN > strlen(chA)){
   for(count=0; count < 20; count++){
      if(0 == memcmp(chA, ch[count], (int)strlen(ch[count])+1)){
         bu=count;
         }
      }
   }
else{
   fprintf(stderr,"big size mess err. %s\n", chA);
   } 
return(bu);
}




