// zither.c
// $Id: zither.c,v 1.4 2007/05/14 07:25:02 cvs Exp $
// masashi shimakura


#include<stdio.h>
#include<unistd.h>
#include<fcntl.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<arpa/inet.h>
#include<stdlib.h>
#include<string.h>
#include<pthread.h>

#include"zither.h"
#include"almemsys.h"
#include"jpreturn.h"

#ifdef POSTGRES_IN
  #include "/usr/local/pgsql/include/libpq-fe.h"
  PGconn * conn;
  PGresult * res;
#endif

global_data_t gd;


/*
struct my_sock ms;
struct buf_data bd;
struct file_path fp;
*/

int connect_open(int);                    /* fdno thread function */
int clockfile_check(void);
int select_fdcat(private_data_t *, int);


int main(int argc, char * argv[])
{

pthread_t t1;
long int fdcount;

malloc_set();
set_data();
optin(argc, argv);
conf_set(gd.fp.conf_path);

printf("neg=%s, lock=%s, conf=%s\n", gd.fp.neg_conf, gd.fp.lock_path, gd.fp.file_conf);
lockfile_remove(gd.fp.neg_conf, gd.fp.lock_path, gd.fp.file_conf);
malloc_set2();

if(gd.exid.uid <= 0){
   fprintf(stderr,"Not exec user id. %d\n", gd.exid.uid);
   exit(-1);
   }
if(setuid(gd.exid.uid)){
   fprintf(stderr,"Not setuid err %d\n", gd.exid.uid);
   exit(-1);
   }

#ifdef ERR_OUT
pthread_mutex_init(&err_mutex, NULL);
#endif
#ifdef LOG_OUT
pthread_mutex_init(&con_mutex, NULL);
gd.fp.con_fd = fd_outopen(gd.fp.connectlog, gd.fp.con_fp);
#endif

#ifdef POSTGRES_IN
pthread_mutex_init(&pg_mutex, NULL);
gd.pg.stat = pqconnect();
#endif


socket_bind(&gd.ms.my_addr, gd.ms.port, gd.ms.ip_addr, &gd.ms.ls);

/* client stop checker thread */
pthread_create( &t1, NULL, (void *)clockfile_check, NULL);

for(;;){
   for(fdcount = 0; fdcount < gd.ms.max_count; fdcount++){
      if(gd.ms.fdstat[fdcount] != 1){
         gd.ms.fdstat[fdcount] = 1;
         break;
         }
      } 
   #ifdef DEBUG
   fprintf(stderr,"new connection fdno = %d\n",fdcount); 
   #endif
   if(fdcount < gd.ms.max_count){
      if((socket_accept(&gd.ms.my_addr, &gd.ms.ls, &gd.ms.sk[fdcount]))!=-1){
         gd.ms.fdno = fdcount;
         memcpy(gd.ms.inip_addr[fdcount], &gd.ms.my_addr.sin_addr.s_addr, sizeof(gd.ms.inip_addr[fdcount]));
         }
      pthread_create( &gd.pt[fdcount], NULL, (void *)connect_open, (long int *)gd.ms.fdno);
      }
   else {
      fprintf(stderr,"It waits for 10 seconds that exceeded connected number threshold.%ld\n",fdcount);
      sleep(10); 
      }
   }

/* --- It doesn't reach. ---*/
close(gd.ms.ls);
return 0;
}




int connect_open(int fdno)
{
int stat = 0;
int ret = 0;
int neg = 0;
private_data_t *pd;


if((pd = (private_data_t *)malloc(sizeof(private_data_t)))==NULL){exit(1);}
private_malloc_set(pd);
pd->rec.fdno = fdno;

pthread_detach(pthread_self());

/*  Processing description as follows  */

stat = select_fdcat(pd, 15);

if(stat == 0){
   neg = start_neg(pd);
   #ifdef DATA_SIZE
   printf("-start_neg-- %d\n", neg);
   #endif
   if(neg >= 1){
      #ifdef POSTGRES_IN
      pg_connectset(pd, "ON");
      #endif
      for(;ret >= 0;){
         ret = select_fdcat(pd, (pd->life.life_int + pd->life.life_los + 15));
         #ifdef DATA_SIZE
         printf("-select_fdcat-- stat %d\n", ret);
         #endif
         if(ret >= 0){
            ret = stag_neg(pd);
            #ifdef DATA_SIZE
            printf("-stag_neg-- stat %d\n", ret);
            #endif
            }

         } /* for */
      }
   }

/*  Here  */

fprintf(stdout,"connect_open(): break loop or not connection. FD=%d USER=%s\n", pd->rec.fdno, pd->rec.user);
fprintf(stdout,"connect_open(): break loop life.cancel no is ->%d\n", pd->life.cancel);

if(pd->life.in_life[0] > 0){
   pd->life.cancel = -1;
   fprintf(stderr,"connect_open(): The thread is canceled. FD=%d USER=%s\n",  pd->rec.fdno, pd->rec.user);
   }

if(neg >= 1){

   #ifdef POSTGRES_IN
   char * swap = (char *)calloc(2, sizeof(char));
   swap = safe_sprintf(swap, BUF_MAX, "%s('%d.%d.%d.%d', '%s', '%s', '%ld', '%ld', '%ld', '%ld' , '%ld', '%ld', '%ld', '%ld', '%s', '%s', '%s', '%ld', '%ld', '%s', '%s', '%ld', '%s', '%s', '%s', '%s');",
      "INSERT INTO errlog VALUES ",
      gd.ms.inip_addr[pd->rec.fdno][0],
      gd.ms.inip_addr[pd->rec.fdno][1],
      gd.ms.inip_addr[pd->rec.fdno][2],
      gd.ms.inip_addr[pd->rec.fdno][3],

      pd->rec.user,
      "CLOSE",
      u_time(),
      ctime_getr('y'),
      ctime_getr('m'),
      ctime_getr('d'),
      ctime_getr('h'),
      ctime_getr('i'),
      ctime_getr('s'),
      0,
      "NOT",
      "NOT",
      "NOT",
      0,
      0,
      pd->rec.info,
      "sitar client shutdown.",
      1,
      "NON",
      "NON",
      "NON",
      "NON");

   pthread_mutex_lock(&pg_mutex);
   pqexec_datain(swap);
   pthread_mutex_unlock(&pg_mutex);
   #ifdef POSTGRES_DEBUG
   printf(">>%s\n", swap);
   #endif

   pg_connectset(pd, "OFF");

   free(swap);
   #endif   /* POSTGRES_IN */


   if(gd.md.in_mailonoff == 1){
      if(0 == self_memcmp(pd->rec.def_user, "administrator")){
         mail_grsend(pd->mail.server,
              pd->mail.from,
              pd->mail.rcptto,
              pd->mail.cc,
              pd->rec.def_user,
              pd->rec.info,
              ADMIN_BODY_1,
              ADMIN_BODY_2);
         }
      else{
         mail_grsend(pd->mail.server,
              pd->mail.from,
              pd->mail.rcptto,
              pd->mail.cc,
              pd->rec.def_user,
              pd->rec.info,
              CLIENT_BODY_1,
              CLIENT_BODY_2);
         }
      }


   #ifdef LOG_OUT
   pthread_mutex_lock(&con_mutex);
   log_out(gd.fp.con_fd, pd->rec.user, pd->rec.com, "Zither server connection is lost.", gd.ms.inip_addr[pd->rec.fdno]);
   pthread_mutex_unlock(&con_mutex);
   #endif

   sleep(2);

   lock_remove(pd->file.lock_filename);
   pd->file.clock_filename = chack_lockfile(pd->rec.user, pd->rec.info, pd->file.clock_filename, gd.fp.clock_path, &stat);
   if(0 == self_memcmp(pd->rec.user, "administrator")){
      lock_remove(pd->file.clock_filename);
      fprintf(stderr,"removd administrator lock file <%s>\n", pd->file.clock_filename);
      }

   } /* neg stat = -1 */



gd.ms.fdstat[pd->rec.fdno] = 0;
close(gd.ms.sk[pd->rec.fdno]);

fprintf(stderr,"thread Management number %d fd openings. <%s>\n", pd->rec.fdno, pd->rec.user);
fprintf(stderr,"thread Management number %d plivate memory openings . <%s>\n", pd->rec.fdno, pd->rec.user);
private_malloc_free(pd);
free(pd);

return 0;
}




int select_fdcat(private_data_t * pd, int interval)
{
static int ret;
struct timeval tv;
int retval;
fd_set rfds;

fcntl(gd.ms.sk[pd->rec.fdno], F_SETFL, O_NONBLOCK);
tv.tv_sec = interval;
tv.tv_usec = 0;

ret = 0;

while(1){
   FD_ZERO(&rfds);
   FD_SET(gd.ms.sk[pd->rec.fdno], &rfds);
   retval = select(gd.ms.sk[pd->rec.fdno] + 1, &rfds, NULL, NULL, &tv);
   if(retval < 0){
      fcntl(gd.ms.sk[pd->rec.fdno], F_SETFL, 0);
      #ifdef SOCKET_BUG
      printf("SOCKET: select_fdcat(1): NG select <%d>\n", retval);
      #endif
      ret = -1;
      break;
      }
   if(retval == 0){
      fcntl(gd.ms.sk[pd->rec.fdno], F_SETFL, 0);
      #ifdef SOCKET_BUG
      printf("SOCKET: select_fdcat(2): NG select <%d>\n", retval);
      #endif
      ret = -1;
      break;
      }
   if(retval >= 1){
      fcntl(gd.ms.sk[pd->rec.fdno], F_SETFL, 0);
      pd->getdata = safe_fdcat(gd.ms.sk[pd->rec.fdno],
        pd->getdata, &ret, BUF_MAX, interval);
      #ifdef SOCKET_BUG
      printf("SOCKET: select_fdcat(): OK select <%d> %s\n", retval, pd->getdata);
      #endif
      break;
      }

   } 

// fcntl(gd.ms.sk[pd->rec.fdno], F_SETFL, 0);

return(ret);
}





int pqconnect(void)
{
int ret;
ret = 0;

conn = PQconnectdb(gd.pg.postgres_data);
switch(PQstatus(conn)){
   case CONNECTION_STARTED:
        fprintf(stderr, "接続確立待ち postgres.\n");
        break;
   case CONNECTION_MADE:
        fprintf(stderr, "接続OK送信待ち postgres.\n");
        break;
   case CONNECTION_AWAITING_RESPONSE:
        fprintf(stderr, "サーバからの接続待ち postgres.\n");
        break;
   case CONNECTION_BAD:
        fprintf(stderr, "接続出来ない postgres.\n");
        fprintf(stderr, "%s", PQerrorMessage(conn));
        PQfinish(conn);
        ret = -1;
        break;
   default:
        #ifdef POSTGRES_DEBUG
        fprintf(stderr, "正常に接続できました postgres.\n");
        #endif
        ret = 1;
   }

return ret;
}



int pqexec_select(char * swap)
{
int ret;
ret = 0;

if(gd.pg.stat == 1){
   res = PQexec(conn, swap);
   if(PQresultStatus(res) != PGRES_TUPLES_OK){
      fprintf(stderr, "セレクトできてないかも\n");
      PQclear(res);
      ret = -1;
      }
   else {
      #ifdef POSTGRES_DEBUG
      fprintf(stderr, "セレクトできたかも\n");
      #endif
      ret = PQntuples(res);
      PQclear(res);
      }
   }

return ret;
}




int pqexec_datain(char * swap)
{
int ret;
ret = 0;

if(gd.pg.stat == 1){
   res = PQexec(conn, swap);
   if(!res || PQresultStatus(res) != PGRES_COMMAND_OK){
      fprintf(stderr, "インサート出来てないかも \n");
      PQclear(res);
      ret = -1;
      }
   else {
      #ifdef POSTGRES_DEBUG
      fprintf(stderr, "インサート成功 \n");
      #endif
      ret = 1;
      PQclear(res);
      }
   }
else{
   gd.pg.stat = pqconnect();
   fprintf(stderr, "つなぎなおしてみました  \n");
   if(gd.pg.stat == 1){
      res = PQexec(conn, swap);
      if(!res || PQresultStatus(res) != PGRES_COMMAND_OK){
         fprintf(stderr, "インサート出来てないかも \n");
         PQclear(res);
         ret = -1;
         }
      else {
         #ifdef POSTGRES_DEBUG
         fprintf(stderr, "インサート成功 \n");
         #endif
         ret = 1;
         PQclear(res);
         }
      }
   else{
      fprintf(stderr, "やっぱダメかもです  \n");
      ret = -1;
      }
   }

return ret;
}






int pg_connectset(private_data_t * pd, char * set)
{
int pret = 0;
char * swap = (char *)calloc(2, sizeof(char));

swap = safe_sprintf(swap, BUF_MAX, "select * from connection where cname='%s';",
   pd->rec.user);
pthread_mutex_lock(&pg_mutex);
pret = pqexec_select(swap);
pthread_mutex_unlock(&pg_mutex);
#ifdef POSTGRES_DEBUG
printf("SELECT STAT=%d >>%s\n",pret, swap);
#endif

if(pret <= 0){
   swap = safe_sprintf(swap, BUF_MAX, "%s('%ld', '%ld', '%ld', '%ld', '%ld', '%ld', '%ld', '%s', '%d.%d.%d.%d', '%s', '%s', '%s', '%s');",
     "INSERT INTO connection VALUES ",
     u_time(),
     ctime_getr('y'),
     ctime_getr('m'),
     ctime_getr('d'),
     ctime_getr('h'),
     ctime_getr('i'),
     ctime_getr('s'),
     pd->rec.user,
     gd.ms.inip_addr[pd->rec.fdno][0],
     gd.ms.inip_addr[pd->rec.fdno][1],
     gd.ms.inip_addr[pd->rec.fdno][2],
     gd.ms.inip_addr[pd->rec.fdno][3],
     gd.pg.pg_webserver,
     "START",
     set,
     pd->rec.ver);

   pthread_mutex_lock(&pg_mutex);
   pqexec_datain(swap);
   pthread_mutex_unlock(&pg_mutex);
   #ifdef POSTGRES_DEBUG 
   printf(">>%s\n", swap);
   #endif
   }

if(pret > 0){
//   swap = safe_sprintf(swap, BUF_MAX, "%s uct='%ld', ye='%ld', mo='%ld', da='%ld', ha='%ld', mi='%ld', se='%ld', cname='%s', cip='%d.%d.%d.%d', server='%s', mode='%s', stat='%s', ver='%s' WHERE cname='%s';",
   swap = safe_sprintf(swap, BUF_MAX, "%s uct='%ld', ye='%ld', mo='%ld', da='%ld', ha='%ld', mi='%ld', se='%ld', cname='%s', cip='%d.%d.%d.%d', server='%s', stat='%s', ver='%s' WHERE cname='%s';",
     "UPDATE connection SET",
     u_time(),
     ctime_getr('y'),
     ctime_getr('m'),
     ctime_getr('d'),
     ctime_getr('h'),
     ctime_getr('i'),
     ctime_getr('s'),
     pd->rec.user,
     gd.ms.inip_addr[pd->rec.fdno][0],
     gd.ms.inip_addr[pd->rec.fdno][1],
     gd.ms.inip_addr[pd->rec.fdno][2],
     gd.ms.inip_addr[pd->rec.fdno][3],
     gd.pg.pg_webserver,
//     "START",
     set,
     pd->rec.ver,
     pd->rec.user);

   pthread_mutex_lock(&pg_mutex);
   pqexec_datain(swap);
   pthread_mutex_unlock(&pg_mutex);
   #ifdef POSTGRES_DEBUG 
   printf(">>%s\n", swap);
   #endif
   }

free(swap);
return 0;
}









int clockfile_check(void)
{
static int ret;
FILE * fp;
FILE * fpl;
int interval = 120;
int fp_stat = 0;
int count0 = 0;
int count1 = 0;
int count2 = 0;
char chA;
char data[2][BUF_SLEN];
char * swap;
char * recdata;
char * alllock_filename = (char *)calloc(BUF_DEFLEN, sizeof(char));

ret = 0;
for(;;){
   recdata = (char *)calloc(BUF_DEFLEN, sizeof(char));
   #ifdef DEBUG
   printf("neg.conf   ->%s\n", gd.fp.neg_conf);
   printf("clock_path ->%s\n", gd.fp.clock_path);
   #endif

   fp_stat = 0;
   for(count2 = 0; count2 < interval; count2++){
      #ifdef DEBUG
      printf("sleep\n"); 
      #endif
      sleep(1);
      }
   if((fp = fopen(gd.fp.neg_conf, "r+"))!=NULL){
      while(fp_stat == 0){
         swap = (char *)calloc(BUF_DEFLEN, sizeof(char));
         chA = fgetc(fp);
         switch(chA){
            case ':' : data[count0][count1] = (char)0x00;
                       if(count0 < 2){
                          count0++; count1 = 0;
                          }
                       break;
            case ';' : data[count0][count1] = (char)0x00;
                       if(count1 != 0){
                          if(0 != strlen(data[count0])){
                             alllock_filename = filename_create(
                                alllock_filename, gd.fp.clock_path, "_lock", data[0]);
                             if((fpl = fopen(alllock_filename, "r"))!=NULL){
                                swap = safe_sprintf(swap, BUF_MAX, 
                                 "The server has stopped.\n%s:%s\nLockfile=%s\n",
                                 data[0], data[1], alllock_filename);
                                #ifdef DEBUG
                                printf("clockfile_check(): %s\n", swap);
                                printf("lock file: %s\n", alllock_filename);
                                #endif
                                fclose(fpl);
                                }
                             }
                          count0 = 0; count1 = 0;
                          }
                       break;
            case '\n' : data[count0][count1] = (char)0x00;
                       if(count1 != 0){
                          if(0 != strlen(data[count0])){
                             alllock_filename = filename_create(
                               alllock_filename, gd.fp.clock_path, "_lock", data[0]);
                             if((fpl = fopen(alllock_filename, "r"))!=NULL){
                                swap = safe_sprintf(swap, BUF_MAX, 
                                 "The server has stopped.\n%s:%s\nLockfile=%s\n",
                                 data[0], data[1], alllock_filename);
                                #ifdef DEBUG
                                printf("clockfile_check(): %s\n", swap);
                                printf("lock file: %s\n", alllock_filename);
                                #endif
                                fclose(fpl);
                                }
                             }
                          count0 = 0; count1 = 0;
                          }
                       break;
            case EOF : fp_stat = 1;
                       data[count0][count1] = (char)0x00;
                       break;
            default  : 
                       if(chA >= 0){
                          data[count0][count1] = chA;
                          if(count1 < BUF_SLEN){
                             count1++;
                             }
                          }
                       break;
            }

         recdata = safe_strncat(recdata, swap, BUF_MAX);
         free(swap);
         } /* while() */

      fclose(fp);
      } /* fopen() */
   else{
      fprintf(stderr,"Not open neg.conf %s\n", gd.fp.neg_conf);
      }

   #ifdef DEBUG
   fprintf(stdout,"%s\n", recdata);
   #endif

   swap_mem(recdata, '\n', (char)0x01, (int)strlen(recdata));

   if(2 < (int)strlen(recdata)){

      mail_grsend(gd.md.ch_MailServ,
              gd.md.ch_MailFrom,
              gd.md.ch_MailRcptTo,
              " ",
              "zither administrator",
              CLIENT_BODY_3, 
              recdata,
              CLIENT_BODY_4);
      }

   free(recdata);
   } /* for(;;) */

free(alllock_filename);

return(ret);
}      







