// zither.h
// $Id: zither.h,v 1.9 2007/05/14 07:34:31 cvs Exp $
// masashi shimakura

#ifndef _ZITHER_H_
  #define _ZITHER_H_

  #define CL_VAR "zither-1.1.2e64"

  #define BUF_LEN 256
  #define BUF_DEFLEN 128
  #define BUF_MAX (1024 * 1024)

  #define BUF_SLEN 128
  #define IP_LEN 128
  #define TIME_LEN 32
  #define LIFE_HI 10
  #define INT_PLUS 10
  #define MAIL_INTERVAL 30

  #define LOGPATH_LEN 256

  /* debug option
  #define DEBUG  */

  /* print config data */
  #define PRINT_CONF

  /* get method loging options */
  #define LOG_OUT

  /* err mail loging options */
  #define ERR_OUT

  /* Big wood use only */
//  #define BIG_WOOD 


//  #define FILESEND_DEBUG
//  #define AL_DEBUG 
//  #define SOCKET_BUG
//  #define SOCKET_SENDBUG
  #define LIFE_DEBUG
//  #define MAIL_DEBUG_IN 
//  #define MAIL_DEBUG_OUT
//  #define DATA_SIZE


  /* PostgreSQL err data import */
  #define POSTGRES_IN 

  /* PostgreSQL debug */
  #ifdef POSTGRES_IN 
  /* #define POSTGRES_DEBUG */
  #endif

  pthread_mutex_t err_mutex;
  pthread_mutex_t con_mutex;

  #ifdef POSTGRES_IN 
    pthread_mutex_t pg_mutex;
  #endif


  typedef struct mail_data mail_data_t;

  struct mail_data{
     struct sockaddr_in my_maddr;
     int sk;
     char * swap;                   /* active swap */
     char * swap2;                  /* active swap */
     char * server;                 /* active swap */
     char * rcptto;                 /* active swap */ 
     char * cp_time;                /* active swap */
     /* --- */
     char * iserver;                /* active swap */
     char * ifrom;                  /* active swap */
     char * ircptto;                /* active swap */
     char * icc;                    /* active swap */
     char * iuser;                  /* active swap */
     char * ihost;                  /* active swap */
     char * idata;                  /* active swap */
     char * isubject;               /* active swap */
     };

  typedef struct private_data private_data_t;

  struct private_data{
     char * getdata;                /* active */
     char * swap;                   /* active swap */  
     char * putdata;                /* active swap */
     char * chA;                    /* active swap */
     char * chB;                    /* active swap */
     char * chC;                    /* active swap */
     struct {
        char * user;                /* active */
        char * user_org;            /* active */
        char * com;                 /* active */
        char * data;                /* active */
        char * def_user;            /* active */
        char * info;                /* active */
        char * minfo;               /* active */
        char * ver;                 /* active */
        int fdno;                   /* active */ 
        } rec;
     struct {
        char * lock_filename;       /* active */
        char * clock_filename;      /* sctive */
        char * bat_filename;        /* active */
        char * scan_filename;       /* active */
        char * conf_filename;       /* active */
        char * stat_filename;       /* active */
        } file;
     struct {
        char * server;              /* active */
        char * from;                /* active */
        char * rcptto;              /* active */
        char * cc;                  /* active */
        char * rcptto_org;          /* active */
        char * cc_org;              /* active */
        int in_mailonoff;
        } mail;
     struct {
        pthread_t life_t;
        char * swap1;                /* active */
        char * swap2;                /* active swap */
        char * swap3;                /* active swap */
        char * swap4;                /* active */
        char * bat_stat;             /* active */
        char * scan_stat;            /* active */
        char * conf_stat;            /* active */
        char * stat_stat;            /* active */
        int life_int;
        int life_los;
        int cancel;
        long int * in_life;
        char onoff;
        } life;
     };

  typedef struct global_data global_data_t;

  struct global_data {
    pthread_t * pt;
    struct {
       char * postgres_data;           /* active */
       char * pg_webserver;            /* active */
       int stat;
       }pg;
    struct {
       int max_count;
       long int fdno;
       int * fdstat;
       int * sk;
       int ls;
       char * ip_addr;
       int port;
       struct sockaddr_in my_addr;
       unsigned char ** inip_addr;
       }ms; /* my_sock */
    struct {
       char * conf_path;            /* read onlly */
       char * neg_conf;             /* read onlly */
       char * lock_path;            /* active */
       char * clock_path;           /* active */
       char * file_conf;            /* active */
/*     char * log_path;             / active / */
       char * errlog;               /* active */
       char * connectlog;           /* active */
/*     int err_fd; */
/*     FILE * err_fp; */
       int con_fd;
       FILE * con_fp;
       }fp; /* file_path */
    struct {
       char * ch_MailFrom;          /* active */
       char * ch_MailRcptTo;        /* active */
       char * ch_MailServ;          /* active */
       char * ch_MailCc;            /* active */
       int in_mailonoff;
       }md; /* mail_data */
    struct {
       char * chA;                  /* active swap */
       char * chB;                  /* active swap */
       char * chC;                  /* active swap */
       }sc; /* set_conf */
    struct {
       int life_int;
       int life_los;
       }bs; /* buff_set */
    struct {
       int uid;
       }exid; /* zither exit user id */

    };

  #include"prototype.h"

#endif 




 
