// zitherset.c
// $Id: zitherset.c,v 1.3 2007/05/08 09:14:37 cvs Exp $
// masashi shimakura

#include<stdio.h>
#include<unistd.h>
#include<fcntl.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<arpa/inet.h>
#include<stdlib.h>
#include<string.h>
#include<errno.h>


#include"almemsys.h"

int socket_send(int, char *, int);
char * select_fdcat_2(int, char *, int, int *);
int help_out(void);


int main(int argc, char ** argv)
{
struct sockaddr_in my_addr;
char * getdata;
char * send_1;
char * send_2;
char * ip_addr;
int sk, ret, port, stat, onoffstat;

send_1 = (char *)calloc(2, sizeof(char));
send_2 = (char *)calloc(2, sizeof(char));

if(argc == 3){
   if(0 == self_memcmp(argv[1], "MAIL_ON")){
      if(0 == self_memcmp(argv[2], "ON")){
         send_1 = safe_memcpy(send_1, "administrator :: COM: NEG DATA: --administrator--\n\n", BUF_MAX);
         send_2 = safe_memcpy(send_2, "administrator :: COM: SETG: DATA: MAIL_ONOFF:1\n\n", BUF_MAX);
         }
      else if(0 == self_memcmp(argv[2], "OFF")){
         send_1 = safe_memcpy(send_1, "administrator :: COM: NEG DATA: --administrator--\n\n", BUF_MAX);
         send_2 = safe_memcpy(send_2, "administrator :: COM: SETG: DATA: MAIL_ONOFF:0\n\n", BUF_MAX);
         }
      else{
         printf("ERR: argv[2] err.\n");
         help_out();
         free(send_1);
         free(send_2);
         return -1;
         }
      }

   else if(0 == self_memcmp(argv[1], "MAIL_SERV")){
      if(3 < (int)strlen(argv[2])){
         send_1 = safe_memcpy(send_1, "administrator :: COM: NEG DATA: --administrator--\n\n", BUF_MAX);
         send_2 = safe_memcpy(send_2, "administrator :: COM: SETG: DATA: MAIL_SERV:", BUF_MAX);
         send_2 = safe_strncat(send_2, argv[2], BUF_MAX);
         send_2 = safe_strncat(send_2, "\n\n", BUF_MAX);
         }
      else{
         printf("ERR: argv[2] err.\n");
         help_out();
         free(send_1);
         free(send_2);
         return -1;
         }
      }

   else if(0 == self_memcmp(argv[1], "MAIL_FROM")){
      if(7 < (int)strlen(argv[2])){
         send_1 = safe_memcpy(send_1, "administrator :: COM: NEG DATA: --administrator--\n\n", BUF_MAX);
         send_2 = safe_memcpy(send_2, "administrator :: COM: SETG: DATA: MAIL_FROM:", BUF_MAX);
         send_2 = safe_strncat(send_2, argv[2], BUF_MAX);
         send_2 = safe_strncat(send_2, "\n\n", BUF_MAX);
         }
      else{
         printf("ERR: argv[2] err.\n");
         help_out();
         free(send_1);
         free(send_2);
         return -1;
         }
      }

   else if(0 == self_memcmp(argv[1], "MAIL_RCPTTO")){
      if(2 < (int)strlen(argv[2])){
         send_1 = safe_memcpy(send_1, "administrator :: COM: NEG DATA: --administrator--\n\n", BUF_MAX);
         send_2 = safe_memcpy(send_2, "administrator :: COM: SETG: DATA: MAIL_RCPTTO:", BUF_MAX);
         send_2 = safe_strncat(send_2, argv[2], BUF_MAX);
         send_2 = safe_strncat(send_2, "\n\n", BUF_MAX);
         }
      else{
         printf("ERR: argv[2] err.\n");
         help_out();
         free(send_1);
         free(send_2);
         return -1;
         }
      }

   else if(0 == self_memcmp(argv[1], "MAIL_CC")){
      if(2 < (int)strlen(argv[2])){
         send_1 = safe_memcpy(send_1, "administrator :: COM: NEG DATA: --administrator--\n\n", BUF_MAX);
         send_2 = safe_memcpy(send_2, "administrator :: COM: SETG: DATA: MAIL_CC:", BUF_MAX);
         send_2 = safe_strncat(send_2, argv[2], BUF_MAX);
         send_2 = safe_strncat(send_2, "\n\n", BUF_MAX);
         }
      else{
         printf("ERR: argv[2] err.\n");
         help_out();
         free(send_1);
         free(send_2);
         return -1;
         }
      }

   else if(0 == self_memcmp(argv[1], "LIST")){
      if(0 == self_memcmp(argv[2], "ON")){
         send_1 = safe_memcpy(send_1, "administrator :: COM: NEG DATA: --administrator--\n\n", BUF_MAX);
         send_2 = safe_memcpy(send_2, "administrator :: COM: STATG: DATA: --\n\n", BUF_MAX);
         }
      else{
         printf("ERR: argv[2] err.\n");
         help_out();
         free(send_1);
         free(send_2);
         return -1;
         }
      }

   else{
      printf("ERR: argv[1] err.\n");
      help_out();
      free(send_1);
      free(send_2);
      return -1;
      }
   }
else{
   printf("ERR: argc count err.\n");
   help_out();
   free(send_1);
   free(send_2);
   return -1;
   }


ip_addr = "127.0.0.1";
port = 9988;
sk = 0;
ret = 0;
stat = 0;
onoffstat = 0;
getdata = (char *)calloc(2, sizeof(char));



if((sk = socket(AF_INET, SOCK_STREAM, 0))==-1){
   fprintf(stderr,"Not cleate socket line=%d file=%s err=%s\n", __LINE__, __FILE__, strerror(errno));
   ret = -1;
   free(getdata);
   free(send_1);
   free(send_2);
   return(ret);
   }

my_addr.sin_family = AF_INET;
my_addr.sin_port = htons(port);
my_addr.sin_addr.s_addr = inet_addr(ip_addr);

if(connect(sk, (struct sockaddr *)(long int)&my_addr, sizeof(my_addr)) == -1){
   fprintf(stderr,"Not connection line=%d file=%s err=%s\n", __LINE__, __FILE__, strerror(errno));
   close(sk);
   free(getdata);
   free(send_1);
   free(send_2);
   ret = -1;
   return(ret);
   }

printf("SEND1 : %s\n", send_1);
if(socket_send(sk, send_1, 5) < 0){
   fprintf(stderr,"Not send data 'NEG send' line=%d file=%s err=%s\n", __LINE__, __FILE__, strerror(errno));
   fprintf(stderr,"Check administrator user login.\n");
   close(sk);
   free(getdata);
   free(send_1);
   free(send_2);
   ret = -1;
   return(ret);
   }

getdata = select_fdcat_2(sk, getdata, 5, &stat);
if(stat < 0){
   fprintf(stderr,"Not recv data 'NEG return' line=%d file=%s err=%s\n", __LINE__, __FILE__, strerror(errno));
   close(sk);
   free(getdata);
   free(send_1);
   free(send_2);
   ret = -1;
   return(ret);
   }
else{
   if(0 == memcmp(getdata, "200 OK\n", 7)){
      printf("OK RECV : %s\n", getdata);
      }
   else{
      printf("NG RECV : %s\n", getdata);
      close(sk);
      free(getdata);
      free(send_1);
      free(send_2);
      return(ret);
      }
   }


printf("SEND2 : %s\n", send_2);
onoffstat = socket_send(sk, send_2, 5);

if(onoffstat < 0){
   fprintf(stderr,"Not send data 'SETG send' line=%d file=%s err=%s\n", __LINE__, __FILE__, strerror(errno));
   close(sk);
   free(getdata);
   free(send_1);
   free(send_2);
   ret = -1;
   return(ret);
   }

getdata = select_fdcat_2(sk, getdata, 5, &stat);
swap_mem(getdata, ';', '\n', (int)strlen(getdata));

if(stat < 0){
   fprintf(stderr,"Not recv data 'SETG return' line=%d file=%s err=%s\n", __LINE__, __FILE__, strerror(errno));
   close(sk);
   free(getdata);
   free(send_1);
   free(send_2);
   ret = -1;
   return(ret);
   }
else{
   if(0 == memcmp(getdata, "200 OK", 6)){
      printf("NG RECV : \n%s\n", getdata);
      }
   else{
      printf("NG RECV : \n%s\n", getdata);
      close(sk);
      free(getdata);
      free(send_1);
      free(send_2);
      return(ret);
      }
   }


close(sk);
free(getdata);
free(send_1);
free(send_2);
return(ret);
}



int help_out(void)
{
printf("\n");
printf("--- 'zitherset' は、動作中のzitherの設定を変更する為のコマンドです ---\n");
printf("\n");
printf("\n");
printf("オプションは以下のように、、、\n");
printf("\n");
printf("メール送信を全て止めるには以下をタイプ\n");
printf("   ./zitherset MAIL_ON OFF <return>\n");
printf("\n");
printf("メール送信を再開するには以下をタイプ\n");
printf("   ./zitherset MAIL_ON ON <return>\n");
printf("\n");
printf("送信メールのFrom：をセットするには以下をタイプ\n");
printf("   ./zitherset MAIL_FROM zither@zither.ms-n.com <return>\n");
printf("\n");
printf("送信メールの送信先（To)をセットするには以下をタイプ\n");
printf("   ./zitherset MAIL_RCPTTO zither@zither.ms-n.com <return>\n");
printf("\n");
printf("送信メールの送信先（Cc)をセットするには以下をタイプ\n");
printf("   ./zitherset MAIL_CC zither@zither.ms-n.com <return>\n");
printf("\n");
printf("SMTPサーバをセットするには以下をタイプ\n");
printf("   ./zitherset MAIL_SERV 127.0.0.1 <return>\n");
printf("\n");
printf("そのサーバの現在の設定状況を確認\n");
printf("   ./zitherset LIST ON <return>\n");
printf("\n");
printf("\n");
printf("このコマンドを使うには 'neg.conf' に以下の記載が必要です\n");
printf("'administrator:127.0.0.1'\n");
printf("\n");
printf("意味、、、\n");
printf("administrator ユーザーに 127.0.0.1 へのアクセスを許可してください。\n");
printf("\n");
return 0;
}











