# ImapGoose

[Source](https://git.sr.ht/~whynothugo/ImapGoose)
| [Issues](https://todo.sr.ht/~whynothugo/ImapGoose)
| [Patches](https://lists.sr.ht/~whynothugo/public-inbox)
| [Chat](irc://ircs.libera.chat:6697/#whynothugo)

Keep local Maildir directories synchronised with an IMAP server.

## Features

- Bidirectional synchronisation using the same algorithm as offlineimap.
- Automatic mailbox discovery: synchronises all mailboxes on the server.
- Real-time updates using IMAP NOTIFY for instant email synchronisation.
- Daemon mode for continuous synchronisation.
- Concurrent syncing of multiple accounts and all mailboxes.

## Requirements

- Go 1.21 or later
- IMAP server with the following capabilities:
  - UIDPLUS (rfc4315, 2005)
  - CONDSTORE (rfc4551, 2006)
  - QRESYNC (rfc5162/rfc7162, 2008/2014)
  - NOTIFY (rfc5465, 2009)

## Build

```sh
make build
```

## Installation

```sh
make install PREFIX=/usr
```

## Configuration

Create a configuration file at `~/.config/imapgoose/config.scfg`:

```scfg
account personal {
    server imap.example.com:993
    username user@example.com
    password your_password_here
    local-path ~/mail/
}
```

See `config.example.scfg` for more details.

## Usage

### Run the daemon

```sh
imapgoose
```

Or with a specific configuration file and verbose logging:

```sh
imapgoose -config ~/path/to/config.scfg -verbose
```

### Check server capabilities

Use the included `capcheck` tool to verify your IMAP server supports the
required capabilities:

```sh
make capcheck
echo "your_password" | ./capcheck -server imap.example.com:993 -username user@example.com
```

## How It Works

ImapGoose implements the same general synchronisation algorithm as offlineimap.
See: <https://blog.ezyang.com/2012/08/how-offlineimap-works/>.

Additionally, it listens to NOTIFY events for real-time server notifications of
changes.

## Licence

Copyright 2025 Hugo Osvaldo Barrera  
Licensed under the ISC licence
