package sync

import (
	"testing"

	"github.com/emersion/go-imap/v2"
)

func TestFlagsEqual(t *testing.T) {
	tests := []struct {
		name string
		a    []imap.Flag
		b    []imap.Flag
		want bool
	}{
		{
			name: "both empty",
			a:    nil,
			b:    nil,
			want: true,
		},
		{
			name: "both empty non-nil",
			a:    []imap.Flag{},
			b:    []imap.Flag{},
			want: true,
		},
		{
			name: "one empty one not",
			a:    nil,
			b:    []imap.Flag{imap.FlagSeen},
			want: false,
		},
		{
			name: "same single flag",
			a:    []imap.Flag{imap.FlagSeen},
			b:    []imap.Flag{imap.FlagSeen},
			want: true,
		},
		{
			name: "different single flag",
			a:    []imap.Flag{imap.FlagSeen},
			b:    []imap.Flag{imap.FlagFlagged},
			want: false,
		},
		{
			name: "same multiple flags same order",
			a:    []imap.Flag{imap.FlagSeen, imap.FlagFlagged},
			b:    []imap.Flag{imap.FlagSeen, imap.FlagFlagged},
			want: true,
		},
		{
			name: "same multiple flags different order",
			a:    []imap.Flag{imap.FlagSeen, imap.FlagFlagged},
			b:    []imap.Flag{imap.FlagFlagged, imap.FlagSeen},
			want: true,
		},
		{
			name: "different multiple flags",
			a:    []imap.Flag{imap.FlagSeen, imap.FlagFlagged},
			b:    []imap.Flag{imap.FlagSeen, imap.FlagAnswered},
			want: false,
		},
		{
			name: "different lengths",
			a:    []imap.Flag{imap.FlagSeen},
			b:    []imap.Flag{imap.FlagSeen, imap.FlagFlagged},
			want: false,
		},
	}

	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			got := flagsEqual(tt.a, tt.b)
			if got != tt.want {
				t.Errorf("FlagsEqual(%v, %v) = %v, want %v", tt.a, tt.b, got, tt.want)
			}

			// Symmetric test:
			got = flagsEqual(tt.b, tt.a)
			if got != tt.want {
				t.Errorf("FlagsEqual(%v, %v) = %v, want %v", tt.b, tt.a, got, tt.want)
			}
		})
	}
}
