/* COPYING ******************************************************************
For copyright and licensing terms, see the file named COPYING.
// **************************************************************************
*/

#include <cstring>
#include <cstdlib>
#include <iostream>
#include <iomanip>
#include <unistd.h>
#include <poll.h>
#include "redo.h"
#include "jobserver.h"

/* The GNU make jobserver ***************************************************
// **************************************************************************
*/

using namespace jobserver;

int jobserver::fds[2] = { -1, -1 };

static unsigned implicit_jobs = 1;

bool
jobserver::try_procure_slot(
	const char * prog
) {
	if (implicit_jobs) {
		--implicit_jobs;
		if (debug) {
			msg(prog, "INFO") << "Procured implicit job slot that is this process itself.\n";
		}
		return true;
	}
	if (-1 != fds[0]) {
		pollfd p;
		p.fd = fds[0];
		p.events = POLLIN;
		const int r0(poll(&p, sizeof p/sizeof(pollfd), 0));
		if ((0 <= r0) && (p.revents & POLLIN)) {
			char c;
			const ssize_t r(read(fds[0], &c, sizeof c));
			if (debug) {
				if (0 < r)
					msg(prog, "INFO") << "Procured a job slot from the jobserver.\n";
				else
					msg(prog, "INFO") << "Failed to procure a job slot from the jobserver.\n";
			}
			return 0 < r;
		}
	}
	return false;
}

bool
jobserver::procure_slot(
	const char * prog
) {
	if (implicit_jobs) {
		--implicit_jobs;
		if (debug) {
			msg(prog, "INFO") << "Procured implicit job slot that is this process itself.\n";
		}
		return true;
	}
	if (-1 != fds[0]) {
		char c;
		const ssize_t r(read(fds[0], &c, sizeof c));
		if (debug) {
			if (0 < r)
				msg(prog, "INFO") << "Procured a job slot from the jobserver.\n";
			else
				msg(prog, "INFO") << "Failed to procure a job slot from the jobserver.\n";
		}
		return 0 < r;
	}
	return false;
}

void
jobserver::vacate_slot(
	const char * prog
) {
	if (!implicit_jobs) {
		++implicit_jobs;
		if (debug) {
			msg(prog, "INFO") << "Vacated implicit job slot that is this process itself.\n";
		}
	} else
	if (-1 != fds[1]) {
		const char c('\0');
		write(fds[1], &c, sizeof c);
		if (debug) {
			msg(prog, "INFO") << "Vacated a job slot to the jobserver.\n";
		}
	}
}
