/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.newsclub.net.unix.AFUNIXDatagramChannel;
import org.newsclub.net.unix.AFUNIXDatagramSocket;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXServerSocketChannel;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.NativeUnixSocket;
import org.newsclub.net.unix.RAFChannelProvider;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class FileDescriptorCast {
    private final FileDescriptor fdObj;
    private int localPort = 0;
    private int remotePort = 0;
    private static final CastingProviderMap GLOBAL_PROVIDERS_FINAL = new CastingProviderMap(){

        @Override
        protected void addProviders() {
            this.addProvider(FileDescriptor.class, new CastingProvider<FileDescriptor>(){

                @Override
                public FileDescriptor provideAs(FileDescriptorCast fdc, Class<? super FileDescriptor> desiredType) throws IOException {
                    return fdc.getFileDescriptor();
                }
            });
        }
    };
    private static final CastingProviderMap GLOBAL_PROVIDERS = new CastingProviderMap(){

        @Override
        protected void addProviders() {
            this.addProvider(WritableByteChannel.class, new CastingProvider<WritableByteChannel>(){

                @Override
                public WritableByteChannel provideAs(FileDescriptorCast fdc, Class<? super WritableByteChannel> desiredType) throws IOException {
                    return new FileOutputStream(fdc.getFileDescriptor()).getChannel();
                }
            });
            this.addProvider(ReadableByteChannel.class, new CastingProvider<ReadableByteChannel>(){

                @Override
                public ReadableByteChannel provideAs(FileDescriptorCast fdc, Class<? super ReadableByteChannel> desiredType) throws IOException {
                    return new FileInputStream(fdc.getFileDescriptor()).getChannel();
                }
            });
            this.addProvider(FileChannel.class, new CastingProvider<FileChannel>(){

                @Override
                public FileChannel provideAs(FileDescriptorCast fdc, Class<? super FileChannel> desiredType) throws IOException {
                    return RAFChannelProvider.getFileChannel(fdc.getFileDescriptor());
                }
            });
            this.addProvider(FileOutputStream.class, new CastingProvider<FileOutputStream>(){

                @Override
                public FileOutputStream provideAs(FileDescriptorCast fdc, Class<? super FileOutputStream> desiredType) throws IOException {
                    return new FileOutputStream(fdc.getFileDescriptor());
                }
            });
            this.addProvider(FileInputStream.class, new CastingProvider<FileInputStream>(){

                @Override
                public FileInputStream provideAs(FileDescriptorCast fdc, Class<? super FileInputStream> desiredType) throws IOException {
                    return new FileInputStream(fdc.getFileDescriptor());
                }
            });
        }
    };
    private static final Map<Class<?>, CastingProviderMap> PRIMARY_TYPE_PROVIDERS_MAP = new HashMap();
    private final CastingProviderMap cpm;

    private FileDescriptorCast(FileDescriptor fdObj, CastingProviderMap cpm) {
        this.fdObj = Objects.requireNonNull(fdObj);
        this.cpm = Objects.requireNonNull(cpm);
    }

    private static void registerCastingProviders(Class<?> primaryType, CastingProviderMap cpm) {
        PRIMARY_TYPE_PROVIDERS_MAP.put(primaryType, cpm);
    }

    public static FileDescriptorCast using(FileDescriptor fdObj) throws IOException {
        if (!fdObj.valid()) {
            throw new IOException("Not a valid file descriptor");
        }
        Class<?> primaryType = NativeUnixSocket.primaryType(fdObj);
        if (primaryType == null) {
            throw new IOException("Unsupported file descriptor");
        }
        CastingProviderMap map = PRIMARY_TYPE_PROVIDERS_MAP.get(primaryType);
        return new FileDescriptorCast(fdObj, map == null ? GLOBAL_PROVIDERS : map);
    }

    public FileDescriptorCast withLocalPort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException();
        }
        this.localPort = port;
        return this;
    }

    public FileDescriptorCast withRemotePort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException();
        }
        this.remotePort = port;
        return this;
    }

    public <K> @NonNull K as(Class<K> desiredType) throws IOException {
        Objects.requireNonNull(desiredType);
        CastingProvider<K> provider = this.cpm.get(desiredType);
        if (provider != null) {
            K obj = desiredType.cast(provider.provideAs(this, desiredType));
            Objects.requireNonNull(obj);
            return obj;
        }
        throw new ClassCastException("Cannot access file descriptor as " + desiredType);
    }

    public boolean isAvailable(Class<?> desiredType) throws IOException {
        return this.cpm.providers.containsKey(desiredType);
    }

    public Set<Class<?>> availableTypes() {
        return this.cpm.classes;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public FileDescriptor getFileDescriptor() {
        return this.fdObj;
    }

    static {
        FileDescriptorCast.registerCastingProviders(AFUNIXSocket.class, new CastingProviderMap(){

            @Override
            protected void addProviders() {
                this.addProviders(GLOBAL_PROVIDERS);
                final CastingProvider<AFUNIXSocket> cpSocket = new CastingProvider<AFUNIXSocket>(){

                    @Override
                    public AFUNIXSocket provideAs(FileDescriptorCast fdc, Class<? super AFUNIXSocket> desiredType) throws IOException {
                        return AFUNIXSocket.newInstance(fdc.getFileDescriptor(), fdc.localPort, fdc.remotePort);
                    }
                };
                final CastingProvider<AFUNIXServerSocket> cpServerSocket = new CastingProvider<AFUNIXServerSocket>(){

                    @Override
                    public AFUNIXServerSocket provideAs(FileDescriptorCast fdc, Class<? super AFUNIXServerSocket> desiredType) throws IOException {
                        return AFUNIXServerSocket.newInstance(fdc.getFileDescriptor(), fdc.localPort, fdc.remotePort);
                    }
                };
                this.addProvider(AFUNIXSocketChannel.class, new CastingProvider<AFUNIXSocketChannel>(){

                    @Override
                    public AFUNIXSocketChannel provideAs(FileDescriptorCast fdc, Class<? super AFUNIXSocketChannel> desiredType) throws IOException {
                        return cpSocket.provideAs(fdc, AFUNIXSocket.class).getChannel();
                    }
                });
                this.addProvider(AFUNIXServerSocketChannel.class, new CastingProvider<AFUNIXServerSocketChannel>(){

                    @Override
                    public AFUNIXServerSocketChannel provideAs(FileDescriptorCast fdc, Class<? super AFUNIXServerSocketChannel> desiredType) throws IOException {
                        return cpServerSocket.provideAs(fdc, AFUNIXServerSocket.class).getChannel();
                    }
                });
                this.addProvider(AFUNIXSocket.class, cpSocket);
                this.addProvider(AFUNIXServerSocket.class, cpServerSocket);
            }
        });
        FileDescriptorCast.registerCastingProviders(AFUNIXDatagramSocket.class, new CastingProviderMap(){

            @Override
            protected void addProviders() {
                this.addProviders(GLOBAL_PROVIDERS);
                final CastingProvider<AFUNIXDatagramSocket> cpDatagramSocket = new CastingProvider<AFUNIXDatagramSocket>(){

                    @Override
                    public AFUNIXDatagramSocket provideAs(FileDescriptorCast fdc, Class<? super AFUNIXDatagramSocket> desiredType) throws IOException {
                        return AFUNIXDatagramSocket.newInstance(fdc.getFileDescriptor(), fdc.localPort, fdc.remotePort);
                    }
                };
                this.addProvider(AFUNIXDatagramChannel.class, new CastingProvider<AFUNIXDatagramChannel>(){

                    @Override
                    public AFUNIXDatagramChannel provideAs(FileDescriptorCast fdc, Class<? super AFUNIXDatagramChannel> desiredType) throws IOException {
                        return cpDatagramSocket.provideAs(fdc, AFUNIXDatagramSocket.class).getChannel();
                    }
                });
                this.addProvider(AFUNIXDatagramSocket.class, cpDatagramSocket);
            }
        });
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static interface CastingProvider<T> {
        public T provideAs(FileDescriptorCast var1, Class<? super T> var2) throws IOException;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static abstract class CastingProviderMap {
        private final Map<Class<?>, CastingProvider<?>> providers = new HashMap();
        private final Set<Class<?>> classes = Collections.unmodifiableSet(this.providers.keySet());

        protected CastingProviderMap() {
            this.addProviders();
            this.addProviders(GLOBAL_PROVIDERS_FINAL);
        }

        protected abstract void addProviders();

        protected final <T> void addProvider(Class<T> type, CastingProvider<? extends T> cp) {
            Objects.requireNonNull(type);
            this.addProvider0(type, cp);
        }

        private void addProvider0(Class<?> type, CastingProvider<?> cp) {
            if (this.providers.put(type, cp) != cp) {
                for (Class<?> cl : type.getInterfaces()) {
                    this.addProvider0(cl, cp);
                }
                Class<?> scl = type.getSuperclass();
                if (scl != null) {
                    this.addProvider0(scl, cp);
                }
            }
        }

        protected final void addProviders(CastingProviderMap other) {
            if (other == null || other == this) {
                return;
            }
            this.providers.putAll(other.providers);
        }

        public <T> CastingProvider<? extends T> get(Class<T> desiredType) {
            return this.providers.get(desiredType);
        }
    }
}

