/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.ExcludeFromCodeCoverageGeneratedReport;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import org.newsclub.net.unix.AFUNIXSelector;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.AFUNIXSocketImpl;
import org.newsclub.net.unix.AncillaryDataSupport;
import org.newsclub.net.unix.NativeLibraryLoader;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class NativeUnixSocket {
    private static boolean loaded;
    static final int SOCK_STREAM = 1;
    static final int SOCK_DGRAM = 2;
    static final int SOCK_SEQPACKET = 5;
    static final int OPT_LOOKUP_SENDER = 1;
    static final int OPT_PEEK = 2;
    static final int OPT_NON_BLOCKING = 4;
    static final int OPT_NON_SOCKET = 8;
    static final int SOCKETSTATUS_INVALID = -1;
    static final int SOCKETSTATUS_UNKNOWN = 0;
    static final int SOCKETSTATUS_BOUND = 1;
    static final int SOCKETSTATUS_CONNECTED = 2;

    @ExcludeFromCodeCoverageGeneratedReport
    private NativeUnixSocket() {
        throw new UnsupportedOperationException("No instances");
    }

    static boolean isLoaded() {
        return loaded;
    }

    static void checkSupported() {
    }

    static native void init() throws Exception;

    static native void destroy() throws Exception;

    static native int capabilities();

    static native byte[] sockname(FileDescriptor var0, boolean var1);

    static native long bind(byte[] var0, FileDescriptor var1, int var2) throws IOException;

    static native void listen(FileDescriptor var0, int var1) throws IOException;

    static native boolean accept(byte[] var0, FileDescriptor var1, FileDescriptor var2, long var3, int var5) throws IOException;

    static native boolean connect(byte[] var0, FileDescriptor var1, long var2) throws IOException;

    static native boolean finishConnect(FileDescriptor var0) throws IOException;

    static native void disconnect(FileDescriptor var0) throws IOException;

    static native int socketStatus(FileDescriptor var0) throws IOException;

    static native Class<?> primaryType(FileDescriptor var0) throws IOException;

    static native int read(FileDescriptor var0, byte[] var1, int var2, int var3, AncillaryDataSupport var4, int var5) throws IOException;

    static native int write(FileDescriptor var0, byte[] var1, int var2, int var3, AncillaryDataSupport var4) throws IOException;

    static native int receive(FileDescriptor var0, ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, AncillaryDataSupport var6, int var7) throws IOException;

    static native int send(FileDescriptor var0, ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, AncillaryDataSupport var6) throws IOException;

    static native void close(FileDescriptor var0) throws IOException;

    static native void shutdown(FileDescriptor var0, int var1) throws IOException;

    static native int getSocketOptionInt(FileDescriptor var0, int var1) throws IOException;

    static native void setSocketOptionInt(FileDescriptor var0, int var1, int var2) throws IOException;

    static native int available(FileDescriptor var0) throws IOException;

    static native AFUNIXSocketCredentials peerCredentials(FileDescriptor var0, AFUNIXSocketCredentials var1) throws IOException;

    static native void initServerImpl(ServerSocket var0, AFUNIXSocketImpl var1) throws IOException;

    static native void createSocket(FileDescriptor var0, int var1) throws IOException;

    static native void setPort(AFUNIXSocketAddress var0, int var1);

    static native void initFD(FileDescriptor var0, int var1) throws IOException;

    static native int getFD(FileDescriptor var0) throws IOException;

    static native void copyFileDescriptor(FileDescriptor var0, FileDescriptor var1) throws IOException;

    static native void attachCloseable(FileDescriptor var0, Closeable var1);

    static native int maxAddressLength();

    static native int sockAddrUnLength();

    static native byte[] sockAddrUnToBytes(ByteBuffer var0);

    static native void bytesToSockAddrUn(ByteBuffer var0, byte[] var1);

    static void setPort1(AFUNIXSocketAddress addr, int port) throws SocketException {
        if (port < 0) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
        try {
            NativeUnixSocket.setPort(addr, port);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw (SocketException)new SocketException("Could not set port").initCause(e);
        }
    }

    static native Socket currentRMISocket();

    static native boolean initPipe(FileDescriptor var0, FileDescriptor var1, boolean var2) throws IOException;

    static native int poll(AFUNIXSelector.PollFd var0, int var1);

    static native void configureBlocking(FileDescriptor var0, boolean var1) throws IOException;

    static native void socketPair(int var0, FileDescriptor var1, FileDescriptor var2);

    static {
        try (NativeLibraryLoader nll = new NativeLibraryLoader();){
            nll.loadLibrary();
        }
        loaded = true;
    }
}

