/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.testng.IClass;
import org.testng.IDataProviderMethod;
import org.testng.IRetryAnalyzer;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.Lists;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.XmlTestUtils;
import org.testng.xml.XmlTest;

public class LiteWeightTestNGMethod
implements ITestNGMethod {
    private final Class<?> realClass;
    private ITestClass testClass;
    private final String methodName;
    private final Object instance;
    private final long[] instanceHashCodes;
    private final String[] groups;
    private final String[] groupsDependedUpon;
    private String missingGroup;
    private final String[] beforeGroups;
    private final String[] afterGroups;
    private final List<String> methodsDependedUpon = new LinkedList<String>();
    private int priority;
    private int interceptedPriority;
    private final XmlTest xmlTest;
    private final String qualifiedName;
    private final boolean isBeforeTestConfiguration;
    private final boolean isAfterTestConfiguration;
    private final boolean isBeforeGroupsConfiguration;
    private final boolean isAfterGroupsConfiguration;
    private final boolean isTest;
    private final boolean isBeforeMethodConfiguration;
    private final boolean isAfterMethodConfiguration;
    private final boolean isBeforeClassConfiguration;
    private final boolean isAfterClassConfiguration;
    private final boolean isBeforeSuiteConfiguration;
    private final boolean isAfterSuiteConfiguration;
    private List<Integer> invocationNumbers;
    private final List<Integer> failedInvocationNumbers;
    private boolean ignoreMissingDependencies;
    private final long invocationTimeout;
    private boolean skipFailedInvocations;
    private long timeout;
    private int invocationCount;
    private final int successPercentage;
    private String id;
    private long date;
    private final boolean isAlwaysRun;
    private int threadPoolSize;
    private final boolean enabled;
    private String description;
    private final int currentInvocationCount;
    private int parameterInvocationCount;
    private final boolean hasMoreInvocation;
    private final Class<? extends IRetryAnalyzer> retryAnalyzerClass;
    private final String toString;
    private final IDataProviderMethod dataProviderMethod;
    private final int hashCode;
    private final Class<?>[] parameterTypes;

    public LiteWeightTestNGMethod(ITestNGMethod iTestNGMethod) {
        this.realClass = iTestNGMethod.getRealClass();
        this.testClass = iTestNGMethod.getTestClass();
        this.methodName = iTestNGMethod.getMethodName();
        this.instance = iTestNGMethod.getInstance();
        this.instanceHashCodes = iTestNGMethod.getInstanceHashCodes();
        this.groups = iTestNGMethod.getGroups();
        this.groupsDependedUpon = iTestNGMethod.getGroupsDependedUpon();
        this.missingGroup = iTestNGMethod.getMissingGroup();
        this.beforeGroups = iTestNGMethod.getBeforeGroups();
        this.afterGroups = iTestNGMethod.getAfterGroups();
        if (iTestNGMethod.getMethodsDependedUpon() != null) {
            this.methodsDependedUpon.addAll(Arrays.asList(iTestNGMethod.getMethodsDependedUpon()));
        }
        this.priority = iTestNGMethod.getPriority();
        this.interceptedPriority = iTestNGMethod.getInterceptedPriority();
        this.xmlTest = iTestNGMethod.getXmlTest();
        this.qualifiedName = iTestNGMethod.getQualifiedName();
        this.isBeforeTestConfiguration = iTestNGMethod.isBeforeTestConfiguration();
        this.isAfterTestConfiguration = iTestNGMethod.isAfterTestConfiguration();
        this.isBeforeGroupsConfiguration = iTestNGMethod.isBeforeGroupsConfiguration();
        this.isAfterGroupsConfiguration = iTestNGMethod.isAfterGroupsConfiguration();
        this.isTest = iTestNGMethod.isTest();
        this.isBeforeMethodConfiguration = iTestNGMethod.isBeforeMethodConfiguration();
        this.isAfterMethodConfiguration = iTestNGMethod.isAfterMethodConfiguration();
        this.isBeforeClassConfiguration = iTestNGMethod.isBeforeClassConfiguration();
        this.isAfterClassConfiguration = iTestNGMethod.isAfterClassConfiguration();
        this.isBeforeSuiteConfiguration = iTestNGMethod.isBeforeSuiteConfiguration();
        this.isAfterSuiteConfiguration = iTestNGMethod.isAfterSuiteConfiguration();
        this.invocationNumbers = iTestNGMethod.getInvocationNumbers();
        this.failedInvocationNumbers = iTestNGMethod.getFailedInvocationNumbers();
        this.ignoreMissingDependencies = iTestNGMethod.ignoreMissingDependencies();
        this.invocationTimeout = iTestNGMethod.getInvocationTimeOut();
        this.skipFailedInvocations = iTestNGMethod.skipFailedInvocations();
        this.timeout = iTestNGMethod.getTimeOut();
        this.invocationCount = iTestNGMethod.getInvocationCount();
        this.successPercentage = iTestNGMethod.getSuccessPercentage();
        this.id = iTestNGMethod.getId();
        this.date = iTestNGMethod.getDate();
        this.isAlwaysRun = iTestNGMethod.isAlwaysRun();
        this.threadPoolSize = iTestNGMethod.getThreadPoolSize();
        this.enabled = iTestNGMethod.getEnabled();
        this.description = iTestNGMethod.getDescription();
        this.currentInvocationCount = iTestNGMethod.getCurrentInvocationCount();
        this.parameterInvocationCount = iTestNGMethod.getParameterInvocationCount();
        this.hasMoreInvocation = iTestNGMethod.hasMoreInvocation();
        this.retryAnalyzerClass = iTestNGMethod.getRetryAnalyzerClass();
        this.toString = iTestNGMethod.toString();
        final IDataProviderMethod dp = iTestNGMethod.getDataProviderMethod();
        this.dataProviderMethod = new IDataProviderMethod(){

            @Override
            public Object getInstance() {
                return dp.getInstance();
            }

            @Override
            public Method getMethod() {
                throw new UnsupportedOperationException("method() retrieval not supported");
            }

            @Override
            public String getName() {
                if (dp == null) {
                    return "";
                }
                return dp.getName();
            }

            @Override
            public boolean isParallel() {
                if (dp == null) {
                    return false;
                }
                return dp.isParallel();
            }

            @Override
            public List<Integer> getIndices() {
                if (dp == null) {
                    return Lists.newArrayList();
                }
                return dp.getIndices();
            }
        };
        this.hashCode = iTestNGMethod.hashCode();
        this.parameterTypes = iTestNGMethod.getConstructorOrMethod().getParameterTypes();
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Class getRealClass() {
        return this.realClass;
    }

    @Override
    public ITestClass getTestClass() {
        return this.testClass;
    }

    @Override
    public void setTestClass(ITestClass cls) {
        this.testClass = cls;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public Object getInstance() {
        return this.instance;
    }

    @Override
    public long[] getInstanceHashCodes() {
        return this.instanceHashCodes;
    }

    @Override
    public String[] getGroups() {
        return this.groups;
    }

    @Override
    public String[] getGroupsDependedUpon() {
        return this.groupsDependedUpon;
    }

    @Override
    public String getMissingGroup() {
        return this.missingGroup;
    }

    @Override
    public void setMissingGroup(String group) {
        this.missingGroup = group;
    }

    @Override
    public String[] getBeforeGroups() {
        return this.beforeGroups;
    }

    @Override
    public String[] getAfterGroups() {
        return this.afterGroups;
    }

    @Override
    public String[] getMethodsDependedUpon() {
        return this.methodsDependedUpon.toArray(new String[0]);
    }

    @Override
    public void addMethodDependedUpon(String methodName) {
        this.methodsDependedUpon.add(methodName);
    }

    @Override
    public boolean isTest() {
        return this.isTest;
    }

    @Override
    public boolean isBeforeMethodConfiguration() {
        return this.isBeforeMethodConfiguration;
    }

    @Override
    public boolean isAfterMethodConfiguration() {
        return this.isAfterMethodConfiguration;
    }

    @Override
    public boolean isBeforeClassConfiguration() {
        return this.isBeforeClassConfiguration;
    }

    @Override
    public boolean isAfterClassConfiguration() {
        return this.isAfterClassConfiguration;
    }

    @Override
    public boolean isBeforeSuiteConfiguration() {
        return this.isBeforeSuiteConfiguration;
    }

    @Override
    public boolean isAfterSuiteConfiguration() {
        return this.isAfterSuiteConfiguration;
    }

    @Override
    public boolean isBeforeTestConfiguration() {
        return this.isBeforeTestConfiguration;
    }

    @Override
    public boolean isAfterTestConfiguration() {
        return this.isAfterTestConfiguration;
    }

    @Override
    public boolean isBeforeGroupsConfiguration() {
        return this.isBeforeGroupsConfiguration;
    }

    @Override
    public boolean isAfterGroupsConfiguration() {
        return this.isAfterGroupsConfiguration;
    }

    @Override
    public long getTimeOut() {
        return this.timeout;
    }

    @Override
    public void setTimeOut(long timeOut) {
        this.timeout = timeOut;
    }

    @Override
    public int getInvocationCount() {
        return this.invocationCount;
    }

    @Override
    public void setInvocationCount(int count) {
        this.invocationCount = count;
    }

    @Override
    public int getSuccessPercentage() {
        return this.successPercentage;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public long getDate() {
        return this.date;
    }

    @Override
    public void setDate(long date) {
        this.date = date;
    }

    @Override
    public boolean canRunFromClass(IClass testClass) {
        return this.getTestClass().getRealClass().isAssignableFrom(testClass.getRealClass());
    }

    @Override
    public boolean isAlwaysRun() {
        return this.isAlwaysRun;
    }

    @Override
    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    @Override
    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void incrementCurrentInvocationCount() {
    }

    @Override
    public int getCurrentInvocationCount() {
        return this.currentInvocationCount;
    }

    @Override
    public void setParameterInvocationCount(int n) {
        this.parameterInvocationCount = n;
    }

    @Override
    public int getParameterInvocationCount() {
        return this.parameterInvocationCount;
    }

    @Override
    public void setMoreInvocationChecker(Callable<Boolean> moreInvocationChecker) {
    }

    @Override
    public boolean hasMoreInvocation() {
        return this.hasMoreInvocation;
    }

    @Override
    public ITestNGMethod clone() {
        throw new UnsupportedOperationException("clone() not supported");
    }

    @Override
    public IRetryAnalyzer getRetryAnalyzer(ITestResult result) {
        throw new UnsupportedOperationException("getRetryAnalyzer() not supported");
    }

    @Override
    public void setRetryAnalyzerClass(Class<? extends IRetryAnalyzer> clazz) {
    }

    @Override
    public Class<? extends IRetryAnalyzer> getRetryAnalyzerClass() {
        return this.retryAnalyzerClass;
    }

    @Override
    public boolean skipFailedInvocations() {
        return this.skipFailedInvocations;
    }

    @Override
    public void setSkipFailedInvocations(boolean skip) {
        this.skipFailedInvocations = skip;
    }

    @Override
    public long getInvocationTimeOut() {
        return this.invocationTimeout;
    }

    @Override
    public boolean ignoreMissingDependencies() {
        return this.ignoreMissingDependencies;
    }

    @Override
    public void setIgnoreMissingDependencies(boolean ignore) {
        this.ignoreMissingDependencies = ignore;
    }

    @Override
    public List<Integer> getInvocationNumbers() {
        return this.invocationNumbers;
    }

    @Override
    public void setInvocationNumbers(List<Integer> numbers) {
        this.invocationNumbers = numbers;
    }

    @Override
    public void addFailedInvocationNumber(int number) {
        this.failedInvocationNumbers.add(number);
    }

    @Override
    public List<Integer> getFailedInvocationNumbers() {
        return this.failedInvocationNumbers;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getInterceptedPriority() {
        return this.interceptedPriority;
    }

    @Override
    public void setInterceptedPriority(int priority) {
        this.interceptedPriority = priority;
    }

    @Override
    public XmlTest getXmlTest() {
        return this.xmlTest;
    }

    @Override
    public ConstructorOrMethod getConstructorOrMethod() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Map<String, String> findMethodParameters(XmlTest test) {
        return XmlTestUtils.findMethodParameters(this.xmlTest, this.getTestClass().getName(), this.getMethodName());
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public IDataProviderMethod getDataProviderMethod() {
        return this.dataProviderMethod;
    }

    public String toString() {
        return this.toString;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ITestNGMethod)) {
            return false;
        }
        ITestNGMethod that = (ITestNGMethod)o;
        boolean value = this.realClass.equals(that.getRealClass()) && this.qualifiedName.equals(that.getQualifiedName()) && this.equalParamTypes(this.parameterTypes, that.getParameterTypes());
        return value;
    }

    boolean equalParamTypes(Class<?>[] params1, Class<?>[] params2) {
        if (params1.length == params2.length) {
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

