/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.util.Date;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;

public class SVNDirEntry
implements Comparable {
    public static final int DIRENT_KIND = 1;
    public static final int DIRENT_SIZE = 2;
    public static final int DIRENT_HAS_PROPERTIES = 4;
    public static final int DIRENT_CREATED_REVISION = 8;
    public static final int DIRENT_TIME = 16;
    public static final int DIRENT_LAST_AUTHOR = 32;
    public static final int DIRENT_COMMIT_MESSAGE = 64;
    public static final int DIRENT_ALL = -1;
    private String myName;
    private SVNNodeKind myKind;
    private long mySize;
    private boolean myHasProperties;
    private long myRevision;
    private Date myCreatedDate;
    private String myLastAuthor;
    private String myPath;
    private String myCommitMessage;
    private SVNLock myLock;
    private SVNURL myURL;
    private SVNURL myRepositoryRoot;
    private SVNURL myExternalParentUrl;
    private String myExternalTarget;

    public SVNDirEntry(SVNURL url, SVNURL repositoryRoot, String name, SVNNodeKind kind, long size, boolean hasProperties, long revision, Date createdDate, String lastAuthor) {
        this.myURL = url;
        this.myRepositoryRoot = repositoryRoot;
        this.myName = name;
        this.myKind = kind;
        this.mySize = size;
        this.myHasProperties = hasProperties;
        this.myRevision = revision;
        this.myCreatedDate = createdDate;
        this.myLastAuthor = lastAuthor;
    }

    public SVNDirEntry(SVNURL url, SVNURL repositoryRoot, String name, SVNNodeKind kind, long size, boolean hasProperties, long revision, Date createdDate, String lastAuthor, String commitMessage) {
        this.myURL = url;
        this.myRepositoryRoot = repositoryRoot;
        this.myName = name;
        this.myKind = kind;
        this.mySize = size;
        this.myHasProperties = hasProperties;
        this.myRevision = revision;
        this.myCreatedDate = createdDate;
        this.myLastAuthor = lastAuthor;
        this.myCommitMessage = commitMessage;
    }

    public SVNURL getURL() {
        return this.myURL;
    }

    public SVNURL getRepositoryRoot() {
        return this.myRepositoryRoot;
    }

    public String getName() {
        return this.myName;
    }

    public long getSize() {
        return this.mySize;
    }

    public long size() {
        return this.getSize();
    }

    public boolean hasProperties() {
        return this.myHasProperties;
    }

    public SVNNodeKind getKind() {
        return this.myKind;
    }

    public Date getDate() {
        return this.myCreatedDate;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public String getAuthor() {
        return this.myLastAuthor;
    }

    public String getRelativePath() {
        return this.myPath == null ? this.getName() : this.myPath;
    }

    public String getPath() {
        return this.getRelativePath();
    }

    public String getCommitMessage() {
        return this.myCommitMessage;
    }

    public SVNLock getLock() {
        return this.myLock;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void setRelativePath(String path) {
        this.myPath = path;
    }

    public void setCommitMessage(String message) {
        this.myCommitMessage = message;
    }

    public void setLock(SVNLock lock) {
        this.myLock = lock;
    }

    public SVNURL getExternalParentUrl() {
        return this.myExternalParentUrl;
    }

    public void setExternalParentUrl(SVNURL myExternalParentUrl) {
        this.myExternalParentUrl = myExternalParentUrl;
    }

    public String getExternalTarget() {
        return this.myExternalTarget;
    }

    public void setExternalTarget(String myExternalTarget) {
        this.myExternalTarget = myExternalTarget;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("name=");
        result.append(this.myName);
        result.append(", kind=");
        result.append(this.myKind);
        result.append(", size=");
        result.append(this.mySize);
        result.append(", hasProps=");
        result.append(this.myHasProperties);
        result.append(", lastchangedrev=");
        result.append(this.myRevision);
        if (this.myLastAuthor != null) {
            result.append(", lastauthor=");
            result.append(this.myLastAuthor);
        }
        if (this.myCreatedDate != null) {
            result.append(", lastchangeddate=");
            result.append(this.myCreatedDate);
        }
        return result.toString();
    }

    public int compareTo(Object o) {
        if (o == null || o.getClass() != SVNDirEntry.class) {
            return -1;
        }
        SVNNodeKind otherKind = ((SVNDirEntry)o).getKind();
        if (otherKind != this.getKind()) {
            return this.getKind().compareTo(otherKind);
        }
        String otherURL = ((SVNDirEntry)o).getURL().toString();
        return this.myURL.toString().compareTo(otherURL);
    }
}

