\name{cystfibr}
\alias{cystfibr}
\title{Cystic fibrosis lung function data}
\description{
  The \code{cystfibr} data frame has 25 rows and 10 columns.
  It contains lung function data for cystic fibrosis patients (7--23 years
  old).
}
\usage{cystfibr}
\format{
  This data frame contains the following columns:
  \describe{
    \item{\code{age}}{a numeric vector, age in years.}
    \item{\code{sex}}{a numeric vector code, 0: male, 1:female.}
    \item{\code{height}}{a numeric vector, height (cm).}
    \item{\code{weight}}{a numeric vector, weight (kg).}
    \item{\code{bmp}}{a numeric vector, body mass (\% of normal).}
    \item{\code{fev1}}{a numeric vector, forced expiratory volume.}
    \item{\code{rv}}{a numeric vector, residual volume.}
    \item{\code{frc}}{a numeric vector, functional residual capacity.}
    \item{\code{tlc}}{a numeric vector, total lung capacity.}
    \item{\code{pemax}}{a numeric vector, maximum expiratory pressure.}
  }
}
\source{
  D.G. Altman (1991), \emph{Practical Statistics for Medical Research}, Table
  12.11, Chapman & Hall.
}
\references{
  O'Neill et al. (1983), The effects of chronic hyperinflation,
  nutritional status, and posture on respiratory muscle strength in
  cystic fibrosis, \emph{Am. Rev. Respir. Dis.,} 128:1051--1054.
}
\keyword{datasets}
