% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proj_trans.R
\name{proj_trans}
\alias{proj_trans}
\title{Transform coordinates}
\usage{
proj_trans(x, target_crs, source_crs = NULL, ..., use_z = NA, use_m = NA)
}
\arguments{
\item{x}{Input geometry/geography. May take any of the following forms:
\itemize{
\item A coordinate matrix containing 2, 3 or 4 columns.
If named, expects column names "x", "y" and optionally "z" and/or "m". If
not named, columns are assumed in xyzm order. Non-coordinate columns are
removed.
\item A data.frame containing coordinates as columns. Expects names "x", "y" and
optionally "z" and/or "m". Non-coordinate columns are retained.
\item A data.frame containing a geometry vector which is readable by
\code{\link[wk:wk_handle]{wk::wk_handle()}}, including \code{sfc} columns.
\item A geometry vector which is readable by \code{\link[wk:wk_handle]{wk::wk_handle()}}, including \code{sfc}
columns.
}}

\item{source_crs, target_crs}{Source/Target CRS definition, coerced with \code{\link[wk:wk_crs_proj_definition]{wk::wk_crs_proj_definition()}}}

\item{...}{Additional parameters forwarded to \code{\link[wk:wk_handle]{wk::wk_handle()}}}

\item{use_z, use_m}{Used to declare the output type. Use \code{TRUE} to
ensure the output has that dimension, \code{FALSE} to ensure it does not,
and \code{NA} to leave the dimension unchanged.}
}
\value{
Transformed geometries whose format is dependent on input.
}
\description{
Transforms all coordinates in \code{x} using \code{\link[wk:wk_handle]{wk::wk_handle()}} and \code{\link[=proj_trans_create]{proj_trans_create()}}.
}
\details{
Values that are detected out of bounds by library PROJ are allowed, we return \code{Inf}
in this case, rather than the error "tolerance condition error".
}
\examples{
proj_trans(cbind(147, -42), "+proj=laea +type=crs", "EPSG:4326")
proj_trans(cbind(147, -42, -2), "+proj=laea +type=crs", "EPSG:4326")
proj_trans(cbind(147, -42, -2, 1), "+proj=laea +type=crs", "EPSG:4326")
proj_trans(wk::xy(147, -42, crs = "EPSG:4326"), "+proj=laea +type=crs")
proj_trans(wk::wkt("POLYGON ((1 1, 0 1, 0 0, 1 0, 1 1))", crs = "EPSG:4326"), 3112)

}
\references{
see the \href{https://proj.org/development/reference/functions.html#coordinate-transformation}{PROJ library documentation}
for details on the underlying functionality
}
