% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git-protocol.R
\name{git-protocol}
\alias{git-protocol}
\title{git protocol notes, for developers}
\description{
Assumptions, they might be relaxed or checked for later:
\itemize{
\item The server must speak the smart protocol, version 1 or 2.
(Although I added some functions specifically for the dumb protocol,
but they are pretty limited.)
\item We use HTTP transport, not SSH.
\item The server should have the \code{shallow} capability.
\item The server should have the \code{filter} capability if protocol version 2.
\item Only SHA-1 hashing is supported.
}
}
\details{
Improvements needed:
\itemize{
\item DONE Tests. (Can always have more.)
\item DONE Use async HTTP.
\item DONE Support packfiles with deltas. (\code{ofs-delta} objects are still
not supported.)
\item DONE Optionally send authorization. Already possibly in the URL.
\item DONE Better error messages.
\item Better errors for non-existing user, repository, ref, PR, etc.
}

Optional improvements:
\itemize{
\item Support \code{ofs-delta} objects in packfiles. Not necessarily, unless we
send this capability, the server is not sending \code{ofs-delta} objects.
\item Make unpacking faster. It is not fast currently, with all the bit
arithmetic in R. But it is already faster than a \code{tar.gz} + uncompress
download from GitHub, so not really needed.
}
\subsection{Docs and other helpful links:}{
\itemize{
\item \url{https://github.com/git/git/blob/master/Documentation/gitprotocol-common.txt}
\item \url{https://github.com/git/git/blob/master/Documentation/gitprotocol-pack.txt}
\item \url{https://github.com/git/git/blob/master/Documentation/gitprotocol-v2.txt}
\item \url{https://github.com/calebsander/git-internals/blob/part2/src/main.rs}
\item \url{https://dev.to/calebsander/git-internals-part-1-the-git-object-model-474m}
}
}
}
\keyword{internal}
