% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git-protocol.R
\name{git_download_file}
\alias{git_download_file}
\title{Download a blob for a remote git repository}
\usage{
git_download_file(url, sha, output = sha)
}
\arguments{
\item{url}{Repository URL, e.g. \verb{https://github.com/r-lib/pak.git}.
It might include authentication information, e.g. a GitHub token.}

\item{sha}{SHA hash of the blob.}

\item{output}{Path where the blob will be written. It's directory is
created if it does not exist.}
}
\value{
A list that corresponds to a git packfile entry, invisibly.
It has entries: \code{type} (always \code{"blob"}), \code{object} (raw object, the
blob itself), \code{size}, \code{packed_size}, \code{hash}.
}
\description{
Download a blob for a remote git repository
}
\section{Examples}{

Download a \code{DESCRIPTION} file from GitHub:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak_repo <- "https://github.com/r-lib/pak.git"
fls <- git_list_files(pak_repo, "HEAD")
git_download_file(
  pak_repo,
  fls$files$hash[fls$files$path == "DESCRIPTION"],
  output = tmp <- tempfile()
)
readLines(tmp)[1:5]
#> [1] "Package: pak"                                                                  
#> [2] "Version: 0.3.1.9999"                                                           
#> [3] "Title: Another Approach to Package Installation"                               
#> [4] "Description: The goal of 'pak' is to make package installation faster and"     
#> [5] "    more reliable. In particular, it performs all HTTP operations in parallel,"
}\if{html}{\out{</div>}}
}

\keyword{internal}
