% analyze grace results
% threads: 80, 40, 20, 10, 5, 2, 1

packages = { 'umf+amd', 'umf+met', 'paru+amd', 'paru+met', 'superlu' , 'mumps+amd', 'mumps+met'} ;
s =        { 'ko:',      'ko-',    'ro:',      'ro-',      'go:'     , 'bo:'      , 'bo-'      } ;
threads = [80 40 20 10 5 2 1] ;
nthreads = length (threads) ;

matrices = {
'rim',
'TSOPF_RS_b39_c30',
'twotone',
'std1_Jac2',
'mac_econ_fwd500',
'std1_Jac3',
'TSOPF_RS_b300_c1',
'lhr71',
'Zd_Jac2',
'av41092',
'Zd_Jac6',
'crashbasis',
'bbmat',
'Zd_Jac3',
'mc2depi',
'TSOPF_RS_b300_c2',
'TSOPF_RS_b678_c1',
'TSOPF_RS_b300_c3',
'Chebyshev4',
'Hamrle3',
'pre2',
'TSOPF_RS_b2052_c1',
'torso1',
'TSOPF_RS_b678_c2',
'TSOPF_RS_b2383',
'vas_stokes_4M',
'stokes' } ;
nmats = length (matrices) ;

%-------------------------------------------------------------------------------
% ParU results (both AMD and METIS): 2*27 = 54 results
% umfpack strategy (1:unsym, 3:sym), paru strategy (1:unsym, 3:sym),
% ordering (1:amd/colamd, 3:metis-guard on A+A' or A'A)
%
paru_strategy = [
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	1
1	1	1
1	1	3
3	3	1
3	3	3
3	3	1
3	3	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	1
1	1	1
1	1	3
3	3	1
3	3	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	1
3	3	1
3	3	3
1	1	1
1	1	3
1	1	1
1	1	1
nan nan nan
nan nan nan
nan nan nan
nan nan nan
] ;
% split into AMD/COLAMD vs METIS orderings:
paru_strategy_amd = paru_strategy (1:2:end,:) ;
paru_strategy_met = paru_strategy (2:2:end,:) ;

paru_sym_time = [
0.0633
0.2688
0.0770
0.3495
0.0774
1.0137
0.3067
0.6597
0.5660
3.2911
0.3221
0.6820
0.2275
0.8169
0.1874
1.5986
0.3949
0.8030
0.1544
0.1534
0.3748
0.8181
0.1557
1.3999
0.1918
0.8131
0.3993
0.8253
0.4008
4.0496
0.4823
1.6849
1.4191
1.4179
0.7436
2.7293
0.6850
1.8946
1.4043
13.3576
2.2001
49.3503
2.5476
2.5476
0.5808
2.3767
2.8795
11.1689
1.1175
1.1125
nan
nan
nan
nan ] ;
% split into AMD/COLAMD vs METIS orderings:
paru_sym_time_amd = paru_sym_time (1:2:end,:) ;
paru_sym_time_met = paru_sym_time (2:2:end,:) ;

paru_factor_time = [
0.6086	0.5590	0.5629	0.3592	0.3590	0.3601	0.5479
0.1082	0.0835	0.0654	0.0704	0.1052	0.1702	0.2308
0.1453	0.1217	0.1231	0.1284	0.1216	0.1165	0.0992
0.2116	0.1406	0.1310	0.1301	0.1135	0.1313	0.1388
0.3803	0.3228	0.3144	0.2442	0.2352	0.2644	0.3457
0.4078	0.4028	0.3418	0.2998	0.3008	0.3421	0.4495
0.1040	0.0730	0.0598	0.0556	0.0521	0.0760	0.1119
0.0881	0.0705	0.0581	0.0548	0.0685	0.1056	0.1747
2.1987	2.0555	1.8665	1.8521	1.9355	2.0303	2.9115
0.4252	0.3861	0.4371	0.5752	0.8438	1.7069	2.9149
0.1302	0.0844	0.0641	0.0555	0.0551	0.0697	0.1053
0.0800	0.0683	0.0610	0.0541	0.0688	0.0994	0.1694
0.0589	0.0569	0.0391	0.0380	0.0414	0.0577	0.0799
0.0986	0.0749	0.0577	0.0503	0.0582	0.0932	0.1499
0.1783	0.1775	0.1282	0.1184	0.1740	0.2325	0.2879
0.1813	0.1490	0.0986	0.0941	0.1031	0.1479	0.2267
0.1045	0.0884	0.0692	0.0688	0.0714	0.0969	0.1288
0.1069	0.0856	0.0668	0.0656	0.0767	0.1279	0.2112
2.2711	2.1916	2.1649	2.1311	2.1306	2.1581	2.3209
2.2143	2.2488	2.1441	2.1014	2.1090	2.1676	2.2900
0.1235	0.0936	0.0734	0.0670	0.0648	0.0807	0.1351
0.1030	0.0788	0.0682	0.0678	0.0879	0.1374	0.2423
0.4894	0.4388	0.3165	0.3113	0.3400	0.5060	0.8335
0.9818	0.9172	0.8005	0.7621	0.7456	0.7895	1.1464
5.0353	5.0481	4.7080	4.5545	4.6955	4.7237	4.9940
1.5207	1.5500	1.4491	1.4288	1.4519	1.4461	1.6288
0.1220	0.0832	0.0650	0.0584	0.0628	0.0886	0.1373
0.1190	0.0796	0.0707	0.0625	0.0748	0.1243	0.2161
1.5571	1.4973	1.3512	1.3382	1.5900	2.2239	3.1752
0.6389	0.5708	0.4736	0.5250	0.8470	1.2831	2.1422
0.1310	0.1372	0.0812	0.0799	0.0998	0.1194	0.1632
0.1336	0.1240	0.0914	0.0983	0.1270	0.1824	0.2999
0.3464	0.1374	0.1146	0.1179	0.1167	0.1548	0.2276
0.3434	0.1234	0.1083	0.1047	0.1135	0.1575	0.2246
0.2193	0.1673	0.1879	0.1775	0.2059	0.1948	0.2603
0.2876	0.2090	0.1629	0.1602	0.1762	0.2788	0.4804
2.8701	2.9603	2.7745	2.6717	2.6542	2.6493	2.7359
2.6138	2.6455	2.5778	2.5290	2.5104	2.5275	2.6030
10.2328	10.3471	10.1077	10.1447	11.2305	15.4141	24.7237
6.3585	6.1568	5.2136	5.5669	6.7986	13.4712	23.5757
24.3161	19.3786	19.7691	19.8944	21.0249	24.2847	37.5700
3.1982	2.9639	3.0977	3.0537	3.9650	7.6511	13.9919
0.3322	0.2365	0.1533	0.1468	0.1678	0.2264	0.3362
0.4382	0.2696	0.2063	0.1921	0.1891	0.2266	0.3379
3.5561	3.5545	3.4334	3.4799	3.4449	3.4004	3.4466
2.5116	2.5495	2.6625	2.3480	2.3514	2.4133	2.5505
0.4135	0.2869	0.2504	0.2114	0.2415	0.3132	0.4523
0.4338	0.3579	0.3538	0.3665	0.4739	0.7976	1.2716
26.1783	28.4942	26.0362	26.0205	36.6529	46.8253	82.2835
28.0780	29.9281	28.3051	28.9051	36.7772	45.2794	80.7041
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan ] ;
% split into AMD/COLAMD vs METIS orderings:
paru_factor_time_amd = paru_factor_time (1:2:end,:) ;
paru_factor_time_met = paru_factor_time (2:2:end,:) ;

paru_solve_time = [
0.0599	0.0915	0.0349	0.0201	0.0212	0.0246	0.0203
0.0185	0.0175	0.0241	0.0118	0.0137	0.0199	0.0107
0.0084	0.0078	0.0084	0.0088	0.0083	0.0071	0.0055
0.0149	0.0144	0.0144	0.0128	0.0115	0.0121	0.0093
0.1275	0.0647	0.0314	0.0239	0.0219	0.0203	0.0214
0.1950	0.1207	0.0317	0.0241	0.0209	0.0222	0.0245
0.0681	0.0850	0.0137	0.0082	0.0081	0.0080	0.0067
0.0680	0.0634	0.0159	0.0090	0.0092	0.0095	0.0081
0.6421	2.2361	0.2569	0.0822	0.0904	0.0999	0.1244
0.2457	0.3868	0.1627	0.1305	0.1217	0.0909	0.0971
0.0179	0.0736	0.0151	0.0071	0.0077	0.0064	0.0066
0.0547	0.0350	0.0153	0.0090	0.0087	0.0075	0.0083
0.0053	0.0055	0.0042	0.0033	0.0031	0.0031	0.0033
0.0171	0.0140	0.0167	0.0066	0.0054	0.0056	0.0062
0.0220	0.0232	0.0203	0.0201	0.0237	0.0210	0.0198
0.0244	0.0227	0.0204	0.0179	0.0166	0.0159	0.0148
0.0571	0.0463	0.0205	0.0108	0.0108	0.0100	0.0079
0.0610	0.0960	0.0176	0.0114	0.0090	0.0089	0.0099
0.2629	0.5041	0.0460	0.0270	0.0321	0.0364	0.0498
0.6760	0.4138	0.0524	0.0290	0.0284	0.0343	0.0491
0.0488	0.1086	0.0143	0.0089	0.0081	0.0076	0.0082
0.0857	0.0673	0.0193	0.0108	0.0144	0.0094	0.0104
0.4120	0.3839	0.0761	0.0559	0.0505	0.0510	0.0599
0.6993	0.5710	0.1157	0.0599	0.0552	0.0597	0.0692
1.5356	1.0215	0.1064	0.0408	0.0534	0.0552	0.0791
0.4044	0.8103	0.0756	0.0383	0.0297	0.0333	0.0438
0.0177	0.0597	0.0171	0.0101	0.0099	0.0083	0.0088
0.0714	0.0710	0.0176	0.0108	0.0109	0.0094	0.0105
0.5020	1.9011	0.3038	0.2182	0.2282	0.1746	0.1740
0.5132	0.5493	0.2286	0.1502	0.1538	0.1308	0.1371
0.0131	0.0116	0.0101	0.0085	0.0092	0.0072	0.0072
0.0289	0.0248	0.0328	0.0149	0.0142	0.0118	0.0134
0.0176	0.0141	0.0114	0.0081	0.0075	0.0064	0.0078
0.0199	0.0146	0.0128	0.0067	0.0059	0.0062	0.0077
0.0202	0.0180	0.0209	0.0156	0.0172	0.0119	0.0123
0.0507	0.0591	0.0442	0.0211	0.0174	0.0182	0.0210
0.9426	1.5097	0.1175	0.0408	0.0382	0.0477	0.0739
0.7673	1.9120	0.1036	0.0388	0.0390	0.0516	0.0730
15.0839	8.7609	1.2365	1.2544	0.9992	0.6946	0.7666
5.1247	5.3240	1.0456	0.8772	0.7742	0.5104	0.6235
20.5263	11.9706	2.1561	1.8843	1.5586	0.5508	0.9090
4.0993	4.9648	0.9693	0.8207	0.5554	0.3442	0.5587
0.0315	0.0448	0.0138	0.0115	0.0103	0.0091	0.0114
0.0467	0.0427	0.0139	0.0101	0.0087	0.0091	0.0115
0.3994	0.4926	0.1057	0.0487	0.0458	0.0484	0.0557
0.4023	0.4338	0.1006	0.0429	0.0449	0.0538	0.0542
0.0290	0.0263	0.0228	0.0144	0.0123	0.0132	0.0158
0.6036	0.1059	0.0543	0.0257	0.0270	0.0261	0.0339
7.9737	0.9153	0.2064	0.2806	0.2792	0.1367	0.2862
4.0369	0.6161	0.1985	0.2545	0.2657	0.1801	0.3023
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan ] ;
% split into AMD/COLAMD vs METIS orderings:
paru_solve_time_amd = paru_solve_time (1:2:end,:) ;
paru_solve_time_met = paru_solve_time (2:2:end,:) ;

paru_total_time_amd = repmat (paru_sym_time_amd, 1, nthreads) + ...
    paru_factor_time_amd + paru_solve_time_amd ;

paru_total_time_met = repmat (paru_sym_time_met, 1, nthreads) + ...
    paru_factor_time_met + paru_solve_time_met ;

%-------------------------------------------------------------------------------
% UMFPACK results
% strategy: (1:unsym, 3:sym)
% ordering: (1:amd/colamd, 3: metis on A+A'/A'A)
umf_strategy = [
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	1
1	1	1
1	1	3
3	3	1
3	3	3
3	3	1
3	3	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	1
1	1	1
1	1	3
3	3	1
3	3	3
1	1	1
1	1	3
1	1	1
1	1	3
1	1	1
1	1	1
3	3	1
3	3	3
1	1	1
1	1	3
1	1	1
1	1	1
nan nan nan
nan nan nan
nan nan nan
nan nan nan ] ;
% split into AMD/COLAMD vs METIS orderings:
umf_strategy_amd = umf_strategy (1:2:end,:) ;
umf_strategy_met = umf_strategy (2:2:end,:) ;

umf_sym_time = [
0.0426
0.2608
0.0741
0.3293
0.0685
0.9846
0.2969
0.6580
0.4032
3.2511
0.3081
0.6713
0.2198
0.8246
0.1780
1.4241
0.3838
0.7881
0.1371
0.1340
0.3562
0.8012
0.1555
1.4307
0.1664
0.7738
0.3928
0.8540
0.3623
3.9435
0.4496
1.6579
1.3710
1.3727
0.6979
2.7002
0.6161
1.7235
1.2618
13.1440
1.9700
50.9522
2.4820
2.5256
0.4959
2.3529
2.7798
11.0560
0.9238
0.9263
nan
nan
nan
nan] ;
% split into AMD/COLAMD vs METIS orderings:
umf_sym_time_amd = umf_sym_time (1:2:end,:) ;
umf_sym_time_met = umf_sym_time (2:2:end,:) ;

umf_factor_time = [
0.5724	0.5478	0.4948	0.4207	0.4073	0.4096	0.3010
1.2881	1.0377	0.3520	0.3240	0.2727	0.2696	0.1984
0.1018	0.1018	0.1015	0.0962	0.0965	0.0961	0.0963
0.1517	0.1517	0.1519	0.1511	0.1516	0.1528	0.1515
1.2164	1.2609	0.5879	0.4787	0.4566	0.5018	0.4163
2.1734	1.4171	0.7491	0.6319	0.6209	0.6930	0.5648
0.3567	0.4003	0.1879	0.1666	0.1598	0.1624	0.1248
0.6124	0.6076	0.2586	0.2336	0.2135	0.2181	0.1691
25.6625	20.5611	5.1734	4.1993	3.9858	3.1857	3.2840
14.2865	8.7711	3.3114	2.8694	2.6772	2.2083	1.9526
0.3896	0.2129	0.1863	0.1637	0.1571	0.1356	0.1259
0.7053	0.5990	0.2489	0.2153	0.2040	0.1776	0.1609
0.1357	0.1205	0.1058	0.1045	0.1066	0.0986	0.0946
0.4091	0.3558	0.2650	0.2159	0.2157	0.1782	0.1580
0.4976	0.4006	0.3179	0.2741	0.2502	0.2534	0.2307
0.8556	0.7792	0.4295	0.3549	0.3248	0.3253	0.2968
0.3805	0.4710	0.2139	0.1844	0.1875	0.1895	0.1461
0.6777	0.5770	0.3041	0.2646	0.2470	0.2565	0.1944
7.8852	5.8758	2.1792	1.8394	1.7248	2.3967	1.9466
7.2301	6.4533	2.2491	1.9857	1.7683	1.7088	2.0034
0.3687	0.3913	0.2215	0.2034	0.1839	0.1878	0.1474
1.1693	0.7214	0.3374	0.3072	0.2731	0.2367	0.2142
2.3578	2.8455	1.0710	0.9070	0.8453	0.8982	0.6776
9.1922	5.5107	1.5402	1.3277	1.2257	1.0188	0.9560
15.5217	12.9364	3.5645	3.0025	3.2227	2.9557	3.6886
11.5527	7.8228	2.0657	1.6256	1.5596	1.2960	1.3201
0.3537	0.3895	0.2188	0.1962	0.1875	0.1911	0.1502
0.9241	0.6449	0.3190	0.2797	0.2577	0.2729	0.2024
17.5471	13.1284	4.5077	3.9365	3.6765	3.0663	3.0408
15.9558	10.4481	3.6629	3.2579	2.9836	3.0306	2.3926
0.2614	0.2336	0.2144	0.2121	0.2175	0.2011	0.1935
1.0977	0.9662	0.5049	0.4664	0.4532	0.3850	0.3444
0.9121	0.8419	0.7912	0.7986	0.7534	0.7551	0.7093
0.9187	0.8671	0.7842	0.7562	0.7466	0.7235	0.7095
0.4046	0.3588	0.3353	0.3304	0.3328	0.3403	0.2979
1.3912	0.9654	0.7549	0.6860	0.6861	0.5657	0.5040
13.7775	9.2371	2.4144	1.9512	2.0583	2.2059	1.7301
21.6104	13.9575	3.1862	2.5664	2.6655	2.2980	2.4966
94.4063	65.8566	24.5827	24.4864	24.6646	23.6089	31.3378
78.1330	52.6374	17.4170	15.1873	14.8884	13.2113	15.3010
100.8789	71.5818	24.4088	24.3001	25.4675	29.3042	42.6060
44.8878	31.1419	13.4680	12.0684	11.3890	9.7718	9.7694
1.7695	1.6770	1.5378	1.8043	1.4791	1.5023	1.4332
1.7066	1.6722	1.6939	1.4847	1.4754	1.4414	1.4369
5.9377	5.1101	2.1356	2.1240	1.9898	1.7859	1.8723
6.8051	5.8086	2.1160	1.7932	1.9810	1.6994	1.8119
0.9636	0.8371	0.7164	0.6939	0.6665	0.6181	0.6029
7.0973	3.9410	1.8936	1.5282	1.4740	1.7869	1.2730
52.3671	36.6663	22.7350	25.5114	31.5563	47.9446	80.6326
53.1160	36.8004	22.2822	26.9391	31.6438	45.8497	81.3330
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan ] ;
% split into AMD/COLAMD vs METIS orderings:
umf_factor_time_amd = umf_factor_time (1:2:end,:) ;
umf_factor_time_met = umf_factor_time (2:2:end,:) ;

umf_solve_time = [
0.0769	0.0765	0.0769	0.0766	0.0767	0.0760	0.0766
0.0638	0.0565	0.0540	0.0536	0.0532	0.0538	0.0533
0.0213	0.0212	0.0161	0.0161	0.0160	0.0160	0.0160
0.0208	0.0207	0.0207	0.0208	0.0207	0.0208	0.0207
0.0864	0.0752	0.0687	0.0677	0.0678	0.0678	0.0678
0.1053	0.0903	0.0869	0.0907	0.0938	0.0881	0.0857
0.0321	0.0313	0.0322	0.0330	0.0361	0.0306	0.0307
0.0405	0.0352	0.0349	0.0341	0.0343	0.0346	0.0344
0.5693	0.5233	0.4958	0.5795	0.5982	0.4304	0.4293
0.4603	0.4495	0.3267	0.4186	0.4977	0.3317	0.3316
0.0250	0.0253	0.0244	0.0244	0.0267	0.0240	0.0241
0.0289	0.0273	0.0273	0.0335	0.0267	0.0268	0.0269
0.0348	0.0347	0.0264	0.0265	0.0263	0.0263	0.0265
0.0512	0.0612	0.0416	0.0409	0.0407	0.0399	0.0401
0.0224	0.0179	0.0189	0.0180	0.0177	0.0178	0.0178
0.0192	0.0223	0.0185	0.0192	0.0184	0.0184	0.0183
0.0394	0.0388	0.0386	0.0389	0.0397	0.0391	0.0394
0.0593	0.0542	0.0500	0.0510	0.0610	0.0456	0.0448
0.2981	0.2804	0.2741	0.1973	0.1966	0.1974	0.1963
0.2767	0.2482	0.2093	0.2809	0.1980	0.2022	0.1981
0.0164	0.0169	0.0201	0.0164	0.0183	0.0182	0.0186
0.0426	0.0393	0.0344	0.0343	0.0341	0.0342	0.0344
0.1896	0.1717	0.1618	0.1671	0.1651	0.1617	0.1610
0.2484	0.2116	0.1926	0.2134	0.2506	0.1935	0.1916
0.5502	0.4492	0.3424	0.3982	0.3671	0.4026	0.3402
0.2996	0.2753	0.2899	0.2709	0.2086	0.2093	0.2094
0.0216	0.0221	0.0210	0.0209	0.0168	0.0168	0.0168
0.0500	0.0402	0.0402	0.0351	0.0357	0.0349	0.0351
0.4823	0.4602	0.3606	0.5329	0.4670	0.3598	0.3581
0.4585	0.3540	0.3143	0.2934	0.3960	0.3045	0.2904
0.0572	0.0572	0.0569	0.0572	0.0571	0.0570	0.0571
0.1053	0.0846	0.0832	0.1062	0.0837	0.0833	0.0837
0.0812	0.0812	0.0798	0.0793	0.0957	0.0793	0.0798
0.1239	0.0808	0.0793	0.0819	0.0804	0.0790	0.0791
0.0864	0.0858	0.0860	0.0857	0.0856	0.0861	0.0861
0.1524	0.1394	0.1350	0.1802	0.1642	0.1226	0.1232
0.3778	0.3603	0.2855	0.2849	0.2873	0.2869	0.2876
0.3849	0.4510	0.2761	0.2486	0.2481	0.2484	0.2485
3.7488	3.4747	2.7822	4.0301	3.6459	2.4134	2.4435
3.0354	2.5567	2.0066	2.0405	2.9614	1.6755	1.6701
1.9943	1.8184	1.7178	2.0119	1.6855	1.2635	1.3839
1.4083	1.2321	1.0999	1.4495	1.2400	1.1049	1.1022
0.1900	0.1407	0.1387	0.1719	0.1249	0.1250	0.1249
0.1920	0.1499	0.1760	0.1237	0.1239	0.1244	0.1239
0.2284	0.2486	0.1702	0.2450	0.2556	0.1708	0.1697
0.2306	0.2148	0.1777	0.1775	0.2671	0.2010	0.1770
0.2250	0.1599	0.1601	0.1629	0.1597	0.1595	0.1598
0.2776	0.2468	0.3207	0.2348	0.2346	0.2347	0.2349
2.3753	1.8700	1.6769	1.8161	1.5071	1.4286	1.3767
2.6494	1.8693	1.5939	1.9726	1.4243	1.3411	1.3878
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan ] ;
% split into AMD/COLAMD vs METIS orderings:
umf_solve_time_amd = umf_solve_time (1:2:end,:) ;
umf_solve_time_met = umf_solve_time (2:2:end,:) ;

umf_total_time_amd = repmat (umf_sym_time_amd, 1, nthreads) + ...
    umf_factor_time_amd + umf_solve_time_amd ;

umf_total_time_met = repmat (umf_sym_time_met, 1, nthreads) + ...
    umf_factor_time_met + umf_solve_time_met ;

%-------------------------------------------------------------------------------
% SuperLU_MT results: only COLAMD ordering
slu_sym_time = [
0.0649	0.0640	0.0645	0.0658	0.0648	0.0642	0.0645
0.1003	0.0996	0.0997	0.0996	0.0994	0.0998	0.0996
0.3027	0.3012	0.2996	0.3007	0.3010	0.3010	0.3007
2.8573	2.8526	2.8515	2.8544	2.8534	2.8503	2.8541
0.6011	0.6063	0.6070	0.6232	0.6078	0.6162	0.6064
3.4154	3.4199	3.4279	3.4222	3.4213	3.4197	3.4200
0.3945	0.3938	0.3941	0.3948	0.3944	0.3963	0.3972
0.4068	0.4073	0.4063	0.4063	0.4047	0.4041	0.4050
3.8099	3.8106	3.8099	3.8055	3.8082	3.8026	3.8027
0.2283	0.2248	0.2296	0.2257	0.2252	0.2258	0.2251
4.1622	4.1488	4.1482	4.1503	4.1463	4.1474	4.1458
0.2229	0.2229	0.2240	0.2266	0.2252	0.2229	0.2225
1.6448	1.6423	1.6453	1.6522	1.6532	1.6439	1.6401
4.4705	4.4674	4.4676	4.4723	4.4744	4.4727	4.4706
nan nan nan nan nan nan nan
0.7907	0.7904	0.7883	0.7879	0.7936	0.7912	0.7874
2.5192	2.5117	2.5117	2.5087	2.5128	2.5120	2.5135
1.1896	1.1926	1.1903	1.1888	1.1909	1.1917	1.1903
nan nan nan nan nan nan nan
1.3321	1.3346	1.3261	1.3334	1.3377	1.3420	1.3293
3.3721	3.3585	3.3584	3.3711	3.3766	3.3674	3.3411
4.6662	4.6740	4.6699	4.6669	4.6730	4.6687	4.6655
1.4247	1.4266	1.4272	1.4265	1.4292	1.4274	1.4359
5.0261	5.0327	5.0298	5.0346	5.0340	5.0295	5.0237
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan ] ;

slu_factor_time = [
0.5481	0.4849	0.5099	0.6599	0.9064	1.8015	3.2290
0.1830	0.1871	0.1748	0.1515	0.1458	0.1535	0.1475
0.8934	0.7119	0.6158	0.6781	0.9826	2.1222	3.5823
0.5793	0.5084	0.6188	0.8987	1.4390	2.8426	2.8620
3.3972	3.5007	4.9839	8.2898	14.3835	32.7544	62.8371
0.8529	0.8720	1.0153	1.4929	2.2781	4.3805	3.3726
0.3152	0.2194	0.1682	0.1503	0.1405	0.1628	0.1805
0.3532	0.2653	0.2231	0.2359	0.2826	0.4176	0.6646
0.6564	0.6264	0.7339	0.9314	1.3604	2.5844	4.3986
2.8796	2.5804	3.0764	4.5693	8.1766	17.6375	34.5347
0.5933	0.6318	0.7366	0.9689	1.3084	2.1505	3.5361
1.0154	0.8301	0.7590	0.7995	0.9945	1.9537	3.6003
1.9358	1.9188	2.3968	3.2807	5.1187	11.3329	21.3150
0.8948	0.9085	1.0492	1.4311	2.0478	4.0208	5.1984
nan nan nan nan nan nan nan
0.3789	0.2884	0.2381	0.2346	0.2368	0.2404	0.3389
0.6385	0.4605	0.4052	0.3925	0.4074	0.5413	0.6515
0.4808	0.3645	0.3096	0.3097	0.3086	0.3797	0.5151
nan nan nan nan nan nan nan
24.7734	28.3719	45.9983	76.4820	131.7131	291.3536	530.4429
37.5366	41.5436	56.5492	88.5228	158.4046	375.4133	745.6816
0.8979	0.6983	0.6204	0.5806	0.6570	0.8975	1.0638
2.9383	3.0471	4.4857	7.3230	12.0868	26.4036	50.2728
0.8212	0.6517	0.6071	0.5964	0.6097	0.7959	1.2465
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan ] ;

slu_solve_time = [
0.5318	0.4648	0.5871	0.5757	0.4315	0.4764	0.4397
0.1225	0.1235	0.1257	0.1217	0.1055	0.1003	0.0940
0.9029	0.8548	0.7982	0.7558	0.7513	0.6794	0.5708
0.4017	0.4097	0.4032	0.3901	0.3807	0.3566	0.2656
3.2325	2.8885	2.9113	2.9143	2.9476	3.0213	2.8305
0.5097	0.5113	0.4729	0.4683	0.4695	0.4395	0.2988
0.1136	0.1156	0.1148	0.1163	0.1154	0.1143	0.1089
0.3166	0.3027	0.3163	0.2886	0.2751	0.2575	0.2394
0.4554	0.4385	0.4486	0.4193	0.4280	0.3897	0.3520
1.3741	1.2110	1.2471	1.3497	1.2847	1.1566	1.1920
0.4881	0.4115	0.4193	0.5054	0.4467	0.3356	0.3210
0.9705	0.9299	0.9021	0.8727	0.8892	0.7859	0.8265
1.2951	1.1837	1.1937	1.2631	1.2437	1.1056	1.0978
0.5471	0.5541	0.6235	0.5490	0.5198	0.5559	0.4435
nan nan nan nan nan nan nan
0.2550	0.2482	0.2482	0.2559	0.2356	0.2384	0.2185
0.3407	0.2786	0.3583	0.3546	0.3355	0.2753	0.2591
0.3805	0.3785	0.3727	0.3913	0.3743	0.3519	0.3281
nan nan nan nan nan nan nan
15.0686	16.5248	14.8590	15.9165	16.1885	15.8613	14.0282
15.8558	16.9476	16.7109	15.6106	15.8651	14.3399	14.0675
0.5365	0.5223	0.5179	0.5003	0.5577	0.4843	0.4761
1.7843	1.7531	1.7213	1.6983	1.6078	1.4676	1.4154
0.7067	0.6894	0.6993	0.6588	0.7325	0.6251	0.5099
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan
nan nan nan nan nan nan nan ] ;

slu_total_time = slu_sym_time + slu_factor_time + slu_solve_time ;

%%-------------------------------------------------------------------------------
% MUMPS: with AMD
% threads: 1, ... 80 (backwards from paru, umf, and superlu results)
% Hamrle3 matrix fails
mumps_sym_time_amd = [
0.0198
0.0930
0.1736
0.8458
0.8922
0.8801
0.1386
0.2415
1.1411
0.9471
1.1879
0.0979
0.1014
1.2016
0.2536
0.2880
0.6641
0.4682
3.4391
nan     % Hamrle3 fails
1.4191
1.2391
1.9416
1.3382
3.8402
] ;

mumps_factor_time_amd = [
0.0748	0.0736	0.0665	0.0620	0.0615	0.1376	0.4264
0.0619	0.0598	0.0506	0.0465	0.3152	1.6455	17.0631
0.8229	0.5582	0.3699	0.2976	0.2927	0.6160	1.8716
1.1235	0.7726	0.4572	0.3648	0.3663	0.7415	4.2859
2.4195	1.7462	1.5042	1.3116	1.4834	5.3052	22.2229
1.5589	0.9822	0.5567	0.4194	0.4610	0.7291	4.0537
0.1226	0.1035	0.1260	0.1347	0.1462	0.2354	2.8433
0.1488	0.1548	0.1080	0.0946	0.0773	0.1275	1.0788
1.6711	1.0608	0.6479	0.4771	0.4356	0.8763	3.7050
0.3258	0.2255	0.1409	0.1407	0.1844	0.7556	2.9031
1.9410	1.2878	0.7248	0.4997	0.5402	0.7594	4.4380
0.7554	0.5929	0.3754	0.2806	0.2891	1.1339	4.1368
1.0255	0.7349	0.4316	0.3684	0.5214	2.7178	12.4765
2.0491	1.3097	0.7452	0.5562	0.5853	0.5555	2.6313
1.6670	1.3740	0.7930	0.5624	0.4799	0.6910	4.0034
0.2416	0.1896	0.2659	0.2644	0.3119	1.1445	10.5918
0.5027	0.3621	0.3056	0.2974	0.3364	0.3803	1.8986
0.3631	0.3101	0.3990	0.3761	0.4315	0.7516	13.2130
1.0228	0.7595	0.4735	0.3453	0.3398	0.4433	4.7783
nan     nan     nan     nan     nan     nan     nan     % Hamrle3 fails
8.8470	5.3541	3.0309	2.5527	1.8307	2.1071	8.3787
0.8856	0.5983	0.5150	0.4439	0.4386	0.5233	3.9474
1.2439	1.1350	0.7997	0.5627	0.4648	0.5995	1.4142
1.0252	0.7122	0.7170	0.5605	0.6642	1.8751	7.8728
2.7769	1.7839	1.4498	1.1105	1.0396	2.6331	5.2305
] ;

mumps_solve_time_amd = [
0.0108	0.0089	0.0080	0.0080	0.0094	0.0137	0.0532
0.0175	0.0151	0.0133	0.0122	0.0185	0.0410	0.0538
0.0468	0.0344	0.0285	0.0272	0.0396	0.1587	0.3322
0.0324	0.0222	0.0208	0.0249	0.0375	0.1972	0.4904
0.1451	0.0942	0.0848	0.0872	0.0946	0.2075	1.8389
0.0363	0.0250	0.0231	0.0244	0.0421	0.0769	0.5641
0.0166	0.0149	0.0286	0.0165	0.0177	0.0208	0.0723
0.0309	0.0264	0.0205	0.0191	0.0212	0.0288	0.0808
0.0400	0.0288	0.0254	0.0297	0.0428	0.2579	0.9594
0.0292	0.0223	0.0218	0.0207	0.0251	0.3111	0.3290
0.0426	0.0297	0.0270	0.0295	0.0477	0.3200	0.4677
0.0706	0.0472	0.0375	0.0291	0.0372	0.6280	0.3501
0.0485	0.0317	0.0265	0.0244	0.0380	0.2236	3.0530
0.0453	0.0318	0.0301	0.0321	0.0537	0.2122	0.4616
0.1469	0.1079	0.0822	0.0615	0.0627	0.1148	0.4364
0.0340	0.0293	0.0346	0.0348	0.0399	0.0685	0.0837
0.0487	0.0430	0.0444	0.0477	0.0673	0.0673	0.1029
0.0516	0.0467	0.0513	0.0527	0.0592	0.0847	0.1056
0.0817	0.0629	0.0583	0.0523	0.0617	0.0841	0.5643
nan     nan     nan     nan     nan     nan     nan     % Hamrle3 fails
0.2517	0.1755	0.1475	0.1643	0.1543	0.7819	1.8321
0.0751	0.0650	0.0674	0.0708	0.0884	0.1014	0.1318
0.0992	0.0816	0.0746	0.0733	0.0830	0.5343	0.9935
0.0986	0.0829	0.0906	0.0928	0.1326	0.1149	0.2124
0.1761	0.1495	0.1555	0.1523	0.1986	0.2415	0.2152
] ;

mumps_sym_time_amd    = mumps_sym_time_amd    (:, end:-1:1) ;
mumps_factor_time_amd = mumps_factor_time_amd (:, end:-1:1) ;
mumps_solve_time_amd  = mumps_solve_time_amd  (:, end:-1:1) ;

%-------------------------------------------------------------------------------
% MUMPS: with METIS
% threads: 1, ... 80 (backwards from paru, umf, and superlu results)
% Hamrle3 matrix fails
mumps_sym_time_met = [
0.1006
0.4023
0.9950
1.0811
2.6638
1.1067
0.3549
0.9907
1.1341
1.5605
1.0549
1.2080
0.5275
1.2768
2.6064
0.7484
0.9168
1.2240
1.3267
nan     % Hamrle3
5.4266
1.4781
3.2191
1.9307
3.3553
] ;

mumps_factor_time_met = [
0.0724	0.0809	0.0675	0.0477	0.0517	0.0715	2.2606
0.0902	0.0868	0.0619	0.0524	0.0713	0.1326	0.6511
0.8140	0.5171	0.3566	0.3106	0.3351	0.8386	3.3098
0.9733	0.6371	0.4318	0.3341	0.3546	0.4836	2.3720
1.0363	1.0714	0.5910	0.4171	0.3831	2.2229	11.8141
1.0404	0.6609	0.4338	0.3840	0.3746	0.5076	3.0206
0.1793	0.1445	0.0863	0.1456	0.1284	0.1870	1.0766
0.1303	0.1352	0.1033	0.0959	0.0801	0.2448	1.5602
0.9708	0.6308	0.3991	0.3686	0.3850	0.5487	3.5157
0.2802	0.2145	0.1367	0.1199	0.1735	0.3648	5.1428
1.0495	0.6985	0.3717	0.4098	0.3792	1.0508	3.7094
0.6736	0.5327	0.3488	0.2421	0.2589	0.5927	3.8623
0.7082	0.6093	0.3359	0.2418	0.2995	2.4248	8.7855
1.1314	0.7857	0.5300	0.4502	0.4386	0.5607	3.0909
1.5999	1.2855	0.6712	0.5463	0.5081	0.6011	4.3447
0.3459	0.3323	0.2042	0.1677	0.2939	1.6585	2.3040
0.8262	0.5541	0.3770	0.3237	0.3020	0.4823	1.6636
0.5608	0.5189	0.3291	0.2472	0.2050	0.7933	4.4029
2.2229	1.4328	0.9462	0.7864	0.8049	1.6676	2.9377
nan     nan     nan     nan     nan     nan     nan     % Hamrle3 fails
4.0644	2.5636	1.5810	1.1418	1.2820	2.7742	12.6624
1.5223	0.9795	0.6875	0.4119	0.6317	0.8930	1.8097
1.0089	0.7202	0.4960	0.4643	0.4247	0.5750	3.5170
1.7078	1.1537	0.7406	0.5016	0.5953	0.9124	3.4627
4.9909	3.0237	1.7553	1.3850	1.0925	1.0963	4.1719
] ;

mumps_solve_time_met = [
0.0109	0.0106	0.0079	0.0079	0.0097	0.0408	0.0779
0.0206	0.0182	0.0144	0.0129	0.0148	0.0165	0.0407
0.0534	0.0371	0.0325	0.0309	0.0464	0.1321	0.2822
0.0357	0.0249	0.0258	0.0859	0.0352	0.3819	0.8583
0.1145	0.1070	0.0624	0.0543	0.0538	0.1759	0.2132
0.0376	0.0259	0.0267	0.0311	0.0440	0.1598	0.6508
0.0195	0.0158	0.0137	0.0185	0.0216	0.0494	0.0932
0.0295	0.0258	0.0209	0.0191	0.0202	0.0242	0.0801
0.0385	0.0272	0.0273	0.0302	0.0421	0.1343	0.6788
0.0317	0.0245	0.0195	0.0209	0.0248	0.0847	0.2232
0.0401	0.0281	0.0267	0.0320	0.0364	0.2023	0.6427
0.0701	0.0480	0.0409	0.0557	0.0750	0.4468	0.4245
0.0398	0.0369	0.0246	0.0205	0.0267	0.4948	0.4487
0.0427	0.0312	0.0268	0.0347	0.0460	0.2531	0.5740
0.1569	0.1194	0.0825	0.0602	0.0647	0.2044	0.3302
0.0405	0.0391	0.0336	0.0288	0.0467	0.3971	0.0843
0.0568	0.0455	0.0630	0.0523	0.0563	0.0554	0.1152
0.0627	0.0604	0.0534	0.0495	0.0496	0.5929	0.1945
0.0940	0.0691	0.0724	0.0753	0.0845	0.1388	0.9420
nan     nan     nan     nan     nan     nan     nan     % Hamrle3 fails
0.2716	0.1897	0.1721	0.1585	0.1755	0.5312	1.3474
0.0868	0.0697	0.0704	0.0696	0.0932	0.1054	0.1377
0.1060	0.0871	0.0839	0.0786	0.0984	0.3288	0.4332
0.1146	0.0902	0.1121	0.0897	0.1014	0.0946	0.1654
0.2031	0.1593	0.1503	0.1493	0.1548	0.1816	0.1836
] ;

mumps_sym_time_met    = mumps_sym_time_met    (:, end:-1:1) ;
mumps_factor_time_met = mumps_factor_time_met (:, end:-1:1) ;
mumps_solve_time_met  = mumps_solve_time_met  (:, end:-1:1) ;

%-------------------------------------------------------------------------------
% factor time

figure (2)
clf (2)

% remove the RIM matrix from the plots:
% for k = 1:(nmats-2)
for k = 2:(nmats-2)

    % just MKL:
    t = {   umf_factor_time_amd(k,:),
            umf_factor_time_met(k,:),
            paru_factor_time_amd(k,:),
            paru_factor_time_met(k,:),
            slu_factor_time(k,:),
            mumps_factor_time_amd(k,:),
            mumps_factor_time_met(k,:)
            } ;

    name = matrices {k}
%   subplot (5,5,k) ;
    subplot (6,4,k-1) ;
    hold on
    what_result = 'factor' ;
    what_result = [ ] ;
    subplot_one_matrix (matrices{k}, what_result, packages, t, threads, 1, s) ;
%   if (k == 1)
%       legend (packages, 'Location', 'NorthWestOutside') ;
%   end
end


%{
fg = 1 ;
for k = 1:(nmats-2)
    t = {   umf_factor_time_amd(k,:),
            umf_factor_time_met(k,:),
            paru_factor_time_amd(k,:),
            paru_factor_time_met(k,:),
            slu_factor_time(k,:) } ;
    name = matrices {k}
    plot_one_matrix (fg, matrices{k}, 'factor', packages, t, threads, 1) ;
    fg = fg + 1 ;
end
%}

%-------------------------------------------------------------------------------
% all time

%{
for k = 1:(nmats-2)
    t = {   umf_total_time_amd(k,:),
            umf_total_time_met(k,:),
            paru_total_time_amd(k,:),
            paru_total_time_met(k,:),
            slu_total_time(k,:) } ;
    name = matrices {k}
    plot_one_matrix (fg, matrices{k}, 'all', packages, t, threads, 1) ;
    fg = fg + 1 ;
end
%}


