package ONVIF::Analytics::Types::VideoSourceConfigurationOptions;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %BoundsRange_of :ATTR(:get<BoundsRange>);
my %VideoSourceTokensAvailable_of :ATTR(:get<VideoSourceTokensAvailable>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        BoundsRange
        VideoSourceTokensAvailable
        Extension

    ) ],
    {
        'BoundsRange' => \%BoundsRange_of,
        'VideoSourceTokensAvailable' => \%VideoSourceTokensAvailable_of,
        'Extension' => \%Extension_of,
    },
    {
        'BoundsRange' => 'ONVIF::Analytics::Types::IntRectangleRange',
        'VideoSourceTokensAvailable' => 'ONVIF::Analytics::Types::ReferenceToken',
        'Extension' => 'ONVIF::Analytics::Types::VideoSourceConfigurationOptionsExtension',
    },
    {

        'BoundsRange' => 'BoundsRange',
        'VideoSourceTokensAvailable' => 'VideoSourceTokensAvailable',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::VideoSourceConfigurationOptions

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
VideoSourceConfigurationOptions from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * BoundsRange


=item * VideoSourceTokensAvailable


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::VideoSourceConfigurationOptions
   BoundsRange =>  { # ONVIF::Analytics::Types::IntRectangleRange
     XRange =>  { # ONVIF::Analytics::Types::IntRange
       Min =>  $some_value, # int
       Max =>  $some_value, # int
     },
     YRange =>  { # ONVIF::Analytics::Types::IntRange
       Min =>  $some_value, # int
       Max =>  $some_value, # int
     },
     WidthRange =>  { # ONVIF::Analytics::Types::IntRange
       Min =>  $some_value, # int
       Max =>  $some_value, # int
     },
     HeightRange =>  { # ONVIF::Analytics::Types::IntRange
       Min =>  $some_value, # int
       Max =>  $some_value, # int
     },
   },
   VideoSourceTokensAvailable => $some_value, # ReferenceToken
   Extension =>  { # ONVIF::Analytics::Types::VideoSourceConfigurationOptionsExtension
     Rotate =>  { # ONVIF::Analytics::Types::RotateOptions
       Mode => $some_value, # RotateMode
       DegreeList =>  { # ONVIF::Analytics::Types::IntList
         Items =>  $some_value, # int
       },
       Extension =>  { # ONVIF::Analytics::Types::RotateOptionsExtension
       },
     },
     Extension =>  { # ONVIF::Analytics::Types::VideoSourceConfigurationOptionsExtension2
     },
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

