		save
		listing	off

;****************************************************************************
;*                                                                          *
;*   REGHC08JB.INC                                                          *
;*   REGISTER DEFINITIONS FOR MC68HC908JB8/16                               *
;*   BY ANDREAS BOLSCH - BOLSCH@MATH.TU-BERLIN.DE                           *
;*   CHANGED: OCT 26 2004                                                   *
;*                                                                          *
;****************************************************************************

		ifndef	__REGHC08JBINC

__REGHC08JBINC	EQU	1

		switch	MOMCPUNAME
		case 	"68HC908JB8"
RAMBEG		EQU	$0040
RAMEND		EQU	$013F
FLASHBEG	EQU	$DC00		;START OF FLASH
FLASHEND	EQU	$FBFF
		
		case	"68HC908JB16"

		elsecase
		fatal  "INVALID PROCESSOR SELECTION: ONLY 68HC08 ALLOWED!"
		endcase

__MONVECRES	EQU	$FF00		;RESET VECTOR TO MONITOR
__MONVECSWI	EQU	$FE1A		;SWI VECTOR TO MONITOR

PTA		EQU	$0000		;PORT A DATA REGISTER
PTA7		EQU	7
PTA6		EQU	6
PTA5		EQU	5
PTA4		EQU	4
PTA3		EQU	3
PTA2		EQU	2
PTA1		EQU	1
PTA0		EQU	0

PTB		EQU	$0001		;PORT B DATA REGISTER
PTB7		EQU	7
PTB6		EQU	6
PTB5		EQU	5
PTB4		EQU	4
PTB3		EQU	3
PTB2		EQU	2
PTB1		EQU	1
PTB0		EQU	0

PTC		EQU	$0003		;PORT C DATA REGISTER
PTC7		EQU	7
PTC6		EQU	6
PTC5		EQU	5
PTC4		EQU	4
PTC3		EQU	3
PTC2		EQU	2
PTC1		EQU	1
PTC0		EQU	0

PTD		EQU	$0004		;PORT D DATA REGISTER
PTD7		EQU	7
PTD6		EQU	6
PTD5		EQU	5
PTD4		EQU	4
PTD3		EQU	3
PTD2		EQU	2
PTD1		EQU	1
PTD0		EQU	0

DDRA		EQU	$0004		;PORT A DATA DIRECTION REGISTER
DDRA7		EQU	7
DDRA6		EQU	6
DDRA5		EQU	5
DDRA4		EQU	4
DDRA3		EQU	3
DDRA1		EQU	1
DDRA0		EQU	0

DDRB		EQU	$0005		;PORT B DATA DIRECTION REGISTER
DDRB7		EQU	7
DDRB6		EQU	6
DDRB5		EQU	5
DDRB4		EQU	4
DDRB3		EQU	3
DDRB2		EQU	2
DDRB1		EQU	1
DDRB0		EQU	0

DDRC		EQU	$0006		;PORT C DATA DIRECTION REGISTER
DDRC7		EQU	7
DDRC6		EQU	6
DDRC5		EQU	5
DDRC4		EQU	4
DDRC3		EQU	3
DDRC1		EQU	1
DDRC0		EQU	0

DDRD		EQU	$0007		;PORT D DATA DIRECTION REGISTER
DDRD7		EQU	7
DDRD6		EQU	6
DDRD5		EQU	5
DDRD4		EQU	4
DDRD3		EQU	3
DDRD2		EQU	2
DDRD1		EQU	1
DDRD0		EQU	0

PTE		EQU	$0008		;PORT E DATA REGISTER
PTE4		EQU	4
PTE3		EQU	3
PTE2		EQU	2
PTE1		EQU	1
PTE0		EQU	0

DDRE		EQU	$0009		;PORT E DATA DIRECTION REGISTER
DDRE4		EQU	4
DDRE3		EQU	3
DDRE2		EQU	2
DDRE1		EQU	1
DDRE0		EQU	0

TSC		EQU	$000A		;TIM STATUS AND CONTROL REGISTER
TOF		EQU	7
TOIE		EQU	6
TSTOP		EQU	5
TRST		EQU	4
PS2		EQU	2
PS1		EQU	1
PS0		EQU	0

TCNTH		EQU	$000C		;TIM COUNTER REGISTER HIGH
TCNTL		EQU	$000D		;TIM COUNTER REGISTER LOW
TMODH		EQU	$000E		;TIM COUNTER MODULO REGISTER HIGH
TMODL		EQU	$000F		;TIM COUNTER MODULO REGISTER LOW

TSC0		EQU	$0010		;TIM CHANNEL 0 STATUS AND CONTROL REGISTER
CH0F		EQU	7
CH0IE		EQU	6
MS0B		EQU	5
MS0A		EQU	4
ELS0B		EQU	3
ELS0A		EQU	2
TOV0		EQU	1
CH0MAX		EQU	0

TCH0H		EQU 	$0011		;TIM CHANNEL 0 REGISTER HIGH
TCH0L		EQU 	$0012		;TIM CHANNEL 0 REGISTER LOW

TSC1		EQU 	$0013		;TIM CHANNEL 0 STATUS AND CONTROL REGISTER
CH1F		EQU	7
CH1IE		EQU	6
MS1A		EQU	4
ELS1B		EQU	3
ELS1A		EQU	2
TOV1		EQU	1
CH1MAX		EQU	0

TCH1H		EQU	$0014		;TIM CHANNEL 1 REGISTER HIGH
TCH1L		EQU	$0015		;TIM CHANNEL 1 REGISTER LOW

KBSCR		EQU	$0016		;KEYBOARD STATUS AND CONTROL REGISTER
KEYF		EQU	3
ACKK		EQU	2
IMASKK		EQU	1
MODEK		EQU	0

KBIER		EQU	$0017		;KEYBOARD INTERRUPT ENABLE REGISTER
AWUIE		EQU	6
KBIE5		EQU	5
KBIE4		EQU	4
KBIE3		EQU	3
KBIE2		EQU	2
KBIE1		EQU	1
KBIE0		EQU	0

UIR2		EQU 	$0018		;USB INTERRUPT REGISTER 2
EOPFR		EQU	7
RSTFR		EQU	6
TXD2FR		EQU	5
RXD2FR		EQU	4
TXD1FR		EQU	3
RESUMFR		EQU	2
TXD0FR		EQU	1
RXD0FR		EQU	0

UCR2		EQU 	$0019		;USB CONTROL REGISTER 2
T2SEQ		EQU	7
STALL2		EQU	6
TX2E		EQU	5
RX2E		EQU	4
TP2SIZ3		EQU	3
TP2SIZ2		EQU	2
TP2SIZ1		EQU	1
TP2SIZ0		EQU	0

UCR3		EQU 	$001A		;USB CONTROL REGISTER 3
TX1ST		EQU	7
TX1STR		EQU	6
OSTALL0		EQU	5
ISTALL0		EQU	4
PULLEN		EQU	2
ENABLE2		EQU	1
ENABLE1		EQU	0

UCR4		EQU 	$001B		;USB CONTROL REGISTER 4
FUSBO		EQU	2
FDP		EQU	1
FDM		EQU	0

IOCR		EQU	$001C		;IRQ OPTION CONTROL REGISTER
PTE4IF		EQU	2
PTE4IE		EQU	1
IRQPD		EQU	0

POCR		EQU	$001D		;PORT OPTION CONTROL REGISTER
PTE20P		EQU	7
PTDLDD		EQU	6
PTDILDD		EQU	5
PTE4P		EQU	4
PTE3P		EQU	3
PCP		EQU	2
PBP		EQU	1
PAP		EQU	0

ISCR		EQU 	$001E		;IRQ STATUS AND CONTROL REGISTER
IRQF		EQU	3
ACK		EQU	2
IMASK		EQU	1
MODE		EQU	0

CONFIG2		EQU 	$001E		;CONFIGURATION REGISTER 2
IRQPUD		EQU	7
IRQEN		EQU	6
OSCOPT1		EQU	4
OSCOPT0		EQU	3
RSTEN		EQU	0

CONFIG		EQU 	$001F		;CONFIGURATION REGISTER
URSTD		EQU	5
LVID		EQU	4
SSREC		EQU	3
COPRS		EQU	2
STOP		EQU	1
COPD		EQU	0

UE0D0		EQU	$0020		;USB ENDPOINT 0 DATA REGISTER 0
UE0D1		EQU	$0021		;USB ENDPOINT 0 DATA REGISTER 1
UE0D2		EQU	$0022		;USB ENDPOINT 0 DATA REGISTER 2
UE0D3		EQU	$0023		;USB ENDPOINT 0 DATA REGISTER 3
UE0D4		EQU	$0024		;USB ENDPOINT 0 DATA REGISTER 4
UE0D5		EQU	$0025		;USB ENDPOINT 0 DATA REGISTER 5
UE0D6		EQU	$0026		;USB ENDPOINT 0 DATA REGISTER 6
UE0D7		EQU	$0027		;USB ENDPOINT 0 DATA REGISTER 7

UE1D0		EQU	$0028		;USB ENDPOINT 1 DATA REGISTER 0
UE1D1		EQU	$0029		;USB ENDPOINT 1 DATA REGISTER 1
UE1D2		EQU	$002A		;USB ENDPOINT 1 DATA REGISTER 2
UE1D3		EQU	$002B		;USB ENDPOINT 1 DATA REGISTER 3
UE1D4		EQU	$002C		;USB ENDPOINT 1 DATA REGISTER 4
UE1D5		EQU	$002D		;USB ENDPOINT 1 DATA REGISTER 5
UE1D6		EQU	$002E		;USB ENDPOINT 1 DATA REGISTER 6
UE1D7		EQU	$002F		;USB ENDPOINT 1 DATA REGISTER 7

UE2D0		EQU	$0030		;USB ENDPOINT 2 DATA REGISTER 0
UE2D1		EQU	$0031		;USB ENDPOINT 2 DATA REGISTER 1
UE2D2		EQU	$0032		;USB ENDPOINT 2 DATA REGISTER 2
UE2D3		EQU	$0033		;USB ENDPOINT 2 DATA REGISTER 3
UE2D4		EQU	$0034		;USB ENDPOINT 2 DATA REGISTER 4
UE2D5		EQU	$0035		;USB ENDPOINT 2 DATA REGISTER 5
UE2D6		EQU	$0036		;USB ENDPOINT 2 DATA REGISTER 6
UE2D7		EQU	$0037		;USB ENDPOINT 2 DATA REGISTER 7

UADDR		EQU	$0038		;USB ADDRESS REGISTER

UIR0		EQU	$0039		;USB INTERRUPT REGISTER 0
EOPIE		EQU	7
SUSPND		EQU	6
TXD2IE		EQU	5
RXD2IE		EQU	4
TXD1IE		EQU	3
TXD0IE		EQU	1
RXD0IE		EQU	0

UIR1		EQU	$003A		;USB INTERRUPT REGISTER 1
EOPF		EQU	7
RSTF		EQU	6
TXD2F		EQU	5
RXD2F		EQU	4
TXD1F		EQU	3
RESUMF		EQU	2
TXD0F		EQU	1
RXD0F		EQU	0

UCR0		EQU 	$003B		;USB CONTROL REGISTER 0
T0SEQ		EQU	7
TX0E		EQU	5
RX0E		EQU	4
TP0SIZ3		EQU	3
TP0SIZ2		EQU	2
TP0SIZ1		EQU	1
TP0SIZ0		EQU	0

UCR1		EQU 	$003C		;USB CONTROL REGISTER 1
T1SEQ		EQU	7
STALL1		EQU	6
TX1E		EQU	5
FRESUM		EQU	4
TP1SIZ3		EQU	3
TP1SIZ2		EQU	2
TP1SIZ1		EQU	1
TP1SIZ0		EQU	0

USR0		EQU 	$003D		;USB STATUS REGISTER 0
R0SEQ		EQU	7
SETUP		EQU	6
RP0SIZ3		EQU	3
RP0SIZ2		EQU	2
RP0SIZ1		EQU	1
RP0SIZ0		EQU	0

USR1		EQU 	$003E		;USB STATUS REGISTER 1
R2SEQ		EQU	7
TXACK		EQU	6
TXNAK		EQU	5
TXSTL		EQU	4
RP2SIZ3		EQU	3
RP2SIZ2		EQU	2
RP2SIZ1		EQU	1
RP2SIZ0		EQU	0

BSR		EQU	$FE00		;BREAK STATUS REGISTER
SBSW		EQU	1

RSR		EQU	$FE01		;RESET STATUS REGISTER
POR		EQU	7
PIN		EQU	6
COP		EQU	5
ILOP		EQU	4
ILAD		EQU	3
USB		EQU	2
LVI		EQU	1

BFCR		EQU	$FE03		;BREAK FLAG CONTROL REGISTER
BCFE		EQU	7

INT1		EQU	$FE04		;INTERRUPT STATUS REGISTER 1
IF6		EQU	7
IF5		EQU	6
IF4		EQU	5
IF3		EQU	4
IF1		EQU	2

FLCR		EQU	$FE08		;FLASH CONTROL REGISTER
HVEN		EQU	3
MASS		EQU	2
ERASE		EQU	1
PGM		EQU	0

FLBPR		EQU	$FE09		;FLASH BLOCK PROTECT REGISTER
BPR7		EQU	7
BPR6		EQU	6
BPR5		EQU	5
BPR4		EQU	4
BPR3		EQU	3
BPR2		EQU	2
BPR1		EQU	1
BPR0		EQU	0

BRKH		EQU	$FE0C		;BREAK ADDRESS HIGH REGISTER
BRKL		EQU	$FE0D		;BREAK ADDRESS LOW REGISTER

BRKSCR		EQU	$FE0E		;BREAK STATUS AND CONTROL REGISTER
BRKE		EQU	7
BRKA		EQU	6

COPCTL		EQU	$FFFF		;COP CONTROL REGISTER            
		
		endif
		restore
