/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.MonoSwimable;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.NotePosition;

public class InstructionSimple
extends MonoSwimable
implements Instruction {
    private boolean killed = false;
    private final Display label;
    private final HtmlColor color;
    private final LinkRendering inlinkRendering;
    private Display note;
    private NotePosition notePosition;
    private final BoxStyle style;
    private final Url url;

    public InstructionSimple(Display label, HtmlColor color, LinkRendering inlinkRendering, Swimlane swimlane, BoxStyle style, Url url) {
        super(swimlane);
        this.url = url;
        this.style = style;
        this.label = label;
        this.color = color;
        this.inlinkRendering = inlinkRendering;
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        Ftile result = factory.activity(this.label, this.color, this.getSwimlaneIn(), this.style);
        if (this.url != null) {
            result = factory.addUrl(result, this.url);
        }
        if (this.note != null) {
            result = factory.addNote(result, this.note, this.notePosition);
        }
        if (this.killed) {
            return new FtileKilled(result);
        }
        return result;
    }

    @Override
    public void add(Instruction other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean kill() {
        this.killed = true;
        return true;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }

    @Override
    public boolean addNote(Display note, NotePosition position) {
        this.note = note;
        this.notePosition = position;
        return true;
    }
}

