/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

class EntityImageActivity
extends AbstractEntityImage {
    private final TextBlock text;
    private final int xMargin = 10;
    private final int yMargin = 6;

    public EntityImageActivity(IEntity entity) {
        super(entity);
        this.text = entity.getDisplay().create(new FontConfiguration(this.getFont14(), HtmlColorUtils.BLACK, HtmlColorUtils.BLUE, true), HorizontalAlignment.CENTER, new SpriteContainerEmpty());
    }

    @Override
    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dim = this.text.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dim, 20.0, 12.0);
    }

    @Override
    public void draw(ColorMapper colorMapper, Graphics2D g2d) {
        Dimension2D dimTotal = this.getDimension(StringBounderUtils.asStringBounder(g2d));
        int width = (int)dimTotal.getWidth();
        int height = (int)dimTotal.getHeight();
        Polygon p = new Polygon();
        p.addPoint(0, 12);
        p.addPoint(20, 0);
        p.addPoint(width - 20, 0);
        p.addPoint(width, 12);
        p.addPoint(width, height - 12);
        p.addPoint(width - 20, height);
        p.addPoint(20, height);
        p.addPoint(0, height - 12);
        g2d.setColor(colorMapper.getMappedColor(this.getYellow()));
        g2d.fill(p);
        g2d.setColor(colorMapper.getMappedColor(this.getRed()));
        g2d.draw(p);
        g2d.setColor(Color.BLACK);
    }
}

