/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.DateEventUtils;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GraphicStrings
extends AbstractTextBlock
implements IEntityImage {
    private final HtmlColor background;
    private final UFont font;
    private final HtmlColor green;
    private final HtmlColor hyperlinkColor = HtmlColorUtils.BLUE;
    private final boolean useUnderlineForHyperlink = true;
    private final List<String> strings;
    private final BufferedImage image;
    private final GraphicPosition position;
    private final UAntiAliasing antiAliasing;
    private final ColorMapper colorMapper = new ColorMapperIdentity();
    private double minWidth;
    private int maxLine = 0;

    public static GraphicStrings createDefault(List<String> strings, boolean useRed) {
        if (useRed) {
            return new GraphicStrings(strings, new UFont("SansSerif", 1, 14), HtmlColorUtils.BLACK, HtmlColorUtils.RED_LIGHT, UAntiAliasing.ANTI_ALIASING_ON);
        }
        return new GraphicStrings(strings, new UFont("SansSerif", 1, 14), HtmlColorSet.getInstance().getColorIfValid("#33FF02"), HtmlColorUtils.BLACK, UAntiAliasing.ANTI_ALIASING_ON);
    }

    public GraphicStrings(List<String> strings, UFont font, HtmlColor green, HtmlColor background, UAntiAliasing antiAliasing) {
        this(strings, font, green, background, antiAliasing, null, null);
    }

    public GraphicStrings(List<String> strings, UFont font, HtmlColor green, HtmlColor background, UAntiAliasing antiAliasing, BufferedImage image, GraphicPosition position) {
        this.strings = strings;
        this.font = font;
        this.green = green;
        this.background = background;
        this.image = image;
        this.position = position;
        this.antiAliasing = antiAliasing;
    }

    public void setMinWidth(double minWidth) {
        this.minWidth = minWidth;
    }

    private TextBlock getTextBlock() {
        TextBlock result = null;
        if (this.maxLine == 0) {
            result = Display.create(this.strings).create(new FontConfiguration(this.font, this.green, this.hyperlinkColor, true), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        } else {
            for (int i = 0; i < this.strings.size(); i += this.maxLine) {
                int n = Math.min(i + this.maxLine, this.strings.size());
                TextBlock textBlock1 = Display.create(this.strings.subList(i, n)).create(new FontConfiguration(this.font, this.green, this.hyperlinkColor, true), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
                if (result == null) {
                    result = textBlock1;
                    continue;
                }
                result = TextBlockUtils.withMargin(result, 0.0, 10.0, 0.0, 0.0);
                result = TextBlockUtils.mergeLR(result, textBlock1, VerticalAlignment.TOP);
            }
        }
        result = DateEventUtils.addEvent(result, this.green);
        return result;
    }

    @Override
    public void drawU(UGraphic ug) {
        Dimension2D size = this.calculateDimension(ug.getStringBounder());
        this.getTextBlock().drawU(ug.apply(new UChangeColor(this.green)));
        if (this.image != null) {
            if (this.position == GraphicPosition.BOTTOM) {
                ug.apply(new UTranslate((size.getWidth() - (double)this.image.getWidth()) / 2.0, size.getHeight() - (double)this.image.getHeight())).draw(new UImage(this.image));
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT) {
                ug.apply(new UTranslate(size.getWidth() - (double)this.image.getWidth(), size.getHeight() - (double)this.image.getHeight())).draw(new UImage(this.image));
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT) {
                ug.apply(new UTranslate(size.getWidth() - (double)this.image.getWidth() - 1.0, 1.0)).draw(new UImage(this.image));
            }
        }
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.getTextBlock().calculateDimension(stringBounder);
        if (dim.getWidth() < this.minWidth) {
            dim = new Dimension2DDouble(this.minWidth, dim.getHeight());
        }
        if (this.image != null) {
            if (this.position == GraphicPosition.BOTTOM) {
                dim = new Dimension2DDouble(dim.getWidth(), dim.getHeight() + (double)this.image.getHeight());
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT) {
                dim = new Dimension2DDouble(dim.getWidth() + (double)this.image.getWidth(), dim.getHeight());
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT) {
                dim = new Dimension2DDouble(dim.getWidth() + (double)this.image.getWidth(), dim.getHeight());
            }
        }
        return dim;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public HtmlColor getBackcolor() {
        return this.background;
    }

    @Override
    public int getShield() {
        return 0;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    public final void setMaxLine(int maxLine) {
        this.maxLine = maxLine;
    }
}

