/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.objectdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.objectdiagram.ObjectDiagram;

public class CommandCreateEntityObject
extends SingleLineCommand2<ObjectDiagram> {
    public CommandCreateEntityObject() {
        super(CommandCreateEntityObject.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(object)[%s]+"), new RegexLeaf("NAME", "(?:[%g]([^%g]+)[%g][%s]+as[%s]+)?([\\p{L}0-9_.]+)"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), ColorParser.exp1(), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(ObjectDiagram diagram, RegexResult arg) {
        String urlString;
        Code code = Code.of(arg.get("NAME", 1));
        String display = arg.get("NAME", 0);
        String stereotype = arg.get("STEREO", 0);
        if (diagram.leafExist(code)) {
            return CommandExecutionResult.error("Object already exists : " + code);
        }
        ILeaf entity = diagram.createLeaf(code, Display.getWithNewlines(display), LeafType.OBJECT, null);
        if (stereotype != null) {
            entity.setStereotype(new Stereotype(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null, false), diagram.getSkinParam().getIHtmlColorSet()));
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            entity.addUrl(url);
        }
        entity.setSpecificBackcolor(diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("COLOR", 0)));
        return CommandExecutionResult.ok();
    }
}

