/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Delay;
import net.sourceforge.plantuml.sequencediagram.Divider;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import net.sourceforge.plantuml.sequencediagram.GroupingStart;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.Reference;
import net.sourceforge.plantuml.sequencediagram.teoz.CommunicationExoTile;
import net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTile;
import net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileNoteLeft;
import net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileNoteRight;
import net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileSelf;
import net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileSelfNoteRight;
import net.sourceforge.plantuml.sequencediagram.teoz.DelayTile;
import net.sourceforge.plantuml.sequencediagram.teoz.DividerTile;
import net.sourceforge.plantuml.sequencediagram.teoz.ElseTile;
import net.sourceforge.plantuml.sequencediagram.teoz.GroupingTile;
import net.sourceforge.plantuml.sequencediagram.teoz.LifeEventTile;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import net.sourceforge.plantuml.sequencediagram.teoz.NoteTile;
import net.sourceforge.plantuml.sequencediagram.teoz.ReferenceTile;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithUpdateStairs;
import net.sourceforge.plantuml.skin.Skin;

public class TileBuilder {
    public static List<Tile> buildSeveral(Iterator<Event> it, TileArguments tileArguments, Tile parent) {
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        while (it.hasNext()) {
            Event ev = it.next();
            Tile tile = TileBuilder.buildOne(it, tileArguments, ev, parent);
            if (tile == null) continue;
            tiles.add(tile);
            Real tmpMax = tile.getMaxX(tileArguments.getStringBounder());
        }
        return Collections.unmodifiableList(tiles);
    }

    public static Tile buildOne(Iterator<Event> it, TileArguments tileArguments, Event ev, Tile parent) {
        StringBounder stringBounder = tileArguments.getStringBounder();
        Skin skin = tileArguments.getSkin();
        ISkinParam skinParam = tileArguments.getSkinParam();
        LivingSpaces livingSpaces = tileArguments.getLivingSpaces();
        Tile tile = null;
        if (ev instanceof Message) {
            Message msg = (Message)ev;
            LivingSpace livingSpace1 = livingSpaces.get(msg.getParticipant1());
            LivingSpace livingSpace2 = livingSpaces.get(msg.getParticipant2());
            boolean reverse = false;
            if (msg.isSelfMessage()) {
                tile = new CommunicationTileSelf(livingSpace1, msg, skin, skinParam, livingSpaces);
            } else {
                tile = new CommunicationTile(livingSpace1, livingSpace2, msg, skin, skinParam);
                reverse = ((CommunicationTile)tile).isReverse(stringBounder);
            }
            if (msg.getNote() != null) {
                NotePosition notePosition = msg.getNotePosition();
                if (notePosition == NotePosition.LEFT) {
                    tile = new CommunicationTileNoteLeft((TileWithUpdateStairs)tile, msg, skin, skinParam, reverse ? livingSpace2 : livingSpace1);
                } else if (notePosition == NotePosition.RIGHT && msg.isSelfMessage()) {
                    tile = new CommunicationTileSelfNoteRight((CommunicationTileSelf)tile, msg, skin, skinParam);
                } else if (notePosition == NotePosition.RIGHT) {
                    tile = new CommunicationTileNoteRight((TileWithUpdateStairs)tile, msg, skin, skinParam, reverse ? livingSpace1 : livingSpace2);
                }
            }
        } else if (ev instanceof MessageExo) {
            MessageExo exo = (MessageExo)ev;
            LivingSpace livingSpace1 = livingSpaces.get(exo.getParticipant());
            tile = new CommunicationExoTile(livingSpace1, exo, skin, skinParam, tileArguments);
            if (exo.getNote() != null) {
                NotePosition notePosition = exo.getNotePosition();
                if (notePosition == NotePosition.LEFT) {
                    tile = new CommunicationTileNoteLeft((TileWithUpdateStairs)tile, exo, skin, skinParam, livingSpace1);
                } else if (notePosition == NotePosition.RIGHT) {
                    tile = new CommunicationTileNoteRight((TileWithUpdateStairs)tile, exo, skin, skinParam, livingSpace1);
                }
            }
        } else if (ev instanceof Note) {
            Note note = (Note)ev;
            LivingSpace livingSpace1 = livingSpaces.get(note.getParticipant());
            LivingSpace livingSpace2 = note.getParticipant2() == null ? null : livingSpaces.get(note.getParticipant2());
            tile = new NoteTile(livingSpace1, livingSpace2, note, skin, skinParam);
        } else if (ev instanceof Divider) {
            Divider divider = (Divider)ev;
            tile = new DividerTile(divider, tileArguments);
        } else if (ev instanceof GroupingStart) {
            GroupingStart start = (GroupingStart)ev;
            tile = new GroupingTile(it, start, tileArguments.withBackColorGeneral(start.getBackColorElement(), start.getBackColorGeneral()), tileArguments);
        } else if (ev instanceof GroupingLeaf && ((GroupingLeaf)ev).getType() == GroupingType.ELSE) {
            GroupingLeaf anElse = (GroupingLeaf)ev;
            tile = new ElseTile(anElse, skin, skinParam, parent);
        } else if (ev instanceof Reference) {
            Reference ref = (Reference)ev;
            tile = new ReferenceTile(ref, tileArguments.withBackColor(ref));
        } else if (ev instanceof Delay) {
            Delay delay = (Delay)ev;
            tile = new DelayTile(delay, tileArguments);
        } else if (ev instanceof LifeEvent) {
            LifeEvent lifeEvent = (LifeEvent)ev;
            LivingSpace livingSpace = livingSpaces.get(lifeEvent.getParticipant());
            tile = new LifeEventTile(lifeEvent, tileArguments, livingSpace, skin, skinParam);
        } else {
            System.err.println("TileBuilder::Ignoring " + ev.getClass());
        }
        return tile;
    }
}

