/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;

public class FillRoundShape {
    private final double width;
    private final double height;
    private final double corner;
    private final HtmlColor c1;
    private final HtmlColor c2;

    public FillRoundShape(double width, double height, HtmlColor c1, HtmlColor c2, double corner) {
        this.width = width;
        this.height = height;
        this.c1 = c1;
        this.c2 = c2;
        this.corner = corner;
    }

    public void draw(ColorMapper mapper, Graphics2D g2d) {
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, mapper.getMappedColor(this.c1), (float)this.width, (float)this.height, mapper.getMappedColor(this.c2));
        RoundRectangle2D.Double r = new RoundRectangle2D.Double(0.0, 0.0, this.width, this.height, this.corner * 2.0, this.corner * 2.0);
        g2d.setPaint(paint);
        g2d.fill(r);
    }

    public void drawU(UGraphic ug) {
        HtmlColorGradient gradient = new HtmlColorGradient(this.c1, this.c2, '\\');
        URectangle r = new URectangle(this.width, this.height, this.corner * 2.0, this.corner * 2.0);
        ug.apply(new UChangeBackColor(gradient)).draw(r);
    }
}

