// Copyright 2020-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: buf/alpha/registry/v1alpha1/recommendation.proto

package registryv1alpha1connect

import (
	connect "connectrpc.com/connect"
	context "context"
	errors "errors"
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// RecommendationServiceName is the fully-qualified name of the RecommendationService service.
	RecommendationServiceName = "buf.alpha.registry.v1alpha1.RecommendationService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// RecommendationServiceRecommendedRepositoriesProcedure is the fully-qualified name of the
	// RecommendationService's RecommendedRepositories RPC.
	RecommendationServiceRecommendedRepositoriesProcedure = "/buf.alpha.registry.v1alpha1.RecommendationService/RecommendedRepositories"
	// RecommendationServiceListRecommendedResourcesProcedure is the fully-qualified name of the
	// RecommendationService's ListRecommendedResources RPC.
	RecommendationServiceListRecommendedResourcesProcedure = "/buf.alpha.registry.v1alpha1.RecommendationService/ListRecommendedResources"
	// RecommendationServiceSetRecommendedResourcesProcedure is the fully-qualified name of the
	// RecommendationService's SetRecommendedResources RPC.
	RecommendationServiceSetRecommendedResourcesProcedure = "/buf.alpha.registry.v1alpha1.RecommendationService/SetRecommendedResources"
)

// These variables are the protoreflect.Descriptor objects for the RPCs defined in this package.
var (
	recommendationServiceServiceDescriptor                        = v1alpha1.File_buf_alpha_registry_v1alpha1_recommendation_proto.Services().ByName("RecommendationService")
	recommendationServiceRecommendedRepositoriesMethodDescriptor  = recommendationServiceServiceDescriptor.Methods().ByName("RecommendedRepositories")
	recommendationServiceListRecommendedResourcesMethodDescriptor = recommendationServiceServiceDescriptor.Methods().ByName("ListRecommendedResources")
	recommendationServiceSetRecommendedResourcesMethodDescriptor  = recommendationServiceServiceDescriptor.Methods().ByName("SetRecommendedResources")
)

// RecommendationServiceClient is a client for the buf.alpha.registry.v1alpha1.RecommendationService
// service.
type RecommendationServiceClient interface {
	// RecommendedRepositories returns a list of recommended repositories.
	RecommendedRepositories(context.Context, *connect.Request[v1alpha1.RecommendedRepositoriesRequest]) (*connect.Response[v1alpha1.RecommendedRepositoriesResponse], error)
	// ListRecommendedResources returns a list of recommended resources.
	ListRecommendedResources(context.Context, *connect.Request[v1alpha1.ListRecommendedResourcesRequest]) (*connect.Response[v1alpha1.ListRecommendedResourcesResponse], error)
	// SetRecommendedResources set the list of recommended resources in the server.
	SetRecommendedResources(context.Context, *connect.Request[v1alpha1.SetRecommendedResourcesRequest]) (*connect.Response[v1alpha1.SetRecommendedResourcesResponse], error)
}

// NewRecommendationServiceClient constructs a client for the
// buf.alpha.registry.v1alpha1.RecommendationService service. By default, it uses the Connect
// protocol with the binary Protobuf Codec, asks for gzipped responses, and sends uncompressed
// requests. To use the gRPC or gRPC-Web protocols, supply the connect.WithGRPC() or
// connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewRecommendationServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) RecommendationServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	return &recommendationServiceClient{
		recommendedRepositories: connect.NewClient[v1alpha1.RecommendedRepositoriesRequest, v1alpha1.RecommendedRepositoriesResponse](
			httpClient,
			baseURL+RecommendationServiceRecommendedRepositoriesProcedure,
			connect.WithSchema(recommendationServiceRecommendedRepositoriesMethodDescriptor),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		listRecommendedResources: connect.NewClient[v1alpha1.ListRecommendedResourcesRequest, v1alpha1.ListRecommendedResourcesResponse](
			httpClient,
			baseURL+RecommendationServiceListRecommendedResourcesProcedure,
			connect.WithSchema(recommendationServiceListRecommendedResourcesMethodDescriptor),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		setRecommendedResources: connect.NewClient[v1alpha1.SetRecommendedResourcesRequest, v1alpha1.SetRecommendedResourcesResponse](
			httpClient,
			baseURL+RecommendationServiceSetRecommendedResourcesProcedure,
			connect.WithSchema(recommendationServiceSetRecommendedResourcesMethodDescriptor),
			connect.WithIdempotency(connect.IdempotencyIdempotent),
			connect.WithClientOptions(opts...),
		),
	}
}

// recommendationServiceClient implements RecommendationServiceClient.
type recommendationServiceClient struct {
	recommendedRepositories  *connect.Client[v1alpha1.RecommendedRepositoriesRequest, v1alpha1.RecommendedRepositoriesResponse]
	listRecommendedResources *connect.Client[v1alpha1.ListRecommendedResourcesRequest, v1alpha1.ListRecommendedResourcesResponse]
	setRecommendedResources  *connect.Client[v1alpha1.SetRecommendedResourcesRequest, v1alpha1.SetRecommendedResourcesResponse]
}

// RecommendedRepositories calls
// buf.alpha.registry.v1alpha1.RecommendationService.RecommendedRepositories.
func (c *recommendationServiceClient) RecommendedRepositories(ctx context.Context, req *connect.Request[v1alpha1.RecommendedRepositoriesRequest]) (*connect.Response[v1alpha1.RecommendedRepositoriesResponse], error) {
	return c.recommendedRepositories.CallUnary(ctx, req)
}

// ListRecommendedResources calls
// buf.alpha.registry.v1alpha1.RecommendationService.ListRecommendedResources.
func (c *recommendationServiceClient) ListRecommendedResources(ctx context.Context, req *connect.Request[v1alpha1.ListRecommendedResourcesRequest]) (*connect.Response[v1alpha1.ListRecommendedResourcesResponse], error) {
	return c.listRecommendedResources.CallUnary(ctx, req)
}

// SetRecommendedResources calls
// buf.alpha.registry.v1alpha1.RecommendationService.SetRecommendedResources.
func (c *recommendationServiceClient) SetRecommendedResources(ctx context.Context, req *connect.Request[v1alpha1.SetRecommendedResourcesRequest]) (*connect.Response[v1alpha1.SetRecommendedResourcesResponse], error) {
	return c.setRecommendedResources.CallUnary(ctx, req)
}

// RecommendationServiceHandler is an implementation of the
// buf.alpha.registry.v1alpha1.RecommendationService service.
type RecommendationServiceHandler interface {
	// RecommendedRepositories returns a list of recommended repositories.
	RecommendedRepositories(context.Context, *connect.Request[v1alpha1.RecommendedRepositoriesRequest]) (*connect.Response[v1alpha1.RecommendedRepositoriesResponse], error)
	// ListRecommendedResources returns a list of recommended resources.
	ListRecommendedResources(context.Context, *connect.Request[v1alpha1.ListRecommendedResourcesRequest]) (*connect.Response[v1alpha1.ListRecommendedResourcesResponse], error)
	// SetRecommendedResources set the list of recommended resources in the server.
	SetRecommendedResources(context.Context, *connect.Request[v1alpha1.SetRecommendedResourcesRequest]) (*connect.Response[v1alpha1.SetRecommendedResourcesResponse], error)
}

// NewRecommendationServiceHandler builds an HTTP handler from the service implementation. It
// returns the path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewRecommendationServiceHandler(svc RecommendationServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	recommendationServiceRecommendedRepositoriesHandler := connect.NewUnaryHandler(
		RecommendationServiceRecommendedRepositoriesProcedure,
		svc.RecommendedRepositories,
		connect.WithSchema(recommendationServiceRecommendedRepositoriesMethodDescriptor),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	recommendationServiceListRecommendedResourcesHandler := connect.NewUnaryHandler(
		RecommendationServiceListRecommendedResourcesProcedure,
		svc.ListRecommendedResources,
		connect.WithSchema(recommendationServiceListRecommendedResourcesMethodDescriptor),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	recommendationServiceSetRecommendedResourcesHandler := connect.NewUnaryHandler(
		RecommendationServiceSetRecommendedResourcesProcedure,
		svc.SetRecommendedResources,
		connect.WithSchema(recommendationServiceSetRecommendedResourcesMethodDescriptor),
		connect.WithIdempotency(connect.IdempotencyIdempotent),
		connect.WithHandlerOptions(opts...),
	)
	return "/buf.alpha.registry.v1alpha1.RecommendationService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case RecommendationServiceRecommendedRepositoriesProcedure:
			recommendationServiceRecommendedRepositoriesHandler.ServeHTTP(w, r)
		case RecommendationServiceListRecommendedResourcesProcedure:
			recommendationServiceListRecommendedResourcesHandler.ServeHTTP(w, r)
		case RecommendationServiceSetRecommendedResourcesProcedure:
			recommendationServiceSetRecommendedResourcesHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedRecommendationServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedRecommendationServiceHandler struct{}

func (UnimplementedRecommendationServiceHandler) RecommendedRepositories(context.Context, *connect.Request[v1alpha1.RecommendedRepositoriesRequest]) (*connect.Response[v1alpha1.RecommendedRepositoriesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.RecommendationService.RecommendedRepositories is not implemented"))
}

func (UnimplementedRecommendationServiceHandler) ListRecommendedResources(context.Context, *connect.Request[v1alpha1.ListRecommendedResourcesRequest]) (*connect.Response[v1alpha1.ListRecommendedResourcesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.RecommendationService.ListRecommendedResources is not implemented"))
}

func (UnimplementedRecommendationServiceHandler) SetRecommendedResources(context.Context, *connect.Request[v1alpha1.SetRecommendedResourcesRequest]) (*connect.Response[v1alpha1.SetRecommendedResourcesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.RecommendationService.SetRecommendedResources is not implemented"))
}
