// Copyright 2020-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2-devel
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/admin.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// BreakingChangeCategory is the allowed list of categories for breaking rule settings.
type BreakingChangeCategory int32

const (
	BreakingChangeCategory_BREAKING_CHANGE_CATEGORY_UNSPECIFIED BreakingChangeCategory = 0
	BreakingChangeCategory_BREAKING_CHANGE_CATEGORY_FILE        BreakingChangeCategory = 1
	BreakingChangeCategory_BREAKING_CHANGE_CATEGORY_WIRE_JSON   BreakingChangeCategory = 2
)

// Enum value maps for BreakingChangeCategory.
var (
	BreakingChangeCategory_name = map[int32]string{
		0: "BREAKING_CHANGE_CATEGORY_UNSPECIFIED",
		1: "BREAKING_CHANGE_CATEGORY_FILE",
		2: "BREAKING_CHANGE_CATEGORY_WIRE_JSON",
	}
	BreakingChangeCategory_value = map[string]int32{
		"BREAKING_CHANGE_CATEGORY_UNSPECIFIED": 0,
		"BREAKING_CHANGE_CATEGORY_FILE":        1,
		"BREAKING_CHANGE_CATEGORY_WIRE_JSON":   2,
	}
)

func (x BreakingChangeCategory) Enum() *BreakingChangeCategory {
	p := new(BreakingChangeCategory)
	*p = x
	return p
}

func (x BreakingChangeCategory) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BreakingChangeCategory) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_admin_proto_enumTypes[0].Descriptor()
}

func (BreakingChangeCategory) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_admin_proto_enumTypes[0]
}

func (x BreakingChangeCategory) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BreakingChangeCategory.Descriptor instead.
func (BreakingChangeCategory) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{0}
}

// CollisionType is the type of collisions that can occur.
type CollisionType int32

const (
	// Unspecified collision type.
	CollisionType_COLLISION_TYPE_UNSPECIFIED CollisionType = 0
	// A fully qualified proto name
	CollisionType_COLLISION_TYPE_FULLY_QUALIFIED_NAME CollisionType = 1
	// A proto file path
	CollisionType_COLLISION_TYPE_PATH CollisionType = 2
)

// Enum value maps for CollisionType.
var (
	CollisionType_name = map[int32]string{
		0: "COLLISION_TYPE_UNSPECIFIED",
		1: "COLLISION_TYPE_FULLY_QUALIFIED_NAME",
		2: "COLLISION_TYPE_PATH",
	}
	CollisionType_value = map[string]int32{
		"COLLISION_TYPE_UNSPECIFIED":          0,
		"COLLISION_TYPE_FULLY_QUALIFIED_NAME": 1,
		"COLLISION_TYPE_PATH":                 2,
	}
)

func (x CollisionType) Enum() *CollisionType {
	p := new(CollisionType)
	*p = x
	return p
}

func (x CollisionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CollisionType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_admin_proto_enumTypes[1].Descriptor()
}

func (CollisionType) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_admin_proto_enumTypes[1]
}

func (x CollisionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CollisionType.Descriptor instead.
func (CollisionType) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{1}
}

type BreakingChangePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Enabled                *bool                  `protobuf:"varint,1,opt,name=enabled,proto3,oneof" json:"enabled,omitempty"`
	IgnoreUnstablePackages *bool                  `protobuf:"varint,2,opt,name=ignore_unstable_packages,json=ignoreUnstablePackages,proto3,oneof" json:"ignore_unstable_packages,omitempty"`
	Category               BreakingChangeCategory `protobuf:"varint,3,opt,name=category,proto3,enum=buf.alpha.registry.v1alpha1.BreakingChangeCategory" json:"category,omitempty"`
}

func (x *BreakingChangePolicy) Reset() {
	*x = BreakingChangePolicy{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BreakingChangePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BreakingChangePolicy) ProtoMessage() {}

func (x *BreakingChangePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BreakingChangePolicy.ProtoReflect.Descriptor instead.
func (*BreakingChangePolicy) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{0}
}

func (x *BreakingChangePolicy) GetEnabled() bool {
	if x != nil && x.Enabled != nil {
		return *x.Enabled
	}
	return false
}

func (x *BreakingChangePolicy) GetIgnoreUnstablePackages() bool {
	if x != nil && x.IgnoreUnstablePackages != nil {
		return *x.IgnoreUnstablePackages
	}
	return false
}

func (x *BreakingChangePolicy) GetCategory() BreakingChangeCategory {
	if x != nil {
		return x.Category
	}
	return BreakingChangeCategory_BREAKING_CHANGE_CATEGORY_UNSPECIFIED
}

// UniquenessPolicy is the policy for uniqueness on the server.
type UniquenessPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether uniqueness policy is enforced.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *UniquenessPolicy) Reset() {
	*x = UniquenessPolicy{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UniquenessPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UniquenessPolicy) ProtoMessage() {}

func (x *UniquenessPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UniquenessPolicy.ProtoReflect.Descriptor instead.
func (*UniquenessPolicy) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{1}
}

func (x *UniquenessPolicy) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// ReviewFlowGracePeriodPolicy is the policy for the review flow grace period on the server.
type ReviewFlowGracePeriodPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of seconds of the grace period.
	// Set to zero to disable the grace period.
	DurationSeconds uint32 `protobuf:"varint,1,opt,name=duration_seconds,json=durationSeconds,proto3" json:"duration_seconds,omitempty"`
}

func (x *ReviewFlowGracePeriodPolicy) Reset() {
	*x = ReviewFlowGracePeriodPolicy{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReviewFlowGracePeriodPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReviewFlowGracePeriodPolicy) ProtoMessage() {}

func (x *ReviewFlowGracePeriodPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReviewFlowGracePeriodPolicy.ProtoReflect.Descriptor instead.
func (*ReviewFlowGracePeriodPolicy) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{2}
}

func (x *ReviewFlowGracePeriodPolicy) GetDurationSeconds() uint32 {
	if x != nil {
		return x.DurationSeconds
	}
	return 0
}

// Collision is a collision that has occurred.
type Collision struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The reference that has collisions.
	Reference string `protobuf:"bytes,1,opt,name=reference,proto3" json:"reference,omitempty"`
	// The type of collision.
	Type CollisionType `protobuf:"varint,2,opt,name=type,proto3,enum=buf.alpha.registry.v1alpha1.CollisionType" json:"type,omitempty"`
	// The sources of the collision that the user is authorized to see.
	Sources []*CollisionSource `protobuf:"bytes,3,rep,name=sources,proto3" json:"sources,omitempty"`
	// Whether there are other collision sources that the user is not authorized to see.
	// The user should contact a server admin for more information about these collisions.
	HasOtherCollisionSources bool `protobuf:"varint,4,opt,name=has_other_collision_sources,json=hasOtherCollisionSources,proto3" json:"has_other_collision_sources,omitempty"`
}

func (x *Collision) Reset() {
	*x = Collision{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Collision) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Collision) ProtoMessage() {}

func (x *Collision) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Collision.ProtoReflect.Descriptor instead.
func (*Collision) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{3}
}

func (x *Collision) GetReference() string {
	if x != nil {
		return x.Reference
	}
	return ""
}

func (x *Collision) GetType() CollisionType {
	if x != nil {
		return x.Type
	}
	return CollisionType_COLLISION_TYPE_UNSPECIFIED
}

func (x *Collision) GetSources() []*CollisionSource {
	if x != nil {
		return x.Sources
	}
	return nil
}

func (x *Collision) GetHasOtherCollisionSources() bool {
	if x != nil {
		return x.HasOtherCollisionSources
	}
	return false
}

// CollisionSource is the source of a collision
type CollisionSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the owner of the source.
	OwnerName string `protobuf:"bytes,1,opt,name=owner_name,json=ownerName,proto3" json:"owner_name,omitempty"`
	// The name of the repository of the source.
	RepositoryName string `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3" json:"repository_name,omitempty"`
	// The path of the file that is the source of the collision.
	Path string `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *CollisionSource) Reset() {
	*x = CollisionSource{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CollisionSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CollisionSource) ProtoMessage() {}

func (x *CollisionSource) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CollisionSource.ProtoReflect.Descriptor instead.
func (*CollisionSource) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{4}
}

func (x *CollisionSource) GetOwnerName() string {
	if x != nil {
		return x.OwnerName
	}
	return ""
}

func (x *CollisionSource) GetRepositoryName() string {
	if x != nil {
		return x.RepositoryName
	}
	return ""
}

func (x *CollisionSource) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// MonthlyUsage contains the total amount of message, enum and services types
// for every organizations repositories within a single tenant BSR instance
// for a given month and year.
type MonthlyUsage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The month, between 1 and 12.
	Month uint32 `protobuf:"varint,1,opt,name=month,proto3" json:"month,omitempty"`
	// The year, between 2020 and the current year.
	Year uint32 `protobuf:"varint,2,opt,name=year,proto3" json:"year,omitempty"`
	// The total amount of message types for the month and year.
	TotalMessageTypes uint32 `protobuf:"varint,3,opt,name=total_message_types,json=totalMessageTypes,proto3" json:"total_message_types,omitempty"`
	// The total amount of enum types for the month and year.
	TotalEnumTypes uint32 `protobuf:"varint,4,opt,name=total_enum_types,json=totalEnumTypes,proto3" json:"total_enum_types,omitempty"`
	// The total amount of method types for the month and year.
	TotalMethodTypes uint32 `protobuf:"varint,5,opt,name=total_method_types,json=totalMethodTypes,proto3" json:"total_method_types,omitempty"`
}

func (x *MonthlyUsage) Reset() {
	*x = MonthlyUsage{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MonthlyUsage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonthlyUsage) ProtoMessage() {}

func (x *MonthlyUsage) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonthlyUsage.ProtoReflect.Descriptor instead.
func (*MonthlyUsage) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{5}
}

func (x *MonthlyUsage) GetMonth() uint32 {
	if x != nil {
		return x.Month
	}
	return 0
}

func (x *MonthlyUsage) GetYear() uint32 {
	if x != nil {
		return x.Year
	}
	return 0
}

func (x *MonthlyUsage) GetTotalMessageTypes() uint32 {
	if x != nil {
		return x.TotalMessageTypes
	}
	return 0
}

func (x *MonthlyUsage) GetTotalEnumTypes() uint32 {
	if x != nil {
		return x.TotalEnumTypes
	}
	return 0
}

func (x *MonthlyUsage) GetTotalMethodTypes() uint32 {
	if x != nil {
		return x.TotalMethodTypes
	}
	return 0
}

type ForceDeleteUserRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
}

func (x *ForceDeleteUserRequest) Reset() {
	*x = ForceDeleteUserRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ForceDeleteUserRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForceDeleteUserRequest) ProtoMessage() {}

func (x *ForceDeleteUserRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForceDeleteUserRequest.ProtoReflect.Descriptor instead.
func (*ForceDeleteUserRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{6}
}

func (x *ForceDeleteUserRequest) GetUserId() string {
	if x != nil {
		return x.UserId
	}
	return ""
}

type ForceDeleteUserResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The deleted user.
	User *User `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	// The deleted organizations.
	Organizations []*Organization `protobuf:"bytes,2,rep,name=organizations,proto3" json:"organizations,omitempty"`
	// The deleted repositories.
	Repositories []*Repository `protobuf:"bytes,3,rep,name=repositories,proto3" json:"repositories,omitempty"`
}

func (x *ForceDeleteUserResponse) Reset() {
	*x = ForceDeleteUserResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ForceDeleteUserResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForceDeleteUserResponse) ProtoMessage() {}

func (x *ForceDeleteUserResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForceDeleteUserResponse.ProtoReflect.Descriptor instead.
func (*ForceDeleteUserResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{7}
}

func (x *ForceDeleteUserResponse) GetUser() *User {
	if x != nil {
		return x.User
	}
	return nil
}

func (x *ForceDeleteUserResponse) GetOrganizations() []*Organization {
	if x != nil {
		return x.Organizations
	}
	return nil
}

func (x *ForceDeleteUserResponse) GetRepositories() []*Repository {
	if x != nil {
		return x.Repositories
	}
	return nil
}

type UpdateUserVerificationStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UserId             string             `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	VerificationStatus VerificationStatus `protobuf:"varint,2,opt,name=verification_status,json=verificationStatus,proto3,enum=buf.alpha.registry.v1alpha1.VerificationStatus" json:"verification_status,omitempty"`
}

func (x *UpdateUserVerificationStatusRequest) Reset() {
	*x = UpdateUserVerificationStatusRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateUserVerificationStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUserVerificationStatusRequest) ProtoMessage() {}

func (x *UpdateUserVerificationStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateUserVerificationStatusRequest.ProtoReflect.Descriptor instead.
func (*UpdateUserVerificationStatusRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateUserVerificationStatusRequest) GetUserId() string {
	if x != nil {
		return x.UserId
	}
	return ""
}

func (x *UpdateUserVerificationStatusRequest) GetVerificationStatus() VerificationStatus {
	if x != nil {
		return x.VerificationStatus
	}
	return VerificationStatus_VERIFICATION_STATUS_UNSPECIFIED
}

type UpdateUserVerificationStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateUserVerificationStatusResponse) Reset() {
	*x = UpdateUserVerificationStatusResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateUserVerificationStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUserVerificationStatusResponse) ProtoMessage() {}

func (x *UpdateUserVerificationStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateUserVerificationStatusResponse.ProtoReflect.Descriptor instead.
func (*UpdateUserVerificationStatusResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{9}
}

type UpdateOrganizationVerificationStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	OrganizationId     string             `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	VerificationStatus VerificationStatus `protobuf:"varint,2,opt,name=verification_status,json=verificationStatus,proto3,enum=buf.alpha.registry.v1alpha1.VerificationStatus" json:"verification_status,omitempty"`
}

func (x *UpdateOrganizationVerificationStatusRequest) Reset() {
	*x = UpdateOrganizationVerificationStatusRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateOrganizationVerificationStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOrganizationVerificationStatusRequest) ProtoMessage() {}

func (x *UpdateOrganizationVerificationStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateOrganizationVerificationStatusRequest.ProtoReflect.Descriptor instead.
func (*UpdateOrganizationVerificationStatusRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{10}
}

func (x *UpdateOrganizationVerificationStatusRequest) GetOrganizationId() string {
	if x != nil {
		return x.OrganizationId
	}
	return ""
}

func (x *UpdateOrganizationVerificationStatusRequest) GetVerificationStatus() VerificationStatus {
	if x != nil {
		return x.VerificationStatus
	}
	return VerificationStatus_VERIFICATION_STATUS_UNSPECIFIED
}

type UpdateOrganizationVerificationStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateOrganizationVerificationStatusResponse) Reset() {
	*x = UpdateOrganizationVerificationStatusResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateOrganizationVerificationStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOrganizationVerificationStatusResponse) ProtoMessage() {}

func (x *UpdateOrganizationVerificationStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateOrganizationVerificationStatusResponse.ProtoReflect.Descriptor instead.
func (*UpdateOrganizationVerificationStatusResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{11}
}

type CreateMachineUserRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
}

func (x *CreateMachineUserRequest) Reset() {
	*x = CreateMachineUserRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateMachineUserRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMachineUserRequest) ProtoMessage() {}

func (x *CreateMachineUserRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMachineUserRequest.ProtoReflect.Descriptor instead.
func (*CreateMachineUserRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{12}
}

func (x *CreateMachineUserRequest) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

type CreateMachineUserResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	User *User `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
}

func (x *CreateMachineUserResponse) Reset() {
	*x = CreateMachineUserResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateMachineUserResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMachineUserResponse) ProtoMessage() {}

func (x *CreateMachineUserResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMachineUserResponse.ProtoReflect.Descriptor instead.
func (*CreateMachineUserResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{13}
}

func (x *CreateMachineUserResponse) GetUser() *User {
	if x != nil {
		return x.User
	}
	return nil
}

type GetBreakingChangePolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetBreakingChangePolicyRequest) Reset() {
	*x = GetBreakingChangePolicyRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBreakingChangePolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBreakingChangePolicyRequest) ProtoMessage() {}

func (x *GetBreakingChangePolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBreakingChangePolicyRequest.ProtoReflect.Descriptor instead.
func (*GetBreakingChangePolicyRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{14}
}

type GetBreakingChangePolicyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Policy *BreakingChangePolicy `protobuf:"bytes,1,opt,name=policy,proto3" json:"policy,omitempty"`
}

func (x *GetBreakingChangePolicyResponse) Reset() {
	*x = GetBreakingChangePolicyResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBreakingChangePolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBreakingChangePolicyResponse) ProtoMessage() {}

func (x *GetBreakingChangePolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBreakingChangePolicyResponse.ProtoReflect.Descriptor instead.
func (*GetBreakingChangePolicyResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{15}
}

func (x *GetBreakingChangePolicyResponse) GetPolicy() *BreakingChangePolicy {
	if x != nil {
		return x.Policy
	}
	return nil
}

type UpdateBreakingChangePolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Policy *BreakingChangePolicy `protobuf:"bytes,1,opt,name=policy,proto3" json:"policy,omitempty"`
}

func (x *UpdateBreakingChangePolicyRequest) Reset() {
	*x = UpdateBreakingChangePolicyRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateBreakingChangePolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBreakingChangePolicyRequest) ProtoMessage() {}

func (x *UpdateBreakingChangePolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBreakingChangePolicyRequest.ProtoReflect.Descriptor instead.
func (*UpdateBreakingChangePolicyRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{16}
}

func (x *UpdateBreakingChangePolicyRequest) GetPolicy() *BreakingChangePolicy {
	if x != nil {
		return x.Policy
	}
	return nil
}

type UpdateBreakingChangePolicyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateBreakingChangePolicyResponse) Reset() {
	*x = UpdateBreakingChangePolicyResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateBreakingChangePolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBreakingChangePolicyResponse) ProtoMessage() {}

func (x *UpdateBreakingChangePolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBreakingChangePolicyResponse.ProtoReflect.Descriptor instead.
func (*UpdateBreakingChangePolicyResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{17}
}

type GetUniquenessPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetUniquenessPolicyRequest) Reset() {
	*x = GetUniquenessPolicyRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUniquenessPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUniquenessPolicyRequest) ProtoMessage() {}

func (x *GetUniquenessPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetUniquenessPolicyRequest.ProtoReflect.Descriptor instead.
func (*GetUniquenessPolicyRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{18}
}

type GetUniquenessPolicyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current uniqueness policy settings.
	Policy *UniquenessPolicy `protobuf:"bytes,1,opt,name=policy,proto3" json:"policy,omitempty"`
	// Reports the status of the backfill task, which can be executed by the server admin with the
	// RunServerUniquenessBackfillTask RPC.
	BackfillTaskComplete bool `protobuf:"varint,2,opt,name=backfill_task_complete,json=backfillTaskComplete,proto3" json:"backfill_task_complete,omitempty"`
}

func (x *GetUniquenessPolicyResponse) Reset() {
	*x = GetUniquenessPolicyResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUniquenessPolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUniquenessPolicyResponse) ProtoMessage() {}

func (x *GetUniquenessPolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetUniquenessPolicyResponse.ProtoReflect.Descriptor instead.
func (*GetUniquenessPolicyResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{19}
}

func (x *GetUniquenessPolicyResponse) GetPolicy() *UniquenessPolicy {
	if x != nil {
		return x.Policy
	}
	return nil
}

func (x *GetUniquenessPolicyResponse) GetBackfillTaskComplete() bool {
	if x != nil {
		return x.BackfillTaskComplete
	}
	return false
}

type UpdateUniquenessPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Policy *UniquenessPolicy `protobuf:"bytes,1,opt,name=policy,proto3" json:"policy,omitempty"`
}

func (x *UpdateUniquenessPolicyRequest) Reset() {
	*x = UpdateUniquenessPolicyRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateUniquenessPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUniquenessPolicyRequest) ProtoMessage() {}

func (x *UpdateUniquenessPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateUniquenessPolicyRequest.ProtoReflect.Descriptor instead.
func (*UpdateUniquenessPolicyRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{20}
}

func (x *UpdateUniquenessPolicyRequest) GetPolicy() *UniquenessPolicy {
	if x != nil {
		return x.Policy
	}
	return nil
}

type UpdateUniquenessPolicyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateUniquenessPolicyResponse) Reset() {
	*x = UpdateUniquenessPolicyResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateUniquenessPolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUniquenessPolicyResponse) ProtoMessage() {}

func (x *UpdateUniquenessPolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateUniquenessPolicyResponse.ProtoReflect.Descriptor instead.
func (*UpdateUniquenessPolicyResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{21}
}

type ListServerUniquenessCollisionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Token of the page to retrieve. If not specified, the first page of
	// results will be returned. Use the value obtained from `next_page_token`
	// in the previous response in order to request the next page of results.
	PageToken string `protobuf:"bytes,1,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Number of elements to retrieve in a single page.
	// When too large a page is requested, the server may decide to further
	// limit the number of returned resources.
	PageSize uint32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The desired collision type to filter by.
	// This must be specified. Only collisions of the specified type will be returned,
	// continue to page through results until no more collisions of the specified
	// type are returned.
	CollisionType CollisionType `protobuf:"varint,3,opt,name=collision_type,json=collisionType,proto3,enum=buf.alpha.registry.v1alpha1.CollisionType" json:"collision_type,omitempty"`
}

func (x *ListServerUniquenessCollisionsRequest) Reset() {
	*x = ListServerUniquenessCollisionsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListServerUniquenessCollisionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServerUniquenessCollisionsRequest) ProtoMessage() {}

func (x *ListServerUniquenessCollisionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServerUniquenessCollisionsRequest.ProtoReflect.Descriptor instead.
func (*ListServerUniquenessCollisionsRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{22}
}

func (x *ListServerUniquenessCollisionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListServerUniquenessCollisionsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListServerUniquenessCollisionsRequest) GetCollisionType() CollisionType {
	if x != nil {
		return x.CollisionType
	}
	return CollisionType_COLLISION_TYPE_UNSPECIFIED
}

type ListServerUniquenessCollisionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The collisions.
	Collisions []*Collision `protobuf:"bytes,1,rep,name=collisions,proto3" json:"collisions,omitempty"`
	// Pagination token used to retrieve the next page of results.
	// Pass the content of this string as the `page_token` attribute of
	// the next request. `next_page_token` is not returned for the last
	// page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListServerUniquenessCollisionsResponse) Reset() {
	*x = ListServerUniquenessCollisionsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListServerUniquenessCollisionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServerUniquenessCollisionsResponse) ProtoMessage() {}

func (x *ListServerUniquenessCollisionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServerUniquenessCollisionsResponse.ProtoReflect.Descriptor instead.
func (*ListServerUniquenessCollisionsResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{23}
}

func (x *ListServerUniquenessCollisionsResponse) GetCollisions() []*Collision {
	if x != nil {
		return x.Collisions
	}
	return nil
}

func (x *ListServerUniquenessCollisionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type RunServerUniquenessBackfillTaskRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RunServerUniquenessBackfillTaskRequest) Reset() {
	*x = RunServerUniquenessBackfillTaskRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RunServerUniquenessBackfillTaskRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunServerUniquenessBackfillTaskRequest) ProtoMessage() {}

func (x *RunServerUniquenessBackfillTaskRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunServerUniquenessBackfillTaskRequest.ProtoReflect.Descriptor instead.
func (*RunServerUniquenessBackfillTaskRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{24}
}

type RunServerUniquenessBackfillTaskResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RunServerUniquenessBackfillTaskResponse) Reset() {
	*x = RunServerUniquenessBackfillTaskResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RunServerUniquenessBackfillTaskResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunServerUniquenessBackfillTaskResponse) ProtoMessage() {}

func (x *RunServerUniquenessBackfillTaskResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunServerUniquenessBackfillTaskResponse.ProtoReflect.Descriptor instead.
func (*RunServerUniquenessBackfillTaskResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{25}
}

type GetReviewFlowGracePeriodPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetReviewFlowGracePeriodPolicyRequest) Reset() {
	*x = GetReviewFlowGracePeriodPolicyRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetReviewFlowGracePeriodPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReviewFlowGracePeriodPolicyRequest) ProtoMessage() {}

func (x *GetReviewFlowGracePeriodPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReviewFlowGracePeriodPolicyRequest.ProtoReflect.Descriptor instead.
func (*GetReviewFlowGracePeriodPolicyRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{26}
}

type GetReviewFlowGracePeriodPolicyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current grace period policy settings.
	Policy *ReviewFlowGracePeriodPolicy `protobuf:"bytes,1,opt,name=policy,proto3" json:"policy,omitempty"`
}

func (x *GetReviewFlowGracePeriodPolicyResponse) Reset() {
	*x = GetReviewFlowGracePeriodPolicyResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetReviewFlowGracePeriodPolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReviewFlowGracePeriodPolicyResponse) ProtoMessage() {}

func (x *GetReviewFlowGracePeriodPolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReviewFlowGracePeriodPolicyResponse.ProtoReflect.Descriptor instead.
func (*GetReviewFlowGracePeriodPolicyResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{27}
}

func (x *GetReviewFlowGracePeriodPolicyResponse) GetPolicy() *ReviewFlowGracePeriodPolicy {
	if x != nil {
		return x.Policy
	}
	return nil
}

type UpdateReviewFlowGracePeriodPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The new grace period policy settings.
	Policy *ReviewFlowGracePeriodPolicy `protobuf:"bytes,1,opt,name=policy,proto3" json:"policy,omitempty"`
}

func (x *UpdateReviewFlowGracePeriodPolicyRequest) Reset() {
	*x = UpdateReviewFlowGracePeriodPolicyRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateReviewFlowGracePeriodPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateReviewFlowGracePeriodPolicyRequest) ProtoMessage() {}

func (x *UpdateReviewFlowGracePeriodPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateReviewFlowGracePeriodPolicyRequest.ProtoReflect.Descriptor instead.
func (*UpdateReviewFlowGracePeriodPolicyRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{28}
}

func (x *UpdateReviewFlowGracePeriodPolicyRequest) GetPolicy() *ReviewFlowGracePeriodPolicy {
	if x != nil {
		return x.Policy
	}
	return nil
}

type UpdateReviewFlowGracePeriodPolicyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateReviewFlowGracePeriodPolicyResponse) Reset() {
	*x = UpdateReviewFlowGracePeriodPolicyResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateReviewFlowGracePeriodPolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateReviewFlowGracePeriodPolicyResponse) ProtoMessage() {}

func (x *UpdateReviewFlowGracePeriodPolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateReviewFlowGracePeriodPolicyResponse.ProtoReflect.Descriptor instead.
func (*UpdateReviewFlowGracePeriodPolicyResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{29}
}

type GetClusterUsageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The timestamp of the beginning time of a date range.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The timestamp of the ending time of a date range.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *GetClusterUsageRequest) Reset() {
	*x = GetClusterUsageRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetClusterUsageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClusterUsageRequest) ProtoMessage() {}

func (x *GetClusterUsageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetClusterUsageRequest.ProtoReflect.Descriptor instead.
func (*GetClusterUsageRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{30}
}

func (x *GetClusterUsageRequest) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *GetClusterUsageRequest) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

type GetClusterUsageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Usage []*MonthlyUsage `protobuf:"bytes,1,rep,name=usage,proto3" json:"usage,omitempty"`
}

func (x *GetClusterUsageResponse) Reset() {
	*x = GetClusterUsageResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetClusterUsageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClusterUsageResponse) ProtoMessage() {}

func (x *GetClusterUsageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetClusterUsageResponse.ProtoReflect.Descriptor instead.
func (*GetClusterUsageResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP(), []int{31}
}

func (x *GetClusterUsageResponse) GetUsage() []*MonthlyUsage {
	if x != nil {
		return x.Usage
	}
	return nil
}

var File_buf_alpha_registry_v1alpha1_admin_proto protoreflect.FileDescriptor

var file_buf_alpha_registry_v1alpha1_admin_proto_rawDesc = []byte{
	0x0a, 0x27, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x1a, 0x2e, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x62, 0x75,
	0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xee, 0x01, 0x0a, 0x14, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e,
	0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x1d, 0x0a,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00,
	0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12, 0x3d, 0x0a, 0x18,
	0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x75, 0x6e, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01,
	0x52, 0x16, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x55, 0x6e, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x4f, 0x0a, 0x08, 0x63,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x42, 0x72, 0x65, 0x61,
	0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f,
	0x72, 0x79, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x42, 0x0a, 0x0a, 0x08,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x69, 0x67, 0x6e,
	0x6f, 0x72, 0x65, 0x5f, 0x75, 0x6e, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x73, 0x22, 0x2c, 0x0a, 0x10, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e,
	0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x22, 0x48, 0x0a, 0x1b, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x46, 0x6c, 0x6f,
	0x77, 0x47, 0x72, 0x61, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x22, 0xf0, 0x01,
	0x0a, 0x09, 0x43, 0x6f, 0x6c, 0x6c, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x3e, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x6c, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x46, 0x0a, 0x07, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x6c, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0x3d, 0x0a, 0x1b, 0x68, 0x61, 0x73, 0x5f, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x5f, 0x63,
	0x6f, 0x6c, 0x6c, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x68, 0x61, 0x73, 0x4f, 0x74, 0x68, 0x65, 0x72,
	0x43, 0x6f, 0x6c, 0x6c, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x22, 0x6d, 0x0a, 0x0f, 0x43, 0x6f, 0x6c, 0x6c, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22,
	0xc0, 0x01, 0x0a, 0x0c, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x05, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x79, 0x65, 0x61, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x79, 0x65, 0x61, 0x72, 0x12, 0x2e, 0x0a, 0x13, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x5f, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x0e, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x45, 0x6e, 0x75, 0x6d, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x6d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x22, 0x31, 0x0a, 0x16, 0x46, 0x6f, 0x72, 0x63, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x07,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75,
	0x73, 0x65, 0x72, 0x49, 0x64, 0x22, 0x8e, 0x02, 0x0a, 0x17, 0x46, 0x6f, 0x72, 0x63, 0x65, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x35, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x4f, 0x0a, 0x0d, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4b, 0x0a, 0x0c, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x4a, 0x04, 0x08, 0x05,
	0x10, 0x06, 0x52, 0x07, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x52, 0x09, 0x74, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x22, 0xa0, 0x01, 0x0a, 0x23, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x55, 0x73, 0x65, 0x72, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17,
	0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x60, 0x0a, 0x13, 0x76, 0x65, 0x72, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x12, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x26, 0x0a, 0x24, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xb8, 0x01, 0x0a, 0x2b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x60, 0x0a, 0x13, 0x76, 0x65,
	0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x12, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x2e, 0x0a, 0x2c,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x36, 0x0a, 0x18,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x52, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x63, 0x68, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x35, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x22, 0x20, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x42,
	0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x6c, 0x0a, 0x1f, 0x47, 0x65,
	0x74, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a,
	0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x42, 0x72, 0x65, 0x61,
	0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x6e, 0x0a, 0x21, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a,
	0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x42, 0x72, 0x65, 0x61,
	0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x24, 0x0a, 0x22, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1c,
	0x0a, 0x1a, 0x47, 0x65, 0x74, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x9a, 0x01, 0x0a,
	0x1b, 0x47, 0x65, 0x74, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x06,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x6e, 0x69, 0x71, 0x75,
	0x65, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x34, 0x0a, 0x16, 0x62, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x5f,
	0x74, 0x61, 0x73, 0x6b, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x14, 0x62, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x54, 0x61, 0x73,
	0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x22, 0x66, 0x0a, 0x1d, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e,
	0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x22, 0x20, 0x0a, 0x1e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x6e, 0x69, 0x71, 0x75,
	0x65, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0xb6, 0x01, 0x0a, 0x25, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6c, 0x6c,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x51, 0x0a, 0x0e, 0x63, 0x6f, 0x6c,
	0x6c, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x43, 0x6f, 0x6c, 0x6c, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x63,
	0x6f, 0x6c, 0x6c, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x22, 0x98, 0x01, 0x0a,
	0x26, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x71, 0x75,
	0x65, 0x6e, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6c, 0x6c, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x6c, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x28, 0x0a, 0x26, 0x52, 0x75, 0x6e, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x42, 0x61,
	0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x22, 0x29, 0x0a, 0x27, 0x52, 0x75, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x55, 0x6e,
	0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x42, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c,
	0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x27, 0x0a, 0x25,
	0x47, 0x65, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x46, 0x6c, 0x6f, 0x77, 0x47, 0x72, 0x61,
	0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x7a, 0x0a, 0x26, 0x47, 0x65, 0x74, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x46, 0x6c, 0x6f, 0x77, 0x47, 0x72, 0x61, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x50, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x46, 0x6c, 0x6f, 0x77, 0x47, 0x72, 0x61, 0x63, 0x65, 0x50, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x22, 0x7c, 0x0a, 0x28, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x46, 0x6c, 0x6f, 0x77, 0x47, 0x72, 0x61, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a,
	0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x46, 0x6c, 0x6f, 0x77, 0x47, 0x72, 0x61, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22,
	0x2b, 0x0a, 0x29, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x46,
	0x6c, 0x6f, 0x77, 0x47, 0x72, 0x61, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8a, 0x01, 0x0a,
	0x16, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x55, 0x73, 0x61, 0x67, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x5a, 0x0a, 0x17, 0x47, 0x65, 0x74,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x05, 0x75, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x05,
	0x75, 0x73, 0x61, 0x67, 0x65, 0x2a, 0x8d, 0x01, 0x0a, 0x16, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x69,
	0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x12, 0x28, 0x0a, 0x24, 0x42, 0x52, 0x45, 0x41, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x48, 0x41,
	0x4e, 0x47, 0x45, 0x5f, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x42, 0x52,
	0x45, 0x41, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x43, 0x41,
	0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x26, 0x0a,
	0x22, 0x42, 0x52, 0x45, 0x41, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45,
	0x5f, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x57, 0x49, 0x52, 0x45, 0x5f, 0x4a,
	0x53, 0x4f, 0x4e, 0x10, 0x02, 0x2a, 0x71, 0x0a, 0x0d, 0x43, 0x6f, 0x6c, 0x6c, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x4f, 0x4c, 0x4c, 0x49, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x27, 0x0a, 0x23, 0x43, 0x4f, 0x4c, 0x4c, 0x49, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x59, 0x5f, 0x51,
	0x55, 0x41, 0x4c, 0x49, 0x46, 0x49, 0x45, 0x44, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x10, 0x01, 0x12,
	0x17, 0x0a, 0x13, 0x43, 0x4f, 0x4c, 0x4c, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x50, 0x41, 0x54, 0x48, 0x10, 0x02, 0x32, 0xa4, 0x10, 0x0a, 0x0c, 0x41, 0x64, 0x6d,
	0x69, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x81, 0x01, 0x0a, 0x0f, 0x46, 0x6f,
	0x72, 0x63, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x12, 0x33, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x6f, 0x72, 0x63,
	0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x46, 0x6f, 0x72, 0x63, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x02, 0x12, 0xa3, 0x01,
	0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x56, 0x65, 0x72, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x40,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x41, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0xbb, 0x01, 0x0a, 0x24, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x48, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x72,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x49, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x87, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x12, 0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x02, 0x12, 0x99, 0x01, 0x0a, 0x17,
	0x47, 0x65, 0x74, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x3b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e,
	0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x9d, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x3e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x72, 0x65, 0x61, 0x6b,
	0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x72, 0x65, 0x61, 0x6b,
	0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x8d, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x55,
	0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65,
	0x6e, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x91, 0x01, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73,
	0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0xae, 0x01, 0x0a, 0x1e,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65,
	0x6e, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6c, 0x6c, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x42,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65, 0x73,
	0x73, 0x43, 0x6f, 0x6c, 0x6c, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x43, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x71, 0x75,
	0x65, 0x6e, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6c, 0x6c, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0xb1, 0x01, 0x0a,
	0x1f, 0x52, 0x75, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65,
	0x6e, 0x65, 0x73, 0x73, 0x42, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x54, 0x61, 0x73, 0x6b,
	0x12, 0x43, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52,
	0x75, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6e, 0x65,
	0x73, 0x73, 0x42, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x44, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x55, 0x6e, 0x69,
	0x71, 0x75, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x42, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x54,
	0x61, 0x73, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x02,
	0x12, 0xa9, 0x01, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x46, 0x6c,
	0x6f, 0x77, 0x47, 0x72, 0x61, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x42, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x46, 0x6c, 0x6f, 0x77, 0x47,
	0x72, 0x61, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x46,
	0x6c, 0x6f, 0x77, 0x47, 0x72, 0x61, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0xb2, 0x01, 0x0a,
	0x21, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x46, 0x6c, 0x6f,
	0x77, 0x47, 0x72, 0x61, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x45, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x46, 0x6c, 0x6f,
	0x77, 0x47, 0x72, 0x61, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x46, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x46, 0x6c, 0x6f, 0x77, 0x47, 0x72, 0x61, 0x63, 0x65, 0x50, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x7c, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x55,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x55, 0x73, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42,
	0x97, 0x02, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x42, 0x0a, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x59, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x75,
	0x66, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x2f,
	0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x3b, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xa2, 0x02, 0x03, 0x42,
	0x41, 0x52, 0xaa, 0x02, 0x1b, 0x42, 0x75, 0x66, 0x2e, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0xca, 0x02, 0x1b, 0x42, 0x75, 0x66, 0x5c, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xe2, 0x02,
	0x27, 0x42, 0x75, 0x66, 0x5c, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x5c, 0x47, 0x50, 0x42,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x1e, 0x42, 0x75, 0x66, 0x3a, 0x3a,
	0x41, 0x6c, 0x70, 0x68, 0x61, 0x3a, 0x3a, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x3a,
	0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_buf_alpha_registry_v1alpha1_admin_proto_rawDescOnce sync.Once
	file_buf_alpha_registry_v1alpha1_admin_proto_rawDescData = file_buf_alpha_registry_v1alpha1_admin_proto_rawDesc
)

func file_buf_alpha_registry_v1alpha1_admin_proto_rawDescGZIP() []byte {
	file_buf_alpha_registry_v1alpha1_admin_proto_rawDescOnce.Do(func() {
		file_buf_alpha_registry_v1alpha1_admin_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_alpha_registry_v1alpha1_admin_proto_rawDescData)
	})
	return file_buf_alpha_registry_v1alpha1_admin_proto_rawDescData
}

var file_buf_alpha_registry_v1alpha1_admin_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes = make([]protoimpl.MessageInfo, 32)
var file_buf_alpha_registry_v1alpha1_admin_proto_goTypes = []any{
	(BreakingChangeCategory)(0),                          // 0: buf.alpha.registry.v1alpha1.BreakingChangeCategory
	(CollisionType)(0),                                   // 1: buf.alpha.registry.v1alpha1.CollisionType
	(*BreakingChangePolicy)(nil),                         // 2: buf.alpha.registry.v1alpha1.BreakingChangePolicy
	(*UniquenessPolicy)(nil),                             // 3: buf.alpha.registry.v1alpha1.UniquenessPolicy
	(*ReviewFlowGracePeriodPolicy)(nil),                  // 4: buf.alpha.registry.v1alpha1.ReviewFlowGracePeriodPolicy
	(*Collision)(nil),                                    // 5: buf.alpha.registry.v1alpha1.Collision
	(*CollisionSource)(nil),                              // 6: buf.alpha.registry.v1alpha1.CollisionSource
	(*MonthlyUsage)(nil),                                 // 7: buf.alpha.registry.v1alpha1.MonthlyUsage
	(*ForceDeleteUserRequest)(nil),                       // 8: buf.alpha.registry.v1alpha1.ForceDeleteUserRequest
	(*ForceDeleteUserResponse)(nil),                      // 9: buf.alpha.registry.v1alpha1.ForceDeleteUserResponse
	(*UpdateUserVerificationStatusRequest)(nil),          // 10: buf.alpha.registry.v1alpha1.UpdateUserVerificationStatusRequest
	(*UpdateUserVerificationStatusResponse)(nil),         // 11: buf.alpha.registry.v1alpha1.UpdateUserVerificationStatusResponse
	(*UpdateOrganizationVerificationStatusRequest)(nil),  // 12: buf.alpha.registry.v1alpha1.UpdateOrganizationVerificationStatusRequest
	(*UpdateOrganizationVerificationStatusResponse)(nil), // 13: buf.alpha.registry.v1alpha1.UpdateOrganizationVerificationStatusResponse
	(*CreateMachineUserRequest)(nil),                     // 14: buf.alpha.registry.v1alpha1.CreateMachineUserRequest
	(*CreateMachineUserResponse)(nil),                    // 15: buf.alpha.registry.v1alpha1.CreateMachineUserResponse
	(*GetBreakingChangePolicyRequest)(nil),               // 16: buf.alpha.registry.v1alpha1.GetBreakingChangePolicyRequest
	(*GetBreakingChangePolicyResponse)(nil),              // 17: buf.alpha.registry.v1alpha1.GetBreakingChangePolicyResponse
	(*UpdateBreakingChangePolicyRequest)(nil),            // 18: buf.alpha.registry.v1alpha1.UpdateBreakingChangePolicyRequest
	(*UpdateBreakingChangePolicyResponse)(nil),           // 19: buf.alpha.registry.v1alpha1.UpdateBreakingChangePolicyResponse
	(*GetUniquenessPolicyRequest)(nil),                   // 20: buf.alpha.registry.v1alpha1.GetUniquenessPolicyRequest
	(*GetUniquenessPolicyResponse)(nil),                  // 21: buf.alpha.registry.v1alpha1.GetUniquenessPolicyResponse
	(*UpdateUniquenessPolicyRequest)(nil),                // 22: buf.alpha.registry.v1alpha1.UpdateUniquenessPolicyRequest
	(*UpdateUniquenessPolicyResponse)(nil),               // 23: buf.alpha.registry.v1alpha1.UpdateUniquenessPolicyResponse
	(*ListServerUniquenessCollisionsRequest)(nil),        // 24: buf.alpha.registry.v1alpha1.ListServerUniquenessCollisionsRequest
	(*ListServerUniquenessCollisionsResponse)(nil),       // 25: buf.alpha.registry.v1alpha1.ListServerUniquenessCollisionsResponse
	(*RunServerUniquenessBackfillTaskRequest)(nil),       // 26: buf.alpha.registry.v1alpha1.RunServerUniquenessBackfillTaskRequest
	(*RunServerUniquenessBackfillTaskResponse)(nil),      // 27: buf.alpha.registry.v1alpha1.RunServerUniquenessBackfillTaskResponse
	(*GetReviewFlowGracePeriodPolicyRequest)(nil),        // 28: buf.alpha.registry.v1alpha1.GetReviewFlowGracePeriodPolicyRequest
	(*GetReviewFlowGracePeriodPolicyResponse)(nil),       // 29: buf.alpha.registry.v1alpha1.GetReviewFlowGracePeriodPolicyResponse
	(*UpdateReviewFlowGracePeriodPolicyRequest)(nil),     // 30: buf.alpha.registry.v1alpha1.UpdateReviewFlowGracePeriodPolicyRequest
	(*UpdateReviewFlowGracePeriodPolicyResponse)(nil),    // 31: buf.alpha.registry.v1alpha1.UpdateReviewFlowGracePeriodPolicyResponse
	(*GetClusterUsageRequest)(nil),                       // 32: buf.alpha.registry.v1alpha1.GetClusterUsageRequest
	(*GetClusterUsageResponse)(nil),                      // 33: buf.alpha.registry.v1alpha1.GetClusterUsageResponse
	(*User)(nil),                                         // 34: buf.alpha.registry.v1alpha1.User
	(*Organization)(nil),                                 // 35: buf.alpha.registry.v1alpha1.Organization
	(*Repository)(nil),                                   // 36: buf.alpha.registry.v1alpha1.Repository
	(VerificationStatus)(0),                              // 37: buf.alpha.registry.v1alpha1.VerificationStatus
	(*timestamppb.Timestamp)(nil),                        // 38: google.protobuf.Timestamp
}
var file_buf_alpha_registry_v1alpha1_admin_proto_depIdxs = []int32{
	0,  // 0: buf.alpha.registry.v1alpha1.BreakingChangePolicy.category:type_name -> buf.alpha.registry.v1alpha1.BreakingChangeCategory
	1,  // 1: buf.alpha.registry.v1alpha1.Collision.type:type_name -> buf.alpha.registry.v1alpha1.CollisionType
	6,  // 2: buf.alpha.registry.v1alpha1.Collision.sources:type_name -> buf.alpha.registry.v1alpha1.CollisionSource
	34, // 3: buf.alpha.registry.v1alpha1.ForceDeleteUserResponse.user:type_name -> buf.alpha.registry.v1alpha1.User
	35, // 4: buf.alpha.registry.v1alpha1.ForceDeleteUserResponse.organizations:type_name -> buf.alpha.registry.v1alpha1.Organization
	36, // 5: buf.alpha.registry.v1alpha1.ForceDeleteUserResponse.repositories:type_name -> buf.alpha.registry.v1alpha1.Repository
	37, // 6: buf.alpha.registry.v1alpha1.UpdateUserVerificationStatusRequest.verification_status:type_name -> buf.alpha.registry.v1alpha1.VerificationStatus
	37, // 7: buf.alpha.registry.v1alpha1.UpdateOrganizationVerificationStatusRequest.verification_status:type_name -> buf.alpha.registry.v1alpha1.VerificationStatus
	34, // 8: buf.alpha.registry.v1alpha1.CreateMachineUserResponse.user:type_name -> buf.alpha.registry.v1alpha1.User
	2,  // 9: buf.alpha.registry.v1alpha1.GetBreakingChangePolicyResponse.policy:type_name -> buf.alpha.registry.v1alpha1.BreakingChangePolicy
	2,  // 10: buf.alpha.registry.v1alpha1.UpdateBreakingChangePolicyRequest.policy:type_name -> buf.alpha.registry.v1alpha1.BreakingChangePolicy
	3,  // 11: buf.alpha.registry.v1alpha1.GetUniquenessPolicyResponse.policy:type_name -> buf.alpha.registry.v1alpha1.UniquenessPolicy
	3,  // 12: buf.alpha.registry.v1alpha1.UpdateUniquenessPolicyRequest.policy:type_name -> buf.alpha.registry.v1alpha1.UniquenessPolicy
	1,  // 13: buf.alpha.registry.v1alpha1.ListServerUniquenessCollisionsRequest.collision_type:type_name -> buf.alpha.registry.v1alpha1.CollisionType
	5,  // 14: buf.alpha.registry.v1alpha1.ListServerUniquenessCollisionsResponse.collisions:type_name -> buf.alpha.registry.v1alpha1.Collision
	4,  // 15: buf.alpha.registry.v1alpha1.GetReviewFlowGracePeriodPolicyResponse.policy:type_name -> buf.alpha.registry.v1alpha1.ReviewFlowGracePeriodPolicy
	4,  // 16: buf.alpha.registry.v1alpha1.UpdateReviewFlowGracePeriodPolicyRequest.policy:type_name -> buf.alpha.registry.v1alpha1.ReviewFlowGracePeriodPolicy
	38, // 17: buf.alpha.registry.v1alpha1.GetClusterUsageRequest.start_time:type_name -> google.protobuf.Timestamp
	38, // 18: buf.alpha.registry.v1alpha1.GetClusterUsageRequest.end_time:type_name -> google.protobuf.Timestamp
	7,  // 19: buf.alpha.registry.v1alpha1.GetClusterUsageResponse.usage:type_name -> buf.alpha.registry.v1alpha1.MonthlyUsage
	8,  // 20: buf.alpha.registry.v1alpha1.AdminService.ForceDeleteUser:input_type -> buf.alpha.registry.v1alpha1.ForceDeleteUserRequest
	10, // 21: buf.alpha.registry.v1alpha1.AdminService.UpdateUserVerificationStatus:input_type -> buf.alpha.registry.v1alpha1.UpdateUserVerificationStatusRequest
	12, // 22: buf.alpha.registry.v1alpha1.AdminService.UpdateOrganizationVerificationStatus:input_type -> buf.alpha.registry.v1alpha1.UpdateOrganizationVerificationStatusRequest
	14, // 23: buf.alpha.registry.v1alpha1.AdminService.CreateMachineUser:input_type -> buf.alpha.registry.v1alpha1.CreateMachineUserRequest
	16, // 24: buf.alpha.registry.v1alpha1.AdminService.GetBreakingChangePolicy:input_type -> buf.alpha.registry.v1alpha1.GetBreakingChangePolicyRequest
	18, // 25: buf.alpha.registry.v1alpha1.AdminService.UpdateBreakingChangePolicy:input_type -> buf.alpha.registry.v1alpha1.UpdateBreakingChangePolicyRequest
	20, // 26: buf.alpha.registry.v1alpha1.AdminService.GetUniquenessPolicy:input_type -> buf.alpha.registry.v1alpha1.GetUniquenessPolicyRequest
	22, // 27: buf.alpha.registry.v1alpha1.AdminService.UpdateUniquenessPolicy:input_type -> buf.alpha.registry.v1alpha1.UpdateUniquenessPolicyRequest
	24, // 28: buf.alpha.registry.v1alpha1.AdminService.ListServerUniquenessCollisions:input_type -> buf.alpha.registry.v1alpha1.ListServerUniquenessCollisionsRequest
	26, // 29: buf.alpha.registry.v1alpha1.AdminService.RunServerUniquenessBackfillTask:input_type -> buf.alpha.registry.v1alpha1.RunServerUniquenessBackfillTaskRequest
	28, // 30: buf.alpha.registry.v1alpha1.AdminService.GetReviewFlowGracePeriodPolicy:input_type -> buf.alpha.registry.v1alpha1.GetReviewFlowGracePeriodPolicyRequest
	30, // 31: buf.alpha.registry.v1alpha1.AdminService.UpdateReviewFlowGracePeriodPolicy:input_type -> buf.alpha.registry.v1alpha1.UpdateReviewFlowGracePeriodPolicyRequest
	32, // 32: buf.alpha.registry.v1alpha1.AdminService.GetClusterUsage:input_type -> buf.alpha.registry.v1alpha1.GetClusterUsageRequest
	9,  // 33: buf.alpha.registry.v1alpha1.AdminService.ForceDeleteUser:output_type -> buf.alpha.registry.v1alpha1.ForceDeleteUserResponse
	11, // 34: buf.alpha.registry.v1alpha1.AdminService.UpdateUserVerificationStatus:output_type -> buf.alpha.registry.v1alpha1.UpdateUserVerificationStatusResponse
	13, // 35: buf.alpha.registry.v1alpha1.AdminService.UpdateOrganizationVerificationStatus:output_type -> buf.alpha.registry.v1alpha1.UpdateOrganizationVerificationStatusResponse
	15, // 36: buf.alpha.registry.v1alpha1.AdminService.CreateMachineUser:output_type -> buf.alpha.registry.v1alpha1.CreateMachineUserResponse
	17, // 37: buf.alpha.registry.v1alpha1.AdminService.GetBreakingChangePolicy:output_type -> buf.alpha.registry.v1alpha1.GetBreakingChangePolicyResponse
	19, // 38: buf.alpha.registry.v1alpha1.AdminService.UpdateBreakingChangePolicy:output_type -> buf.alpha.registry.v1alpha1.UpdateBreakingChangePolicyResponse
	21, // 39: buf.alpha.registry.v1alpha1.AdminService.GetUniquenessPolicy:output_type -> buf.alpha.registry.v1alpha1.GetUniquenessPolicyResponse
	23, // 40: buf.alpha.registry.v1alpha1.AdminService.UpdateUniquenessPolicy:output_type -> buf.alpha.registry.v1alpha1.UpdateUniquenessPolicyResponse
	25, // 41: buf.alpha.registry.v1alpha1.AdminService.ListServerUniquenessCollisions:output_type -> buf.alpha.registry.v1alpha1.ListServerUniquenessCollisionsResponse
	27, // 42: buf.alpha.registry.v1alpha1.AdminService.RunServerUniquenessBackfillTask:output_type -> buf.alpha.registry.v1alpha1.RunServerUniquenessBackfillTaskResponse
	29, // 43: buf.alpha.registry.v1alpha1.AdminService.GetReviewFlowGracePeriodPolicy:output_type -> buf.alpha.registry.v1alpha1.GetReviewFlowGracePeriodPolicyResponse
	31, // 44: buf.alpha.registry.v1alpha1.AdminService.UpdateReviewFlowGracePeriodPolicy:output_type -> buf.alpha.registry.v1alpha1.UpdateReviewFlowGracePeriodPolicyResponse
	33, // 45: buf.alpha.registry.v1alpha1.AdminService.GetClusterUsage:output_type -> buf.alpha.registry.v1alpha1.GetClusterUsageResponse
	33, // [33:46] is the sub-list for method output_type
	20, // [20:33] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_admin_proto_init() }
func file_buf_alpha_registry_v1alpha1_admin_proto_init() {
	if File_buf_alpha_registry_v1alpha1_admin_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_organization_proto_init()
	file_buf_alpha_registry_v1alpha1_repository_proto_init()
	file_buf_alpha_registry_v1alpha1_user_proto_init()
	file_buf_alpha_registry_v1alpha1_verification_status_proto_init()
	file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes[0].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_alpha_registry_v1alpha1_admin_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   32,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_admin_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_admin_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_admin_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_admin_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_admin_proto = out.File
	file_buf_alpha_registry_v1alpha1_admin_proto_rawDesc = nil
	file_buf_alpha_registry_v1alpha1_admin_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_admin_proto_depIdxs = nil
}
