// Copyright 2020-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2-devel
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/search.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type SearchFilter int32

const (
	SearchFilter_SEARCH_FILTER_UNSPECIFIED    SearchFilter = 0
	SearchFilter_SEARCH_FILTER_USER           SearchFilter = 1
	SearchFilter_SEARCH_FILTER_ORGANIZATION   SearchFilter = 2
	SearchFilter_SEARCH_FILTER_REPOSITORY     SearchFilter = 3
	SearchFilter_SEARCH_FILTER_TEAM           SearchFilter = 6
	SearchFilter_SEARCH_FILTER_CURATED_PLUGIN SearchFilter = 7
	SearchFilter_SEARCH_FILTER_MODULE_ELEMENT SearchFilter = 8
	SearchFilter_SEARCH_FILTER_MODULE_FILE    SearchFilter = 9
)

// Enum value maps for SearchFilter.
var (
	SearchFilter_name = map[int32]string{
		0: "SEARCH_FILTER_UNSPECIFIED",
		1: "SEARCH_FILTER_USER",
		2: "SEARCH_FILTER_ORGANIZATION",
		3: "SEARCH_FILTER_REPOSITORY",
		6: "SEARCH_FILTER_TEAM",
		7: "SEARCH_FILTER_CURATED_PLUGIN",
		8: "SEARCH_FILTER_MODULE_ELEMENT",
		9: "SEARCH_FILTER_MODULE_FILE",
	}
	SearchFilter_value = map[string]int32{
		"SEARCH_FILTER_UNSPECIFIED":    0,
		"SEARCH_FILTER_USER":           1,
		"SEARCH_FILTER_ORGANIZATION":   2,
		"SEARCH_FILTER_REPOSITORY":     3,
		"SEARCH_FILTER_TEAM":           6,
		"SEARCH_FILTER_CURATED_PLUGIN": 7,
		"SEARCH_FILTER_MODULE_ELEMENT": 8,
		"SEARCH_FILTER_MODULE_FILE":    9,
	}
)

func (x SearchFilter) Enum() *SearchFilter {
	p := new(SearchFilter)
	*p = x
	return p
}

func (x SearchFilter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchFilter) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_search_proto_enumTypes[0].Descriptor()
}

func (SearchFilter) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_search_proto_enumTypes[0]
}

func (x SearchFilter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchFilter.Descriptor instead.
func (SearchFilter) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{0}
}

type OrderBy int32

const (
	OrderBy_ORDER_BY_UNSPECIFIED OrderBy = 0
	OrderBy_ORDER_BY_CREATE_TIME OrderBy = 1
	OrderBy_ORDER_BY_UPDATE_TIME OrderBy = 2
	OrderBy_ORDER_BY_NAME        OrderBy = 3
)

// Enum value maps for OrderBy.
var (
	OrderBy_name = map[int32]string{
		0: "ORDER_BY_UNSPECIFIED",
		1: "ORDER_BY_CREATE_TIME",
		2: "ORDER_BY_UPDATE_TIME",
		3: "ORDER_BY_NAME",
	}
	OrderBy_value = map[string]int32{
		"ORDER_BY_UNSPECIFIED": 0,
		"ORDER_BY_CREATE_TIME": 1,
		"ORDER_BY_UPDATE_TIME": 2,
		"ORDER_BY_NAME":        3,
	}
)

func (x OrderBy) Enum() *OrderBy {
	p := new(OrderBy)
	*p = x
	return p
}

func (x OrderBy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OrderBy) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_search_proto_enumTypes[1].Descriptor()
}

func (OrderBy) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_search_proto_enumTypes[1]
}

func (x OrderBy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OrderBy.Descriptor instead.
func (OrderBy) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{1}
}

// SearchModuleElementType is the protobuf element type of a fully qualified name in a module element search result.
// This is a subset of types in https://protobuf.com/docs/language-spec#named-elements that are exposing in the search.
type SearchModuleElementType int32

const (
	SearchModuleElementType_SEARCH_MODULE_ELEMENT_TYPE_UNSPECIFIED SearchModuleElementType = 0
	SearchModuleElementType_SEARCH_MODULE_ELEMENT_TYPE_SERVICE     SearchModuleElementType = 1
	SearchModuleElementType_SEARCH_MODULE_ELEMENT_TYPE_METHOD      SearchModuleElementType = 2
	SearchModuleElementType_SEARCH_MODULE_ELEMENT_TYPE_MESSAGE     SearchModuleElementType = 3
	SearchModuleElementType_SEARCH_MODULE_ELEMENT_TYPE_ENUM        SearchModuleElementType = 4
)

// Enum value maps for SearchModuleElementType.
var (
	SearchModuleElementType_name = map[int32]string{
		0: "SEARCH_MODULE_ELEMENT_TYPE_UNSPECIFIED",
		1: "SEARCH_MODULE_ELEMENT_TYPE_SERVICE",
		2: "SEARCH_MODULE_ELEMENT_TYPE_METHOD",
		3: "SEARCH_MODULE_ELEMENT_TYPE_MESSAGE",
		4: "SEARCH_MODULE_ELEMENT_TYPE_ENUM",
	}
	SearchModuleElementType_value = map[string]int32{
		"SEARCH_MODULE_ELEMENT_TYPE_UNSPECIFIED": 0,
		"SEARCH_MODULE_ELEMENT_TYPE_SERVICE":     1,
		"SEARCH_MODULE_ELEMENT_TYPE_METHOD":      2,
		"SEARCH_MODULE_ELEMENT_TYPE_MESSAGE":     3,
		"SEARCH_MODULE_ELEMENT_TYPE_ENUM":        4,
	}
)

func (x SearchModuleElementType) Enum() *SearchModuleElementType {
	p := new(SearchModuleElementType)
	*p = x
	return p
}

func (x SearchModuleElementType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchModuleElementType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_search_proto_enumTypes[2].Descriptor()
}

func (SearchModuleElementType) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_search_proto_enumTypes[2]
}

func (x SearchModuleElementType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchModuleElementType.Descriptor instead.
func (SearchModuleElementType) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{2}
}

type SearchModuleContentFilter int32

const (
	SearchModuleContentFilter_SEARCH_MODULE_CONTENT_FILTER_UNSPECIFIED SearchModuleContentFilter = 0
	// SEARCH_MODULE_CONTENT_FILTER_ELEMENT is the filter for elements, e.g. messages, services, and methods.
	SearchModuleContentFilter_SEARCH_MODULE_CONTENT_FILTER_ELEMENT SearchModuleContentFilter = 1
	// SEARCH_MODULE_CONTENT_FILTER_FILE is the filter for files.
	SearchModuleContentFilter_SEARCH_MODULE_CONTENT_FILTER_FILE SearchModuleContentFilter = 2
)

// Enum value maps for SearchModuleContentFilter.
var (
	SearchModuleContentFilter_name = map[int32]string{
		0: "SEARCH_MODULE_CONTENT_FILTER_UNSPECIFIED",
		1: "SEARCH_MODULE_CONTENT_FILTER_ELEMENT",
		2: "SEARCH_MODULE_CONTENT_FILTER_FILE",
	}
	SearchModuleContentFilter_value = map[string]int32{
		"SEARCH_MODULE_CONTENT_FILTER_UNSPECIFIED": 0,
		"SEARCH_MODULE_CONTENT_FILTER_ELEMENT":     1,
		"SEARCH_MODULE_CONTENT_FILTER_FILE":        2,
	}
)

func (x SearchModuleContentFilter) Enum() *SearchModuleContentFilter {
	p := new(SearchModuleContentFilter)
	*p = x
	return p
}

func (x SearchModuleContentFilter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchModuleContentFilter) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_search_proto_enumTypes[3].Descriptor()
}

func (SearchModuleContentFilter) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_search_proto_enumTypes[3]
}

func (x SearchModuleContentFilter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchModuleContentFilter.Descriptor instead.
func (SearchModuleContentFilter) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{3}
}

type RepositorySearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id   string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the user or organization
	// who is the owner of this repository.
	Owner string `protobuf:"bytes,3,opt,name=owner,proto3" json:"owner,omitempty"`
	// The visibility of the repository.
	Visibility Visibility `protobuf:"varint,4,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.Visibility" json:"visibility,omitempty"`
	Deprecated bool       `protobuf:"varint,5,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	// The SPDX license ID of the latest main commit in the repository.
	LatestSpdxLicenseId string `protobuf:"bytes,6,opt,name=latest_spdx_license_id,json=latestSpdxLicenseId,proto3" json:"latest_spdx_license_id,omitempty"`
	// The verification status of the owner of the repository.
	OwnerVerificationStatus VerificationStatus `protobuf:"varint,7,opt,name=owner_verification_status,json=ownerVerificationStatus,proto3,enum=buf.alpha.registry.v1alpha1.VerificationStatus" json:"owner_verification_status,omitempty"`
	// The user configurable URL in the description of the repository.
	Url string `protobuf:"bytes,8,opt,name=url,proto3" json:"url,omitempty"`
	// The commit time of the latest main commit in the repository.
	LatestCommitTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=latest_commit_time,json=latestCommitTime,proto3" json:"latest_commit_time,omitempty"`
}

func (x *RepositorySearchResult) Reset() {
	*x = RepositorySearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepositorySearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepositorySearchResult) ProtoMessage() {}

func (x *RepositorySearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepositorySearchResult.ProtoReflect.Descriptor instead.
func (*RepositorySearchResult) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{0}
}

func (x *RepositorySearchResult) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *RepositorySearchResult) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RepositorySearchResult) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *RepositorySearchResult) GetVisibility() Visibility {
	if x != nil {
		return x.Visibility
	}
	return Visibility_VISIBILITY_UNSPECIFIED
}

func (x *RepositorySearchResult) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

func (x *RepositorySearchResult) GetLatestSpdxLicenseId() string {
	if x != nil {
		return x.LatestSpdxLicenseId
	}
	return ""
}

func (x *RepositorySearchResult) GetOwnerVerificationStatus() VerificationStatus {
	if x != nil {
		return x.OwnerVerificationStatus
	}
	return VerificationStatus_VERIFICATION_STATUS_UNSPECIFIED
}

func (x *RepositorySearchResult) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *RepositorySearchResult) GetLatestCommitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LatestCommitTime
	}
	return nil
}

type OrganizationSearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id         string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name       string                 `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *OrganizationSearchResult) Reset() {
	*x = OrganizationSearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OrganizationSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OrganizationSearchResult) ProtoMessage() {}

func (x *OrganizationSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OrganizationSearchResult.ProtoReflect.Descriptor instead.
func (*OrganizationSearchResult) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{1}
}

func (x *OrganizationSearchResult) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *OrganizationSearchResult) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *OrganizationSearchResult) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

type UserSearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id          string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Username    string                 `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
	Deactivated bool                   `protobuf:"varint,3,opt,name=deactivated,proto3" json:"deactivated,omitempty"`
	CreateTime  *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *UserSearchResult) Reset() {
	*x = UserSearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserSearchResult) ProtoMessage() {}

func (x *UserSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserSearchResult.ProtoReflect.Descriptor instead.
func (*UserSearchResult) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{2}
}

func (x *UserSearchResult) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *UserSearchResult) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *UserSearchResult) GetDeactivated() bool {
	if x != nil {
		return x.Deactivated
	}
	return false
}

func (x *UserSearchResult) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

type TeamSearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id               string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name             string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	OrganizationName string `protobuf:"bytes,3,opt,name=organization_name,json=organizationName,proto3" json:"organization_name,omitempty"`
}

func (x *TeamSearchResult) Reset() {
	*x = TeamSearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TeamSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TeamSearchResult) ProtoMessage() {}

func (x *TeamSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TeamSearchResult.ProtoReflect.Descriptor instead.
func (*TeamSearchResult) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{3}
}

func (x *TeamSearchResult) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *TeamSearchResult) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TeamSearchResult) GetOrganizationName() string {
	if x != nil {
		return x.OrganizationName
	}
	return ""
}

type CuratedPluginSearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id   string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the user or organization
	// who is the owner of this plugin.
	Owner      string `protobuf:"bytes,3,opt,name=owner,proto3" json:"owner,omitempty"`
	Deprecated bool   `protobuf:"varint,4,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	// The description of the plugin and it's functionality.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// The registry type of the plugin.
	RegistryType PluginRegistryType `protobuf:"varint,6,opt,name=registry_type,json=registryType,proto3,enum=buf.alpha.registry.v1alpha1.PluginRegistryType" json:"registry_type,omitempty"`
	// The output languages supported by the plugin.
	OutputLanguages []PluginLanguage `protobuf:"varint,7,rep,packed,name=output_languages,json=outputLanguages,proto3,enum=buf.alpha.registry.v1alpha1.PluginLanguage" json:"output_languages,omitempty"`
	// The plugins creation timestamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *CuratedPluginSearchResult) Reset() {
	*x = CuratedPluginSearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CuratedPluginSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CuratedPluginSearchResult) ProtoMessage() {}

func (x *CuratedPluginSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CuratedPluginSearchResult.ProtoReflect.Descriptor instead.
func (*CuratedPluginSearchResult) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{4}
}

func (x *CuratedPluginSearchResult) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *CuratedPluginSearchResult) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CuratedPluginSearchResult) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *CuratedPluginSearchResult) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

func (x *CuratedPluginSearchResult) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CuratedPluginSearchResult) GetRegistryType() PluginRegistryType {
	if x != nil {
		return x.RegistryType
	}
	return PluginRegistryType_PLUGIN_REGISTRY_TYPE_UNSPECIFIED
}

func (x *CuratedPluginSearchResult) GetOutputLanguages() []PluginLanguage {
	if x != nil {
		return x.OutputLanguages
	}
	return nil
}

func (x *CuratedPluginSearchResult) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

type ModuleElementSearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RepositoryId            string                  `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
	RepositoryOwner         string                  `protobuf:"bytes,2,opt,name=repository_owner,json=repositoryOwner,proto3" json:"repository_owner,omitempty"`
	RepositoryName          string                  `protobuf:"bytes,3,opt,name=repository_name,json=repositoryName,proto3" json:"repository_name,omitempty"`
	ProtoFilePath           string                  `protobuf:"bytes,4,opt,name=proto_file_path,json=protoFilePath,proto3" json:"proto_file_path,omitempty"`
	FullyQualifiedName      string                  `protobuf:"bytes,5,opt,name=fully_qualified_name,json=fullyQualifiedName,proto3" json:"fully_qualified_name,omitempty"`
	PackageName             string                  `protobuf:"bytes,6,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	SearchModuleElementType SearchModuleElementType `protobuf:"varint,7,opt,name=search_module_element_type,json=searchModuleElementType,proto3,enum=buf.alpha.registry.v1alpha1.SearchModuleElementType" json:"search_module_element_type,omitempty"`
}

func (x *ModuleElementSearchResult) Reset() {
	*x = ModuleElementSearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModuleElementSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModuleElementSearchResult) ProtoMessage() {}

func (x *ModuleElementSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModuleElementSearchResult.ProtoReflect.Descriptor instead.
func (*ModuleElementSearchResult) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{5}
}

func (x *ModuleElementSearchResult) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

func (x *ModuleElementSearchResult) GetRepositoryOwner() string {
	if x != nil {
		return x.RepositoryOwner
	}
	return ""
}

func (x *ModuleElementSearchResult) GetRepositoryName() string {
	if x != nil {
		return x.RepositoryName
	}
	return ""
}

func (x *ModuleElementSearchResult) GetProtoFilePath() string {
	if x != nil {
		return x.ProtoFilePath
	}
	return ""
}

func (x *ModuleElementSearchResult) GetFullyQualifiedName() string {
	if x != nil {
		return x.FullyQualifiedName
	}
	return ""
}

func (x *ModuleElementSearchResult) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

func (x *ModuleElementSearchResult) GetSearchModuleElementType() SearchModuleElementType {
	if x != nil {
		return x.SearchModuleElementType
	}
	return SearchModuleElementType_SEARCH_MODULE_ELEMENT_TYPE_UNSPECIFIED
}

type ModuleFileSearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RepositoryId    string `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
	RepositoryOwner string `protobuf:"bytes,2,opt,name=repository_owner,json=repositoryOwner,proto3" json:"repository_owner,omitempty"`
	RepositoryName  string `protobuf:"bytes,3,opt,name=repository_name,json=repositoryName,proto3" json:"repository_name,omitempty"`
	ProtoFilePath   string `protobuf:"bytes,4,opt,name=proto_file_path,json=protoFilePath,proto3" json:"proto_file_path,omitempty"`
}

func (x *ModuleFileSearchResult) Reset() {
	*x = ModuleFileSearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModuleFileSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModuleFileSearchResult) ProtoMessage() {}

func (x *ModuleFileSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModuleFileSearchResult.ProtoReflect.Descriptor instead.
func (*ModuleFileSearchResult) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{6}
}

func (x *ModuleFileSearchResult) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

func (x *ModuleFileSearchResult) GetRepositoryOwner() string {
	if x != nil {
		return x.RepositoryOwner
	}
	return ""
}

func (x *ModuleFileSearchResult) GetRepositoryName() string {
	if x != nil {
		return x.RepositoryName
	}
	return ""
}

func (x *ModuleFileSearchResult) GetProtoFilePath() string {
	if x != nil {
		return x.ProtoFilePath
	}
	return ""
}

type SearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Item:
	//
	//	*SearchResult_Repository
	//	*SearchResult_Organization
	//	*SearchResult_User
	//	*SearchResult_Team
	//	*SearchResult_CuratedPlugin
	//	*SearchResult_ModuleElement
	//	*SearchResult_ModuleFile
	Item isSearchResult_Item `protobuf_oneof:"item"`
}

func (x *SearchResult) Reset() {
	*x = SearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResult) ProtoMessage() {}

func (x *SearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResult.ProtoReflect.Descriptor instead.
func (*SearchResult) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{7}
}

func (m *SearchResult) GetItem() isSearchResult_Item {
	if m != nil {
		return m.Item
	}
	return nil
}

func (x *SearchResult) GetRepository() *RepositorySearchResult {
	if x, ok := x.GetItem().(*SearchResult_Repository); ok {
		return x.Repository
	}
	return nil
}

func (x *SearchResult) GetOrganization() *OrganizationSearchResult {
	if x, ok := x.GetItem().(*SearchResult_Organization); ok {
		return x.Organization
	}
	return nil
}

func (x *SearchResult) GetUser() *UserSearchResult {
	if x, ok := x.GetItem().(*SearchResult_User); ok {
		return x.User
	}
	return nil
}

func (x *SearchResult) GetTeam() *TeamSearchResult {
	if x, ok := x.GetItem().(*SearchResult_Team); ok {
		return x.Team
	}
	return nil
}

func (x *SearchResult) GetCuratedPlugin() *CuratedPluginSearchResult {
	if x, ok := x.GetItem().(*SearchResult_CuratedPlugin); ok {
		return x.CuratedPlugin
	}
	return nil
}

func (x *SearchResult) GetModuleElement() *ModuleElementSearchResult {
	if x, ok := x.GetItem().(*SearchResult_ModuleElement); ok {
		return x.ModuleElement
	}
	return nil
}

func (x *SearchResult) GetModuleFile() *ModuleFileSearchResult {
	if x, ok := x.GetItem().(*SearchResult_ModuleFile); ok {
		return x.ModuleFile
	}
	return nil
}

type isSearchResult_Item interface {
	isSearchResult_Item()
}

type SearchResult_Repository struct {
	Repository *RepositorySearchResult `protobuf:"bytes,1,opt,name=repository,proto3,oneof"`
}

type SearchResult_Organization struct {
	Organization *OrganizationSearchResult `protobuf:"bytes,2,opt,name=organization,proto3,oneof"`
}

type SearchResult_User struct {
	User *UserSearchResult `protobuf:"bytes,3,opt,name=user,proto3,oneof"`
}

type SearchResult_Team struct {
	Team *TeamSearchResult `protobuf:"bytes,4,opt,name=team,proto3,oneof"`
}

type SearchResult_CuratedPlugin struct {
	CuratedPlugin *CuratedPluginSearchResult `protobuf:"bytes,7,opt,name=curated_plugin,json=curatedPlugin,proto3,oneof"`
}

type SearchResult_ModuleElement struct {
	ModuleElement *ModuleElementSearchResult `protobuf:"bytes,8,opt,name=module_element,json=moduleElement,proto3,oneof"`
}

type SearchResult_ModuleFile struct {
	ModuleFile *ModuleFileSearchResult `protobuf:"bytes,9,opt,name=module_file,json=moduleFile,proto3,oneof"`
}

func (*SearchResult_Repository) isSearchResult_Item() {}

func (*SearchResult_Organization) isSearchResult_Item() {}

func (*SearchResult_User) isSearchResult_Item() {}

func (*SearchResult_Team) isSearchResult_Item() {}

func (*SearchResult_CuratedPlugin) isSearchResult_Item() {}

func (*SearchResult_ModuleElement) isSearchResult_Item() {}

func (*SearchResult_ModuleFile) isSearchResult_Item() {}

type ElementSearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RepositoryId       string `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
	RepositoryOwner    string `protobuf:"bytes,2,opt,name=repository_owner,json=repositoryOwner,proto3" json:"repository_owner,omitempty"`
	RepositoryName     string `protobuf:"bytes,3,opt,name=repository_name,json=repositoryName,proto3" json:"repository_name,omitempty"`
	ProtoFilePath      string `protobuf:"bytes,4,opt,name=proto_file_path,json=protoFilePath,proto3" json:"proto_file_path,omitempty"`
	FullyQualifiedName string `protobuf:"bytes,5,opt,name=fully_qualified_name,json=fullyQualifiedName,proto3" json:"fully_qualified_name,omitempty"`
	// Types that are assignable to Document:
	//
	//	*ElementSearchResult_Service
	//	*ElementSearchResult_Method
	//	*ElementSearchResult_Enum
	//	*ElementSearchResult_Message
	//	*ElementSearchResult_FileExtension
	Document isElementSearchResult_Document `protobuf_oneof:"document"`
}

func (x *ElementSearchResult) Reset() {
	*x = ElementSearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ElementSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ElementSearchResult) ProtoMessage() {}

func (x *ElementSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ElementSearchResult.ProtoReflect.Descriptor instead.
func (*ElementSearchResult) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{8}
}

func (x *ElementSearchResult) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

func (x *ElementSearchResult) GetRepositoryOwner() string {
	if x != nil {
		return x.RepositoryOwner
	}
	return ""
}

func (x *ElementSearchResult) GetRepositoryName() string {
	if x != nil {
		return x.RepositoryName
	}
	return ""
}

func (x *ElementSearchResult) GetProtoFilePath() string {
	if x != nil {
		return x.ProtoFilePath
	}
	return ""
}

func (x *ElementSearchResult) GetFullyQualifiedName() string {
	if x != nil {
		return x.FullyQualifiedName
	}
	return ""
}

func (m *ElementSearchResult) GetDocument() isElementSearchResult_Document {
	if m != nil {
		return m.Document
	}
	return nil
}

func (x *ElementSearchResult) GetService() *Service {
	if x, ok := x.GetDocument().(*ElementSearchResult_Service); ok {
		return x.Service
	}
	return nil
}

func (x *ElementSearchResult) GetMethod() *Method {
	if x, ok := x.GetDocument().(*ElementSearchResult_Method); ok {
		return x.Method
	}
	return nil
}

func (x *ElementSearchResult) GetEnum() *Enum {
	if x, ok := x.GetDocument().(*ElementSearchResult_Enum); ok {
		return x.Enum
	}
	return nil
}

func (x *ElementSearchResult) GetMessage() *Message {
	if x, ok := x.GetDocument().(*ElementSearchResult_Message); ok {
		return x.Message
	}
	return nil
}

func (x *ElementSearchResult) GetFileExtension() *FileExtension {
	if x, ok := x.GetDocument().(*ElementSearchResult_FileExtension); ok {
		return x.FileExtension
	}
	return nil
}

type isElementSearchResult_Document interface {
	isElementSearchResult_Document()
}

type ElementSearchResult_Service struct {
	Service *Service `protobuf:"bytes,6,opt,name=service,proto3,oneof"`
}

type ElementSearchResult_Method struct {
	Method *Method `protobuf:"bytes,7,opt,name=method,proto3,oneof"`
}

type ElementSearchResult_Enum struct {
	Enum *Enum `protobuf:"bytes,8,opt,name=enum,proto3,oneof"`
}

type ElementSearchResult_Message struct {
	Message *Message `protobuf:"bytes,9,opt,name=message,proto3,oneof"`
}

type ElementSearchResult_FileExtension struct {
	FileExtension *FileExtension `protobuf:"bytes,10,opt,name=file_extension,json=fileExtension,proto3,oneof"`
}

func (*ElementSearchResult_Service) isElementSearchResult_Document() {}

func (*ElementSearchResult_Method) isElementSearchResult_Document() {}

func (*ElementSearchResult_Enum) isElementSearchResult_Document() {}

func (*ElementSearchResult_Message) isElementSearchResult_Document() {}

func (*ElementSearchResult_FileExtension) isElementSearchResult_Document() {}

type FileSearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RepositoryId    string `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
	RepositoryOwner string `protobuf:"bytes,2,opt,name=repository_owner,json=repositoryOwner,proto3" json:"repository_owner,omitempty"`
	RepositoryName  string `protobuf:"bytes,3,opt,name=repository_name,json=repositoryName,proto3" json:"repository_name,omitempty"`
	ProtoFilePath   string `protobuf:"bytes,4,opt,name=proto_file_path,json=protoFilePath,proto3" json:"proto_file_path,omitempty"`
	Content         []byte `protobuf:"bytes,5,opt,name=content,proto3" json:"content,omitempty"`
}

func (x *FileSearchResult) Reset() {
	*x = FileSearchResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileSearchResult) ProtoMessage() {}

func (x *FileSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileSearchResult.ProtoReflect.Descriptor instead.
func (*FileSearchResult) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{9}
}

func (x *FileSearchResult) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

func (x *FileSearchResult) GetRepositoryOwner() string {
	if x != nil {
		return x.RepositoryOwner
	}
	return ""
}

func (x *FileSearchResult) GetRepositoryName() string {
	if x != nil {
		return x.RepositoryName
	}
	return ""
}

func (x *FileSearchResult) GetProtoFilePath() string {
	if x != nil {
		return x.ProtoFilePath
	}
	return ""
}

func (x *FileSearchResult) GetContent() []byte {
	if x != nil {
		return x.Content
	}
	return nil
}

type SearchModuleContentResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Item:
	//
	//	*SearchModuleContentResult_Element
	//	*SearchModuleContentResult_File
	Item isSearchModuleContentResult_Item `protobuf_oneof:"item"`
}

func (x *SearchModuleContentResult) Reset() {
	*x = SearchModuleContentResult{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchModuleContentResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchModuleContentResult) ProtoMessage() {}

func (x *SearchModuleContentResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchModuleContentResult.ProtoReflect.Descriptor instead.
func (*SearchModuleContentResult) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{10}
}

func (m *SearchModuleContentResult) GetItem() isSearchModuleContentResult_Item {
	if m != nil {
		return m.Item
	}
	return nil
}

func (x *SearchModuleContentResult) GetElement() *ElementSearchResult {
	if x, ok := x.GetItem().(*SearchModuleContentResult_Element); ok {
		return x.Element
	}
	return nil
}

func (x *SearchModuleContentResult) GetFile() *FileSearchResult {
	if x, ok := x.GetItem().(*SearchModuleContentResult_File); ok {
		return x.File
	}
	return nil
}

type isSearchModuleContentResult_Item interface {
	isSearchModuleContentResult_Item()
}

type SearchModuleContentResult_Element struct {
	Element *ElementSearchResult `protobuf:"bytes,1,opt,name=element,proto3,oneof"`
}

type SearchModuleContentResult_File struct {
	File *FileSearchResult `protobuf:"bytes,2,opt,name=file,proto3,oneof"`
}

func (*SearchModuleContentResult_Element) isSearchModuleContentResult_Item() {}

func (*SearchModuleContentResult_File) isSearchModuleContentResult_Item() {}

type SearchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The search string.
	Query    string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	PageSize uint32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The first page is returned if this is 0.
	PageToken uint32 `protobuf:"varint,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Empty list means show all. Supplying one or more enums will
	// limit the search to only the requested resources.
	// Supplying all possible enums is equivalent to empty list of filters.
	Filters []SearchFilter `protobuf:"varint,4,rep,packed,name=filters,proto3,enum=buf.alpha.registry.v1alpha1.SearchFilter" json:"filters,omitempty"`
}

func (x *SearchRequest) Reset() {
	*x = SearchRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchRequest) ProtoMessage() {}

func (x *SearchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchRequest.ProtoReflect.Descriptor instead.
func (*SearchRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{11}
}

func (x *SearchRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchRequest) GetPageToken() uint32 {
	if x != nil {
		return x.PageToken
	}
	return 0
}

func (x *SearchRequest) GetFilters() []SearchFilter {
	if x != nil {
		return x.Filters
	}
	return nil
}

type SearchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SearchResults []*SearchResult `protobuf:"bytes,1,rep,name=search_results,json=searchResults,proto3" json:"search_results,omitempty"`
	// There are no more pages if this is 0.
	NextPageToken uint32 `protobuf:"varint,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchResponse) Reset() {
	*x = SearchResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResponse) ProtoMessage() {}

func (x *SearchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResponse.ProtoReflect.Descriptor instead.
func (*SearchResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{12}
}

func (x *SearchResponse) GetSearchResults() []*SearchResult {
	if x != nil {
		return x.SearchResults
	}
	return nil
}

func (x *SearchResponse) GetNextPageToken() uint32 {
	if x != nil {
		return x.NextPageToken
	}
	return 0
}

type SearchTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The owner of the repository.
	RepositoryOwner string `protobuf:"bytes,1,opt,name=repository_owner,json=repositoryOwner,proto3" json:"repository_owner,omitempty"`
	// The name of the repository.
	RepositoryName string `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3" json:"repository_name,omitempty"`
	// The search string.
	Query    string `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	PageSize uint32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The first page is returned if this is empty.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The field to order results by.
	OrderBy OrderBy `protobuf:"varint,6,opt,name=order_by,json=orderBy,proto3,enum=buf.alpha.registry.v1alpha1.OrderBy" json:"order_by,omitempty"`
	// Reverse orders results in descending order.
	Reverse bool `protobuf:"varint,7,opt,name=reverse,proto3" json:"reverse,omitempty"`
}

func (x *SearchTagRequest) Reset() {
	*x = SearchTagRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTagRequest) ProtoMessage() {}

func (x *SearchTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTagRequest.ProtoReflect.Descriptor instead.
func (*SearchTagRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{13}
}

func (x *SearchTagRequest) GetRepositoryOwner() string {
	if x != nil {
		return x.RepositoryOwner
	}
	return ""
}

func (x *SearchTagRequest) GetRepositoryName() string {
	if x != nil {
		return x.RepositoryName
	}
	return ""
}

func (x *SearchTagRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchTagRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchTagRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchTagRequest) GetOrderBy() OrderBy {
	if x != nil {
		return x.OrderBy
	}
	return OrderBy_ORDER_BY_UNSPECIFIED
}

func (x *SearchTagRequest) GetReverse() bool {
	if x != nil {
		return x.Reverse
	}
	return false
}

type SearchTagResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RepositoryTags []*RepositoryTag `protobuf:"bytes,1,rep,name=repository_tags,json=repositoryTags,proto3" json:"repository_tags,omitempty"`
	// There are no more pages if this is empty.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchTagResponse) Reset() {
	*x = SearchTagResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchTagResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchTagResponse) ProtoMessage() {}

func (x *SearchTagResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchTagResponse.ProtoReflect.Descriptor instead.
func (*SearchTagResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{14}
}

func (x *SearchTagResponse) GetRepositoryTags() []*RepositoryTag {
	if x != nil {
		return x.RepositoryTags
	}
	return nil
}

func (x *SearchTagResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type SearchDraftRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The owner of the repository.
	RepositoryOwner string `protobuf:"bytes,1,opt,name=repository_owner,json=repositoryOwner,proto3" json:"repository_owner,omitempty"`
	// The name of the repository.
	RepositoryName string `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3" json:"repository_name,omitempty"`
	// The search string.
	Query    string `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	PageSize uint32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The first page is returned if this is empty.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The field to order results by.
	OrderBy OrderBy `protobuf:"varint,6,opt,name=order_by,json=orderBy,proto3,enum=buf.alpha.registry.v1alpha1.OrderBy" json:"order_by,omitempty"`
	// Reverse orders results in descending order.
	Reverse bool `protobuf:"varint,7,opt,name=reverse,proto3" json:"reverse,omitempty"`
}

func (x *SearchDraftRequest) Reset() {
	*x = SearchDraftRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchDraftRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchDraftRequest) ProtoMessage() {}

func (x *SearchDraftRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchDraftRequest.ProtoReflect.Descriptor instead.
func (*SearchDraftRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{15}
}

func (x *SearchDraftRequest) GetRepositoryOwner() string {
	if x != nil {
		return x.RepositoryOwner
	}
	return ""
}

func (x *SearchDraftRequest) GetRepositoryName() string {
	if x != nil {
		return x.RepositoryName
	}
	return ""
}

func (x *SearchDraftRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchDraftRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchDraftRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchDraftRequest) GetOrderBy() OrderBy {
	if x != nil {
		return x.OrderBy
	}
	return OrderBy_ORDER_BY_UNSPECIFIED
}

func (x *SearchDraftRequest) GetReverse() bool {
	if x != nil {
		return x.Reverse
	}
	return false
}

type SearchDraftResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RepositoryCommits []*RepositoryCommit `protobuf:"bytes,1,rep,name=repository_commits,json=repositoryCommits,proto3" json:"repository_commits,omitempty"`
	// There are no more pages if this is empty.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchDraftResponse) Reset() {
	*x = SearchDraftResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchDraftResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchDraftResponse) ProtoMessage() {}

func (x *SearchDraftResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchDraftResponse.ProtoReflect.Descriptor instead.
func (*SearchDraftResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{16}
}

func (x *SearchDraftResponse) GetRepositoryCommits() []*RepositoryCommit {
	if x != nil {
		return x.RepositoryCommits
	}
	return nil
}

func (x *SearchDraftResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type SearchModuleContentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The search string.
	Query    string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	PageSize uint32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The first page is returned if this is 0.
	PageToken uint32 `protobuf:"varint,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Empty list means show all. Supplying one or more enums will
	// limit the search to only the requested resources.
	// Supplying all possible enums is equivalent to empty list of filters.
	Filters []SearchModuleContentFilter `protobuf:"varint,4,rep,packed,name=filters,proto3,enum=buf.alpha.registry.v1alpha1.SearchModuleContentFilter" json:"filters,omitempty"`
	// Optional, if provided the search results will be limited to the provided repository.
	RepositoryFullName string `protobuf:"bytes,5,opt,name=repository_full_name,json=repositoryFullName,proto3" json:"repository_full_name,omitempty"`
	// Optional, if provided the search results will be limited to the provided owner,
	// ignored if repository_full_name is provided.
	RepositoryOwner string `protobuf:"bytes,6,opt,name=repository_owner,json=repositoryOwner,proto3" json:"repository_owner,omitempty"`
}

func (x *SearchModuleContentRequest) Reset() {
	*x = SearchModuleContentRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchModuleContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchModuleContentRequest) ProtoMessage() {}

func (x *SearchModuleContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchModuleContentRequest.ProtoReflect.Descriptor instead.
func (*SearchModuleContentRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{17}
}

func (x *SearchModuleContentRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchModuleContentRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchModuleContentRequest) GetPageToken() uint32 {
	if x != nil {
		return x.PageToken
	}
	return 0
}

func (x *SearchModuleContentRequest) GetFilters() []SearchModuleContentFilter {
	if x != nil {
		return x.Filters
	}
	return nil
}

func (x *SearchModuleContentRequest) GetRepositoryFullName() string {
	if x != nil {
		return x.RepositoryFullName
	}
	return ""
}

func (x *SearchModuleContentRequest) GetRepositoryOwner() string {
	if x != nil {
		return x.RepositoryOwner
	}
	return ""
}

type SearchModuleContentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SearchResults []*SearchModuleContentResult `protobuf:"bytes,1,rep,name=search_results,json=searchResults,proto3" json:"search_results,omitempty"`
	// There are no more pages if this is 0.
	NextPageToken uint32 `protobuf:"varint,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchModuleContentResponse) Reset() {
	*x = SearchModuleContentResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchModuleContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchModuleContentResponse) ProtoMessage() {}

func (x *SearchModuleContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchModuleContentResponse.ProtoReflect.Descriptor instead.
func (*SearchModuleContentResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP(), []int{18}
}

func (x *SearchModuleContentResponse) GetSearchResults() []*SearchModuleContentResult {
	if x != nil {
		return x.SearchResults
	}
	return nil
}

func (x *SearchModuleContentResponse) GetNextPageToken() uint32 {
	if x != nil {
		return x.NextPageToken
	}
	return 0
}

var File_buf_alpha_registry_v1alpha1_search_proto protoreflect.FileDescriptor

var file_buf_alpha_registry_v1alpha1_search_proto_rawDesc = []byte{
	0x0a, 0x28, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x1a, 0x25, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2f, 0x64, 0x6f, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31,
	0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x5f, 0x63, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2c, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x33, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x74, 0x61, 0x67,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb9,
	0x03, 0x0a, 0x16, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77,
	0x6e, 0x65, 0x72, 0x12, 0x47, 0x0a, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x52, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x1e, 0x0a, 0x0a,
	0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x33, 0x0a, 0x16,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x73, 0x70, 0x64, 0x78, 0x5f, 0x6c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x74, 0x53, 0x70, 0x64, 0x78, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x49,
	0x64, 0x12, 0x6b, 0x0a, 0x19, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x17, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x56, 0x65, 0x72, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x10,
	0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c,
	0x12, 0x48, 0x0a, 0x12, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x7b, 0x0a, 0x18, 0x4f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x9d, 0x01, 0x0a, 0x10, 0x55, 0x73, 0x65, 0x72,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08,
	0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x64,
	0x65, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x63, 0x0a, 0x10, 0x54, 0x65, 0x61, 0x6d, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x2b, 0x0a, 0x11, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x82, 0x03, 0x0a,
	0x19, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x0d, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x56, 0x0a, 0x10,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x22, 0x84, 0x03, 0x0a, 0x19, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x45, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x5f, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x12,
	0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x46, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x74, 0x68,
	0x12, 0x30, 0x0a, 0x14, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x66,
	0x69, 0x65, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12,
	0x66, 0x75, 0x6c, 0x6c, 0x79, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x64, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x71, 0x0a, 0x1a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x17, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x45, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x22, 0xb9, 0x01, 0x0a, 0x16, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4f, 0x77,
	0x6e, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x46, 0x69, 0x6c, 0x65,
	0x50, 0x61, 0x74, 0x68, 0x22, 0x8c, 0x05, 0x0a, 0x0c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x55, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00,
	0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x5b, 0x0a, 0x0c,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0c, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x04, 0x75, 0x73, 0x65,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x43,
	0x0a, 0x04, 0x74, 0x65, 0x61, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x61, 0x6d, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x04, 0x74,
	0x65, 0x61, 0x6d, 0x12, 0x5f, 0x0a, 0x0e, 0x63, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x70,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65,
	0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x12, 0x5f, 0x0a, 0x0e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x65,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x45, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x0b, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f,
	0x66, 0x69, 0x6c, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x46,
	0x69, 0x6c, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48,
	0x00, 0x52, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x42, 0x06, 0x0a,
	0x04, 0x69, 0x74, 0x65, 0x6d, 0x4a, 0x04, 0x08, 0x05, 0x10, 0x06, 0x4a, 0x04, 0x08, 0x06, 0x10,
	0x07, 0x52, 0x06, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x22, 0xc5, 0x04, 0x0a, 0x13, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64,
	0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0f, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x5f, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x46, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x30, 0x0a, 0x14,
	0x66, 0x75, 0x6c, 0x6c, 0x79, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x66, 0x75, 0x6c, 0x6c,
	0x79, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x48, 0x00, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x3d, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x48, 0x00, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12,
	0x37, 0x0a, 0x04, 0x65, 0x6e, 0x75, 0x6d, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x75, 0x6d,
	0x48, 0x00, 0x52, 0x04, 0x65, 0x6e, 0x75, 0x6d, 0x12, 0x40, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x48,
	0x00, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x53, 0x0a, 0x0e, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x46, 0x69, 0x6c, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x0d, 0x66, 0x69, 0x6c, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x42,
	0x0a, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xcd, 0x01, 0x0a, 0x10,
	0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x5f, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4f, 0x77, 0x6e, 0x65, 0x72,
	0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x46, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x74,
	0x68, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0xb6, 0x01, 0x0a, 0x19,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x4c, 0x0a, 0x07, 0x65, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x07,
	0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x42, 0x06, 0x0a, 0x04,
	0x69, 0x74, 0x65, 0x6d, 0x22, 0xa6, 0x01, 0x0a, 0x0d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x43, 0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x22, 0x8a, 0x01,
	0x0a, 0x0e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x50, 0x0a, 0x0e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x93, 0x02, 0x0a, 0x10, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x29, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6f, 0x77,
	0x6e, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x3f, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x52, 0x07, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65,
	0x22, 0x90, 0x01, 0x0a, 0x11, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x61, 0x67, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x54, 0x61, 0x67, 0x52, 0x0e, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x54, 0x61, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x95, 0x02, 0x0a, 0x12, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x72,
	0x61, 0x66, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x4f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x3f, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x24, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x07, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x22, 0x9b, 0x01, 0x0a, 0x13,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x72, 0x61, 0x66, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x5c, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x11,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9d, 0x02, 0x0a, 0x1a, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x50, 0x0a, 0x07, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x30, 0x0a, 0x14,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x66, 0x75, 0x6c, 0x6c, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x46, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x29,
	0x0a, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x22, 0xa4, 0x01, 0x0a, 0x1b, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5d, 0x0a, 0x0e, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x2a, 0xb8, 0x02, 0x0a, 0x0c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x46, 0x49, 0x4c, 0x54,
	0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x16, 0x0a, 0x12, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45,
	0x52, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x45, 0x41, 0x52,
	0x43, 0x48, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49,
	0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x45, 0x41, 0x52,
	0x43, 0x48, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49,
	0x54, 0x4f, 0x52, 0x59, 0x10, 0x03, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48,
	0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x45, 0x41, 0x4d, 0x10, 0x06, 0x12, 0x20,
	0x0a, 0x1c, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f,
	0x43, 0x55, 0x52, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x10, 0x07,
	0x12, 0x20, 0x0a, 0x1c, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45,
	0x52, 0x5f, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45, 0x5f, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54,
	0x10, 0x08, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x46, 0x49, 0x4c,
	0x54, 0x45, 0x52, 0x5f, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10,
	0x09, 0x22, 0x04, 0x08, 0x04, 0x10, 0x04, 0x22, 0x04, 0x08, 0x05, 0x10, 0x05, 0x2a, 0x14, 0x53,
	0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x50, 0x4c, 0x55,
	0x47, 0x49, 0x4e, 0x2a, 0x16, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x46, 0x49, 0x4c, 0x54,
	0x45, 0x52, 0x5f, 0x54, 0x45, 0x4d, 0x50, 0x4c, 0x41, 0x54, 0x45, 0x2a, 0x6a, 0x0a, 0x07, 0x4f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x18, 0x0a, 0x14, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f,
	0x42, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x18, 0x0a, 0x14, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x42, 0x59, 0x5f, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x4f, 0x52,
	0x44, 0x45, 0x52, 0x5f, 0x42, 0x59, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x49,
	0x4d, 0x45, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x42, 0x59,
	0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x10, 0x03, 0x2a, 0xe1, 0x01, 0x0a, 0x17, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x2a, 0x0a, 0x26, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x4d, 0x4f,
	0x44, 0x55, 0x4c, 0x45, 0x5f, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x26, 0x0a, 0x22, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45,
	0x5f, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45,
	0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x01, 0x12, 0x25, 0x0a, 0x21, 0x53, 0x45, 0x41, 0x52, 0x43,
	0x48, 0x5f, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45, 0x5f, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x10, 0x02, 0x12, 0x26,
	0x0a, 0x22, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45, 0x5f,
	0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x45, 0x53,
	0x53, 0x41, 0x47, 0x45, 0x10, 0x03, 0x12, 0x23, 0x0a, 0x1f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48,
	0x5f, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45, 0x5f, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x4e, 0x55, 0x4d, 0x10, 0x04, 0x2a, 0x9a, 0x01, 0x0a, 0x19,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x2c, 0x0a, 0x28, 0x53, 0x45, 0x41,
	0x52, 0x43, 0x48, 0x5f, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45,
	0x4e, 0x54, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x28, 0x0a, 0x24, 0x53, 0x45, 0x41, 0x52, 0x43,
	0x48, 0x5f, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54,
	0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x10,
	0x01, 0x12, 0x25, 0x0a, 0x21, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x4d, 0x4f, 0x44, 0x55,
	0x4c, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45,
	0x52, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x02, 0x32, 0xef, 0x03, 0x0a, 0x0d, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x66, 0x0a, 0x06, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x12, 0x2a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90,
	0x02, 0x01, 0x12, 0x6f, 0x0a, 0x09, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x61, 0x67, 0x12,
	0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x54, 0x61, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03,
	0x90, 0x02, 0x01, 0x12, 0x75, 0x0a, 0x0b, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x72, 0x61,
	0x66, 0x74, 0x12, 0x2f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x72, 0x61, 0x66, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x72, 0x61, 0x66, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x8d, 0x01, 0x0a, 0x13, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x12, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x42, 0x98, 0x02, 0x0a, 0x1f, 0x63,
	0x6f, 0x6d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x42, 0x0b,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x59, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x67,
	0x65, 0x6e, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x3b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xa2, 0x02, 0x03, 0x42, 0x41, 0x52, 0xaa, 0x02,
	0x1b, 0x42, 0x75, 0x66, 0x2e, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xca, 0x02, 0x1b, 0x42,
	0x75, 0x66, 0x5c, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xe2, 0x02, 0x27, 0x42, 0x75, 0x66,
	0x5c, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c,
	0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x1e, 0x42, 0x75, 0x66, 0x3a, 0x3a, 0x41, 0x6c, 0x70, 0x68,
	0x61, 0x3a, 0x3a, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_alpha_registry_v1alpha1_search_proto_rawDescOnce sync.Once
	file_buf_alpha_registry_v1alpha1_search_proto_rawDescData = file_buf_alpha_registry_v1alpha1_search_proto_rawDesc
)

func file_buf_alpha_registry_v1alpha1_search_proto_rawDescGZIP() []byte {
	file_buf_alpha_registry_v1alpha1_search_proto_rawDescOnce.Do(func() {
		file_buf_alpha_registry_v1alpha1_search_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_alpha_registry_v1alpha1_search_proto_rawDescData)
	})
	return file_buf_alpha_registry_v1alpha1_search_proto_rawDescData
}

var file_buf_alpha_registry_v1alpha1_search_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_buf_alpha_registry_v1alpha1_search_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_buf_alpha_registry_v1alpha1_search_proto_goTypes = []any{
	(SearchFilter)(0),                   // 0: buf.alpha.registry.v1alpha1.SearchFilter
	(OrderBy)(0),                        // 1: buf.alpha.registry.v1alpha1.OrderBy
	(SearchModuleElementType)(0),        // 2: buf.alpha.registry.v1alpha1.SearchModuleElementType
	(SearchModuleContentFilter)(0),      // 3: buf.alpha.registry.v1alpha1.SearchModuleContentFilter
	(*RepositorySearchResult)(nil),      // 4: buf.alpha.registry.v1alpha1.RepositorySearchResult
	(*OrganizationSearchResult)(nil),    // 5: buf.alpha.registry.v1alpha1.OrganizationSearchResult
	(*UserSearchResult)(nil),            // 6: buf.alpha.registry.v1alpha1.UserSearchResult
	(*TeamSearchResult)(nil),            // 7: buf.alpha.registry.v1alpha1.TeamSearchResult
	(*CuratedPluginSearchResult)(nil),   // 8: buf.alpha.registry.v1alpha1.CuratedPluginSearchResult
	(*ModuleElementSearchResult)(nil),   // 9: buf.alpha.registry.v1alpha1.ModuleElementSearchResult
	(*ModuleFileSearchResult)(nil),      // 10: buf.alpha.registry.v1alpha1.ModuleFileSearchResult
	(*SearchResult)(nil),                // 11: buf.alpha.registry.v1alpha1.SearchResult
	(*ElementSearchResult)(nil),         // 12: buf.alpha.registry.v1alpha1.ElementSearchResult
	(*FileSearchResult)(nil),            // 13: buf.alpha.registry.v1alpha1.FileSearchResult
	(*SearchModuleContentResult)(nil),   // 14: buf.alpha.registry.v1alpha1.SearchModuleContentResult
	(*SearchRequest)(nil),               // 15: buf.alpha.registry.v1alpha1.SearchRequest
	(*SearchResponse)(nil),              // 16: buf.alpha.registry.v1alpha1.SearchResponse
	(*SearchTagRequest)(nil),            // 17: buf.alpha.registry.v1alpha1.SearchTagRequest
	(*SearchTagResponse)(nil),           // 18: buf.alpha.registry.v1alpha1.SearchTagResponse
	(*SearchDraftRequest)(nil),          // 19: buf.alpha.registry.v1alpha1.SearchDraftRequest
	(*SearchDraftResponse)(nil),         // 20: buf.alpha.registry.v1alpha1.SearchDraftResponse
	(*SearchModuleContentRequest)(nil),  // 21: buf.alpha.registry.v1alpha1.SearchModuleContentRequest
	(*SearchModuleContentResponse)(nil), // 22: buf.alpha.registry.v1alpha1.SearchModuleContentResponse
	(Visibility)(0),                     // 23: buf.alpha.registry.v1alpha1.Visibility
	(VerificationStatus)(0),             // 24: buf.alpha.registry.v1alpha1.VerificationStatus
	(*timestamppb.Timestamp)(nil),       // 25: google.protobuf.Timestamp
	(PluginRegistryType)(0),             // 26: buf.alpha.registry.v1alpha1.PluginRegistryType
	(PluginLanguage)(0),                 // 27: buf.alpha.registry.v1alpha1.PluginLanguage
	(*Service)(nil),                     // 28: buf.alpha.registry.v1alpha1.Service
	(*Method)(nil),                      // 29: buf.alpha.registry.v1alpha1.Method
	(*Enum)(nil),                        // 30: buf.alpha.registry.v1alpha1.Enum
	(*Message)(nil),                     // 31: buf.alpha.registry.v1alpha1.Message
	(*FileExtension)(nil),               // 32: buf.alpha.registry.v1alpha1.FileExtension
	(*RepositoryTag)(nil),               // 33: buf.alpha.registry.v1alpha1.RepositoryTag
	(*RepositoryCommit)(nil),            // 34: buf.alpha.registry.v1alpha1.RepositoryCommit
}
var file_buf_alpha_registry_v1alpha1_search_proto_depIdxs = []int32{
	23, // 0: buf.alpha.registry.v1alpha1.RepositorySearchResult.visibility:type_name -> buf.alpha.registry.v1alpha1.Visibility
	24, // 1: buf.alpha.registry.v1alpha1.RepositorySearchResult.owner_verification_status:type_name -> buf.alpha.registry.v1alpha1.VerificationStatus
	25, // 2: buf.alpha.registry.v1alpha1.RepositorySearchResult.latest_commit_time:type_name -> google.protobuf.Timestamp
	25, // 3: buf.alpha.registry.v1alpha1.OrganizationSearchResult.create_time:type_name -> google.protobuf.Timestamp
	25, // 4: buf.alpha.registry.v1alpha1.UserSearchResult.create_time:type_name -> google.protobuf.Timestamp
	26, // 5: buf.alpha.registry.v1alpha1.CuratedPluginSearchResult.registry_type:type_name -> buf.alpha.registry.v1alpha1.PluginRegistryType
	27, // 6: buf.alpha.registry.v1alpha1.CuratedPluginSearchResult.output_languages:type_name -> buf.alpha.registry.v1alpha1.PluginLanguage
	25, // 7: buf.alpha.registry.v1alpha1.CuratedPluginSearchResult.create_time:type_name -> google.protobuf.Timestamp
	2,  // 8: buf.alpha.registry.v1alpha1.ModuleElementSearchResult.search_module_element_type:type_name -> buf.alpha.registry.v1alpha1.SearchModuleElementType
	4,  // 9: buf.alpha.registry.v1alpha1.SearchResult.repository:type_name -> buf.alpha.registry.v1alpha1.RepositorySearchResult
	5,  // 10: buf.alpha.registry.v1alpha1.SearchResult.organization:type_name -> buf.alpha.registry.v1alpha1.OrganizationSearchResult
	6,  // 11: buf.alpha.registry.v1alpha1.SearchResult.user:type_name -> buf.alpha.registry.v1alpha1.UserSearchResult
	7,  // 12: buf.alpha.registry.v1alpha1.SearchResult.team:type_name -> buf.alpha.registry.v1alpha1.TeamSearchResult
	8,  // 13: buf.alpha.registry.v1alpha1.SearchResult.curated_plugin:type_name -> buf.alpha.registry.v1alpha1.CuratedPluginSearchResult
	9,  // 14: buf.alpha.registry.v1alpha1.SearchResult.module_element:type_name -> buf.alpha.registry.v1alpha1.ModuleElementSearchResult
	10, // 15: buf.alpha.registry.v1alpha1.SearchResult.module_file:type_name -> buf.alpha.registry.v1alpha1.ModuleFileSearchResult
	28, // 16: buf.alpha.registry.v1alpha1.ElementSearchResult.service:type_name -> buf.alpha.registry.v1alpha1.Service
	29, // 17: buf.alpha.registry.v1alpha1.ElementSearchResult.method:type_name -> buf.alpha.registry.v1alpha1.Method
	30, // 18: buf.alpha.registry.v1alpha1.ElementSearchResult.enum:type_name -> buf.alpha.registry.v1alpha1.Enum
	31, // 19: buf.alpha.registry.v1alpha1.ElementSearchResult.message:type_name -> buf.alpha.registry.v1alpha1.Message
	32, // 20: buf.alpha.registry.v1alpha1.ElementSearchResult.file_extension:type_name -> buf.alpha.registry.v1alpha1.FileExtension
	12, // 21: buf.alpha.registry.v1alpha1.SearchModuleContentResult.element:type_name -> buf.alpha.registry.v1alpha1.ElementSearchResult
	13, // 22: buf.alpha.registry.v1alpha1.SearchModuleContentResult.file:type_name -> buf.alpha.registry.v1alpha1.FileSearchResult
	0,  // 23: buf.alpha.registry.v1alpha1.SearchRequest.filters:type_name -> buf.alpha.registry.v1alpha1.SearchFilter
	11, // 24: buf.alpha.registry.v1alpha1.SearchResponse.search_results:type_name -> buf.alpha.registry.v1alpha1.SearchResult
	1,  // 25: buf.alpha.registry.v1alpha1.SearchTagRequest.order_by:type_name -> buf.alpha.registry.v1alpha1.OrderBy
	33, // 26: buf.alpha.registry.v1alpha1.SearchTagResponse.repository_tags:type_name -> buf.alpha.registry.v1alpha1.RepositoryTag
	1,  // 27: buf.alpha.registry.v1alpha1.SearchDraftRequest.order_by:type_name -> buf.alpha.registry.v1alpha1.OrderBy
	34, // 28: buf.alpha.registry.v1alpha1.SearchDraftResponse.repository_commits:type_name -> buf.alpha.registry.v1alpha1.RepositoryCommit
	3,  // 29: buf.alpha.registry.v1alpha1.SearchModuleContentRequest.filters:type_name -> buf.alpha.registry.v1alpha1.SearchModuleContentFilter
	14, // 30: buf.alpha.registry.v1alpha1.SearchModuleContentResponse.search_results:type_name -> buf.alpha.registry.v1alpha1.SearchModuleContentResult
	15, // 31: buf.alpha.registry.v1alpha1.SearchService.Search:input_type -> buf.alpha.registry.v1alpha1.SearchRequest
	17, // 32: buf.alpha.registry.v1alpha1.SearchService.SearchTag:input_type -> buf.alpha.registry.v1alpha1.SearchTagRequest
	19, // 33: buf.alpha.registry.v1alpha1.SearchService.SearchDraft:input_type -> buf.alpha.registry.v1alpha1.SearchDraftRequest
	21, // 34: buf.alpha.registry.v1alpha1.SearchService.SearchModuleContent:input_type -> buf.alpha.registry.v1alpha1.SearchModuleContentRequest
	16, // 35: buf.alpha.registry.v1alpha1.SearchService.Search:output_type -> buf.alpha.registry.v1alpha1.SearchResponse
	18, // 36: buf.alpha.registry.v1alpha1.SearchService.SearchTag:output_type -> buf.alpha.registry.v1alpha1.SearchTagResponse
	20, // 37: buf.alpha.registry.v1alpha1.SearchService.SearchDraft:output_type -> buf.alpha.registry.v1alpha1.SearchDraftResponse
	22, // 38: buf.alpha.registry.v1alpha1.SearchService.SearchModuleContent:output_type -> buf.alpha.registry.v1alpha1.SearchModuleContentResponse
	35, // [35:39] is the sub-list for method output_type
	31, // [31:35] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_search_proto_init() }
func file_buf_alpha_registry_v1alpha1_search_proto_init() {
	if File_buf_alpha_registry_v1alpha1_search_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_doc_proto_init()
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_init()
	file_buf_alpha_registry_v1alpha1_repository_proto_init()
	file_buf_alpha_registry_v1alpha1_repository_commit_proto_init()
	file_buf_alpha_registry_v1alpha1_repository_tag_proto_init()
	file_buf_alpha_registry_v1alpha1_verification_status_proto_init()
	file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[7].OneofWrappers = []any{
		(*SearchResult_Repository)(nil),
		(*SearchResult_Organization)(nil),
		(*SearchResult_User)(nil),
		(*SearchResult_Team)(nil),
		(*SearchResult_CuratedPlugin)(nil),
		(*SearchResult_ModuleElement)(nil),
		(*SearchResult_ModuleFile)(nil),
	}
	file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[8].OneofWrappers = []any{
		(*ElementSearchResult_Service)(nil),
		(*ElementSearchResult_Method)(nil),
		(*ElementSearchResult_Enum)(nil),
		(*ElementSearchResult_Message)(nil),
		(*ElementSearchResult_FileExtension)(nil),
	}
	file_buf_alpha_registry_v1alpha1_search_proto_msgTypes[10].OneofWrappers = []any{
		(*SearchModuleContentResult_Element)(nil),
		(*SearchModuleContentResult_File)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_alpha_registry_v1alpha1_search_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_search_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_search_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_search_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_search_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_search_proto = out.File
	file_buf_alpha_registry_v1alpha1_search_proto_rawDesc = nil
	file_buf_alpha_registry_v1alpha1_search_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_search_proto_depIdxs = nil
}
