// Copyright 2020-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2-devel
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/studio_request.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// StudioProtocol are the supported protocols for Studio Requests.
type StudioProtocol int32

const (
	// STUDIO_PROTOCOL_UNSPECIFIED is a safe default for requests with no protocol
	// defined.
	StudioProtocol_STUDIO_PROTOCOL_UNSPECIFIED StudioProtocol = 0
	// STUDIO_PROTOCOL_CONNECT is the Connect protocol in Studio.
	StudioProtocol_STUDIO_PROTOCOL_CONNECT StudioProtocol = 1
	// STUDIO_PROTOCOL_GRPC is the gRPC protocol in Studio.
	StudioProtocol_STUDIO_PROTOCOL_GRPC StudioProtocol = 2
	// STUDIO_PROTOCOL_GRPC_WEB is the gRPC-web protocol in Studio.
	StudioProtocol_STUDIO_PROTOCOL_GRPC_WEB StudioProtocol = 3
)

// Enum value maps for StudioProtocol.
var (
	StudioProtocol_name = map[int32]string{
		0: "STUDIO_PROTOCOL_UNSPECIFIED",
		1: "STUDIO_PROTOCOL_CONNECT",
		2: "STUDIO_PROTOCOL_GRPC",
		3: "STUDIO_PROTOCOL_GRPC_WEB",
	}
	StudioProtocol_value = map[string]int32{
		"STUDIO_PROTOCOL_UNSPECIFIED": 0,
		"STUDIO_PROTOCOL_CONNECT":     1,
		"STUDIO_PROTOCOL_GRPC":        2,
		"STUDIO_PROTOCOL_GRPC_WEB":    3,
	}
)

func (x StudioProtocol) Enum() *StudioProtocol {
	p := new(StudioProtocol)
	*p = x
	return p
}

func (x StudioProtocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StudioProtocol) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_studio_request_proto_enumTypes[0].Descriptor()
}

func (StudioProtocol) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_studio_request_proto_enumTypes[0]
}

func (x StudioProtocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StudioProtocol.Descriptor instead.
func (StudioProtocol) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDescGZIP(), []int{0}
}

// CreateStudioRequestRequest is the proto request representation of the
// CreateStudioRequest method.
type CreateStudioRequestRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The linked BSR repository owner name (user or organization).
	RepositoryOwner string `protobuf:"bytes,1,opt,name=repository_owner,json=repositoryOwner,proto3" json:"repository_owner,omitempty"`
	// The linked BSR repository name.
	RepositoryName string `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3" json:"repository_name,omitempty"`
	// The friendly name of this request.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// The target base URL of this request.
	TargetBaseUrl string `protobuf:"bytes,4,opt,name=target_base_url,json=targetBaseUrl,proto3" json:"target_base_url,omitempty"`
	// The target service name as defined in the BSR repository.
	Service string `protobuf:"bytes,5,opt,name=service,proto3" json:"service,omitempty"`
	// The target RPC method name as defined in the BSR repository.
	Method string `protobuf:"bytes,6,opt,name=method,proto3" json:"method,omitempty"`
	// The request body as defined in Studio.
	Body string `protobuf:"bytes,7,opt,name=body,proto3" json:"body,omitempty"`
	// The request headers as defined in Studio.
	Headers map[string]string `protobuf:"bytes,8,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Should this request include cookies from the Studio current session?
	IncludeCookies bool `protobuf:"varint,9,opt,name=include_cookies,json=includeCookies,proto3" json:"include_cookies,omitempty"`
	// The protocol that Studio uses to send this request.
	Protocol StudioProtocol `protobuf:"varint,10,opt,name=protocol,proto3,enum=buf.alpha.registry.v1alpha1.StudioProtocol" json:"protocol,omitempty"`
	// The agent url (if any) used by Studio to send the request. See
	// https://docs.buf.build/bsr/studio#via-buf-studio-agent for details.
	AgentUrl string `protobuf:"bytes,11,opt,name=agent_url,json=agentUrl,proto3" json:"agent_url,omitempty"`
}

func (x *CreateStudioRequestRequest) Reset() {
	*x = CreateStudioRequestRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateStudioRequestRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateStudioRequestRequest) ProtoMessage() {}

func (x *CreateStudioRequestRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateStudioRequestRequest.ProtoReflect.Descriptor instead.
func (*CreateStudioRequestRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDescGZIP(), []int{0}
}

func (x *CreateStudioRequestRequest) GetRepositoryOwner() string {
	if x != nil {
		return x.RepositoryOwner
	}
	return ""
}

func (x *CreateStudioRequestRequest) GetRepositoryName() string {
	if x != nil {
		return x.RepositoryName
	}
	return ""
}

func (x *CreateStudioRequestRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateStudioRequestRequest) GetTargetBaseUrl() string {
	if x != nil {
		return x.TargetBaseUrl
	}
	return ""
}

func (x *CreateStudioRequestRequest) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *CreateStudioRequestRequest) GetMethod() string {
	if x != nil {
		return x.Method
	}
	return ""
}

func (x *CreateStudioRequestRequest) GetBody() string {
	if x != nil {
		return x.Body
	}
	return ""
}

func (x *CreateStudioRequestRequest) GetHeaders() map[string]string {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *CreateStudioRequestRequest) GetIncludeCookies() bool {
	if x != nil {
		return x.IncludeCookies
	}
	return false
}

func (x *CreateStudioRequestRequest) GetProtocol() StudioProtocol {
	if x != nil {
		return x.Protocol
	}
	return StudioProtocol_STUDIO_PROTOCOL_UNSPECIFIED
}

func (x *CreateStudioRequestRequest) GetAgentUrl() string {
	if x != nil {
		return x.AgentUrl
	}
	return ""
}

// CreateStudioRequestResponse returns the created StudioRequest.
type CreateStudioRequestResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Created Studio Request.
	CreatedRequest *StudioRequest `protobuf:"bytes,1,opt,name=created_request,json=createdRequest,proto3" json:"created_request,omitempty"`
}

func (x *CreateStudioRequestResponse) Reset() {
	*x = CreateStudioRequestResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateStudioRequestResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateStudioRequestResponse) ProtoMessage() {}

func (x *CreateStudioRequestResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateStudioRequestResponse.ProtoReflect.Descriptor instead.
func (*CreateStudioRequestResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDescGZIP(), []int{1}
}

func (x *CreateStudioRequestResponse) GetCreatedRequest() *StudioRequest {
	if x != nil {
		return x.CreatedRequest
	}
	return nil
}

// RenameStudioRequestRequest is the proto request representation of the
// RenameStudioRequest method.
type RenameStudioRequestRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Studio Request ID that will be renamed.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The new name for the request.
	NewName string `protobuf:"bytes,2,opt,name=new_name,json=newName,proto3" json:"new_name,omitempty"`
}

func (x *RenameStudioRequestRequest) Reset() {
	*x = RenameStudioRequestRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RenameStudioRequestRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenameStudioRequestRequest) ProtoMessage() {}

func (x *RenameStudioRequestRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenameStudioRequestRequest.ProtoReflect.Descriptor instead.
func (*RenameStudioRequestRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDescGZIP(), []int{2}
}

func (x *RenameStudioRequestRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *RenameStudioRequestRequest) GetNewName() string {
	if x != nil {
		return x.NewName
	}
	return ""
}

// RenameStudioRequestResponse returns empty on successful renaming.
type RenameStudioRequestResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RenameStudioRequestResponse) Reset() {
	*x = RenameStudioRequestResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RenameStudioRequestResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenameStudioRequestResponse) ProtoMessage() {}

func (x *RenameStudioRequestResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenameStudioRequestResponse.ProtoReflect.Descriptor instead.
func (*RenameStudioRequestResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDescGZIP(), []int{3}
}

// DeleteStudioRequestRequest is the proto request representation of the
// DeleteStudioRequest method.
type DeleteStudioRequestRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Studio Request ID that will be deleted.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *DeleteStudioRequestRequest) Reset() {
	*x = DeleteStudioRequestRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteStudioRequestRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteStudioRequestRequest) ProtoMessage() {}

func (x *DeleteStudioRequestRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteStudioRequestRequest.ProtoReflect.Descriptor instead.
func (*DeleteStudioRequestRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteStudioRequestRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// DeleteStudioRequestResponse returns empty on successful deletions.
type DeleteStudioRequestResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteStudioRequestResponse) Reset() {
	*x = DeleteStudioRequestResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteStudioRequestResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteStudioRequestResponse) ProtoMessage() {}

func (x *DeleteStudioRequestResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteStudioRequestResponse.ProtoReflect.Descriptor instead.
func (*DeleteStudioRequestResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDescGZIP(), []int{5}
}

// ListStudioRequestsRequest is the proto request representation of the
// ListStudioRequests method.
type ListStudioRequestsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The page size for listing studio requests, values between 1-250.
	PageSize uint32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token for paginating. The first page is returned if this is empty.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The listed studio requests are order by created time in ascending order.
	// You can reverse that order setting this value to true.
	Reverse bool `protobuf:"varint,3,opt,name=reverse,proto3" json:"reverse,omitempty"`
}

func (x *ListStudioRequestsRequest) Reset() {
	*x = ListStudioRequestsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListStudioRequestsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListStudioRequestsRequest) ProtoMessage() {}

func (x *ListStudioRequestsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListStudioRequestsRequest.ProtoReflect.Descriptor instead.
func (*ListStudioRequestsRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDescGZIP(), []int{6}
}

func (x *ListStudioRequestsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListStudioRequestsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListStudioRequestsRequest) GetReverse() bool {
	if x != nil {
		return x.Reverse
	}
	return false
}

// ListStudioRequestsResponse is the proto response representation of the
// ListStudioRequests method.
type ListStudioRequestsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of requests in the current page.
	Requests []*StudioRequest `protobuf:"bytes,1,rep,name=requests,proto3" json:"requests,omitempty"`
	// The requests' next page token. There are no more pages if this is empty.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListStudioRequestsResponse) Reset() {
	*x = ListStudioRequestsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListStudioRequestsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListStudioRequestsResponse) ProtoMessage() {}

func (x *ListStudioRequestsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListStudioRequestsResponse.ProtoReflect.Descriptor instead.
func (*ListStudioRequestsResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDescGZIP(), []int{7}
}

func (x *ListStudioRequestsResponse) GetRequests() []*StudioRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

func (x *ListStudioRequestsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// StudioRequest represents a saved request in Studio, that is synced to a BSR
// user's profile.
type StudioRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of this Studio Request.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The request creation timestamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The request last updated timestamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User ID who created and saved this request.
	AuthorUserId string `protobuf:"bytes,4,opt,name=author_user_id,json=authorUserId,proto3" json:"author_user_id,omitempty"`
	// BSR repository ID this request is linked to.
	RepositoryId string `protobuf:"bytes,5,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
	// The friendly name of this request.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// The target base URL of this request.
	TargetBaseUrl string `protobuf:"bytes,7,opt,name=target_base_url,json=targetBaseUrl,proto3" json:"target_base_url,omitempty"`
	// The BSR repository owner name (user or organization).
	RepositoryOwner string `protobuf:"bytes,8,opt,name=repository_owner,json=repositoryOwner,proto3" json:"repository_owner,omitempty"`
	// The BSR repository name.
	RepositoryName string `protobuf:"bytes,9,opt,name=repository_name,json=repositoryName,proto3" json:"repository_name,omitempty"`
	// The target service name as defined in the BSR repository.
	Service string `protobuf:"bytes,10,opt,name=service,proto3" json:"service,omitempty"`
	// The target RPC method name as defined in the BSR repository.
	Method string `protobuf:"bytes,11,opt,name=method,proto3" json:"method,omitempty"`
	// The request body as defined in Studio.
	Body string `protobuf:"bytes,12,opt,name=body,proto3" json:"body,omitempty"`
	// The request headers as defined in Studio.
	Headers map[string]string `protobuf:"bytes,13,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Should this request include cookies from the Studio current session?
	IncludeCookies bool `protobuf:"varint,14,opt,name=include_cookies,json=includeCookies,proto3" json:"include_cookies,omitempty"`
	// The protocol that Studio uses to send this request.
	Protocol StudioProtocol `protobuf:"varint,15,opt,name=protocol,proto3,enum=buf.alpha.registry.v1alpha1.StudioProtocol" json:"protocol,omitempty"`
	// The agent url (if any) used by Studio to send the request. See
	// https://docs.buf.build/bsr/studio#via-buf-studio-agent for details.
	AgentUrl string `protobuf:"bytes,16,opt,name=agent_url,json=agentUrl,proto3" json:"agent_url,omitempty"`
}

func (x *StudioRequest) Reset() {
	*x = StudioRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StudioRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StudioRequest) ProtoMessage() {}

func (x *StudioRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StudioRequest.ProtoReflect.Descriptor instead.
func (*StudioRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDescGZIP(), []int{8}
}

func (x *StudioRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *StudioRequest) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *StudioRequest) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *StudioRequest) GetAuthorUserId() string {
	if x != nil {
		return x.AuthorUserId
	}
	return ""
}

func (x *StudioRequest) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

func (x *StudioRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StudioRequest) GetTargetBaseUrl() string {
	if x != nil {
		return x.TargetBaseUrl
	}
	return ""
}

func (x *StudioRequest) GetRepositoryOwner() string {
	if x != nil {
		return x.RepositoryOwner
	}
	return ""
}

func (x *StudioRequest) GetRepositoryName() string {
	if x != nil {
		return x.RepositoryName
	}
	return ""
}

func (x *StudioRequest) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *StudioRequest) GetMethod() string {
	if x != nil {
		return x.Method
	}
	return ""
}

func (x *StudioRequest) GetBody() string {
	if x != nil {
		return x.Body
	}
	return ""
}

func (x *StudioRequest) GetHeaders() map[string]string {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *StudioRequest) GetIncludeCookies() bool {
	if x != nil {
		return x.IncludeCookies
	}
	return false
}

func (x *StudioRequest) GetProtocol() StudioProtocol {
	if x != nil {
		return x.Protocol
	}
	return StudioProtocol_STUDIO_PROTOCOL_UNSPECIFIED
}

func (x *StudioRequest) GetAgentUrl() string {
	if x != nil {
		return x.AgentUrl
	}
	return ""
}

var File_buf_alpha_registry_v1alpha1_studio_request_proto protoreflect.FileDescriptor

var file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDesc = []byte{
	0x0a, 0x30, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x73, 0x74,
	0x75, 0x64, 0x69, 0x6f, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1b, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x9d, 0x04, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x74, 0x75, 0x64, 0x69,
	0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x29, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6f, 0x77,
	0x6e, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x61, 0x73, 0x65, 0x55, 0x72, 0x6c, 0x12,
	0x18, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0x5e, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73,
	0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x74, 0x75, 0x64, 0x69,
	0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x5f, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x73, 0x12, 0x47,
	0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53,
	0x74, 0x75, 0x64, 0x69, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x52, 0x08, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x1b, 0x0a, 0x09, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x5f, 0x75, 0x72, 0x6c, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x55, 0x72, 0x6c, 0x1a, 0x3a, 0x0a, 0x0c, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x72, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x74, 0x75, 0x64, 0x69, 0x6f,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x53, 0x0a, 0x0f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x52, 0x0e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x22, 0x47, 0x0a, 0x1a, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x53, 0x74,
	0x75, 0x64, 0x69, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6e, 0x65, 0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e, 0x65, 0x77, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x1d, 0x0a,
	0x1b, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2c, 0x0a, 0x1a,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x1d, 0x0a, 0x1b, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x71, 0x0a, 0x19, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x07, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x22, 0x8c, 0x01, 0x0a,
	0x1a, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x08, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64,
	0x69, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd8, 0x05, 0x0a, 0x0d,
	0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x3b, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x23, 0x0a,
	0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x61, 0x73, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x29,
	0x0a, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0x51, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x73, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x43, 0x6f, 0x6f,
	0x6b, 0x69, 0x65, 0x73, 0x12, 0x47, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x1b, 0x0a,
	0x09, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x6c, 0x1a, 0x3a, 0x0a, 0x0c, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x2a, 0x86, 0x01, 0x0a, 0x0e, 0x53, 0x74, 0x75, 0x64, 0x69,
	0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x1f, 0x0a, 0x1b, 0x53, 0x54, 0x55,
	0x44, 0x49, 0x4f, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x54,
	0x55, 0x44, 0x49, 0x4f, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x43, 0x4f,
	0x4e, 0x4e, 0x45, 0x43, 0x54, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x54, 0x55, 0x44, 0x49,
	0x4f, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x47, 0x52, 0x50, 0x43, 0x10,
	0x02, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x54, 0x55, 0x44, 0x49, 0x4f, 0x5f, 0x50, 0x52, 0x4f, 0x54,
	0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x47, 0x52, 0x50, 0x43, 0x5f, 0x57, 0x45, 0x42, 0x10, 0x03, 0x32,
	0xcd, 0x04, 0x0a, 0x14, 0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x8a, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x74,
	0x75, 0x64, 0x69, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x8a, 0x01, 0x0a, 0x13, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65,
	0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6e, 0x61,
	0x6d, 0x65, 0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x53, 0x74, 0x75, 0x64, 0x69,
	0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x12, 0x8d, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x74, 0x75,
	0x64, 0x69, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53,
	0x74, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90,
	0x02, 0x02, 0x12, 0x8a, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x75, 0x64, 0x69,
	0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x36, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x75, 0x64,
	0x69, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x42,
	0x9f, 0x02, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x42, 0x12, 0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x59, 0x67, 0x69, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x62,
	0x75, 0x66, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x3b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0xa2, 0x02, 0x03, 0x42, 0x41, 0x52, 0xaa, 0x02, 0x1b, 0x42, 0x75, 0x66,
	0x2e, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xca, 0x02, 0x1b, 0x42, 0x75, 0x66, 0x5c, 0x41,
	0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c, 0x56, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xe2, 0x02, 0x27, 0x42, 0x75, 0x66, 0x5c, 0x41, 0x6c, 0x70,
	0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c, 0x56, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xea, 0x02, 0x1e, 0x42, 0x75, 0x66, 0x3a, 0x3a, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x3a, 0x3a, 0x52,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDescOnce sync.Once
	file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDescData = file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDesc
)

func file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDescGZIP() []byte {
	file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDescOnce.Do(func() {
		file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDescData)
	})
	return file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDescData
}

var file_buf_alpha_registry_v1alpha1_studio_request_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_buf_alpha_registry_v1alpha1_studio_request_proto_goTypes = []any{
	(StudioProtocol)(0),                 // 0: buf.alpha.registry.v1alpha1.StudioProtocol
	(*CreateStudioRequestRequest)(nil),  // 1: buf.alpha.registry.v1alpha1.CreateStudioRequestRequest
	(*CreateStudioRequestResponse)(nil), // 2: buf.alpha.registry.v1alpha1.CreateStudioRequestResponse
	(*RenameStudioRequestRequest)(nil),  // 3: buf.alpha.registry.v1alpha1.RenameStudioRequestRequest
	(*RenameStudioRequestResponse)(nil), // 4: buf.alpha.registry.v1alpha1.RenameStudioRequestResponse
	(*DeleteStudioRequestRequest)(nil),  // 5: buf.alpha.registry.v1alpha1.DeleteStudioRequestRequest
	(*DeleteStudioRequestResponse)(nil), // 6: buf.alpha.registry.v1alpha1.DeleteStudioRequestResponse
	(*ListStudioRequestsRequest)(nil),   // 7: buf.alpha.registry.v1alpha1.ListStudioRequestsRequest
	(*ListStudioRequestsResponse)(nil),  // 8: buf.alpha.registry.v1alpha1.ListStudioRequestsResponse
	(*StudioRequest)(nil),               // 9: buf.alpha.registry.v1alpha1.StudioRequest
	nil,                                 // 10: buf.alpha.registry.v1alpha1.CreateStudioRequestRequest.HeadersEntry
	nil,                                 // 11: buf.alpha.registry.v1alpha1.StudioRequest.HeadersEntry
	(*timestamppb.Timestamp)(nil),       // 12: google.protobuf.Timestamp
}
var file_buf_alpha_registry_v1alpha1_studio_request_proto_depIdxs = []int32{
	10, // 0: buf.alpha.registry.v1alpha1.CreateStudioRequestRequest.headers:type_name -> buf.alpha.registry.v1alpha1.CreateStudioRequestRequest.HeadersEntry
	0,  // 1: buf.alpha.registry.v1alpha1.CreateStudioRequestRequest.protocol:type_name -> buf.alpha.registry.v1alpha1.StudioProtocol
	9,  // 2: buf.alpha.registry.v1alpha1.CreateStudioRequestResponse.created_request:type_name -> buf.alpha.registry.v1alpha1.StudioRequest
	9,  // 3: buf.alpha.registry.v1alpha1.ListStudioRequestsResponse.requests:type_name -> buf.alpha.registry.v1alpha1.StudioRequest
	12, // 4: buf.alpha.registry.v1alpha1.StudioRequest.create_time:type_name -> google.protobuf.Timestamp
	12, // 5: buf.alpha.registry.v1alpha1.StudioRequest.update_time:type_name -> google.protobuf.Timestamp
	11, // 6: buf.alpha.registry.v1alpha1.StudioRequest.headers:type_name -> buf.alpha.registry.v1alpha1.StudioRequest.HeadersEntry
	0,  // 7: buf.alpha.registry.v1alpha1.StudioRequest.protocol:type_name -> buf.alpha.registry.v1alpha1.StudioProtocol
	1,  // 8: buf.alpha.registry.v1alpha1.StudioRequestService.CreateStudioRequest:input_type -> buf.alpha.registry.v1alpha1.CreateStudioRequestRequest
	3,  // 9: buf.alpha.registry.v1alpha1.StudioRequestService.RenameStudioRequest:input_type -> buf.alpha.registry.v1alpha1.RenameStudioRequestRequest
	5,  // 10: buf.alpha.registry.v1alpha1.StudioRequestService.DeleteStudioRequest:input_type -> buf.alpha.registry.v1alpha1.DeleteStudioRequestRequest
	7,  // 11: buf.alpha.registry.v1alpha1.StudioRequestService.ListStudioRequests:input_type -> buf.alpha.registry.v1alpha1.ListStudioRequestsRequest
	2,  // 12: buf.alpha.registry.v1alpha1.StudioRequestService.CreateStudioRequest:output_type -> buf.alpha.registry.v1alpha1.CreateStudioRequestResponse
	4,  // 13: buf.alpha.registry.v1alpha1.StudioRequestService.RenameStudioRequest:output_type -> buf.alpha.registry.v1alpha1.RenameStudioRequestResponse
	6,  // 14: buf.alpha.registry.v1alpha1.StudioRequestService.DeleteStudioRequest:output_type -> buf.alpha.registry.v1alpha1.DeleteStudioRequestResponse
	8,  // 15: buf.alpha.registry.v1alpha1.StudioRequestService.ListStudioRequests:output_type -> buf.alpha.registry.v1alpha1.ListStudioRequestsResponse
	12, // [12:16] is the sub-list for method output_type
	8,  // [8:12] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_studio_request_proto_init() }
func file_buf_alpha_registry_v1alpha1_studio_request_proto_init() {
	if File_buf_alpha_registry_v1alpha1_studio_request_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_studio_request_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_studio_request_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_studio_request_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_studio_request_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_studio_request_proto = out.File
	file_buf_alpha_registry_v1alpha1_studio_request_proto_rawDesc = nil
	file_buf_alpha_registry_v1alpha1_studio_request_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_studio_request_proto_depIdxs = nil
}
